/*$************************************************************************************************
 **
 ** $Id: FeatureStoreListener.java 1019 2007-04-24 15:21:07Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.0/geoapi/src/main/java/org/opengis/feature/FeatureStoreListener.java $
 **
 ** Copyright (C) 2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.feature;

import java.util.EventListener;
import org.opengis.feature.type.FeatureType;  // For javadoc


/**
 * Interface whose methods are invoked when types are modified in a {@link FeatureStore}.
 * To use this interface, implement its methods and invoke the
 * {@link FeatureStore#addFeatureStoreListener addFeatureStoreListener} method on feature store.
 *
 * @since GeoAPI 2.0
 */
public interface FeatureStoreListener extends EventListener {
    /**
     * Invoked when a new {@link FeatureType} has been created.
     */
    void typeAdded(FeatureStoreEvent dse);

    /**
     * Invoked when a {@link FeatureType} has been removed from a {@link FeatureStore}.
     */
    void typeRemoved(FeatureStoreEvent dse);

    /**
     * Invoked when the schema for a type has been changed.
     */
    void typeModified(FeatureStoreEvent dse);
}
