/**************************************************************************************************
 **
 ** $Id: CanvasController.java 1122 2007-11-24 18:49:16Z desruisseaux $
 **
 ** $URL: https://geoapi.svn.sourceforge.net/svnroot/geoapi/tags/2.1.1/geoapi/src/main/java/org/opengis/go/display/canvas/CanvasController.java $
 **
 ** Copyright (C) 2003-2005 Open GIS Consortium, Inc.
 ** All Rights Reserved. http://www.opengis.org/legal/
 **
 *************************************************************************************************/
package org.opengis.go.display.canvas;

import org.opengis.geometry.DirectPosition;


/**
 * The <code>CanvasController</code> interface serves as the token in the
 * <code>CanvasController &lt;--&gt; Canvas</code> interaction.  When
 * the <code>Canvas</code> enables a <code>CanvasHandler</code>, it calls
 * <code>handlerEnabled(CanvasController)</code> on the
 * <code>CanvasHandler</code>.  The <code>CanvasController</code> may then be
 * used by the programmer to set some of the properties of the associated
 * <code>Canvas</code>.  The <code>CanvasController</code> will be active
 * until another <code>CanvasHandler</code> is enabled.
 * <p/>
 * The <code>CanvasController</code>'s methods (in an implementation-specific
 * interaction with the <code>Canvas</code>) should only set the
 * <code>Canvas</code>'s properties <b>IFF</b> the
 * <code>CanvasController</code> is recognized to be the active controller (the
 * controller given out by the canvas when the most recent handler was
 * enabled).
 *
 * @author Open GIS Consortium, Inc.
 */
public interface CanvasController {
    /**
     * Sets the position of the center pixel of the <code>Canvas</code> this
     * controller works for, if it is the active controller.
     * @see CanvasState#getCenter()
     */
    void setCenter(DirectPosition newCenter);
}
