import rabbyt
import snowui
from gamelib.menu import Text
from gamelib.input import TextWidget
import simplejson

class IngameMenu(snowui.Widget):
    def __init__(self, ui):
        self.ui = ui
        snowui.Widget.__init__(self, texture="ingame_menu.png",
                bounds="rect", x=self.ui.view.width, y=self.ui.view.height/2-138/2)

        self.award = None

        button = snowui.widget_setting(snowui.Button,
                texture="button_long.png", bounds="rect",
                default_color=(1,1,1,1), hover_color=(1,1,1,.7))

        self.add(button(rx=251/2-97/2-60, ry=20,
                callback=self.close, icon="icon_continue.png",
                default_color=(1,1,0.4,1),))
        self.add(button(rx=251/2-97/2+60, ry=20,
                callback=ui.end_game, icon="icon_exit.png"))
        self.close()

    def submit_highscore(self, name):
        fp = open("settings.json")
        settings = simplejson.load(fp)
        fp.close()

        if not settings.has_key("highscore"):
            settings["highscore"] = []
        settings["highscore"].append((name, self.ui.final_score))

        if self.award:
            if self.award == "gold":
                set_award = True
            else:
                set_award = False
                if settings["awards"].has_key(self.ui.map.mapname):
                    a = settings["awards"][self.ui.map.mapname]
                    if a == "bronze" and self.award == "silver":
                        set_award = True
            if set_award:
                settings["awards"][self.ui.map.mapname] = self.award

        out = simplejson.dumps(settings, sort_keys=False, indent=4)
        fp = open("settings.json", "w")
        fp.write(out)
        fp.close()

        self.remove(self.hsi)
        self.remove(self.hsb)

        t = Text("Highscore saved!", rx=251/2, ry=90,
                anchor_x="center", font_size=20, color=(0,0,0,255))
        self.add(t)

    def enter_highscore(self):
        self.open()
        self.hsi = w = TextWidget(self.submit_highscore, rx=251/2-56/2-80, ry=90,
                texture="hsinput.png")
        self.add(w)
        w.do_focus()

        self.hsb = b = snowui.Button(rx=w.rx+210-56, ry=65, bounds="rect",
                texture="hssubmit.png", callback=w.submit,
                hover_color=(.7,.9,1,1))
        self.add(b)

        for a in "gold silver bronze".split():
            i = self.ui.map.data["settings"]["awards"][a]
            if self.ui.final_score >= i:
                self.award = a
                self.add(snowui.Widget(texture=a+".png", rx=265, ry=30))
                break

    def close(self):
        if self.ui.game_speed:
            self.alpha = rabbyt.lerp(end=0, dt=.2)
            for c in self.children:
                c.alpha = rabbyt.lerp(end=0, dt=.2)
        else:
            self.alpha = 0
            for c in self.children:
                c.alpha = 0

        self.do_blur()
        self.is_active = False
        self.bounds = "rect"
    def open(self):
        if self.ui.game_speed:
            self.alpha = rabbyt.lerp(end=1, dt=.2)
            for c in self.children:
                c.alpha = rabbyt.lerp(end=1, dt=.2)
        else:
            self.alpha = 1
            for c in self.children:
                c.alpha = 1
        self.x = self.ui.view.width/2-251/2

        self.do_focus()
        self.is_active = True
        self.bounds = "always"
