-- GunFu Deadlands
-- Copyright 2009 Christiaan Janssen, September-December 2009
--
-- This file is part of GunFu Deadlands.
--
--     GunFu Deadlands is free software: you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation, either version 3 of the License, or
--     (at your option) any later version.
--
--     GunFu Deadlands is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with GunFu Deadlands.  If not, see <http://www.gnu.org/licenses/>.

Colors = {
	green = love.graphics.newColor(124,164,26),
	dk_green = love.graphics.newColor(120,115,19),
	red = love.graphics.newColor(164,26,33),
	black = love.graphics.newColor(33,18,5),
	orange = love.graphics.newColor(206,111,33),
	dk_red = love.graphics.newColor(120,19,24),
	lt_red = love.graphics.newColor(183,29,39),
	dark_black = love.graphics.newColor(0,0,0),
	lt_blue = love.graphics.newColor(26,122,160),
	yellow = love.graphics.newColor(207,198,33),
}

function Colors.init()
	Colors.background = Colors.orange
	Colors.foreground = Colors.dk_red

	love.graphics.setBackgroundColor(Colors.background)
	love.graphics.setColor(Colors.foreground)
	love.graphics.setPoint(1,love.point_rough)
end

Graphics = {}

Graphics.walk_framedelay = 0.030
Graphics.jump_framedelay = 0.045
Graphics.death_framedelay = 0.060
Graphics.shadow_mode = false
Graphics.show_shoot_dir = true
Graphics.show_personalprogressbar=true

Graphics.images = {

-- todo: arreglar confusio gerundis infinitius
	title = love.graphics.newImage("images/title.png"),

 	guy_standing = love.graphics.newImage("images/guy.png"),
	guy_walk_right = love.graphics.newImage("images/guy_walk_right.png"),
 	guy_walk_up = love.graphics.newImage("images/guy_walk_up.png"),
 	guy_jumping_right = love.graphics.newImage("images/guy_jumping_right.png"),
	guy_jumping_up = love.graphics.newImage("images/guy_jumping_up.png"),
 	guys_gun = love.graphics.newImage("images/guys_gun.png"),
	guy_dying_right = love.graphics.newImage("images/guy_die_right.png"),

	blue_bandit_standing = love.graphics.newImage("images/blue_bandit.png"),
	blue_bandit_walk_right = love.graphics.newImage("images/blue_bandit_walk_right.png"),
 	blue_bandit_walk_up = love.graphics.newImage("images/blue_bandit_walk_up.png"),
 	blue_bandit_gun = love.graphics.newImage("images/blue_gun.png"),
	blue_bandit_dying_right = love.graphics.newImage("images/blue_bandit_die_right.png"),

	red_bandit_standing = love.graphics.newImage("images/red_bandit.png"),
	red_bandit_walk_right = love.graphics.newImage("images/red_bandit_walk_right.png"),
 	red_bandit_walk_up = love.graphics.newImage("images/red_bandit_walk_up.png"),
 	red_bandit_gun = love.graphics.newImage("images/red_gun.png"),
	red_bandit_dying_right = love.graphics.newImage("images/red_bandit_die_right.png"),

	green_bandit_standing = love.graphics.newImage("images/green_bandit.png"),
	green_bandit_walk_right = love.graphics.newImage("images/green_bandit_walk_right.png"),
 	green_bandit_walk_up = love.graphics.newImage("images/green_bandit_walk_up.png"),
 	green_bandit_gun = love.graphics.newImage("images/green_gun.png"),
	green_bandit_dying_right = love.graphics.newImage("images/green_bandit_die_right.png"),

	yellow_bandit_standing = love.graphics.newImage("images/yellow_bandit.png"),
	yellow_bandit_walk_right = love.graphics.newImage("images/yellow_bandit_walk_right.png"),
 	yellow_bandit_walk_up = love.graphics.newImage("images/yellow_bandit_walk_up.png"),
 	yellow_bandit_gun = love.graphics.newImage("images/yellow_gun.png"),
	yellow_bandit_dying_right = love.graphics.newImage("images/yellow_bandit_die_right.png"),

	ninja_bandit_standing = love.graphics.newImage("images/ninja_bandit.png"),
	ninja_bandit_walk_right = love.graphics.newImage("images/ninja_bandit_walk_right.png"),
 	ninja_bandit_walk_up = love.graphics.newImage("images/ninja_bandit_walk_up.png"),
	ninja_bandit_walk_dn = love.graphics.newImage("images/ninja_bandit_walk_dn.png"),
 	ninja_bandit_blue_gun = love.graphics.newImage("images/ninja_bandit_blue_gun.png"),
	ninja_bandit_red_gun = love.graphics.newImage("images/ninja_bandit_red_gun.png"),
	ninja_bandit_green_gun = love.graphics.newImage("images/ninja_bandit_green_gun.png"),
	ninja_bandit_yellow_gun = love.graphics.newImage("images/ninja_bandit_yellow_gun.png"),
	ninja_bandit_dying_right = love.graphics.newImage("images/ninja_bandit_die_right.png"),

	bullet = love.graphics.newImage("images/bullet.png"),
	bullet_marker = love.graphics.newImage("images/bullet_huge.png"),

	cactus = love.graphics.newImage("images/cactus.png"),
	barrel = love.graphics.newImage("images/barrel.png"),
	saloon = love.graphics.newImage("images/saloon.png"),
	sheriff_box = love.graphics.newImage("images/sheriff.png"),
	church = love.graphics.newImage("images/church.png"),
	bank = love.graphics.newImage("images/bank.png"),
	mansion = love.graphics.newImage("images/mansion.png"),
	house = love.graphics.newImage("images/house.png"),
	warehouse = love.graphics.newImage("images/warehouse.png"),
	barrier_horiz = love.graphics.newImage("images/barrier_horiz.png"),
	barrier_vert = love.graphics.newImage("images/barrier_vert.png"),
	dead_branch = love.graphics.newImage("images/dead_branch.png"),
	dead_tree = love.graphics.newImage("images/dead_tree.png"),
	fence_horiz = love.graphics.newImage("images/fence_horiz.png"),
	fence_vert = love.graphics.newImage("images/fence_vert.png"),
	herb = love.graphics.newImage("images/herb.png"),
	mill = love.graphics.newImage("images/mill.png"),
	bush = love.graphics.newImage("images/bush.png"),
	barber = love.graphics.newImage("images/barber.png"),
	crate = love.graphics.newImage("images/crate.png"),
	generic_house = love.graphics.newImage("images/generic_house.png"),
	smith = love.graphics.newImage("images/smith.png"),
	stable = love.graphics.newImage("images/stable.png"),
	tiny_house = love.graphics.newImage("images/tiny_house.png"),
	pile = love.graphics.newImage("images/pile.png"),
	well = love.graphics.newImage("images/well.png"),


	commands = love.graphics.newImage("images/functions.png"),
	f1help = love.graphics.newImage("images/f1help.png"),
	f2save = love.graphics.newImage("images/f2save.png"),
	f3load = love.graphics.newImage("images/f3load.png"),
	f4move = love.graphics.newImage("images/f4move.png"),
	f5add = love.graphics.newImage("images/f5add.png"),
	f6test = love.graphics.newImage("images/f6test.png"),
	f7reset = love.graphics.newImage("images/f7reset.png"),
	f8opts = love.graphics.newImage("images/f8opts.png"),
	f10wipe = love.graphics.newImage("images/f10wipe.png"),

}

Graphics.animations = {
  -- todo: animations sizes from images
	guy_walk_right = love.graphics.newAnimation(Graphics.images.guy_walk_right, 18, 22, Graphics.walk_framedelay),
	guy_walk_up = love.graphics.newAnimation(Graphics.images.guy_walk_up, 18, 22, Graphics.walk_framedelay),
	guy_jumping_right = love.graphics.newAnimation(Graphics.images.guy_jumping_right, 18, 22, Graphics.jump_framedelay),
	guy_jumping_up = love.graphics.newAnimation(Graphics.images.guy_jumping_up, 18, 22, Graphics.jump_framedelay),
	guy_dying_right = love.graphics.newAnimation(Graphics.images.guy_dying_right, 18, 22, Graphics.death_framedelay),
}

function Graphics.animations.new_blue_bandit_walk_right()
	return love.graphics.newAnimation(Graphics.images.blue_bandit_walk_right, 18, 24, Graphics.walk_framedelay)
end

function Graphics.animations.new_blue_bandit_walk_up()
	return  love.graphics.newAnimation(Graphics.images.blue_bandit_walk_up, 18, 24, Graphics.walk_framedelay)
end
function Graphics.animations.new_blue_bandit_dying_right()
	return  love.graphics.newAnimation(Graphics.images.blue_bandit_dying_right, 18, 22, Graphics.death_framedelay)
end

function Graphics.animations.new_red_bandit_walk_right()
	return  love.graphics.newAnimation(Graphics.images.red_bandit_walk_right, 18, 22, Graphics.walk_framedelay)
end
function Graphics.animations.new_red_bandit_walk_up()
	return  love.graphics.newAnimation(Graphics.images.red_bandit_walk_up, 18, 22, Graphics.walk_framedelay)
end
function Graphics.animations.new_red_bandit_dying_right()
	return  love.graphics.newAnimation(Graphics.images.red_bandit_dying_right, 18, 22, Graphics.death_framedelay)
end

function Graphics.animations.new_green_bandit_walk_right()
	return  love.graphics.newAnimation(Graphics.images.green_bandit_walk_right, 18, 24, Graphics.walk_framedelay)
end
function Graphics.animations.new_green_bandit_walk_up()
	return  love.graphics.newAnimation(Graphics.images.green_bandit_walk_up, 18, 24, Graphics.walk_framedelay)
end
function Graphics.animations.new_green_bandit_dying_right()
	return  love.graphics.newAnimation(Graphics.images.green_bandit_dying_right, 18, 22, Graphics.death_framedelay)
end

function Graphics.animations.new_yellow_bandit_walk_right()
	return  love.graphics.newAnimation(Graphics.images.yellow_bandit_walk_right, 18, 22, Graphics.walk_framedelay)
end
function Graphics.animations.new_yellow_bandit_walk_up()
	return  love.graphics.newAnimation(Graphics.images.yellow_bandit_walk_up, 18, 22, Graphics.walk_framedelay)
end
function Graphics.animations.new_yellow_bandit_dying_right()
	return  love.graphics.newAnimation(Graphics.images.yellow_bandit_dying_right, 18, 22, Graphics.death_framedelay)
end

function Graphics.animations.new_ninja_bandit_walk_right()
	return  love.graphics.newAnimation(Graphics.images.ninja_bandit_walk_right, 18, 22, Graphics.walk_framedelay)
end
function Graphics.animations.new_ninja_bandit_walk_up()
	return  love.graphics.newAnimation(Graphics.images.ninja_bandit_walk_up, 18, 22, Graphics.walk_framedelay)
end
function Graphics.animations.new_ninja_bandit_walk_dn()
	return  love.graphics.newAnimation(Graphics.images.ninja_bandit_walk_dn, 18, 22, Graphics.walk_framedelay)
end
function Graphics.animations.new_ninja_bandit_dying_right()
	return  love.graphics.newAnimation(Graphics.images.ninja_bandit_dying_right, 18, 22, Graphics.death_framedelay)
end


function Graphics.get_jumptime(  )
	return Graphics.jump_framedelay * Graphics.animations.guy_jumping_up:getSize()
end

function Graphics.get_deathtime( )
	return Graphics.death_framedelay * Graphics.animations.guy_dying_right:getSize() - Graphics.death_framedelay/2
end

function Graphics.reset_jump()
	Graphics.animations.guy_jumping_right:reset()
	Graphics.animations.guy_jumping_up:reset()
end

function Graphics.reset_death()
	Graphics.animations.guy_dying_right:reset()
end

function Graphics.update_player(delta)
	Graphics.animations.guy_walk_right:update(delta)
	Graphics.animations.guy_walk_up:update(delta)

	Graphics.animations.guy_jumping_right:update(delta)
	Graphics.animations.guy_jumping_up:update(delta)

	Graphics.animations.guy_dying_right:update(delta)
end

function Graphics.update_enemies(delta)
	for i,enemy in ipairs(Level.enemies) do
		if enemy.dir ~= {0,0} then
			if math.abs(enemy.dir[1]) > math.abs(enemy.dir[2]) then
				enemy.sprite_walking_right:update(delta)
				enemy.sprite_ninja_walking_right:update(delta)
			else
				if enemy.dir[2]<0 then
					enemy.sprite_walking_up:update(delta)
					enemy.sprite_ninja_walking_up:update(delta)
				else
					enemy.sprite_walking_dn:update(delta)
					enemy.sprite_ninja_walking_dn:update(delta)
				end
			end
		end

		if enemy.state == 0 then
			enemy.sprite_dying:update(delta)
			enemy.sprite_ninja_dying:update(delta)
		end

	end

end

-- ============== modes ==================
-- viewmodes= 1-fullscreen, 2-windowed
Graphics.viewmode = 2
function Graphics.toggleMode()
	if Graphics.viewmode == 1 then
		return Graphics.setWindowed()
	else
		return Graphics.setFullscreen()
	end
end

function Graphics.setWindowed()
	local success = love.graphics.setMode( screensize[1], screensize[2], false, true, 0 )
	Graphics.viewmode = 2
	return success
end

function Graphics.setFullscreen()
  local success = love.graphics.setMode( screensize[1], screensize[2], true, true, 0 )
	Graphics.viewmode = 1
	return success
end

function Graphics.drawtext(text, x, y)
	love.graphics.setColor(Colors.dark_black)
	love.graphics.draw(text,x,y)
end

-- ============== DRAW FUNCTION ==============
function Graphics.drawTitleScreen()

	love.graphics.draw(Graphics.images.title,320,60)
--		love.graphics.draw(Level.menutext, 150, 130)
	Graphics.drawtext(Level.menutext_U,  150, 95)
	Graphics.drawtext("F1 - Instructions\n\nF2 - Start in normal mode\n\nF3 - Start in hard mode\n\nF4 - Play user level\n\nF5 - Level editor\n\nESC - Exit", 200,160)
end

function Graphics.drawEndScreen()

	love.graphics.setColor(Colors.dark_black)
	love.graphics.draw(Level.endtext, 130, 130)
	if Game.gamemode == 2 then
		love.graphics.draw(Level.hardtext, 130,70)
	end
end

function Graphics.showinstructions()
	Graphics.drawtext(Level.menutext_L,  150, 30)
	Graphics.drawtext(Level.menutext_R,  370, 30)
end
-- in graphics!
function Graphics.draw()

	if Game.paused then
		love.graphics.setColor(Colors.dark_black)
		love.graphics.draw("Game Paused",280,240)
		return
	end

	if Game.helpmode then
		Graphics.showinstructions()
		return
	end

	if not Editor.enabled then
		if Level.currentlevel == 0 then
			Graphics.drawTitleScreen()

	--~ 		return
		elseif Level.currentlevel == 11 then
			Graphics.drawEndScreen()
	--		return
		end
	end


	--love.graphics.draw("WANTED\nDead or Alive\nJoseph <Joe> Smith\nWilliam <Happy Trigger> Gordon\nAbraham <Gramps> Derrick\nRobert <Crazy Horse> Morris\n6000$",10,10)

  --floors
  for i,building in ipairs(Level.buildings) do
	if building.solid == 5 then
		Graphics.draw_building( building )
	end
  end

  Graphics.draw_player()

  List.apply(Bullets, Graphics.draw_bullet)


  for i,enemy in ipairs(Level.enemies) do
	Graphics.draw_enemy(enemy)
  end



  for i,building in ipairs(Level.buildings) do
	if building.solid ~= 5 then
		Graphics.draw_building( building )
	end
  end

	-- bullettime progressbar
	if BulletTime.showprogress and ((Editor.enabled and Editor.showprogress) or not Editor.enabled) then
		if Graphics.show_personalprogressbar then
			Graphics.draw_personalprogressbar()
		else
			Graphics.draw_progressbar(550, 10)
		end
	end

end

function Graphics.draw_player( )
	local lplayerpos = { math.floor( Player.pos[1] ), math.floor( Player.pos[2]) }
	if Player.alive then

		if Player.jumping then
		  -- jumping animation
			if Player.spinning_dir[1] > 0 then
				-- todo: invert animation sprites so all face right as default
				love.graphics.draw(Graphics.animations.guy_jumping_right, lplayerpos[1], lplayerpos[2])
			elseif Player.spinning_dir[1] < 0 then
				love.graphics.draw(Graphics.animations.guy_jumping_right, lplayerpos[1], lplayerpos[2], 0, -1, 1)
			elseif Player.spinning_dir[2] < 0 then
				love.graphics.draw(Graphics.animations.guy_jumping_up, lplayerpos[1], lplayerpos[2])
			elseif Player.spinning_dir[2] > 0 then
				love.graphics.draw(Graphics.animations.guy_jumping_up, lplayerpos[1], lplayerpos[2], 0, -1, 1)
			else
				Player.jumping = false
			end
		else
		  -- normal walk
			if Player.dir[1] > 0 then
				love.graphics.draw(Graphics.animations.guy_walk_right, lplayerpos[1], lplayerpos[2])
			elseif Player.dir[1] < 0 then
				love.graphics.draw(Graphics.animations.guy_walk_right, lplayerpos[1], lplayerpos[2], 0, -1, 1)
			elseif Player.dir[2] ~= 0 then
				love.graphics.draw(Graphics.animations.guy_walk_up, lplayerpos[1], lplayerpos[2])
			else
				love.graphics.draw(Graphics.images.guy_standing, lplayerpos[1], lplayerpos[2])
			end

		  -- render gun
			if Player.firing_timer > 0 then
				if love.mouse.getX() > lplayerpos[1] then
					love.graphics.draws(Graphics.images.guys_gun, math.floor(lplayerpos[1]), math.floor(lplayerpos[2]),
						0, 0, Player.spritesize[1], Player.spritesize[2])
				else
					love.graphics.draws(Graphics.images.guys_gun, math.floor(lplayerpos[1]), math.floor(lplayerpos[2]),
						Player.spritesize[1], 0, Player.spritesize[1], Player.spritesize[2])
				end
			end
		end
	else
		if Player.death_timer > 0 then
			if Player.dir[1]>=0 then
				love.graphics.draw(Graphics.animations.guy_dying_right, lplayerpos[1], lplayerpos[2])
			else
				love.graphics.draw(Graphics.animations.guy_dying_right, lplayerpos[1], lplayerpos[2], 0, -1, 1)
			end
		end
	end
end

function Graphics.draw_bullet( bullet )
	love.graphics.draw(Graphics.images.bullet, bullet.pos[1], bullet.pos[2])
end

function Graphics.draw_enemy( enemy )

	if Level.ninjamode and not (Editor.enabled and Editor.mode ~= 6) and Level.currentlevel > 0 then
		Graphics.draw_ninja_enemy( enemy )
		return
	end

	local px, py = math.floor(enemy.pos[1]), math.floor(enemy.pos[2])

	-- if it's dead, don't draw
	if enemy.state == 0 then
		if enemy.death_timer > 0 then
			if enemy.dir[1]>=0 then
				love.graphics.draw(enemy.sprite_dying, px, py)
			else
				love.graphics.draw(enemy.sprite_dying, px, py, 0, -1, 1)
			end
		end
		return
	end



	if enemy.blocked or (enemy.dir[1] == 0 and enemy.dir[2] == 0)   then
		love.graphics.draw(enemy.sprite_standing, px, py)
	else
	-- moving!
		if math.abs(enemy.dir[1]) > math.abs(enemy.dir[2]) then
			-- horizontal movement
			if enemy.dir[1]>0 then
				-- moving right
				love.graphics.draw(enemy.sprite_walking_right, px, py)
			else
				-- moving left
				love.graphics.draw(enemy.sprite_walking_right, px, py,  0, -1, 1 )
			end
		else
			-- vertical movement
			if enemy.dir[2]<0 then
				love.graphics.draw(enemy.sprite_walking_up, px, py)
			else
				love.graphics.draw(enemy.sprite_walking_dn, px, py)
			end
		end
	end

	-- if he is shooting, draw the gun
	if enemy.shooting_timer > 0 then
		local lx, ly = enemy.sprite_gun:getWidth()/2, enemy.sprite_gun:getHeight()
		if enemy.shoot_dir[1]>enemy.accuracy*2 then
			enemy.side = 1
		end
		if enemy.shoot_dir[1]<-enemy.accuracy*2 then
			enemy.side = 2
		end
		if enemy.side==1 then
			love.graphics.draws(enemy.sprite_gun, px, py, 0, 0, lx, ly)
		else
			love.graphics.draws(enemy.sprite_gun, px, py, lx, 0, lx, ly)
		end

	end

	-- show the shooting direction pointer
	if Graphics.show_shoot_dir then
		love.graphics.setColor(Colors.black)
		love.graphics.point(enemy.pos[1]+enemy.shoot_dir[1]*15,enemy.pos[2]+enemy.shoot_dir[2]*15)
		love.graphics.point(enemy.pos[1]+enemy.shoot_dir[1]*16,enemy.pos[2]+enemy.shoot_dir[2]*16)
	end
end

function Graphics.draw_ninja_enemy( enemy )

	local px, py = math.floor(enemy.pos[1]), math.floor(enemy.pos[2])

	-- if it's dead, don't draw
	if enemy.state == 0 then
		if enemy.death_timer > 0 then
			if enemy.dir[1]>=0 then
				love.graphics.draw(enemy.sprite_ninja_dying, px, py)
			else
				love.graphics.draw(enemy.sprite_ninja_dying, px, py, 0, -1, 1)
			end
		end
		return
	end

	if not EnemyAI.ninja_see_player_short( enemy ) then
		return
	end


	if enemy.blocked or (enemy.dir[1] == 0 and enemy.dir[2] == 0)   then
		love.graphics.draw(enemy.sprite_ninja_standing, px, py)
	else
	-- moving!
		if math.abs(enemy.dir[1]) > math.abs(enemy.dir[2]) then
			-- horizontal movement
			if enemy.dir[1]>0 then
				-- moving right
				love.graphics.draw(enemy.sprite_ninja_walking_right, px, py)
			else
				-- moving left
				love.graphics.draw(enemy.sprite_ninja_walking_right, px, py,  0, -1, 1 )
			end
		else
			-- vertical movement
			if enemy.dir[2]<0 then
				love.graphics.draw(enemy.sprite_ninja_walking_up, px, py)
			else
				love.graphics.draw(enemy.sprite_ninja_walking_dn, px, py)
			end
		end
	end

	-- if he is shooting, draw the gun
	if enemy.shooting_timer > 0 then
		local lx, ly = enemy.sprite_ninja_gun:getWidth()/2, enemy.sprite_ninja_gun:getHeight()
		if enemy.shoot_dir[1]>enemy.accuracy*2 then
			enemy.side = 1
		end
		if enemy.shoot_dir[1]<-enemy.accuracy*2 then
			enemy.side = 2
		end
		if enemy.side==1 then
			love.graphics.draws(enemy.sprite_ninja_gun, px, py, 0, 0, lx, ly)
		else
			love.graphics.draws(enemy.sprite_ninja_gun, px, py, lx, 0, lx, ly)
		end

	end

	-- show the shooting direction pointer
	if Graphics.show_shoot_dir then
		love.graphics.setColor(enemy.color)
		love.graphics.point(enemy.pos[1]+enemy.shoot_dir[1]*15,enemy.pos[2]+enemy.shoot_dir[2]*15)
		love.graphics.point(enemy.pos[1]+enemy.shoot_dir[1]*16,enemy.pos[2]+enemy.shoot_dir[2]*16)
	end
end

function Graphics.draw_building( building )
	if building.sprite then
		if building.len then
		-- several
		-- len[1] tells the direction: 1 horiz, 2 vert
		-- len[2] tells the number of repetitions
		-- len[3] tells the size of a single element
			if building.len[1] == 1 then
				for j=1,building.len[2] do
					love.graphics.draw(building.sprite,
						math.floor(building.pos[1]+(j-1-(building.len[2]-1)/2)*building.len[3]),
						math.floor(building.pos[2]))
				end
			elseif building.len[1] == 2 then
				for j=1,building.len[2] do
					love.graphics.draw(building.sprite,
						math.floor(building.pos[1]),
						math.floor(building.pos[2]+(j-1-(building.len[2]-1)/2)*building.len[3]))

				end

			end
		else
		-- just one
			love.graphics.draw(building.sprite, math.floor(building.pos[1]), math.floor(building.pos[2]))
		end
	end
end

function Graphics.draw_progressbar(px, py)

	local fraction
	local bar_len = 100

	-- enclosing box
	love.graphics.setColor(Colors.black)
	love.graphics.setLine(12,love.line_rough)
	love.graphics.line( px- bar_len/2 -3, py, px + bar_len/2 + 3, py )

	-- bar

	-- charging or discharging?
	if BulletTime.charged then
		love.graphics.setColor(Colors.dk_green)
		fraction = 1
	else
		if BulletTime.active then
			fraction = BulletTime.timer / BulletTime.duration
			-- green when discharging
			love.graphics.setColor(Colors.dk_green)
		else
			fraction = BulletTime.charge_timer/BulletTime.charge_duration
			-- red when charging
			love.graphics.setColor(Colors.red)
		end
	end

	love.graphics.setLine(6,love.line_rough ) -- big dots!
	love.graphics.line( px- bar_len/2 , py, px- bar_len/2 + math.floor(fraction*bar_len) , py)

	-- rest
	love.graphics.setColor(Colors.background)
	love.graphics.line(   px- bar_len/2 + math.floor(fraction*bar_len) , py , px + bar_len/2, py)

	-- bullet pocket
	for i=1,Player.bullet_pocket do
		love.graphics.draw(Graphics.images.bullet_marker,i*10, 8)
	end

	-- return to foreground color
	love.graphics.setColor(Colors.foreground)



end

function Graphics.draw_personalprogressbar()

	local fraction
	local bar_len = 18
	local px,py = Player.pos[1],math.floor(Player.pos[2] - 13)

	-- bar

	-- charging or discharging?
	if BulletTime.charged then
		love.graphics.setColor(Colors.dk_green)
		fraction = 1
	else
		if BulletTime.active then
			fraction = BulletTime.timer / BulletTime.duration
			-- green when discharging
			love.graphics.setColor(Colors.dk_green)
		else
			fraction = BulletTime.charge_timer/BulletTime.charge_duration
			-- red when charging
			love.graphics.setColor(Colors.red)
		end
	end

	love.graphics.setLine(1,love.line_rough ) -- small dots!
	love.graphics.line( px- bar_len/2 , py, px- bar_len/2 + math.floor(fraction*bar_len) , py)

	-- bullet pocket
	love.graphics.setColor(Colors.dark_black)

	for i=1,Player.bullet_pocket do
 		love.graphics.point(math.floor(px-bar_len/2) + i*3 - 2, py-1)
		love.graphics.point(math.floor(px-bar_len/2) + i*3 - 2, py-2)
 	end

	-- return to foreground color
	love.graphics.setColor(Colors.foreground)

end

-- ============== END DRAW FUNCTION ==============

