<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	 
	if ($auth->userdata["acclevel"] < 80) die ("Access denied!");
	
	$edlist = new EditList("serverId", "hlstats_Servers", "server");
	$edlist->columns[] = new EditListColumn("game", "Game", 0, true, "hidden", $gamecode);
	$edlist->columns[] = new EditListColumn("address", "IP Address", 15, true, "ipaddress", "", 15);
	$edlist->columns[] = new EditListColumn("port", "Port", 5, true, "text", "27015", 5);
  $edlist->columns[] = new EditListColumn("name", "Server Name", 22, true, "text", "", 255);
	$edlist->columns[] = new EditListColumn("rcon_password", "Rcon Password", 10, false, "text", "", 48);
	
	if (((isset($_GET['advanced'])) && ($_GET['advanced'] == 1)) ||
      ((isset($_POST['advanced'])) && ($_POST['advanced'] == 1))) 
	{
		$edlist->columns[] = new EditListColumn("publicaddress", "Public Address", 20, false, "text", "", 128);
		$edlist->columns[] = new EditListColumn("statusurl", "Status URL", 20, false, "text", "", 255);
	}
	
	
	if ($HTTP_POST_VARS)
	{
		if ($edlist->update())
			message("success", "Operation successful.");
		else
			message("warning", $edlist->error());
	}
	
?>
Enter the addresses of all servers that you want to accept data from here.<p>

<?php
  if (((isset($_GET['advanced'])) && ($_GET['advanced'] == 1)) ||
      ((isset($_POST['advanced'])) && ($_POST['advanced'] == 1))) 
	{
?>
&gt;&gt; Go to <a href="<?php echo $g_options["scripturl"]; ?>?mode=admin&admingame=<?php echo $gamecode; ?>&task=servers&advanced=0#servers">Basic View</a><p>

The "Public Address" should be the address you want shown to users. If left blank, it will be generated from the IP Address and Port. If you are using any kind of log relaying utility (i.e. hlstats.pl will not be receiving data directly from the game servers), you will want to set the IP Address and Port to the address of the log relay program, and set the Public Address to the real address of the game server. You will need a separate log relay for each game server. You can specify a hostname (or anything at all) in the Public Address.<p>
<?php
	}
	else
	{
?>
&gt;&gt; Go to <a href="<?php echo $g_options["scripturl"]; ?>?mode=admin&admingame=<?php echo $gamecode; ?>&task=servers&advanced=1#servers">Advanced View</a><p>
<?php
	}
	
	$result = $db->query("
		SELECT
			serverId,
			address,
			port,
			name,
			publicaddress,
			statusurl,
			rcon_password
		FROM
			hlstats_Servers
		WHERE
			game='$gamecode'
		ORDER BY
			address ASC,
			port ASC
	");
	
	$edlist->draw($result);

  $advanced = ""; 
  if (((isset($_GET['advanced'])) && ($_GET['advanced'] == 1)) ||
      ((isset($_POST['advanced'])) && ($_POST['advanced'] == 1))) { 
    $advanced = 1;
  }  


?>

<input type="hidden" name="advanced" value="<?php echo $advanced ?>">
<table width="75%" border=0 cellspacing=0 cellpadding=0>
<tr>
	<td align="center"><input type="submit" value="  Apply  " class="submit"></td>
</tr>
</table>

