<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	
	// Player Chat History
	
	$player =  valid_request(intval($HTTP_GET_VARS["player"]), 1)
		or error("No player ID specified.");
	
	$db->query("
		SELECT
			hlstats_Players.lastName,
			hlstats_Players.game
		FROM
			hlstats_Players
		WHERE
			playerId=$player
	");
	if ($db->num_rows() != 1)
		error("No such player '$player'.");
	
	$playerdata = $db->fetch_array();
	
	
	$pl_name = $playerdata["lastName"];
	if (strlen($pl_name) > 10)
	{
		$pl_shortname = substr($pl_name, 0, 8) . "...";
	}
	else
	{
		$pl_shortname = $pl_name;
	}
  $pl_name = htmlentities($pl_name, ENT_COMPAT, "UTF-8");
  $pl_shortname = htmlentities($pl_shortname, ENT_COMPAT, "UTF-8");
	
	
	$game = $playerdata["game"];
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() != 1)
		$gamename = ucfirst($game);
	else
		list($gamename) = $db->fetch_row();
	
	
	pageHeader(
		array($gamename, "Chat History", $pl_name),
		array(
			$gamename=>$g_options["scripturl"] . "?game=$game",
			"Player Rankings"=>$g_options["scripturl"] . "?mode=players&amp;game=$game",
			"Player Details"=>$g_options["scripturl"] . "?mode=playerinfo&amp;player=$player",
			"Event History"=>""
		),
		$playername
	);
	
	flush();
	
	
	$table = new Table(
		array(
			new TableColumn(
				"eventTime",
				"Date",
				"width=20"
			),
			new TableColumn(
				"eventType",
				"Type",
				"width=10&align=center"
			),
			new TableColumn(
				"eventDesc",
				"Description",
				"width=40&sort=no&append=.&embedlink=yes"
			),
			new TableColumn(
				"serverName",
				"Server",
				"width=20"
			),
			new TableColumn(
				"map",
				"Map",
				"width=10"
			)
		),
		"eventTime",
		"eventTime",
		"eventType",
		false,
		50,
		"page",
		"sort",
		"sortorder"
	);
	
	$surl = $g_options["scripturl"];
	
	
	// This would be better done with a UNION query, I think, but MySQL doesn't
	// support them yet. (NOTE you need MySQL 3.23 for temporary table support.)
	
	$db->query("DROP TABLE IF EXISTS hlstats_ChatHistory");
	$db->query("
		CREATE TEMPORARY TABLE hlstats_ChatHistory
		(
			eventType VARCHAR(32) NOT NULL,
			eventTime DATETIME NOT NULL,
			eventDesc VARCHAR(255) NOT NULL,
			serverName VARCHAR(32) NOT NULL,
			map VARCHAR(32) NOT NULL
		)
	");
	
	function insertEvents ($table, $select)
	{
		global $db;
		
		$select = str_replace("<table>", "hlstats_Events_$table", $select);
		$db->query("
			INSERT INTO
				hlstats_ChatHistory
				(
					eventType,
					eventTime,
					eventDesc,
					serverName,
					map
				)
			$select
		");
	}
	
	insertEvents("Chat", "
		SELECT
			'Say',
			<table>.eventTime,
			CONCAT('I said \"', message, '\"'),
			hlstats_Servers.name,
			<table>.map
		FROM
			<table>
		LEFT JOIN hlstats_Servers ON
			hlstats_Servers.serverId = <table>.serverId
		WHERE
			<table>.playerId=$player
	");
	
	
	$result = $db->query("
		SELECT
			eventTime,
			eventType,
			eventDesc,
			serverName,
			map
		FROM
			hlstats_ChatHistory
		ORDER BY
			$table->sort $table->sortorder,
			$table->sort2 $table->sortorder
		LIMIT
			$table->startitem,$table->numperpage
	");
	
	$resultCount = $db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_ChatHistory
	");
	
	list($numitems) = $db->fetch_row($resultCount);
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
    <td width="100%"><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Player Event History</b> (Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"];?><p>
</tr>
<tr>
    <table width="95%" align="center" border=0 cellspacing=0 cellpadding=0>
    <tr>
      <td align="right"><?php echo $g_options["font_normal"]; ?>Back to <a href="<?php echo $g_options["scripturl"] . "?mode=playerinfo&amp;player=$player"; ?>">Player Statistics</a><?php echo $g_options["fontend_normal"]; ?></td>
    </tr>
    </table><p>
      

	<?php
		$table->draw($result, $numitems, 95);
	?></td>
</tr>

</table>
