<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	// Clan Rankings
	
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() < 1) error("No such game '$game'.");
	
	list($gamename) = $db->fetch_row();
	$db->free_result();
	
	if (isset($HTTP_GET_VARS["minmembers"]))
	{
		$minmembers = valid_request(intval($HTTP_GET_VARS["minmembers"]),1);
	}
	else
	{
		$minmembers = 3;
	}
	
	pageHeader(
		array($gamename, "Clan Rankings"),
		array($gamename=>"%s?game=$game", "Clan Rankings"=>"")
	);
?>

<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>
<tr>
    <td><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Clan Rankings</b><?php echo $g_options["fontend_normal"];?><p>



<form method="GET" action="<?php echo $g_options["scripturl"]; ?>">
<input type="hidden" name="mode" value="search">
<input type="hidden" name="game" value="<?php echo $game; ?>">
<input type="hidden" name="st" value="clan">

<table width="95%" align="center" border=0 cellspacing=0 cellpadding=2>

<tr valign="bottom">
	<td width="75%"><?php echo $g_options["font_normal"]; ?><b>&#149;</b> Find a clan: <input type="text" name="q" size=20 maxlength=64 class="textbox"> <input type="submit" value="Search" class="smallsubmit"><?php echo $g_options["fontend_normal"]; ?></td>
	<td width="25%" align="right" nowrap><?php echo $g_options["font_normal"]; ?>Go to <a href="<?php echo $g_options["scripturl"] . "?mode=players&amp;game=$game"; ?>"><img src="<?php echo $g_options["imgdir"]; ?>/player.gif" width=16 height=16 hspace=3 border=0 align="middle" alt="player.gif">Player Rankings</a><?php echo $g_options["fontend_normal"]; ?></td>
</tr>

</table><p>
</form>

<?php
	$table = new Table(
		array(
			new TableColumn(
				"name",
				"Name",
				"width=25&icon=clan&link=" . urlencode("mode=claninfo&amp;clan=%k")
			),
			new TableColumn(
				"tag",
				"Tag",
				"width=15&align=center"
			),
			new TableColumn(
				"skill",
				"Points",
				"width=8&align=right"
			),
			new TableColumn(
				"nummembers",
				"Members",
				"width=5&align=right"
			),
      new TableColumn(
       "activity",
       "Activity",
       "width=8&sort=no&type=bargraph"
      ),
      new TableColumn(
       "connection_time",
       "Time",
       "width=13&align=right&type=timestamp"
      ),
			new TableColumn(
				"kills",
				"Kills",
				"width=7&align=right"
			),
			new TableColumn(
				"deaths",
				"Deaths",
				"width=7&align=right"
			),
			new TableColumn(
				"kpd",
				"Kpd",
				"width=7&align=right"
			)
		),
		"clanId",
		"skill",
		"kpd",
		true
	);

	$result = $db->query("
		SELECT
			hlstats_Clans.clanId,
			hlstats_Clans.name,
			hlstats_Clans.tag,
			COUNT(hlstats_Players.playerId) AS nummembers,
			SUM(hlstats_Players.kills) AS kills,
			SUM(hlstats_Players.deaths) AS deaths,
      SUM(hlstats_Players.connection_time) AS connection_time,
			ROUND(AVG(hlstats_Players.skill)) AS skill,
			IFNULL(SUM(hlstats_Players.kills)/SUM(hlstats_Players.deaths), '-') AS kpd,
      TRUNCATE(AVG(IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), -1)), 2) as activity
		FROM
			hlstats_Clans, hlstats_Players
		WHERE
			hlstats_Clans.game='$game' 
      AND hlstats_Players.clan=hlstats_Clans.clanId
      AND hlstats_Players.hideranking = 0
      AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), -1) >= 0
		GROUP BY
			hlstats_Clans.clanId
		HAVING
      activity >= 0 AND
			nummembers >= $minmembers
		ORDER BY
			$table->sort $table->sortorder,
			$table->sort2 $table->sortorder,
			name ASC
		LIMIT $table->startitem,$table->numperpage
	");
	
	$resultCount = $db->query("
		SELECT
			hlstats_Clans.clanId,
      SUM(IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), -1)) as activity
		FROM
			hlstats_Clans
		LEFT JOIN hlstats_Players ON
			hlstats_Players.clan=hlstats_Clans.clanId
		WHERE
			hlstats_Clans.game='$game'
      AND hlstats_Players.hideranking = 0
		GROUP BY
			hlstats_Clans.clanId
		HAVING
      activity >= 0 AND
			COUNT(hlstats_Players.playerId) >= $minmembers
	");
	
	$table->draw($result, $db->num_rows($resultCount), 95);
?><p>

<form method="GET" action="<?php echo $g_options["scripturl"]; ?>"> 
<table width="95%" align="center" border=0 cellspacing=0 cellpadding=2>

<tr valign="bottom">
	<td width="75%"><?php echo $g_options["font_normal"]; ?>
<?php
	foreach ($HTTP_GET_VARS as $k=>$v)
	{
    $v = valid_request($v, 0);     
		if ($k != "minmembers")
		{
			echo "<input type=\"hidden\" name=\"$k\" value=\"" . htmlspecialchars($v) . "\">\n";
		}
	}
?>
		<b>&#149;</b> Only show clans with <input type="text" name="minmembers" size=4 maxlength=2 value="<?php echo $minmembers; ?>" class="textbox"> or more members. <input type="submit" value="Apply" class="smallsubmit"><?php echo $g_options["fontend_normal"]; ?></td>
</tr>

</table>
</form>

</td></tr>
</table>
