<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	/*
	 * HLstatsX Page Footer This file will be inserted at the end of every page
	 * generated by HLstats. This file can contain PHP code.
	 */
     
  #if (SHOW_CITIES == 1)  
   # new LocateCities();
    
?>

<br>
<center>
<?php echo $g_options["font_small"]; ?>Generated in real-time by <a href="http://www.hlstatsx.com">HLstatsX</a> V<?php echo VERSION; ?>&nbsp;&nbsp;<a href="http://www.hlstatsx.com/masterserver">(Official Serverlist)</a>&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;[<a href="<?php echo $g_options["scripturl"]; ?>?mode=admin">Admin</a>]<?php echo $g_options["fontend_small"]; ?><br><br>
</center>

<?php
  global $mode;
  global $game;
  global $redirect_to_game;
  
  if ((SHOW_GOOGLE_MAP == 1) && ($mode == "contents") && ($redirect_to_game > 0))  {

?> 
            <script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo GOOGLE_MAP_KEY; ?>" type="text/javascript"></script>
            <script type="text/javascript">
               var icon = new GIcon();
               icon.image = "<?php echo $g_options["imgdir"]; ?>/mm_20_blue.png";
               icon.shadow = "<?php echo $g_options["imgdir"]; ?>/mm_20_shadow.png";
               icon.iconSize = new GSize(12, 20);
               icon.shadowSize = new GSize(22, 20);
               icon.iconAnchor = new GPoint(6, 20);
               icon.infoWindowAnchor = new GPoint(5, 1);

               var map = new GMap2(document.getElementById("map"));
               
               map.addControl(new GLargeMapControl());
               map.addControl(new GMapTypeControl());
               
               map.enableDoubleClickZoom();

              <?php
                    switch (strtoupper(GOOGLE_MAP_REGION)) {
                      case "EUROPE"         : echo 'map.setCenter(new GLatLng(48.8, 8.5),     4);';
                                              break;    
                      case "NORTH AMERICA"  : echo 'map.setCenter(new GLatLng(45.0, -97.0),   3);';
                                              break;
                      case "SOUTH AMERICA"  : echo 'map.setCenter(new GLatLng(-14.8, -61.2),  3);';
                                              break;    
                      case "NORTH AFRICA"   : echo 'map.setCenter(new GLatLng(25.4, 8.4),     4);';
                                              break;
                      case "SOUTH AFRICA"   : echo 'map.setCenter(new GLatLng(-29.0, 23.7),   5);';
                                              break;    
                      case "NORTH EUROPE"   : echo 'map.setCenter(new GLatLng(62.6, 15.4),    4);';
                                              break;
                      case "EAST EUROPE"    : echo 'map.setCenter(new GLatLng(51.9, 31.8),    4);';
                                              break;
                      case "GERMANY"        : echo 'map.setCenter(new GLatLng(51.1, 10.1),    5);';
                                              break;    
                      case "FRANCE"         : echo 'map.setCenter(new GLatLng(47.2, 2.4),     5);';
                                              break;    
                      case "SPAIN"          : echo 'map.setCenter(new GLatLng(40.3, -4.0),    5);';
                                              break;    
                      case "UNITED KINGDOM" : echo 'map.setCenter(new GLatLng(54.0, -4.3),    5);';
                                              break;    
                      case "DENMARK"        : echo 'map.setCenter(new GLatLng(56.1, 9.2),     6);';
                                              break;    
                      case "SWEDEN"         : echo 'map.setCenter(new GLatLng(63.2, 16.3),    4);';
                                              break;   
                      case "NORWAY"         : echo 'map.setCenter(new GLatLng(65.6, 13.1),    4);';
                                              break;    
                      case "FINLAND"        : echo 'map.setCenter(new GLatLng(65.1, 26.6),    4);';
                                              break;    
                      case "NETHERLANDS"    : echo 'map.setCenter(new GLatLng(52.3, 5.4),     7);';
                                              break;
                      case "BELGIUM"        : echo 'map.setCenter(new GLatLng(50.7, 4.5),     7);';
                                              break;    
                      case "SUISSE"         : echo 'map.setCenter(new GLatLng(46.8, 8.2),     7);';
                                              break;    
                      case "AUSTRIA"        : echo 'map.setCenter(new GLatLng(47.7, 14.1),    7);';
                                              break;    
                      case "POLAND"         : echo 'map.setCenter(new GLatLng(52.1, 19.3),    6);';
                                              break;    
                      case "ITALY"          : echo 'map.setCenter(new GLatLng(42.6, 12.7),    5);';
                                              break;    
                      case "TURKEY"         : echo 'map.setCenter(new GLatLng(39.0, 34.9),    6);';
                                              break;    
                      case "BRAZIL"         : echo 'map.setCenter(new GLatLng(-12.0, -53.1),  4);';
                                              break;    
                      case "ARGENTINA"      : echo 'map.setCenter(new GLatLng(-34.3, -65.7),  3);';
                                              break;    
                      case "RUSSIA"         : echo 'map.setCenter(new GLatLng(65.7, 98.8),    3);';
                                              break;    
                      case "ASIA"           : echo 'map.setCenter(new GLatLng(20.4, 95.6),    3);';
                                              break;    
                      case "CHINA"          : echo 'map.setCenter(new GLatLng(36.2, 104.0),   4);';
                                              break;    
                      case "JAPAN"          : echo 'map.setCenter(new GLatLng(36.2, 136.8),   5);';
                                              break;    
                      case "SOUTH KOREA"    : echo 'map.setCenter(new GLatLng(36.6, 127.8),   6);';
                                              break;    
                      case "AUSTRALIA"      : echo 'map.setCenter(new GLatLng(-26.1, 134.8),  4);';
                                              break;    
                      case "CANADA"         : echo 'map.setCenter(new GLatLng(60.0, -97.0),   3);';
                                              break;    
                      case "WORLD"          : echo 'map.setCenter(new GLatLng(25.0, 8.5),     2);';
                                              break;    
                      default               : echo 'map.setCenter(new GLatLng(48.8, 8.5),     4);';
                                              break;    
                    }
                    switch (strtoupper(GOOGLE_MAP_TYPE)) {
                      case "SATELLITE"      : echo 'map.setMapType(G_SATELLITE_TYPE);';
                                              break;    
                      case "MAP"            : echo 'map.setMapType(G_MAP_TYPE);';
                                              break;    
                      case "HYBRID"         : echo 'map.setMapType(G_HYBRID_TYPE);';
                                              break;    
                      default               : echo 'map.setMapType(G_HYBRID_TYPE);';
                                              break;    
                    }    
                 ?>       
                 
                 function createMarker(point, name, city, country, kills, deaths, time, player_id) {
                   var marker    = new GMarker(point, icon);
                   var html_text = '<table border=0 style="text-align:left;"><tr><td colspan="2" align="left" style="border-bottom:1px solid black;"><a href="hlstats.php?mode=playerinfo&player='+player_id+'" style="color:blue;font-weight:bold;text-decoration:none;"><small>'+name+'</small></a></td></tr>'+
                                   '<tr><td><small>Location</small></td><td><small>'+city+', '+country+'<small></td></tr>'+
                                   '<tr><td><small>Frags</small></td><td><small>'+kills+':'+deaths+'<small></td></tr>'+
                                   '<tr><td><small>Time</small></td><td><small>'+time+'<small></td></tr>'+
                                   '</table>';  
                   map.addOverlay(marker);
                   GEvent.addListener(marker, "click", function() {marker.openInfoWindowHtml(html_text);});
                 }
                 
                 
                 <?php
                   global $db;
                   $data = array();
                   $db->query("SELECT hlstats_Livestats.* FROM hlstats_Livestats, hlstats_Servers WHERE hlstats_Livestats.cli_lat<>0 AND hlstats_Livestats.cli_lng<>0 AND hlstats_Livestats.cli_address<>'' AND hlstats_Servers.serverId=hlstats_Livestats.server_id AND hlstats_Servers.game='$game'");
                   while ($rowdata = $db->fetch_array()) {
                     $search_pattern  = array("/[^A-Za-z0-9\[\]*.,=()!\"$%&^`':;߲#+~_\-|<>\/@{} ]/");
                     $replace_pattern = array("");
                     $rowdata['name'] = preg_replace($search_pattern, $replace_pattern, $rowdata['name']);
                    
                     $stamp    = time()-$rowdata['connected'];
                     $hours    = sprintf("%02d", floor($stamp / 3600));
                     $min      = sprintf("%02d", floor(($stamp % 3600) / 60));
                     $sec      = sprintf("%02d", floor($stamp % 60)); 
                     $time_str = $hours.":".$min.":".$sec;  
                     echo "createMarker(new GLatLng(".$rowdata['cli_lat'].", ".
                                                      $rowdata['cli_lng']."), \"".
                                                      htmlentities(urldecode($rowdata['name']), ENT_QUOTES)."\", \"".
                                                      htmlentities(urldecode($rowdata['cli_city']), ENT_QUOTES)."\", \"".
                                                      htmlentities(ucfirst(strtolower(urldecode($rowdata['cli_country']))), ENT_QUOTES)."\", ".
                                                      $rowdata['kills'].",".$rowdata['deaths'].", \"".
                                                      $time_str."\",".$rowdata['player_id'].");\n";
                    }                                   
                 ?>
            </script>
<?php } ?>            


</body>
</html>
