<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	
	// Player Details
	
	$player = valid_request(intval($HTTP_GET_VARS["player"]), 1);
	$uniqueid  = valid_request(strval($HTTP_GET_VARS["uniqueid"]), 0);
	$game = valid_request(strval($HTTP_GET_VARS["game"]), 0);

	
	if (!$player && $uniqueid)
	{
		if (!$game)
		{
			header("Location: " . $g_options["scripturl"] . "&mode=search&st=uniqueid&q=$uniqueid");
			exit;
		}
		
		$db->query("
			SELECT
				playerId
			FROM
				hlstats_PlayerUniqueIds
			WHERE
				uniqueId='$uniqueid'
				AND game='$game'
		");
		
		if ($db->num_rows() > 1)
		{
			header("Location: " . $g_options["scripturl"] . "&mode=search&st=uniqueid&q=$uniqueid&game=$game");
			exit;
		}
		elseif ($db->num_rows() < 1)
		{
			error("No players found matching uniqueId '$uniqueid'");
		}
		else
		{
			list($player) = $db->fetch_row();
			$player = intval($player);
		}
	}
	elseif (!$player && !$uniqueid)
	{
		error("No player ID specified.");
	}
	
	$db->query("
		SELECT
			hlstats_Players.playerId,
      hlstats_Players.connection_time,
			hlstats_Players.lastName,
      hlstats_Players.country,
      hlstats_Players.flag,
			hlstats_Players.clan,
			hlstats_Players.fullName,
			hlstats_Players.email,
			hlstats_Players.homepage,
			hlstats_Players.icq,
			hlstats_Players.game,
			hlstats_Players.skill,
			hlstats_Players.kills,
			hlstats_Players.deaths,
			IFNULL(kills/deaths, '-') AS kpd,
			hlstats_Players.suicides,
			hlstats_Players.headshots,
			IFNULL(headshots/kills, '-') AS hpk,
			hlstats_Players.shots,
			hlstats_Players.hits,
			IFNULL(ROUND((hits / shots * 100), 1), 0.0) AS acc,
			CONCAT(hlstats_Clans.name) AS clan_name,
      IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - last_event))), 0) as activity
		FROM
			hlstats_Players
		LEFT JOIN hlstats_Clans ON
			hlstats_Clans.clanId = hlstats_Players.clan
		WHERE
			playerId='$player'
	");
	if ($db->num_rows() != 1)
		error("No such player '$player'.");
	
	$playerdata = $db->fetch_array();
	$db->free_result();
	
	$pl_name = $playerdata["lastName"];
	if (strlen($pl_name) > 10)
	{
		$pl_shortname = substr($pl_name, 0, 8) . "...";
	}
	else
	{
		$pl_shortname = $pl_name;
	}
	$pl_name = htmlentities($pl_name, ENT_COMPAT, "UTF-8");
	$pl_shortname = htmlentities($pl_shortname, ENT_COMPAT, "UTF-8");
	$pl_urlname = urlencode($playerdata["lastName"]);
	
	
	$game = $playerdata["game"];
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() != 1)
		$gamename = ucfirst($game);
	else
		list($gamename) = $db->fetch_row();
	
?>



<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr valign="top">
	<td width="100%">
		<table width="100%" border=0 cellspacing=0 cellpadding=0 bgcolor="<?php echo $g_options["table_border"]; ?>">

		<tr>
			<td>
				<table width="100%" border=0 cellspacing=1 cellpadding=3>
			
        <tr valign="bottom" bgcolor="<?php echo $g_options["table_head_bgcolor"]; ?>">
          <td colspan="3"><?php
            echo $g_options["font_small"];
            echo "Statistics Summary";
            echo $g_options["fontend_small"];
          ?></td>
        </tr>
        <tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
            <td align="left"><?php
                echo $g_options["font_small"];
                echo "Name:";
                echo $g_options["fontend_small"];
            ?></td>
            <td colspan="2" align="left"><?php
                echo $g_options["font_small"];
                if (SHOW_FLAGS == 1) 
                  echo '<img src="'.$g_options["imgdir"].'/flags/'.flag_exists(strtolower($playerdata["flag"]).".gif").'" style="border:0px;" alt="'.strtolower($playerdata["country"]).'" title="'.strtolower($playerdata["country"]).'">&nbsp;';   
                echo "<b>" . htmlentities($playerdata["lastName"], ENT_COMPAT, "UTF-8") . "</b>";
                echo $g_options["fontend_small"]; 
            ?></td>
        </tr>
        <tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
           <td align="left"><?php
              echo $g_options["font_small"];
              echo "Member of Clan:";
              echo $g_options["fontend_small"];
           ?></td>
           <td colspan="2" align="left"><?php
              echo $g_options["font_small"];
              if ($playerdata["clan"]) {
                echo "&nbsp;<a href=\"" . $g_options["scripturl"]
                   . "?mode=claninfo&clan=" . $playerdata["clan"]
                   . "\">"
                   . htmlentities($playerdata["clan_name"], ENT_COMPAT, "UTF-8") . "</a>";
              } else
                echo "(None)";
              echo $g_options["fontend_small"];
           ?></td>
        </tr>


				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Rank:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
            if ($playerdata['activity'] > 0)
            {            
    						$db->query("
		  					SELECT
                  COUNT(*)
							  FROM
								    hlstats_Players
							  WHERE
							    	game='$game' 
                    AND skill>'".$playerdata['skill']."' 
                    AND hideranking = 0
          	     		AND kills >= 1
                    AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), UNIX_TIMESTAMP() - last_event, -1) >= 0
				    		");
                            
						  list($rank) = $db->fetch_row();
						  $rank++;

    						$result = $db->query("
		  					SELECT
            			playerId,
              			IFNULL(kills / deaths, '-') AS kpd
    							FROM
		  					   	hlstats_Players
			 			     	WHERE
				    				game='$game' 
                    AND skill='".$playerdata['skill']."' 
                    AND hideranking = 0
              			AND kills >= 1
                    AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), UNIX_TIMESTAMP() - last_event, -1) >= 0
		  			     	ORDER BY kpd DESC,					
           			       lastName ASC
				    		");
         		   while ($rowdata = $db->fetch_array($result))  {
         			   if ($rowdata['playerId'] == $playerdata['playerId'])
         			     break;
			          $rank++;
		           }	
            } else
              $rank = "Not active";    

            if (is_numeric($rank))
              echo "<b>" . number_format($rank) . "</b>";
            else              
              echo "<b>" . $rank . "</b>";
                        
						echo $g_options["fontend_small"];
					?></td>
				</tr>


				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Points:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
            echo "<b>" . number_format($playerdata["skill"]) . "</b>";
						echo $g_options["fontend_small"];
					?></td>
				</tr>

        <tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
          <td width="45%"><?php
            echo $g_options["font_small"];
            echo "Activity:*";
            echo $g_options["fontend_small"];
          ?></td>
          <td width="45%"><?php
            $width = sprintf("%d%%", $playerdata['activity'] + 0.5);
            $bar_type = 1;
            if ($playerdata['activity'] > 40)
              $bar_type = "6";
            elseif ($playerdata['activity'] > 30)
              $bar_type = "5";
            elseif ($playerdata['activity'] > 20)
              $bar_type = "4";
            elseif ($playerdata['activity'] > 10)
              $bar_type = "3";
            elseif ($playerdata['activity'] > 5)
              $bar_type = "2";
              
            echo "<img src=\"" . $g_options["imgdir"] . "/bar".$bar_type.".gif\" width=\"".$width."\" height=10 border=0 alt=\"".$playerdata['activity']."%\">";            
          ?></td>
          <td width="10%"><?php
            echo $g_options["font_small"];
            echo $playerdata["activity"]."%";
            echo $g_options["fontend_small"];
          ?></td>
       </tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Kills:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
						echo number_format($playerdata["kills"]);
						$db->query("
							SELECT
								COUNT(*)
							FROM
								hlstats_Events_Frags
							LEFT JOIN hlstats_Servers ON
								hlstats_Servers.serverId=hlstats_Events_Frags.serverId
							WHERE
								hlstats_Servers.game='$game' AND killerId='$player'
						");
						list($realkills) = $db->fetch_row();
						echo " (".number_format($realkills).")";
						echo $g_options["fontend_small"];
					?></td>
				</tr>

				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Deaths:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
						echo number_format($playerdata["deaths"]);
						echo $g_options["fontend_small"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Suicides:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
						echo number_format($playerdata["suicides"]);
						echo $g_options["fontend_small"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Kills per Death:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
						$db->query("
							SELECT
          			IFNULL(SUM(killerId='$player')/SUM(victimId='$player'), '-') AS kpd
							FROM
								hlstats_Events_Frags,
							  hlstats_Servers
							WHERE
                hlstats_Servers.serverId=hlstats_Events_Frags.serverId AND
                (hlstats_Events_Frags.killerId='$player' OR hlstats_Events_Frags.victimId='$player') AND
								hlstats_Servers.game='$game'
						");
						list($realkpd) = $db->fetch_row();
						echo						 $playerdata["kpd"];
						echo " ($realkpd)";
						echo $g_options["fontend_small"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Headshots:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
						$db->query("
							SELECT
								COUNT(*)
							FROM
								hlstats_Events_Frags
							LEFT JOIN hlstats_Servers ON
								hlstats_Servers.serverId=hlstats_Events_Frags.serverId
							WHERE
								hlstats_Servers.game='$game' AND killerId='$player'
								AND headshot=1		
						");
						list($realheadshots) = $db->fetch_row();
						if ($playerdata["headshots"]==0) 
  						echo number_format($realheadshots);
            else
						  echo number_format($playerdata["headshots"]);
						echo " (".number_format($realheadshots).")";
						echo $g_options["fontend_small"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Headshots per Kill:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
    				$db->query("
							SELECT
          			IFNULL(SUM(headshot=1)/COUNT(*), '-') AS hpk
							FROM
								hlstats_Events_Frags
							LEFT JOIN hlstats_Servers ON
								hlstats_Servers.serverId=hlstats_Events_Frags.serverId
							WHERE
								hlstats_Servers.game='$game' AND killerId='$player'
						");
						list($realhpk) = $db->fetch_row();
					  echo					   $playerdata["hpk"];
						echo " ($realhpk)";
						echo $g_options["fontend_small"];
					?></td>
				</tr>
				
				<tr bgcolor="<?php echo $g_options["table_bgcolor1"]; ?>">
					<td width="45%"><?php
						echo $g_options["font_small"];
						echo "Weapon Accuracy:";
						echo $g_options["fontend_small"];
					?></td>
					<td colspan="2" width="55%"><?php
						echo $g_options["font_small"];
   					$db->query("
							SELECT
								IFNULL(ROUND((SUM(hlstats_Events_Statsme.hits)
									/ SUM(hlstats_Events_Statsme.shots) * 100), 1), 0.0) AS accuracy,
                SUM(hlstats_Events_Statsme.shots) as shots,
                SUM(hlstats_Events_Statsme.hits) as hits
							FROM
								hlstats_Events_Statsme
							LEFT JOIN hlstats_Servers ON
								hlstats_Servers.serverId=hlstats_Events_Statsme.serverId
							WHERE
								hlstats_Servers.game='$game' AND playerId='$player'
						");
						list($playerdata["accuracy"], $sm_shots, $sm_hits) = $db->fetch_row();
  					echo $playerdata["acc"] . "%";
						echo " (".$playerdata["accuracy"] . "%)";
						echo $g_options["fontend_small"];
					?></td>
				</tr>

        <tr bgcolor="<?php echo $g_options["table_bgcolor2"]; ?>">
           <td align="left"><?php
              echo $g_options["font_small"];
              echo "Total Connection Time:";
              echo $g_options["fontend_small"];
            ?></td>
            <td colspan="2" align="left"><?php
              echo $g_options["font_small"];
              echo timestamp_to_str($playerdata['connection_time']);
              echo $g_options["fontend_small"]; ?></td>
        </tr>

				</table></td>
		</tr>
		
		</table>
</tr>
</table>