<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	
	// Map Statistics
	
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() < 1) error("No such game '$game'.");
	
	list($gamename) = $db->fetch_row();
	$db->free_result();
	
	pageHeader(
		array($gamename, "Map Statistics"),
		array($gamename=>"%s?game=$game", "Map Statistics"=>"")
	);


	$tblMaps = new Table(
		array(
			new TableColumn(
				"map",
				"Map Name",
				"width=23&align=left&link=" . urlencode("mode=mapinfo&map=%k&game=$game")
			),
			new TableColumn(
				"kills",
				"Kills",
				"width=10&align=right"
			),
			new TableColumn(
				"kpercent",
				"Percentage of Kills",
				"width=15&sort=no&type=bargraph"
			),
			new TableColumn(
				"kpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"headshots",
				"Headshots",
				"width=10&align=right"
			),
			new TableColumn(
				"hpercent",
				"Percentage of Headshots",
				"width=15&sort=no&type=bargraph"
			),
			new TableColumn(
				"hpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"hpk",
				"Headshots per Kill",
				"width=12&align=right"
			)
		),
		"map",
		"kills",
		"map",
		true,
		9999,
		"maps_page",
		"maps_sort",
		"maps_sortorder",
		"maps"
	);
	
	$db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_Events_Frags,
			hlstats_Servers		
		WHERE
			hlstats_Servers.serverId = hlstats_Events_Frags.serverId AND
			hlstats_Servers.game = '$game'
	");
	
	list($realkills) = $db->fetch_row();
	
  $db->query("
	 	SELECT
			COUNT(*)
		FROM
			hlstats_Events_Frags,
			hlstats_Servers		
		WHERE
			hlstats_Servers.serverId = hlstats_Events_Frags.serverId AND
			hlstats_Servers.game = '$game' AND headshot=1
	");
	list($realheadshots) = $db->fetch_row();
	

	$result = $db->query("
		SELECT
			IF(map='', '(Unaccounted)', map) AS map,
			COUNT(hlstats_Events_Frags.map) AS kills,
			COUNT(hlstats_Events_Frags.map) / $realkills * 100 AS kpercent,
			SUM(headshot=1) as headshots,
			IFNULL(SUM(headshot=1) / COUNT(hlstats_Events_Frags.map), '-') AS hpk,
			ROUND(CONCAT(SUM(headshot=1)) / $realheadshots * 100, 2) AS hpercent
		FROM
			hlstats_Events_Frags,
			hlstats_Servers		
		WHERE
			hlstats_Servers.serverId = hlstats_Events_Frags.serverId AND
			hlstats_Servers.game='$game'
		GROUP BY
			hlstats_Events_Frags.map
		ORDER BY
			$tblMaps->sort $tblMaps->sortorder,
			$tblMaps->sort2 $tblMaps->sortorder
	");

?>

<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>
<tr>
    <td><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Map Statistics</b><?php echo $g_options["fontend_normal"];?><p>



<table width="95%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%"><?php echo $g_options["font_normal"]; ?>From a total of <b><?php echo number_format($realkills); ?></b> kills with <b><?php echo number_format($realheadshots); ?></b> headshots (Last <?php echo DELETEDAYS; ?> Days)<?php echo $g_options["fontend_normal"]; ?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>Back to <a href="<?php echo $g_options["scripturl"] . "?game=$game"; ?>"><?php echo $gamename; ?></a><?php echo $g_options["fontend_normal"]; ?></td>
</tr>

</table><p>
<?php $tblMaps->draw($result, $db->num_rows($result), 95);
?>

</td></tr>
</table>