<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	
	// Player Rankings
	
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() < 1) error("No such game '$game'.");
	
	list($gamename) = $db->fetch_row();
	$db->free_result();
	
	if (isset($HTTP_GET_VARS["minkills"]))
	{
		$minkills = valid_request(intval($HTTP_GET_VARS["minkills"]), 1);
	}
	else
	{
		$minkills = 1;
	}
	
	pageHeader(
		array($gamename, "Player Rankings"),
		array($gamename=>"%s?game=$game", "Player Rankings"=>"")
	);
    
  $rank_type = 0;
  if (isset($HTTP_GET_VARS["rank_type"]))
    $rank_type = valid_request(strval($HTTP_GET_VARS["rank_type"]), 0);
  
?>
<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>
<tr>
    <td><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Player Rankings</b><?php echo $g_options["fontend_normal"];?><p>





<table width="95%" align="center" border=0 cellspacing=0 cellpadding=2>

<tr valign="bottom">
  <td width="35%">
    <form method="GET" action="<?php echo $g_options["scripturl"]; ?>" style="margin:0px;padding:0px;">
    <input type="hidden" name="mode" value="players">
    <input type="hidden" name="game" value="<?php echo $game; ?>">
    <?php echo $g_options["font_normal"]; ?><b>&#149;</b> Ranking View <?php echo $g_options["fontend_normal"]; ?><?php
    $result = $db->query("SELECT eventTime FROM hlstats_Players_History GROUP BY eventTime ORDER by eventTime DESC LIMIT 0, 50");
    echo '<select name="rank_type"><option value="0">Total Ranking</option>';
    $i = 1;
    $dates = array();
    while ($rowdata = $db->fetch_array()) {
      $dates[] = $rowdata;  
      if ($rank_type == $i) 
        echo '<option value="'.$i.'" selected="selected">'.$rowdata['eventTime'].'</option>';
      else
        echo '<option value="'.$i.'">'.$rowdata['eventTime'].'</option>';
      $i++;
    }  
    echo '</select>';
    ?> <input type="submit" value="View" class="smallsubmit"></form>
  </td>  
  <td width="35%">
    <form method="GET" action="<?php echo $g_options["scripturl"]; ?>" style="margin:0px;padding:0px;">
    <input type="hidden" name="mode" value="search">
    <input type="hidden" name="game" value="<?php echo $game; ?>">
    <input type="hidden" name="st" value="player">
    <?php echo $g_options["font_normal"]; ?><b>&#149;</b> Find a player: <input type="text" name="q" size=20 maxlength=64 class="textbox"> <input type="submit" value="Search" class="smallsubmit"><?php echo $g_options["fontend_normal"]; ?>
    </form>
  </td>
	<td width="30%" align="right" nowrap><?php echo $g_options["font_normal"]; ?>Go to <a href="<?php echo $g_options["scripturl"] . "?mode=clans&amp;game=$game"; ?>"><img src="<?php echo $g_options["imgdir"]; ?>/clan.gif" width=16 height=16 hspace=3 border=0 align="middle" alt="clan.gif">Clan Rankings</a><?php echo $g_options["fontend_normal"]; ?></td>
</tr>

</table><p>

<?php

if ($rank_type == 0)  {

	$table = new Table(
		array(
			new TableColumn(
				"lastName",
				"Name",
				"width=32&flag=1&link=" . urlencode("mode=playerinfo&amp;player=%k")
			),
			new TableColumn(
				"skill",
				"Points",
				"width=7&align=right&skill_change=1"
			),
      new TableColumn(
       "activity",
       "Activity",
       "width=8&sort=no&type=bargraph"
      ),
      new TableColumn(
       "connection_time",
       "Time",
       "width=12&align=right&type=timestamp"
      ),
			new TableColumn(
				"kills",
				"Kills",
				"width=7&align=right"
			),
			new TableColumn(
				"deaths",
				"Deaths",
				"width=7&align=right"
			),
			new TableColumn(
				"headshots",
				"Hs",
				"width=5&align=right"
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=5&align=right"
			),
      new TableColumn(
        "kpd",
        "Kpd",
        "width=5&align=right"
      ),
			new TableColumn(
				"acc",
				"Accuracy",
				"width=7&align=right&append=" . urlencode("%")
			)
		),
		"playerId",
		"skill",
		"kpd",
		true
	);
	
  $day_interval = 28;  
	$result = $db->query("
		SELECT
			hlstats_Players.playerId,
      hlstats_Players.connection_time,
			hlstats_Players.lastName,
      hlstats_Players.flag,
      hlstats_Players.country,
			hlstats_Players.skill,
			hlstats_Players.kills,
			hlstats_Players.deaths,
      hlstats_Players.last_skill_change,
			hlstats_Players.kills/(IF(hlstats_Players.deaths=0, 1, hlstats_Players.deaths)) AS kpd,
			hlstats_Players.headshots,
			IFNULL(hlstats_Players.headshots/hlstats_Players.kills, '-') AS hpk,
			IFNULL(ROUND((hlstats_Players.hits / hlstats_Players.shots * 100), 1), 0.0) AS acc,
      IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), -1) as activity
		FROM
			hlstats_Players
		WHERE
			hlstats_Players.game='$game'
			AND hlstats_Players.hideranking=0
			AND hlstats_Players.kills >= $minkills
      AND hideranking=0
      AND kills >= $minkills
    HAVING activity >= 0
		ORDER BY
			$table->sort $table->sortorder,
			$table->sort2 $table->sortorder,
			hlstats_Players.lastName ASC
		LIMIT $table->startitem,$table->numperpage
	");
    
	$resultCount = $db->query("
		SELECT
			COUNT(*)
		FROM
			hlstats_Players
		WHERE
			game='$game'
			AND hideranking=0
			AND kills >= $minkills
      AND IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - last_event), UNIX_TIMESTAMP() - last_event, -1) >= 0
	");
	
	list($numitems) = $db->fetch_row($resultCount);
	
	$table->draw($result, $numitems, 95);

} else {

  $table = new Table(
    array(
      new TableColumn(
       "lastName",
       "Name",
       "width=30&flag=1&link=" . urlencode("mode=playerinfo&amp;player=%k")
      ),
      new TableColumn(
       "skill_change",
       "Points",
       "width=7&align=right&skill_change=1"
      ),
      new TableColumn(
       "activity",
       "Activity",
       "width=8&sort=no&type=bargraph"
      ),
      new TableColumn(
       "connection_time",
       "Time",
       "width=7&align=right&type=timestamp"
      ),
      new TableColumn(
        "kills",
        "Kills",
        "width=7&align=right"
      ),
      new TableColumn(
        "deaths",
        "Deaths",
        "width=7&align=right"
      ),
      new TableColumn(
        "headshots",
        "Headshots",
        "width=7&align=right"
      ),
      new TableColumn(
        "hpk",
        "Hpk",
        "width=5&align=right"
      ),
      new TableColumn(
        "kpd",
        "Kills per Death",
        "width=10&align=right"
      ),
      new TableColumn(
        "acc",
        "Accuracy",
        "width=7&align=right&append=" . urlencode("%")
      )
    ),
    "playerId",
    "skill_change",
    "kpd",
    true
    );
    
    $result = $db->query("
        SELECT
            hlstats_Players_History.playerId,
            hlstats_Players.lastName,
            hlstats_Players.flag,
            hlstats_Players.country,
            hlstats_Players_History.connection_time,
            hlstats_Players_History.skill,
            hlstats_Players_History.skill_change,
            hlstats_Players_History.skill_change as last_skill_change,
            hlstats_Players_History.kills,
            hlstats_Players_History.deaths,
            IFNULL(hlstats_Players_History.kills/hlstats_Players_History.deaths, '-') AS kpd,
            hlstats_Players_History.headshots,
            IFNULL(hlstats_Players_History.headshots/hlstats_Players_History.kills, '-') AS hpk,
            IFNULL(ROUND((hlstats_Players_History.hits / hlstats_Players_History.shots * 100), 1), 0.0) AS acc,
            IF(".MINACTIVITY." > (UNIX_TIMESTAMP() - hlstats_Players.last_event), ((100/".MINACTIVITY.") * (".MINACTIVITY." - (UNIX_TIMESTAMP() - hlstats_Players.last_event))), 0) as activity
        FROM
            hlstats_Players_History, hlstats_Players
        WHERE
            hlstats_Players_History.playerId = hlstats_Players.playerId 
            AND hlstats_Players_History.game='$game'
            AND hlstats_Players_History.kills >= $minkills
            AND hlstats_Players_History.eventTime= '".$dates[$rank_type-1]['eventTime']."'
        HAVING 
            activity > 0
        ORDER BY
            $table->sort $table->sortorder,
            $table->sort2 $table->sortorder,
            lastName ASC
        LIMIT $table->startitem,$table->numperpage
    ");
    
    $resultCount = $db->query("
        SELECT
            COUNT(*)
        FROM
            hlstats_Players_History
        WHERE
            game='$game'
            AND kills >= $minkills
            AND eventTime= '".$dates[$rank_type-1]['eventTime']."'
    ");
    
    list($numitems) = $db->fetch_row($resultCount);
    
    $table->draw($result, $numitems, 95);
    
    
}
?><p>

<form method="GET" action="<?php echo $g_options["scripturl"]; ?>">
<table width="95%" align="center" border=0 cellspacing=0 cellpadding=2>

<tr valign="bottom">
	<td width="75%"><?php echo $g_options["font_normal"]; ?>
<?php
	foreach ($HTTP_GET_VARS as $k=>$v)
	{
    $v = valid_request($v, 0);      
		if ($k != "minkills")
		{
			echo "		<input type=\"hidden\" name=\"$k\" value=\"" . htmlspecialchars($v) . "\">\n";
		}
	}
?>
		<b>&#149;</b> Only show players with <input type="text" name="minkills" size=4 maxlength=2 value="<?php echo $minkills; ?>" class="textbox"> or more kills. <input type="submit" value="Apply" class="smallsubmit"><?php echo $g_options["fontend_normal"]; ?> </td>
</tr>

</table>
</form>

</td></tr>
</table>
