<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
	
	
	
	// Weapon Statistics
	
	$db->query("SELECT name FROM hlstats_Games WHERE code='$game'");
	if ($db->num_rows() < 1) error("No such game '$game'.");
	
	list($gamename) = $db->fetch_row();
	$db->free_result();
	
	pageHeader(
		array($gamename, "Weapon Statistics"),
		array($gamename=>"%s?game=$game", "Weapon Statistics"=>"")
	);


	$tblWeapons = new Table(
		array(
			new TableColumn(
				"weapon",
				"Weapon",
				"width=15&type=weaponimg&align=center&link=" . urlencode("mode=weaponinfo&amp;weapon=%k&amp;game=$game")
			),
			new TableColumn(
				"modifier",
				"Points Modifier",
				"width=10&align=right"
			),
			new TableColumn(
				"kills",
				"Kills",
				"width=11&align=right"
			),
			new TableColumn(
				"kpercent",
				"Percentage of Kills",
				"width=18&sort=no&type=bargraph"
			),
			new TableColumn(
				"kpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"headshots",
				"Headshots",
				"width=8&align=right"
			),
			new TableColumn(
				"hpercent",
				"Percentage of Headshots",
				"width=18&sort=no&type=bargraph"
			),
			new TableColumn(
				"hpercent",
				"%",
				"width=5&sort=no&align=right&append=" . urlencode("%")
			),
			new TableColumn(
				"hpk",
				"Hpk",
				"width=5&align=right"
			)
			
		),
		"weapon",
		"kills",
		"weapon",
		true,
		9999,
		"weap_page",
		"weap_sort",
		"weap_sortorder"
	);
	
	$db->query("
		SELECT
			SUM(kills), SUM(headshots)
		FROM
			hlstats_Weapons		
		WHERE
			hlstats_Weapons.game = '$game'
	");
	list($realkills, $realheadshots) = $db->fetch_row();
	
    $query = "
        SELECT
            code as weapon,
            kills,
            kills / $realkills * 100 AS kpercent,
            headshots,
            headshots / kills AS hpk,
            headshots / $realheadshots * 100 AS hpercent,
            modifier
        FROM
            hlstats_Weapons
        WHERE
            game='$game'
            AND kills > 0  
        GROUP BY
            weaponId
        ORDER BY
            $tblWeapons->sort $tblWeapons->sortorder,
            $tblWeapons->sort2 $tblWeapons->sortorder
    ";
   $result = $db->query($query);    
	
?>

<table width="100%" align="center" border=0 cellspacing=0 cellpadding=0>
<tr>
    <td><?php echo $g_options["font_normal"]; ?>&nbsp;<img src="<?php echo $g_options["imgdir"]; ?>/downarrow.gif" width=9 height=6 border=0 align="middle" alt="downarrow.gif"><b>&nbsp;Weapon Statistics</b><?php echo $g_options["fontend_normal"];?><p>

<table width="95%" align="center" border=0 cellspacing=0 cellpadding=0>

<tr>
	<td width="50%"><?php echo $g_options["font_normal"]; ?>From a total of <b><?php echo number_format($realkills); ?></b> kills with <b><?php echo number_format($realheadshots); ?></b> headshots<?php echo $g_options["fontend_normal"]; ?></td>
	<td width="50%" align="right"><?php echo $g_options["font_normal"]; ?>Back to <a href="<?php echo $g_options["scripturl"] . "?game=$game"; ?>"><?php echo $gamename; ?></a><?php echo $g_options["fontend_normal"]; ?></td>
</tr>

</table><p>
<?php $tblWeapons->draw($result, $db->num_rows($result), 95);
?>

</td></tr>
</table>
