/**
 * HLstatsX - SourceMod plugin to generate advanced weapon logging
 * http://www.hlstatsx.com/
 * Copyright (C) 2007 Tobias Oetzel (Tobi@hlstatsx.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <sourcemod>

#define	HITGROUP_GENERIC   0
#define	HITGROUP_HEAD      1
#define	HITGROUP_CHEST     2
#define	HITGROUP_STOMACH   3
#define HITGROUP_LEFTARM   4
#define HITGROUP_RIGHTARM  5
#define HITGROUP_LEFTLEG   6
#define HITGROUP_RIGHTLEG  7

#define MAX_LOG_PLAYERS    64
#define MAX_LOG_WEAPONS    32

#define LOG_HIT_OFFSET     7 

#define	LOG_HIT_SHOTS      0
#define	LOG_HIT_HITS       1
#define	LOG_HIT_KILLS      2
#define	LOG_HIT_HEADSHOTS  3
#define	LOG_HIT_TEAMKILLS  4
#define	LOG_HIT_DAMAGE     5
#define	LOG_HIT_DEATHS     6
#define LOG_HIT_GENERIC    7
#define LOG_HIT_HEAD       8
#define LOG_HIT_CHEST      9
#define LOG_HIT_STOMACH    10
#define LOG_HIT_LEFTARM    11
#define LOG_HIT_RIGHTARM   12
#define LOG_HIT_LEFTLEG    13
#define LOG_HIT_RIGHTLEG   14

new String: game_mod[32];
new String: team_list[16][64];

new weapon_stats[MAX_LOG_PLAYERS + 1][MAX_LOG_WEAPONS][15];
new String: css_weapon_list[][] = {
									"ak47", 
									"m4a1",
									"awp", 
									"deagle",
									"mp5navy",
									"aug", 
									"p90",
									"famas",
									"galil",
									"scout",
									"g3sg1",
									"hegrenade",
									"usp",
									"glock",
									"m249",
									"m3",
									"elite",
									"fiveseven",
									"mac10",
									"p228",
									"sg550",
									"sg552",
									"tmp",
									"ump45",
									"xm1014",
									"knife",
									"smokegrenade",
									"flashbang"
								};

new String: dods_weapon_list[][] = {
									 "thompson",
									 "m1carbine",
									 "k98",
									 "k98_scoped",
									 "mp40",
									 "mg42",
									 "mp44",
									 "colt",
									 "garand",
									 "spring",
									 "c96",
									 "bar",
									 "30cal",
									 "bazooka",
									 "pschreck",
									 "p38",
									 "spade",
									 "frag_ger",
									 "punch",
									 "frag_us",
									 "amerknife",
									 "riflegren_ger",
									 "riflegren_us",
									 "smoke_ger",
									 "smoke_us",
									 "dod_bomb_target"
								};

public Plugin:myinfo = {
	name = "Weapon Logging",
	author = "Tobi17",
	description = "Advanced weapon logging for HLstatsX",
	version = "1.1",
	url = "http://www.hlstatsx.com"
};

public OnPluginStart()
{
	new String: game_description[64];
	GetGameDescription(game_description, 64, true);
	if (strcmp(game_description, "Counter-Strike: Source") == 0) {
		game_mod = "CSS";
	}
	if (strcmp(game_description, "Day of Defeat") == 0) {
		game_mod = "DODS";
	}
	if (strcmp(game_description, "Half-Life 2 Deathmatch") == 0) {
		game_mod = "HL2MP";
	}


	for (new i = 0; (i < (MAX_LOG_PLAYERS + 1)); i++) {
		reset_player_stats(i);
	}
	
	if (strcmp(game_mod, "CSS") == 0) {
		HookEvent("weapon_fire",  Event_CSSPlayerFire);
		HookEvent("player_death", Event_CSSPlayerDeath);
		HookEvent("player_hurt",  Event_CSSPlayerHurt);
		HookEvent("player_spawn", Event_CSSPlayerSpawn);
		HookEvent("round_end",    Event_CSSRoundEnd);
	}
	if (strcmp(game_mod, "DODS") == 0) {

		HookEvent("dod_stats_player_damage",  Event_DODSPlayerDamage);
		HookEvent("player_death", Event_DODSPlayerDeath);
		HookEvent("player_hurt",  Event_DODSPlayerHurt);
		HookEvent("player_spawn", Event_DODSRoundEnd);
	}
}

public OnMapStart()
{
	new max_entities = GetMaxEntities();
	for (new entity_index = 0; (entity_index < max_entities); entity_index++) {
		if (IsValidEntity(entity_index)) {

			new String: entity_classname[64];
			GetEntityNetClass(entity_index, entity_classname, 64);

			if (strcmp(entity_classname, "CCSTeam") == 0) {
				new team_index;
				new index_offset = FindSendPropOffs("CCSTeam", "m_iTeamNum");				
				team_index = GetEntData(entity_index, index_offset);

				new String: team_name[64];
				new name_offset = FindSendPropOffs("CCSTeam", "m_szTeamname");				
				GetEntDataString(entity_index, name_offset, team_name, 64);
				
				if (strcmp(team_name, "") != 0) {
					team_list[team_index] = team_name;
				}
			}

			if (strcmp(entity_classname, "CDODTeam") == 0) {
				new team_index;
				new index_offset = FindSendPropOffs("CDODTeam", "m_iTeamNum");				
				team_index = GetEntData(entity_index, index_offset);

				new String: team_name[64];
				new name_offset = FindSendPropOffs("CDODTeam", "m_szTeamname");				
				GetEntDataString(entity_index, name_offset, team_name, 64);
				
				if (strcmp(team_name, "") != 0) {
					team_list[team_index] = team_name;
				}
			}
			if ((strcmp(entity_classname, "CDODTeam_Allies") == 0) || (strcmp(entity_classname, "CDODTeam_Axis") == 0)) {
				new team_index;
				new index_offset = FindSendPropOffs(entity_classname, "m_iTeamNum");				
				team_index = GetEntData(entity_index, index_offset);

				new String: team_name[64];
				new name_offset = FindSendPropOffs(entity_classname, "m_szTeamname");				
				GetEntDataString(entity_index, name_offset, team_name, 64);
				
				if (strcmp(team_name, "") != 0) {
					team_list[team_index] = team_name;
				}
			}
		}
	}
}


stock get_weapon_index(const String: weapon_name[])
{
	new loop_break = 0;
	new index = 0;
	
	if (strcmp(game_mod, "CSS") == 0) {
		while ((loop_break == 0) && (index < sizeof(css_weapon_list))) {
    	    if (strcmp(weapon_name, css_weapon_list[index], true) == 0) {
        		loop_break++;
	        }
    	    index++;
		}
	} else if (strcmp(game_mod, "DODS") == 0) {
		while ((loop_break == 0) && (index < sizeof(dods_weapon_list))) {
    	    if (strcmp(weapon_name, dods_weapon_list[index], true) == 0) {
        		loop_break++;
	        }
    	    index++;
		}
	}

	if (loop_break == 0) {
		return -1;
	} else {
		return index - 1;
	}
}

stock reset_player_stats(player_index) 
{
	for (new i = 0; (i < MAX_LOG_WEAPONS); i++) {
		weapon_stats[player_index][i][LOG_HIT_SHOTS]     = 0;
		weapon_stats[player_index][i][LOG_HIT_HITS]      = 0;
		weapon_stats[player_index][i][LOG_HIT_KILLS]     = 0;
		weapon_stats[player_index][i][LOG_HIT_HEADSHOTS] = 0;
		weapon_stats[player_index][i][LOG_HIT_TEAMKILLS] = 0;
		weapon_stats[player_index][i][LOG_HIT_DAMAGE]    = 0;
		weapon_stats[player_index][i][LOG_HIT_DEATHS]    = 0;
		weapon_stats[player_index][i][LOG_HIT_GENERIC]   = 0;
		weapon_stats[player_index][i][LOG_HIT_HEAD]      = 0;
		weapon_stats[player_index][i][LOG_HIT_CHEST]     = 0;
		weapon_stats[player_index][i][LOG_HIT_STOMACH]   = 0;
		weapon_stats[player_index][i][LOG_HIT_LEFTARM]   = 0;
		weapon_stats[player_index][i][LOG_HIT_RIGHTARM]  = 0;
		weapon_stats[player_index][i][LOG_HIT_LEFTLEG]   = 0;
		weapon_stats[player_index][i][LOG_HIT_RIGHTLEG]  = 0;
	}
}

stock dump_player_stats(player_index)
{
	if (IsClientConnected(player_index)) {

		new String:player_name[64];
		if (!GetClientName(player_index, player_name, 64))	{
			strcopy(player_name, 64, "UNKNOWN");
		}
		new String:player_authid[64];
		if (!GetClientAuthString(player_index, player_authid, 64)){
			strcopy(player_authid, 64, "UNKNOWN");
		}
		new player_team_index = GetClientTeam(player_index);
		new String:player_team[64];
		player_team = team_list[player_team_index];

		new player_userid = GetClientUserId(player_index);
		
		new is_logged = 0;
		for (new i = 0; (i < MAX_LOG_WEAPONS); i++) {
			if (weapon_stats[player_index][i][LOG_HIT_SHOTS] > 0) {
				if (strcmp(game_mod, "CSS") == 0) {
					LogToGame("\"%s<%d><%s><%s>\" triggered \"weaponstats\" (weapon \"%s\") (shots \"%d\") (hits \"%d\") (kills \"%d\") (headshots \"%d\") (tks \"%d\") (damage \"%d\") (deaths \"%d\")", player_name, player_userid, player_authid, player_team, css_weapon_list[i], weapon_stats[player_index][i][LOG_HIT_SHOTS], weapon_stats[player_index][i][LOG_HIT_HITS], weapon_stats[player_index][i][LOG_HIT_KILLS], weapon_stats[player_index][i][LOG_HIT_HEADSHOTS], weapon_stats[player_index][i][LOG_HIT_TEAMKILLS], weapon_stats[player_index][i][LOG_HIT_DAMAGE], weapon_stats[player_index][i][LOG_HIT_DEATHS]); 
					LogToGame("\"%s<%d><%s><%s>\" triggered \"weaponstats2\" (weapon \"%s\") (head \"%d\") (chest \"%d\") (stomach \"%d\") (leftarm \"%d\") (rightarm \"%d\") (leftleg \"%d\") (rightleg \"%d\")", player_name, player_userid, player_authid, player_team, css_weapon_list[i], weapon_stats[player_index][i][LOG_HIT_HEAD], weapon_stats[player_index][i][LOG_HIT_CHEST], weapon_stats[player_index][i][LOG_HIT_STOMACH], weapon_stats[player_index][i][LOG_HIT_LEFTARM], weapon_stats[player_index][i][LOG_HIT_RIGHTARM], weapon_stats[player_index][i][LOG_HIT_LEFTLEG], weapon_stats[player_index][i][LOG_HIT_RIGHTLEG]); 
				} else if (strcmp(game_mod, "DODS") == 0) {
					LogToGame("\"%s<%d><%s><%s>\" triggered \"weaponstats\" (weapon \"%s\") (shots \"%d\") (hits \"%d\") (kills \"%d\") (headshots \"%d\") (tks \"%d\") (damage \"%d\") (deaths \"%d\")", player_name, player_userid, player_authid, player_team, dods_weapon_list[i], weapon_stats[player_index][i][LOG_HIT_SHOTS], weapon_stats[player_index][i][LOG_HIT_HITS], weapon_stats[player_index][i][LOG_HIT_KILLS], weapon_stats[player_index][i][LOG_HIT_HEADSHOTS], weapon_stats[player_index][i][LOG_HIT_TEAMKILLS], weapon_stats[player_index][i][LOG_HIT_DAMAGE], weapon_stats[player_index][i][LOG_HIT_DEATHS]); 
					LogToGame("\"%s<%d><%s><%s>\" triggered \"weaponstats2\" (weapon \"%s\") (head \"%d\") (chest \"%d\") (stomach \"%d\") (leftarm \"%d\") (rightarm \"%d\") (leftleg \"%d\") (rightleg \"%d\")", player_name, player_userid, player_authid, player_team, dods_weapon_list[i], weapon_stats[player_index][i][LOG_HIT_HEAD], weapon_stats[player_index][i][LOG_HIT_CHEST], weapon_stats[player_index][i][LOG_HIT_STOMACH], weapon_stats[player_index][i][LOG_HIT_LEFTARM], weapon_stats[player_index][i][LOG_HIT_RIGHTARM], weapon_stats[player_index][i][LOG_HIT_LEFTLEG], weapon_stats[player_index][i][LOG_HIT_RIGHTLEG]); 
				}
				is_logged++;
			}
		}
		if (is_logged > 0) {
			reset_player_stats(player_index);
		}
	}
	
}

public Action:Event_DODSPlayerDamage(Handle:event, const String:name[], bool:dontBroadcast)
{
	// "attacker"      "short"         // userid of the attacker
	// "victim"        "short"         // userid of the victim
	// "weapon"        "byte"          // weapon id
	// "damage"        "short"         // total damage in this shot
	// "damage_given"  "byte"  		   // applied damage, not to exceed health
	// "distance"      "float"         // distance of the shot
	// "hitgroup"      "byte"          // hitgroup that was hit

	// new userid   = GetClientOfUserId(GetEventInt(event, "attacker"));
	// new victim   = GetClientOfUserId(GetEventInt(event, "victim"));
	// new damage   = GetClientOfUserId(GetEventInt(event, "damage"));
	// LogToGame("FIRE! %d", userid);

}

public Action:Event_CSSPlayerFire(Handle:event, const String:name[], bool:dontBroadcast)
{
	// "userid"        "short"
	// "weapon"        "string"        // weapon name used

	new userid   = GetClientOfUserId(GetEventInt(event, "userid"));
	if (userid > 0) {
		new String: weapon[64];
		GetEventString(event, "weapon", weapon, 64)
		new weapon_index = get_weapon_index(weapon);
		if (weapon_index > -1) {
		    if ((strcmp(weapon, "flashbang") != 0) && (strcmp(weapon, "hegrenade") != 0) && (strcmp(weapon, "smokegrenade") != 0)) {
				weapon_stats[userid][weapon_index][LOG_HIT_SHOTS]++;
			}
		}
	}
}

public Action:Event_CSSPlayerHurt(Handle:event, const String:name[], bool:dontBroadcast)
{
	//	"userid"        "short"         // player index who was hurt
	//	"attacker"      "short"         // player index who attacked
	//	"health"        "byte"          // remaining health points
	//	"armor"         "byte"          // remaining armor points
	//	"weapon"        "string"        // weapon name attacker used, if not the world
	//	"dmg_health"    "byte"  		// damage done to health
	//	"dmg_armor"     "byte"          // damage done to armor
	//	"hitgroup"      "byte"          // hitgroup that was damaged

	new attacker  = GetClientOfUserId(GetEventInt(event, "attacker"));
	new damage    = GetEventInt(event, "dmg_health");
	new hitgroup  = GetEventInt(event, "hitgroup");
	
	if (attacker > 0) {
		new String: weapon[64];
		GetEventString(event, "weapon", weapon, 64)
		new weapon_index = get_weapon_index(weapon);
		if (weapon_index > -1) {
			if ((strcmp(weapon, "flashbang") != 0) && (strcmp(weapon, "hegrenade") != 0) && (strcmp(weapon, "smokegrenade") != 0)) {
				weapon_stats[attacker][weapon_index][LOG_HIT_SHOTS]++;
			}
			weapon_stats[attacker][weapon_index][LOG_HIT_HITS]++;
			weapon_stats[attacker][weapon_index][LOG_HIT_DAMAGE]  += damage;
			if (hitgroup < 8) {
				weapon_stats[attacker][weapon_index][hitgroup + LOG_HIT_OFFSET]++;
			}
		}
	}

	return Plugin_Continue
}

public Action:Event_DODSPlayerHurt(Handle:event, const String:name[], bool:dontBroadcast)
{
	// "userid"        "short"         // user ID who was hurt
	// "attacker"      "short"         // user ID who attacked
	// "weapon"        "string"        // weapon name attacker used
	// "health"        "byte"          // health remaining
	// "damage"        "byte"          // how much damage in this attack
	// "hitgroup"      "byte"          // what hitgroup was hit

	new attacker  = GetClientOfUserId(GetEventInt(event, "attacker"));
	new damage    = GetEventInt(event, "health");
	new hitgroup  = GetEventInt(event, "hitgroup");
	
	if (attacker > 0) {
		new String: weapon[64];
		GetEventString(event, "weapon", weapon, 64)
		new weapon_index = get_weapon_index(weapon);
		if (weapon_index > -1) {
			if ((strcmp(weapon, "dod_bomb_target") != 0) && (strcmp(weapon, "riflegren_ger") != 0) && (strcmp(weapon, "riflegren_us") != 0) && (strcmp(weapon, "smoke_ger") != 0) && (strcmp(weapon, "smoke_us") != 0)) {
				weapon_stats[attacker][weapon_index][LOG_HIT_SHOTS]++;
			}
			weapon_stats[attacker][weapon_index][LOG_HIT_HITS]++;
			weapon_stats[attacker][weapon_index][LOG_HIT_DAMAGE]  += damage;
			if (hitgroup < 8) {
				weapon_stats[attacker][weapon_index][hitgroup + LOG_HIT_OFFSET]++;
			}
		}
	}

	return Plugin_Continue
}

 
public Action:Event_CSSPlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	// this extents the original player_death by a new fields
	// "userid"        "short"         // user ID who died                             
	// "attacker"      "short"         // user ID who killed
	// "weapon"        "string"        // weapon name killer used 
	// "headshot"      "bool"          // singals a headshot

	new victim   = GetClientOfUserId(GetEventInt(event, "userid"));
	new attacker = GetClientOfUserId(GetEventInt(event, "attacker"));
	new headshot = GetEventBool(event, "headshot");

	if ((victim > 0) && (attacker > 0)) {
		new String: weapon[64];
		GetEventString(event, "weapon", weapon, 64)
		new weapon_index = get_weapon_index(weapon);
		if (weapon_index > -1) {
			weapon_stats[attacker][weapon_index][LOG_HIT_KILLS]++;
			if (headshot == 1) {
				weapon_stats[attacker][weapon_index][LOG_HIT_HEADSHOTS]++;
			}
			weapon_stats[victim][weapon_index][LOG_HIT_DEATHS]++;
			if (GetClientTeam(attacker) == GetClientTeam(victim)) {
				weapon_stats[attacker][weapon_index][LOG_HIT_TEAMKILLS]++;
			}
			dump_player_stats(victim);
		}
	}

	return Plugin_Continue
}

public Action:Event_DODSPlayerDeath(Handle:event, const String:name[], bool:dontBroadcast)
{
	// this extents the original player_death
	// "userid"        "short"         // user ID who died
	// "attacker"      "short"         // user ID who killed
	// "weapon"        "string"        // weapon name killed used

	new victim   = GetClientOfUserId(GetEventInt(event, "userid"));
	new attacker = GetClientOfUserId(GetEventInt(event, "attacker"));

	if ((victim > 0) && (attacker > 0)) {
		new String: weapon[64];
		GetEventString(event, "weapon", weapon, 64)
		new weapon_index = get_weapon_index(weapon);
		if (weapon_index > -1) {
			weapon_stats[attacker][weapon_index][LOG_HIT_KILLS]++;
			weapon_stats[victim][weapon_index][LOG_HIT_DEATHS]++;
			if (GetClientTeam(attacker) == GetClientTeam(victim)) {
				weapon_stats[attacker][weapon_index][LOG_HIT_TEAMKILLS]++;
			}
			dump_player_stats(victim);
		}
	}

	return Plugin_Continue
}



public Action:Event_CSSPlayerSpawn(Handle:event, const String:name[], bool:dontBroadcast)
{
	new userid   = GetClientOfUserId(GetEventInt(event, "userid"));
	if (userid > 0) {
		reset_player_stats(userid);
	}
	return Plugin_Continue
}


public Action:Event_CSSRoundEnd(Handle:event, const String:name[], bool:dontBroadcast)
{
	new max_clients = GetMaxClients();
	for (new i = 1; (i <= max_clients); i++) {
		dump_player_stats(i);
	}
	return Plugin_Continue
}

public Action:Event_DODSRoundEnd(Handle:event, const String:name[], bool:dontBroadcast)
{
	new max_clients = GetMaxClients();
	for (new i = 1; (i <= max_clients); i++) {
		dump_player_stats(i);
	}
	return Plugin_Continue
}


public OnClientDisconnect(client)
{
	reset_player_stats(client);
}



