-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Latency`
-- 

CREATE TABLE `hlstats_Events_Latency` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(32) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `ping` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) TYPE=MyISAM;


-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Livestats`
-- 

CREATE TABLE `hlstats_Livestats` (
  `player_id` int(10) NOT NULL default '0',
  `server_id` int(4) NOT NULL default '0',
  `cli_address` varchar(15) NOT NULL default '',
  `cli_city` varchar(128) NOT NULL default '',
  `cli_country` varchar(128) NOT NULL default '',
  `cli_flag` char(2) NOT NULL default '',
  `cli_state` varchar(128) NOT NULL default '',
  `cli_lat` varchar(16) NOT NULL default '',
  `cli_lng` varchar(16) NOT NULL default '',
  `steam_id` varchar(128) NOT NULL default '',
  `name` text NOT NULL,
  `team` varchar(32) NOT NULL default '',
  `kills` int(6) NOT NULL default '0',
  `deaths` int(6) NOT NULL default '0',
  `suicides` int(6) NOT NULL default '0',
  `headshots` int(6) NOT NULL default '0',
  `shots` int(11) NOT NULL default '0',
  `hits` int(11) NOT NULL default '0',
  `is_dead` tinyint(1) NOT NULL default '0',
  `has_bomb` int(1) NOT NULL default '0',
  `ping` int(6) NOT NULL default '0',
  `connected` int(10) NOT NULL default '0',
  `skill_change` int(10) NOT NULL default '0',
  `skill` int(10) NOT NULL default '0',
  PRIMARY KEY  (`player_id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Players`
-- 

ALTER TABLE `hlstats_Players` ADD COLUMN `last_event` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Players` ADD COLUMN `shots` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Players` ADD COLUMN `hits` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Players` ADD COLUMN `headshots` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Players` 
  ADD `connection_time` INT DEFAULT '0' NOT NULL AFTER `last_event` ;
  ADD `lastAddress` VARCHAR(15) NOT NULL AFTER `lastName`,
  ADD `city` VARCHAR(128) NOT NULL AFTER `lastAddress`,
  ADD `state` VARCHAR( 128 ) NOT NULL AFTER `city`,
  ADD `country` VARCHAR(128) NOT NULL AFTER `state`,
  ADD `flag` VARCHAR(2) NOT NULL AFTER `country`,
  ADD `lat` VARCHAR( 16 ) NOT NULL AFTER `flag` ,
  ADD `lng` VARCHAR( 16 ) NOT NULL AFTER `lat`;
ALTER TABLE `hlstats_Players` 
  CHANGE `last_event` `last_event` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `connection_time` `connection_time` INT( 11 ) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `kills` `kills` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `deaths` `deaths` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `suicides` `suicides` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `skill` `skill` INT(11) UNSIGNED NOT NULL DEFAULT '1000',
  CHANGE `shots` `shots` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `hits` `hits` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `headshots` `headshots` INT(11) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE `hlstats_Players` ADD `last_skill_change` INT DEFAULT '0' NOT NULL ;
UPDATE hlstats_Players SET last_event=UNIX_TIMESTAMP();
-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Servers`
-- 

ALTER TABLE `hlstats_Servers` ADD COLUMN `kills` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `players` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `rounds` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `suicides` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `headshots` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `bombs_planted` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `bombs_defused` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `ct_wins` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `ts_wins` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `act_players` int(4) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `max_players` int(4) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `act_map` varchar(128) NOT NULL default '';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_rounds` int(6) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_ct_wins` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_ts_wins` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_started` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_changes` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `ct_shots` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `ct_hits` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `ts_shots` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `ts_hits` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_ct_shots` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_ct_hits` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_ts_shots` int(11) NOT NULL default '0';
ALTER TABLE `hlstats_Servers` ADD COLUMN `map_ts_hits` int(11) NOT NULL default '0';

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_Trend`
-- 

CREATE TABLE `hlstats_Trend` (
  `timestamp` int(11) NOT NULL default '0',
  `game` varchar(16) NOT NULL default '',
  `players` int(11) NOT NULL default '0',
  `kills` int(11) NOT NULL default '0',
  `headshots` int(11) NOT NULL default '0',
  `servers` tinyint(4) NOT NULL default '0',
  `act_slots` tinyint(4) NOT NULL default '0',
  `max_slots` tinyint(4) NOT NULL default '0',
  KEY `game` (`game`)
) TYPE=MyISAM;

-- --------------------------------------------------------

-- 
-- Tabellenstruktur fr Tabelle `hlstats_server_load`
-- 

CREATE TABLE `hlstats_server_load` (
  `server_id` tinyint(4) NOT NULL default '0',
  `timestamp` int(11) NOT NULL default '0',
  `act_players` tinyint(2) NOT NULL default '0',
  `min_players` tinyint(2) NOT NULL default '0',
  `max_players` tinyint(2) NOT NULL default '0',
  KEY `server_id` (`server_id`)
) TYPE=MyISAM;


-- --------------------------------------------------------
-- 
-- Tabellenstruktur fr Tabelle `hlstats_Events_Frags`
-- 
ALTER TABLE `hlstats_Events_Frags` ADD COLUMN `headshot` tinyint(1) NOT NULL default '0';


-- --------------------------------------------------------
-- 
-- Tabellenstruktur fr Tabelle `hlstats_PlayerNames`
-- 
ALTER TABLE `hlstats_PlayerNames` ADD COLUMN `shots` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_PlayerNames` ADD COLUMN `hits` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_PlayerNames` ADD COLUMN `headshots` int(10) NOT NULL default '0';
ALTER TABLE `hlstats_PlayerNames` 
  ADD `connection_time` INT DEFAULT '0' NOT NULL AFTER `lastuse` ;
ALTER TABLE `hlstats_PlayerNames` 
  CHANGE `connection_time` `connection_time` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `kills` `kills` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `deaths` `deaths` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `suicides` `suicides` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `headshots` `headshots` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `shots` `shots` INT(11) UNSIGNED NOT NULL DEFAULT '0',
  CHANGE `hits` `hits` INT(11) UNSIGNED NOT NULL DEFAULT '0';

-- --------------------------------------------------------
-- 
-- Tabellenstruktur fr Tabelle `hlstats_Weapons`
-- 
ALTER TABLE `hlstats_Weapons` 
  ADD `kills` INT UNSIGNED DEFAULT '0' NOT NULL,
  ADD `headshots` INT UNSIGNED DEFAULT '0' NOT NULL;          
  
-- --------------------------------------------------------
-- 
-- Tabellenstruktur fr Tabelle `hlstats_Actions`
-- 
ALTER TABLE `hlstats_Actions` 
  ADD `count` INT UNSIGNED DEFAULT '0' NOT NULL ;
  


