<?php
#
# HLstatsX - Real-time player and clan rankings and statistics for Half-Life 2
# http://www.hlstatsx.com/
# Copyright (C) 2005-2007 Tobias Oetzel (Tobi@hlstatsx.com)
#
# HlstatsX is an enhanced version of HLstats made by Simon Garner
# HLstats - Real-time player and clan rankings and statistics for Half-Life
# http://sourceforge.net/projects/hlstats/
# Copyright (C) 2001  Simon Garner
#             
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

  foreach ($_SERVER as $key => $entry) {
    if ($key !== "HTTTP_COOKIE") {
      $search_pattern  = array("/<script>/", "/<\/script>/", "/[^A-Za-z0-9.\-\/=:;_?#&~]/");
      $replace_pattern = array("", "", "");
      $entry = preg_replace($search_pattern, $replace_pattern, $entry);
      
      if ($key == "PHP_SELF") {
        if ((strrchr($entry, "/") !== "/hlstats.php") &&
			(strrchr($entry, "/") !== "/ingame.php") &&
			(strrchr($entry, "/") !== "/show_graph.php") &&
			(strrchr($entry, "/") !== "/sig.php") &&
			(strrchr($entry, "/") !== "/sig2.php") &&
			(strrchr($entry, "/") !== "/index.php") &&
			(strrchr($entry, "/") !== "/status.php") &&
			(strrchr($entry, "/") !== "/top10.php") &&
			(strrchr($entry, "/") !== "/config.php") &&
			(strrchr($entry, "/") !== "/") &&
			($entry !== "")) {
          header("Location: http://".$_SERVER['HTTP_HOST']."/hlstats.php");    
          exit;
        }    
      }
      $_SERVER[$key] = $entry;
	}
  }

  function valid_request($str, $numeric)  {
    $search_pattern  = array("/[^A-Za-z0-9\[\]*.,=()!\"$%&^`':;߲#+~_\-|<>\/@{} ]/");
    $replace_pattern = array("");
    $str             = preg_replace($search_pattern, $replace_pattern, $str);
    if ($numeric == 0) 
      return htmlentities(strip_tags($str), ENT_QUOTES, "UTF-8");
    else {
      $temp = htmlentities(strip_tags($str), ENT_QUOTES, "UTF-8");
      if (is_numeric($str) === true) 
        return $temp;
      else
        return -1;  
    }    
  }  

    
    require("config.php");
    
    header("Content-Type: image/png");

    $width = 500;
    if ((isset($_GET['width'])) && (is_numeric($_GET['width'])))
      $width = valid_request($_GET['width'], 1);
    $server_id = 1;  
    if ((isset($_GET['server_id'])) && (is_numeric($_GET['server_id'])))
      $server_id = valid_request($_GET['server_id'], 1);
    $height = 125;
    if ((isset($_GET['height'])) && (is_numeric($_GET['height'])))
      $height = valid_request($_GET['height'], 1);
    $game = "css";
    if ((isset($_GET['game'])) && (is_string($_GET['game'])))
      $game = valid_request($_GET['game'], 0);
    $bar_type = 0; // 0 == serverinfo last 100 entries
    if ((isset($_GET['type'])) && (is_numeric($_GET['type'])))
      $bar_type = valid_request( $_GET['type'], 1);

    /** 
      * Convert colors Usage:  color::hex2rgb("FFFFFF")
      * 
      * @author      Tim Johannessen <root@it.dk>
      * @version    1.0.1
    */
    function hex2rgb($hexVal = "") { 
      $hexVal = eregi_replace("[^a-fA-F0-9]", "", $hexVal); 
      if (strlen($hexVal) != 6) { return "ERR: Incorrect colorcode, expecting 6 chars (a-f, 0-9)"; } 
      $arrTmp = explode(" ", chunk_split($hexVal, 2, " ")); 
      $arrTmp = array_map("hexdec", $arrTmp); 
      return array("red" => $arrTmp[0], "green" => $arrTmp[1], "blue" => $arrTmp[2]); 
    } 
    $bg_color = array("red" => 171, "green" => 204, "blue" => 214);
    if ((isset($_GET['bgcolor'])) && (is_string($_GET['bgcolor'])))
      $bg_color = hex2rgb(valid_request($_GET['bgcolor'], 0));

    $color = array("red" => 255, "green" => 255, "blue" => 255);
    if ((isset($_GET['color'])) && (is_string($_GET['color'])))
      $color = hex2rgb(valid_request($_GET['color'], 0));

    $web_dir = IMAGE_PATH_URL;
    $bg_id = $bg_color["red"]+$bg_color["green"]+$bg_color["blue"];
    
    $server_load_type = 1;
    if ((isset($_GET['range'])) && (is_numeric($_GET['range'])))
      $server_load_type = valid_request($_GET['range'], 1);
    switch($server_load_type)  {
      case 1  : $avg_step = 1;
                break;
      case 2  : $avg_step = 7;
                break;
      case 3  : $avg_step = 33;
                break;
      case 4  : $avg_step = 400;
                break;
      default : $avg_step = 1;
                break;
    }            

    if (file_exists(IMAGE_PATH."/server_".$width."_".$height."_".$bar_type."_".$game."_".$server_id."_".$bg_id."_".$server_load_type.".png")) {
      $file_timestamp = filemtime(IMAGE_PATH."/server_".$width."_".$height."_".$bar_type."_".$game."_".$server_id."_".$bg_id."_".$server_load_type.".png");
      if ($file_timestamp + (IMAGE_UPDATE_INTERVAL * $avg_step) > time()) {
        if (isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
          $browser_timestamp = strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']);
          if ($browser_timestamp + (IMAGE_UPDATE_INTERVAL * $avg_step) > time()) {
             header('HTTP/1.0 304 Not Modified');
             exit; 
          }
        }          
        $mod_date = date('D, d M Y H:i:s \G\M\T', $file_timestamp);
        header('Last-Modified:'.$mod_date);
        header("Location: ".$web_dir."/hlstatsimg/progress/server_".$width."_".$height."_".$bar_type."_".$game."_".$server_id."_".$bg_id."_".$server_load_type.".png");
        exit;
      }  
    }

    // Load database classes
    require(INCLUDE_PATH . "/db.inc");
    define("VERSION", "1.20 RC2");
    $db_classname = "DB_" . DB_TYPE;
    $db = new $db_classname;
    
    
    
    function image_dashed_line($image, $x1, $y1, $x2, $y2, $style)  {
      if (count($style)>0)  {
        $temp_x1 = $x1;
        $temp_y1 = $y1;
        $count   = 0;
        while (($temp_x1<$x2) || ($temp_y1<$y2)) {
          $my_style = $style[$count % count($style)];
          $step = 0;
          while ($my_style != $style[(($count+$step) % count($style))])  {
            $step++;
          }
          if ($step==0)
            $step++;

          if ($x1 != $x2)  {
            if ($my_style != -1)
              imageline($image, $temp_x1, $y1, $temp_x1+$step, $y2, $my_style);
            $temp_x1 = $temp_x1 + $step;
          }
          if ($y1!=$y2) {
            if ($my_style != -1)
              imageline($image, $x1, $temp_y1, $x2, $temp_y1+$step, $my_style);
            $temp_y1 = $temp_y1 + $step;
          }
          $count = $count + $step;
        }
      } else {
        imageline($image, $x1, $y1, $x2, $y2, $style[0]);
      }
    }
    
    $legend_x  = 0;
    $max_pos_y = array();
    // array("width" => $width, "height" => $height, "indent_x" => array(20, 20), "indent_y" => array(10,15))
    function drawItems($image, $bounds, $data_array, $max_index, $name, $dot, $make_grid, $write_timestamp, $write_legend, $color)  {
      global $max_pos_y;
      global $legend_x;
      
      if (!isset($max_pos_y[$max_index])) {
        $max_pos_y[$max_index] = 0; 
      }  

      foreach ($data_array as $entry)  {
        if ($entry[$name] >= $max_pos_y[$max_index]) {
          if ($entry[$name] < 100)
            $max_pos_y[$max_index] = $entry[$name] + 2;
          else if ($entry[$name] < 200) 
            $max_pos_y[$max_index] = $entry[$name] + 10;
          else if ($entry[$name] < 10000)
            $max_pos_y[$max_index] = $entry[$name] + ($entry[$name] * 0.3);
          else
            $max_pos_y[$max_index] = $entry[$name] - ($entry[$name] % 50000) + 100000;


          if ($make_grid > 0) {
            if ($max_pos_y[$max_index] % 2 != 0)
              $max_pos_y[$max_index]++;
            $i = 0;
            while (($i < 10) && ($max_pos_y[$max_index] % 4 != 0)) {
              $max_pos_y[$max_index]++;
              $i++;
            }
          }

          if ($max_pos_y[$max_index] == 0)
            $max_pos_y[$max_index] = 1;
                
        }    
      }    
      
      if ($write_legend > 0)  {
        if ($legend_x == 0)
          $legend_x += $bounds['indent_x'][0] + 10;
        imagesetpixel($image, $legend_x,   $bounds['indent_y'][0]-7, $color[0]);
        imagesetpixel($image, $legend_x+1, $bounds['indent_y'][0]-7, $color[0]);
        imagesetpixel($image, $legend_x+2, $bounds['indent_y'][0]-7, $color[0]);
        imagesetpixel($image, $legend_x,   $bounds['indent_y'][0]-8, $color[0]);
        imagesetpixel($image, $legend_x+1, $bounds['indent_y'][0]-8, $color[0]);
        imagesetpixel($image, $legend_x+2, $bounds['indent_y'][0]-8, $color[0]);
        imagesetpixel($image, $legend_x,   $bounds['indent_y'][0]-9, $color[0]);
        imagesetpixel($image, $legend_x+1, $bounds['indent_y'][0]-9, $color[0]);
        imagesetpixel($image, $legend_x+2, $bounds['indent_y'][0]-9, $color[0]);
        $legend_x += 7;
        imagestring($image, 1, $legend_x, $bounds['indent_y'][0]-11, $name , $color[2]);
        $legend_x += (imagefontwidth(1) * strlen($name)) + 7;
      }
      
      $start_pos = array("x" => $bounds['width']-$bounds['indent_x'][1], "y" => $bounds['indent_y'][1]);
      $pos   = $start_pos;
      $cache = array("x" => 0, "y" => 0);
      
      $step_y = ($bounds['height']-$bounds['indent_y'][0]-$bounds['indent_y'][1]) / 10;
      if ($step_y < 15)
        $step_y = 15;
        
      if ($make_grid > 0) {
        $step_diff  = 0;
        $step_width = 0;
        while ($step_diff < 15)  {
          $step_width++;
          if ($max_pos_y[$max_index] % $step_width == 0) {
            $steps = $max_pos_y[$max_index] / $step_width;
            if ($steps > 0)
              $step_diff = ($bounds['height']-$bounds['indent_y'][0]-$bounds['indent_y'][1]) / $steps;
            else
              $step_diff = 15;
          } else {
            $step_diff = 0;
          }    
        }    
        
        for ($i=1; $i<$steps; $i++)  {
          $temp_y = (($bounds['height']-$bounds['indent_y'][0]-$bounds['indent_y'][1]) - ((($bounds['height']-$bounds['indent_y'][0]-$bounds['indent_y'][1]) / $max_pos_y[$max_index]) * ($i*$step_width))) + $bounds['indent_y'][0];
          if ($temp_y > $bounds['indent_y'][0]+5)
            image_dashed_line($image, $bounds['indent_x'][0]+1, 
                                      $temp_y, 
                                      ($bounds['width']-$bounds['indent_x'][1]-1), 
                                      $temp_y, 
                                      array($color[4], $color[4], $color[4], -1, -1, -1));
          imageline($image, $bounds['indent_x'][0]+1, $temp_y, $bounds['indent_x'][0]+4, $temp_y, $color[3]);

          if ($max_pos_y[$max_index] > 10000) {
            $str     = sprintf("%.0fk", ($i*$step_width) / 1000);
          } else {
            $str     = sprintf("%.0f", $i*$step_width);
          }  
          $str_pos = $bounds['indent_x'][0] - (imagefontwidth(1) * strlen($str)) - 2;
          imagestring($image, 1, $str_pos, $temp_y-3, $str, $color[2]);
        }
        
        if ($max_pos_y[$max_index] > 10000)
          $str     = sprintf("%.0fk", $max_pos_y[$max_index] / 1000);
        else  
          $str     = sprintf("%.0f", $max_pos_y[$max_index]);
        $str_pos = $bounds['indent_x'][0] - (imagefontwidth(1) * strlen($str)) - 2;
        imagestring($image, 1, $str_pos, $bounds['indent_y'][0]-3, $str, $color[2]);
      }  
      

      $last_month           = 0;
      $last_month_timestamp = 0;
      $last_day             = 0;
      $last_day_timestamp   = 0;
      $first_timestamp      = 0;
      $first_day            = 0;


      global $server_load_type; 
      switch ($server_load_type)  {
         case 1 : $mov_avg_precision = 5;
                  break; 
         case 2 : $mov_avg_precision = 5;
                  break; 
         case 3 : $mov_avg_precision = 10;
                  break; 
         case 4 : $mov_avg_precision = 10;
                  break; 
         default: $mov_avg_precision = 1;
                  break; 
      }  
      

      $mov_avg_array        = array();
      $mov_avg_value        = 0;
      $mov_avg_display_value = array();

      $i = 0;
      while (($i < count($data_array)) && ($i < $mov_avg_precision / 2)) {
        $entry = $data_array[$i];
        $mov_avg_array[] = (($bounds['height']-$bounds['indent_y'][0]-$bounds['indent_y'][1]) - ((($bounds['height']-$bounds['indent_y'][0]-$bounds['indent_y'][1]) / $max_pos_y[$max_index]) * $entry[$name])) + $bounds['indent_y'][0];
        $mov_avg_display_value[] = $entry[$name];
        $i++;
      }

      foreach ($data_array as $key => $entry)  {

        $pos['y'] = (($bounds['height']-$bounds['indent_y'][0]-$bounds['indent_y'][1]) - ((($bounds['height']-$bounds['indent_y'][0]-$bounds['indent_y'][1]) / $max_pos_y[$max_index]) * $entry[$name])) + $bounds['indent_y'][0];

        $mov_avg_array[] = $pos['y'];
        $mov_avg_value   = $pos['y'];
        
        if (count($mov_avg_array) > $mov_avg_precision)
         array_shift($mov_avg_array);
        $mov_avg_sum         = 0;
        $mov_avg_display_sum = 0;
        foreach ($mov_avg_array as $mov_avg_entry)
          $mov_avg_sum += $mov_avg_entry;
        $mov_avg_value = sprintf("%d", ($mov_avg_sum / count($mov_avg_array)));
        $pos['y']   = $mov_avg_value;

        
        if ($key > 0) {
          imageline($image, $cache['x'], $cache['y'], $pos['x'], $pos['y'], $color[0]);  
        }
        
        if ($key == 0)  {
          foreach ($mov_avg_display_value as $mov_avg_display_entry)
            $mov_avg_display_sum += $mov_avg_display_entry;
          $display_value = sprintf("%d", ($mov_avg_display_sum / count($mov_avg_display_value)));
          if ($display_value > 10000)
            $str     = sprintf("%.1fk", $display_value / 1000);
          else  
            if ($name !== "act_players")
              $str     = sprintf("%.0f", $display_value);
            else  
              $str     = sprintf("%.1f", $display_value);
          imagestring($image, 1, $pos['x']+2, $pos['y']-4, $str, $color[2]);
        }        
        
        if ($first_timestamp == 0)
          $first_timestamp = $entry['timestamp'];
        $this_month = date("m", $entry['timestamp']);
        if ($this_month > $last_month+1)
          $last_month = $this_month+1;
        if ($last_month == 0) {
          $last_month           = $this_month;
          $last_month_timestamp = $entry['timestamp'];
        }  
        if ($last_month == $this_month)
          $last_month_timestamp = $entry['timestamp'];
          
        $this_day = date("d", $entry['timestamp']);
        if ($this_day > $last_day+1)
          $last_day = $this_day+1;
        if ($last_day == 0) {
          $last_day           = $this_day;
          $last_day_timestamp = $entry['timestamp'];
        }  
        if ($last_day == $this_day)
          $last_day_timestamp = $entry['timestamp'];

          
        global $server_load_type; 
        switch ($server_load_type)  {
           case 1:  if (($write_timestamp > 0) && ($key > 0 && $key % 12 == 0))  {
                      image_dashed_line($image, $pos['x'], $pos['y'], $pos['x'], $bounds['height']-$bounds['indent_y'][1], array($color[1], $color[1], $color[1], -1, -1, -1));
                      $str = date("H:i", $entry['timestamp']);
                      imagestring($image, 1, $pos['x']-10, $bounds['height']-$bounds['indent_y'][1]+3, $str, $color[2]);
                    }
                    break;    
           case 2:  if (($write_timestamp > 0) && ($last_day > $this_day)) {
                      $last_day = $this_day; 
                      if ($bounds['width']-$bounds['indent_x'][1]-$pos['x'] > 120)
                        $first_day++;
                      if ($first_day > 0) { 
                        image_dashed_line($image, $pos['x'], $pos['y'], $pos['x'], $bounds['height']-$bounds['indent_y'][1], array($color[1], $color[1], $color[1], -1, -1, -1));
                        $first_day++;  
                        if ($last_day_timestamp == 0)
                          $last_day_timestamp = $first_timestamp;
                        $str = date("l", $last_day_timestamp);
                        imagestring($image, 1, $pos['x']-15, $bounds['height']-$bounds['indent_y'][1]+3, $str, $color[2]);
                      }
                      $first_day++;
                    }
                    break;    
           case 3:  if (($write_timestamp > 0) && ($last_day > $this_day)) {
                      $last_day = $this_day; 
                      if ($bounds['width']-$bounds['indent_x'][1]-$pos['x'] > 0)
                        $first_day++;
                      if ($first_day > 0) { 
                        image_dashed_line($image, $pos['x'], $pos['y'], $pos['x'], $bounds['height']-$bounds['indent_y'][1], array($color[1], $color[1], $color[1], -1, -1, -1));
                        if ($last_day_timestamp == 0)
                          $last_day_timestamp = $first_timestamp;
                        $str = date("d", $last_day_timestamp);
                        imagestring($image, 1, $pos['x']-5, $bounds['height']-$bounds['indent_y'][1]+3, $str, $color[2]);
                      }  
                    }
                    break;    
           case 4:  if (($write_timestamp > 0) && ($last_month > $this_month)) {
                      $last_month = $this_month; 
                      if ($bounds['width']-$bounds['indent_x'][1]-$pos['x'] > 30)
                        $first_day++;
                      if ($first_day > 0) { 
                        image_dashed_line($image, $pos['x'], $pos['y'], $pos['x'], $bounds['height']-$bounds['indent_y'][1], array($color[1], $color[1], $color[1], -1, -1, -1));
                        $first_day++;  
                        if ($last_month_timestamp == 0)
                          $last_month_timestamp = $first_timestamp;
                        $str = date("M", $last_month_timestamp);
                        imagestring($image, 1, $pos['x']-5, $bounds['height']-$bounds['indent_y'][1]+3, $str, $color[2]);
                      }
                      $first_day++;
                    }
                    break;    
           default: if (($write_timestamp > 0) && ($key > 0 && $key % 12 == 0))  {
                     image_dashed_line($image, $pos['x'], $pos['y'], $pos['x'], $bounds['height']-$bounds['indent_y'][1], array($color[1], $color[1], $color[1], -1, -1, -1));
                     $str = date("H:i", $entry['timestamp']);
                     imagestring($image, 1, $pos['x']-10, $bounds['height']-$bounds['indent_y'][1]+3, $str, $color[2]);
                    }
                    break;
        }             
                        

        if ($dot > 0) {
          imagesetpixel($image, $pos['x'],   $pos['y'],   $color[0]);
          imagesetpixel($image, $pos['x']-1, $pos['y'],   $color[0]);
          imagesetpixel($image, $pos['x']-1, $pos['y']-1, $color[0]);
          imagesetpixel($image, $pos['x']-1, $pos['y']+1, $color[0]);
          imagesetpixel($image, $pos['x']+1, $pos['y'],   $color[0]);
          imagesetpixel($image, $pos['x']+1, $pos['y']-1, $color[0]);
          imagesetpixel($image, $pos['x']+1, $pos['y']+1, $color[0]);
          imagesetpixel($image, $pos['x'],   $pos['y']-1, $color[0]);
          imagesetpixel($image, $pos['x'],   $pos['y']+1, $color[0]);
        } else {
          imagesetpixel($image, $pos['x'],   $pos['y'],   $color[0]);
        }      
        
        $cache['x'] = $pos['x'];
        $cache['y'] = $pos['y'];
        $pos['x'] -= 3;
        if ($pos['x'] < $bounds['indent_x'][0])
          break;
      }  
    }    


      
    
  $image   = imagecreatetruecolor($width, $height);
  imagealphablending($image, false);
  
  if (function_exists("imageantialias"))
    imageantialias ($image, true);

  $normal_color = imagecolorallocate($image, 0xEF, 0xEF, 0xEF);
  $light_color  = imagecolorallocate($image, 0xFF, 0xFF, 0xFF);
  $dark_color   = imagecolorallocate($image, 0x99, 0xAA, 0xAA);
  
  //$main_color  = imagecolorallocate($image, 0xAB, 0xCC, 0xD6);
  $main_color  = imagecolorallocate($image, $bg_color["red"], $bg_color["green"], $bg_color["blue"]);
  $font_color  = imagecolorallocate($image, $color["red"], $color["green"], $color["blue"]);

  $blue         = imagecolorallocate($image,   0,   0, 255);
  $black        = ImagecolorAllocate($image,   0,   0,   0);
  $red          = ImagecolorAllocate($image, 255,   0,   0);
  $white        = imagecolorallocate($image, 255, 255, 255);
  $orange       = imagecolorallocate($image, 255, 165, 0);
  $gray         = imagecolorallocate($image, 105, 105, 105);
  $light_gray   = imagecolorallocate($image, 0xEF, 0xEF, 0xEF); 
  $green        = imagecolorallocate($image, 255,   0, 255);
  

  if ($bar_type == 0) {

    $indent_x = array(30, 30);
    $indent_y = array(15, 15);
    
    // background
    imagefilledrectangle($image, 0, 0, $width, $height, $main_color);
    imagerectangle($image, $indent_x[0], $indent_y[0], $width-$indent_x[1], $height-$indent_y[1], $dark_color);
    imagefilledrectangle($image, $indent_x[0]+1, $indent_y[0]+1, $width-$indent_x[1]-1, $height-$indent_y[1]-1, $light_color);

    $limit     = "";
    if ($avg_step < 10)
      $limit = " LIMIT 0, 2500";

    // entries
    $data_array = array(); 
    $result  = $db->query("SELECT * FROM hlstats_server_load WHERE server_id='".$server_id."' ORDER BY timestamp DESC".$limit);
    
    $i          = 0;
    $avg_values = array();
    while ($rowdata = $db->fetch_array($result)) {
      $i++;
      $avg_values[] = array("timestamp" => $rowdata['timestamp'], "act_players" => $rowdata['act_players'], "min_players" => $rowdata['min_players'], "max_players" => $rowdata['max_players']);
      if ($i == $avg_step)  {
        $insert_values = array();
        $insert_values['timestamp']   = $avg_values[ceil($avg_step / 2)-1]['timestamp'];
        $insert_values['act_players'] = 0;
        $insert_values['min_players'] = 0;
        $insert_values['max_players'] = 0;
        foreach ($avg_values as $entry) {
          $insert_values['act_players'] += $entry['act_players'];    
          $insert_values['min_players'] += $entry['min_players'];    
          $insert_values['max_players'] += $entry['max_players'];    
        }
        $insert_values['act_players'] = round($insert_values['act_players'] / $avg_step);    
        $insert_values['min_players'] = round($insert_values['min_players'] / $avg_step);    
        $insert_values['max_players'] = round($insert_values['max_players'] / $avg_step);
        $data_array[] = array("timestamp" => $insert_values['timestamp'], "act_players" => $insert_values['act_players'], "min_players" => $insert_values['min_players'], "max_players" => $insert_values['max_players']);
        $avg_values = array();
        $i = 0;
      }  
    }
#    print_r($data_array);
    if ($avg_step == 1)  {
      $result  = $db->query("SELECT act_players, max_players FROM hlstats_Servers WHERE serverId='".$server_id."'");
      $rowdata = $db->fetch_array($result);
      array_unshift($data_array, array("timestamp" => time(), "act_players" => $rowdata['act_players'], "min_players" => $data_array[0]['min_players'], "max_players" => $rowdata['max_players']));
    }  

    if (count($data_array) > 1)  { 
      drawItems($image, array("width" => $width, "height" => $height, "indent_x" => $indent_x, "indent_y" => $indent_y), 
                $data_array, 0,"max_players", 0, 1, 0, 1, array($gray, $red, $font_color, $dark_color, $light_gray));
      drawItems($image, array("width" => $width, "height" => $height, "indent_x" => $indent_x, "indent_y" => $indent_y), 
                $data_array, 0,"min_players", 0, 0, 0, 1, array($dark_color, $red, $font_color, $dark_color));
      drawItems($image, array("width" => $width, "height" => $height, "indent_x" => $indent_x, "indent_y" => $indent_y), 
                $data_array, 0,"act_players", 0, 0, 1, 1, array($blue, $red, $font_color, $dark_color));
    }            
              
    if ($width >= 800)  {
      if ($avg_step == 1)  {
        $result  = $db->query("SELECT avg(act_players) as players FROM hlstats_server_load WHERE server_id='".$server_id."' AND timestamp>=".(time()-3600) );
        $rowdata = $db->fetch_array($result);
        $players_last_hour = sprintf("%.1f", $rowdata['players']);
    
        $result  = $db->query("SELECT avg(act_players) as players FROM hlstats_server_load WHERE server_id='".$server_id."' AND timestamp>=".(time()-86400) );
        $rowdata = $db->fetch_array($result);
        $players_last_day = sprintf("%.1f", $rowdata['players']);
 
        $str = "Average Players Last 24h: ".$players_last_day." Last 1h: ".$players_last_hour;
        $str_width = (imagefontwidth(1) * strlen($str)) + 2;
        imagestring($image, 1, $width-$indent_x[1]-$str_width, $indent_y[0]-11, $str , $font_color);
      }  
    }  
              
  } elseif ($bar_type == 1) {

    $indent_x = array(35, 35);
    $indent_y = array(15, 15);
    
    // background
    imagefilledrectangle($image, 0, 0, $width, $height, $main_color);
    imagerectangle($image, $indent_x[0], $indent_y[0], $width-$indent_x[1], $height-$indent_y[1], $dark_color);
    imagefilledrectangle($image, $indent_x[0]+1, $indent_y[0]+1, $width-$indent_x[1]-1, $height-$indent_y[1]-1, $light_color);

    // entries
    $data_array = array(); 
    $result  = $db->query("SELECT * FROM hlstats_Trend WHERE game='".$game."' ORDER BY timestamp DESC LIMIT 0, 350");
    while ($rowdata = $db->fetch_array($result)) {
      $data_array[] = array("timestamp" => $rowdata['timestamp'], "players" => $rowdata['players'], "kills" => $rowdata['kills'], "headshots" => $rowdata['headshots'], "act_slots" => $rowdata['act_slots'], "max_slots" => $rowdata['max_slots']);
    }
    
    $players_data  = $db->query("SELECT count(*) as player_count FROM hlstats_Players WHERE game='".$game."'");
    $rowdata       = $db->fetch_array($players_data);
    $total_players = $rowdata['player_count'];
    

#    $result  = $db->query("SELECT SUM(kills) as kills, SUM(headshots) as headshots, count(serverId) as servers, SUM(act_players) as act_slots, SUM(max_players) as max_slots FROM hlstats_Servers WHERE game='".$game."'");
#    $rowdata = $db->fetch_array($result);
#    array_unshift($data_array, array("timestamp" => time(), "players" => $total_players, "kills" => $rowdata['kills'], "headshots" => $rowdata['headshots'], "act_slots" => $rowdata['act_slots'], "max_slots" => $rowdata['max_slots']));

    if (count($data_array) > 1)  { 
      drawItems($image, array("width" => $width, "height" => $height, "indent_x" => $indent_x, "indent_y" => $indent_y), 
                $data_array, 0, "kills", 0, 1, 0, 1, array($orange, $red, $font_color, $dark_color, $light_gray));
      drawItems($image, array("width" => $width, "height" => $height, "indent_x" => $indent_x, "indent_y" => $indent_y), 
                $data_array, 0, "headshots", 0, 0, 0, 1, array($dark_color, $red, $font_color, $dark_color, $light_gray));
      drawItems($image, array("width" => $width, "height" => $height, "indent_x" => $indent_x, "indent_y" => $indent_y), 
                $data_array, 0, "players", 0, 0, 0, 1, array($red, $red, $font_color, $dark_color, $light_gray));
      drawItems($image, array("width" => $width, "height" => $height, "indent_x" => $indent_x, "indent_y" => $indent_y), 
                $data_array, 2, "max_slots", 0, 0, 0, 1, array($gray, $red, $font_color, $dark_color, $light_gray));
      drawItems($image, array("width" => $width, "height" => $height, "indent_x" => $indent_x, "indent_y" => $indent_y), 
                $data_array, 2, "act_slots", 0, 0, 1, 1,array($blue, $red, $font_color, $dark_color));
    }
              
    if ($width >= 800)  {
      $result  = $db->query("SELECT players FROM hlstats_Trend WHERE game='".$game."' AND timestamp<=".(time()-3600)." ORDER by timestamp DESC LIMIT 0,1");
      $rowdata = $db->fetch_array($result);
      $players_last_hour = $total_players - $rowdata['players'];
    
      $result  = $db->query("SELECT players FROM hlstats_Trend WHERE game='".$game."' AND timestamp<=".(time()-86400)." ORDER by timestamp DESC LIMIT 0,1");
      $rowdata = $db->fetch_array($result);
      $players_last_day = $total_players - $rowdata['players'];
    
      $str = "New Players Last 24h: ".$players_last_day." Last 1h: ".$players_last_hour;
      $str_width = (imagefontwidth(1) * strlen($str)) + 2;
      imagestring($image, 1, $width-$indent_x[1]-$str_width, $indent_y[0]-11, $str , $font_color);
    }  

  }    

  imageTrueColorToPalette($image, 0, 65535);
  imagepng($image, IMAGE_PATH."/server_".$width."_".$height."_".$bar_type."_".$game."_".$server_id."_".$bg_id."_".$server_load_type.".png");
  imagedestroy($image);
  $mod_date = date('D, d M Y H:i:s \G\M\T', time());
  header('Last-Modified:'.$mod_date);
  header("Location: ".$web_dir."/hlstatsimg/progress/server_".$width."_".$height."_".$bar_type."_".$game."_".$server_id."_".$bg_id."_".$server_load_type.".png");

?>