/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CImage;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class CCustomCursor
extends Cursor {
    static Dimension sMaxCursorSize;
    private long[] fData = null;
    Image fImage;
    Point fHotspot;
    CImage fCImage = null;

    public CCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException, HeadlessException {
        super(string);
        this.fImage = image;
        this.fHotspot = point;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Canvas canvas = new Canvas();
        MediaTracker mediaTracker = new MediaTracker(canvas);
        mediaTracker.addImage(this.fImage, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = this.fImage.getWidth(canvas);
        int n2 = this.fImage.getHeight(canvas);
        if (mediaTracker.isErrorAny() || n < 0 || n2 < 0) {
            this.fHotspot.y = 0;
            this.fHotspot.x = 0;
        }
        Dimension dimension = toolkit.getBestCursorSize(n, n2);
        if (dimension.width != n || dimension.height != n2) {
            this.fImage = this.fImage.getScaledInstance(dimension.width, dimension.height, 1);
            n = dimension.width;
            n2 = dimension.height;
        }
        if (this.fHotspot.x >= n) {
            this.fHotspot.x = n - 1;
        } else if (this.fHotspot.x < 0) {
            this.fHotspot.x = 0;
        }
        if (this.fHotspot.y >= n2) {
            this.fHotspot.y = n2 - 1;
        } else if (this.fHotspot.y < 0) {
            this.fHotspot.y = 0;
        }
    }

    public static Dimension getBestCursorSize(int n, int n2) {
        return new Dimension(Math.min(n, CCustomCursor.sMaxCursorSize.width), Math.min(n2, CCustomCursor.sMaxCursorSize.height));
    }

    private long[] getImageData() {
        if (this.fData == null) {
            this.fCImage = new CImage(this.fImage);
            this.fData = new long[]{this.fCImage.getNSImage(), this.fHotspot.x, this.fHotspot.y};
        }
        return this.fData;
    }

    static {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        sMaxCursorSize = new Dimension(rectangle.width / 2, rectangle.height / 2);
    }
}

