/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.AWTLockAccess;
import apple.awt.CDropTargetContextPeer;
import apple.awt.CImage;
import apple.awt.ComponentModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import sun.awt.dnd.SunDragSourceContextPeer;

final class CDragSourceContextPeer
extends SunDragSourceContextPeer {
    private static final CDragSourceContextPeer fInstance = new CDragSourceContextPeer(null);
    private Image fDragImage;
    private CImage fDragCImage;
    private Point fDragImageOffset;

    private CDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        super(dragGestureEvent);
    }

    static CDragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        fInstance.setTrigger(dragGestureEvent);
        return fInstance;
    }

    public void startDrag(DragSourceContext dragSourceContext, Cursor cursor, Image image, Point point) throws InvalidDnDOperationException {
        this.fDragImage = image;
        this.fDragImageOffset = point;
        super.startDrag(dragSourceContext, cursor, image, point);
    }

    protected void startDrag(Transferable transferable, long[] lArray, Map map) {
        Point point;
        long l;
        int n;
        Object object;
        DragGestureEvent dragGestureEvent = this.getTrigger();
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        Point point2 = dragGestureEvent.getDragOrigin();
        int n2 = inputEvent.getModifiers() | inputEvent.getModifiersEx();
        long l2 = inputEvent.getWhen();
        int n3 = inputEvent instanceof MouseEvent ? ((MouseEvent)inputEvent).getClickCount() : 1;
        Component component = dragGestureEvent.getComponent();
        Point point3 = new Point();
        ComponentPeer componentPeer = component.getPeer();
        if (component.isLightweight()) {
            object = component.getLocation();
            point3.translate(((Point)object).x, ((Point)object).y);
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!container.isLightweight()) {
                    componentPeer = container.getPeer();
                    break;
                }
                object = container.getLocation();
                point3.translate(((Point)object).x, ((Point)object).y);
            }
        }
        if (!(componentPeer instanceof ComponentModel)) {
            throw new IllegalArgumentException("DragSource's peer must be a ComponentModel.");
        }
        object = (ComponentModel)componentPeer;
        long l3 = ((ComponentModel)object).getModelPtr();
        Cursor cursor = this.getCursor();
        int n4 = n = cursor != null ? cursor.getType() : 0;
        if (this.fDragImage == null) {
            this.setDefaultDragImage(component);
        }
        if (this.fDragImage != null) {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = bufferedImage = this.fDragImage instanceof BufferedImage ? (BufferedImage)this.fDragImage : null;
            if (bufferedImage == null) {
                int n5 = this.fDragImage.getWidth(null);
                int n6 = this.fDragImage.getHeight(null);
                bufferedImage = new BufferedImage(n5, n6, 3);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.drawImage(this.fDragImage, 0, 0, null);
                graphics.dispose();
            }
            this.fDragCImage = new CImage(bufferedImage);
            l = this.fDragCImage.getNSImage();
            point = this.fDragImageOffset;
        } else {
            this.fDragCImage = null;
            l = 0L;
            point = new Point(0, 0);
        }
        long l4 = this.fDragCImage != null ? this.fDragCImage.getNSImage() : 0L;
        try {
            long l5 = this.createNativeDragSource(component, componentPeer, l3, transferable, inputEvent, (int)(point2.getX() + (double)point3.x), (int)(point2.getY() + (double)point3.y), n2, n3, l2, cursor, n, l, point.x, point.y, this.getDragSourceContext().getSourceActions(), lArray, map);
            if (l5 == 0L) {
                throw new InvalidDnDOperationException("");
            }
            this.setNativeContext(l5);
        }
        catch (Exception exception) {
            throw new InvalidDnDOperationException("failed to create native peer: " + exception);
        }
        CDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
        try {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    long l = CDragSourceContextPeer.this.getNativeContext();
                    try {
                        try {
                            CDragSourceContextPeer.this.doDragging(l);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var5_3 = null;
                            CDragSourceContextPeer.this.releaseNativeDragSource(l);
                            CDragSourceContextPeer.this.fDragImage = null;
                            if (CDragSourceContextPeer.this.fDragCImage == null) return;
                            CDragSourceContextPeer.this.fDragCImage.dispose();
                            CDragSourceContextPeer.this.fDragCImage = null;
                            return;
                        }
                        Object var5_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        CDragSourceContextPeer.this.releaseNativeDragSource(l);
                        CDragSourceContextPeer.this.fDragImage = null;
                        if (CDragSourceContextPeer.this.fDragCImage == null) throw throwable;
                        CDragSourceContextPeer.this.fDragCImage.dispose();
                        CDragSourceContextPeer.this.fDragCImage = null;
                        throw throwable;
                    }
                    CDragSourceContextPeer.this.releaseNativeDragSource(l);
                    CDragSourceContextPeer.this.fDragImage = null;
                    if (CDragSourceContextPeer.this.fDragCImage == null) return;
                    CDragSourceContextPeer.this.fDragCImage.dispose();
                    CDragSourceContextPeer.this.fDragCImage = null;
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            long l6 = this.getNativeContext();
            this.setNativeContext(0L);
            this.releaseNativeDragSource(l6);
            CDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
            throw new InvalidDnDOperationException("failed to start dragging thread: " + exception);
        }
    }

    protected boolean isLightweightDragSource() {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        return component.isLightweight();
    }

    private void setDefaultDragImage(Component component) {
        boolean bl = false;
        if (component.isLightweight() && component instanceof JTextComponent) {
            this.setDefaultDragImage((JTextComponent)component);
            bl = true;
        }
        if (!bl) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage(JTextComponent jTextComponent) {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        boolean bl = false;
        int n3 = jTextComponent.viewToModel(dragGestureEvent.getDragOrigin());
        if (n < n2 && n3 >= n && n3 <= n2) {
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                Rectangle rectangle2 = jTextComponent.modelToView(n2);
                Rectangle rectangle3 = null;
                if (rectangle.y == rectangle2.y) {
                    rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle2.x - rectangle.x + rectangle2.width, rectangle2.y - rectangle.y + rectangle2.height);
                } else {
                    AccessibleContext accessibleContext = jTextComponent.getAccessibleContext();
                    AccessibleText accessibleText = (AccessibleText)((Object)accessibleContext);
                    rectangle3 = jTextComponent.modelToView(n);
                    for (int i = n + 1; i <= n2; ++i) {
                        Rectangle rectangle4 = accessibleText.getCharacterBounds(i);
                        rectangle3.add(rectangle4);
                    }
                }
                this.setOutlineDragImage(rectangle3);
                bl = true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (!bl) {
            this.setDefaultDragImage();
        }
    }

    private void setDefaultDragImage() {
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        Point point = dragGestureEvent.getDragOrigin();
        this.setOutlineDragImage(new Rectangle(0, 0, component.getWidth(), component.getHeight()));
    }

    private void setOutlineDragImage(Rectangle rectangle) {
        Object object;
        Object object2;
        DragGestureEvent dragGestureEvent = this.getTrigger();
        Component component = dragGestureEvent.getComponent();
        Point point = component.getLocation();
        if (component instanceof JComponent) {
            object2 = ((JComponent)component).getVisibleRect();
            object = rectangle.intersection((Rectangle)object2);
            if (!((Rectangle)object).isEmpty()) {
                rectangle = object;
            }
            rectangle.translate(point.x, point.y);
        }
        object2 = component.getGraphicsConfiguration();
        object = ((GraphicsConfiguration)object2).createCompatibleImage((int)rectangle.getWidth(), (int)rectangle.getHeight());
        Point point2 = dragGestureEvent.getDragOrigin();
        Point point3 = new Point(rectangle.x - point2.x, rectangle.y - point2.y);
        if (component instanceof JComponent) {
            point3.translate(-point.x, -point.y);
        }
        Color color = Color.gray;
        BasicStroke basicStroke = new BasicStroke(2.0f);
        int n = (int)(basicStroke.getLineWidth() + 1.0f) / 2;
        Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
        graphics2D.setPaint(color);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawRect(n, n, (int)rectangle.getWidth() - 2 * n - 1, (int)rectangle.getHeight() - 2 * n - 1);
        graphics2D.dispose();
        this.fDragImage = object;
        this.fDragImageOffset = point3;
    }

    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        AWTLockAccess.awtLock();
        super.setCursor(cursor);
        AWTLockAccess.awtUnlock();
    }

    protected boolean needsBogusExitBeforeDrop() {
        return false;
    }

    private native long createNativeDragSource(Component var1, ComponentPeer var2, long var3, Transferable var5, InputEvent var6, int var7, int var8, int var9, int var10, long var11, Cursor var13, int var14, long var15, int var17, int var18, int var19, long[] var20, Map var21);

    private native void doDragging(long var1);

    private native void releaseNativeDragSource(long var1);
}

