/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CSurfaceData;
import apple.awt.ContainerModel;
import apple.awt.NSViewAPI;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;

public class CPeerSurfaceData
extends CSurfaceData {
    private ContainerModel fPeer;
    private boolean fActiveSurface;
    private boolean fIsLockFocused = false;
    private Object fLockFocusedLOCK = new Object();
    public static final String DESC_INT_ARGB_PRE_Q = "Integer ARGB_PRE 32 bit Display Quartz";
    public static final SurfaceType IntArgbPreQ = SurfaceType.IntArgbPre.deriveSubType("Integer ARGB_PRE 32 bit Display Quartz");
    static Timer fFlusherTimer;
    private boolean fUseFlusher;
    static final long kFlusherCleanupPeriod = 500L;
    private static TimerTask sFlusherCleanupTask;
    static final long kFlusherCleanupTickLife = 40L;
    private static int sTicksSinceFlusherLastActive;
    static final long kFlusherPeriod = 50L;
    private TimerTask fFlusherTask;
    static final long kFlusherTaskTickLife = 20L;
    private int fTicksSinceLastDrawing;

    public static CPeerSurfaceData createData(ContainerModel containerModel, boolean bl) {
        return new CPeerSurfaceData(containerModel, bl);
    }

    public static SurfaceType getSurfaceType(ColorModel colorModel, boolean bl) {
        return IntArgbPreQ;
    }

    private CPeerSurfaceData(ContainerModel containerModel, boolean bl) {
        super(CPeerSurfaceData.getSurfaceType(containerModel.getColorModel(), false), containerModel.getColorModel(), containerModel.getGraphicsConfiguration(), new Rectangle(containerModel.fOldWidth, containerModel.fOldHeight));
        this.fPeer = containerModel;
        if (!containerModel.isInactiveSurfaceSituation() && bl) {
            boolean bl2;
            this.fActiveSurface = true;
            this.fUseFlusher = bl2 = !EventQueue.isDispatchThread();
            this.initOps(containerModel.getCGContext(), containerModel.getViewPtr(), bl2);
        } else {
            this.fActiveSurface = false;
            boolean bl3 = true;
            this.fUseFlusher = false;
            this.fQueueGraphicsPrimitives = false;
            this.initOps(0L, containerModel.getViewPtr(), bl3);
        }
    }

    ContainerModel getPeer() {
        return this.fPeer;
    }

    private native void initOps(long var1, long var3, boolean var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocusLocked() {
        Object object = this.fLockFocusedLOCK;
        synchronized (object) {
            this.fIsLockFocused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeContext() {
        Object object = this.fLockFocusedLOCK;
        synchronized (object) {
            this.flush();
            this._completeContext();
            this.fIsLockFocused = false;
        }
    }

    native void _completeContext();

    public SurfaceData getReplacement() {
        if (this.fUseFlusher) {
            this.endFlusher();
        }
        CPeerSurfaceData cPeerSurfaceData = this.fPeer.getSurfaceData();
        cPeerSurfaceData.fChangeFlag = this.fChangeFlag;
        cPeerSurfaceData.fByteParameters = this.fByteParameters;
        cPeerSurfaceData.fIntParameters = this.fIntParameters;
        cPeerSurfaceData.fFloatParameters = this.fFloatParameters;
        cPeerSurfaceData.fObjectParameters = this.fObjectParameters;
        this.fQueueGraphicsPrimitives = false;
        return cPeerSurfaceData;
    }

    public synchronized boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        if (sunGraphics2D.transformState == 0 || sunGraphics2D.transformState == 1) {
            this.flush();
            this.setupGraphicsState(sunGraphics2D, 3);
            Rectangle rectangle = this.clipCopyArea(sunGraphics2D, n, n2, n3, n4, n5, n6);
            if (rectangle == null) {
                return true;
            }
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.width;
            n4 = rectangle.height;
            if (this.fActiveSurface) {
                return fCRenderer.doCopyAreaInWindow(this, this.fByteParameters, this.fObjectParameters, n, n2, n3, n4, n5, n6);
            }
            return true;
        }
        return false;
    }

    public synchronized BufferedImage copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, BufferedImage bufferedImage) {
        Object object;
        if (sunGraphics2D.transformState == 1) {
            n -= (int)sunGraphics2D.transform.getTranslateX();
            n2 -= (int)sunGraphics2D.transform.getTranslateY();
        }
        this.flush();
        this.setupGraphicsState(sunGraphics2D, 3);
        if (bufferedImage == null) {
            object = this.getDeviceConfiguration();
            bufferedImage = ((GraphicsConfiguration)object).createCompatibleImage(n3, n4);
        }
        if (this.fActiveSurface) {
            object = (CSurfaceData)BufImgSurfaceData.getSurfaceData((BufferedImage)bufferedImage);
            ((CSurfaceData)object).flush();
            Graphics graphics = bufferedImage.getGraphics();
            ((CSurfaceData)object).setupGraphicsState((SunGraphics2D)graphics, 3);
            graphics.dispose();
            fCRenderer.doCopyAreaFromWindow(this, this.fByteParameters, this.fObjectParameters, (SurfaceData)object, ((CSurfaceData)object).fByteParameters, ((CSurfaceData)object).fObjectParameters, n, n2, n3, n4);
            return bufferedImage;
        }
        return bufferedImage;
    }

    public void validatePipe(SunGraphics2D sunGraphics2D) {
        if (this.fActiveSurface) {
            super.validatePipe(sunGraphics2D);
        } else {
            sunGraphics2D.drawpipe = CSurfaceData.sNullPipe;
            sunGraphics2D.fillpipe = CSurfaceData.sNullPipe;
            sunGraphics2D.shapepipe = CSurfaceData.sNullPipe;
            sunGraphics2D.textpipe = CSurfaceData.sNullPipe;
            sunGraphics2D.imagepipe = CSurfaceData.sNullPipe;
        }
    }

    public boolean isActive() {
        return this.fActiveSurface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.isValid()) {
            Object object = this.fLockFocusedLOCK;
            synchronized (object) {
                if (this.fIsLockFocused) {
                    this.completeContext();
                }
            }
            this._markInvalid();
            super.invalidate();
        }
    }

    private native void _markInvalid();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ContainerModel containerModel = this.fPeer;
        if (containerModel == null) {
            return;
        }
        ContainerModel containerModel2 = containerModel;
        synchronized (containerModel2) {
            if (!containerModel.isDisposed()) {
                super.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushQueue(SurfaceData surfaceData, ByteBuffer byteBuffer, Object[] objectArray, ByteBuffer byteBuffer2, int n, Object[] objectArray2, int n2) {
        ContainerModel containerModel = this.fPeer;
        if (containerModel == null) {
            return;
        }
        ContainerModel containerModel2 = containerModel;
        synchronized (containerModel2) {
            if (!containerModel.isDisposed()) {
                super.flush(surfaceData, byteBuffer, objectArray, byteBuffer2, n, objectArray2, n2);
            }
        }
    }

    void setupGraphicsState(SunGraphics2D sunGraphics2D, int n, Font font) {
        super.setupGraphicsState(sunGraphics2D, n, font);
        if (this.fUseFlusher) {
            this.startFlusher();
            this.fTicksSinceLastDrawing = 0;
        }
    }

    static synchronized void createFlusher() {
        if (fFlusherTimer == null) {
            fFlusherTimer = new Timer(true);
            sFlusherCleanupTask = new TimerTask(){

                public void run() {
                    CPeerSurfaceData.tickFlusherTaskCleanup();
                }
            };
            fFlusherTimer.scheduleAtFixedRate(sFlusherCleanupTask, 500L, 500L);
            sTicksSinceFlusherLastActive = 0;
        }
    }

    static synchronized void destroyFlusher() {
        if (fFlusherTimer != null) {
            try {
                sFlusherCleanupTask.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            sFlusherCleanupTask = null;
            try {
                fFlusherTimer.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            fFlusherTimer = null;
        }
    }

    void startFlusher() {
        if (fFlusherTimer == null) {
            CPeerSurfaceData.createFlusher();
        }
        if (this.fFlusherTask == null) {
            this.fFlusherTask = new TimerTask(){

                public void run() {
                    CPeerSurfaceData.this.tickFlusherTask();
                }
            };
            try {
                fFlusherTimer.scheduleAtFixedRate(this.fFlusherTask, 50L, 50L);
            }
            catch (IllegalStateException illegalStateException) {
                this.endFlusher();
                CPeerSurfaceData.destroyFlusher();
                this.startFlusher();
            }
        }
    }

    void endFlusher() {
        if (this.fFlusherTask != null) {
            try {
                this.fFlusherTask.cancel();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.fFlusherTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tickFlusherTask() {
        Object object = this.getClass();
        synchronized (object) {
            sTicksSinceFlusherLastActive = 0;
        }
        object = this;
        synchronized (object) {
            if ((long)this.fTicksSinceLastDrawing < 20L) {
                ++this.fTicksSinceLastDrawing;
                int n = this.fIntParameters.get(48);
                if (n == 0) {
                    this.fIntParameters.put(48, 2);
                } else {
                    ContainerModel containerModel = this.fPeer;
                    if (containerModel != null) {
                        ContainerModel containerModel2 = containerModel;
                        synchronized (containerModel2) {
                            if (!containerModel.isDisposed() && this.isValid()) {
                                try {
                                    super.flush();
                                    this._flushContext();
                                    this.fIntParameters.put(48, 0);
                                }
                                catch (InvalidPipeException invalidPipeException) {
                                    long l = containerModel.getViewPtr();
                                    NSViewAPI.redrawViewLater(l);
                                }
                            }
                        }
                    }
                    this.endFlusher();
                }
            } else {
                this.endFlusher();
            }
        }
    }

    private native void _flushContext();

    static synchronized void tickFlusherTaskCleanup() {
        if ((long)sTicksSinceFlusherLastActive < 40L) {
            ++sTicksSinceFlusherLastActive;
        } else {
            CPeerSurfaceData.destroyFlusher();
        }
    }
}

