/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import serpro.ppgd.gui.ButtonPPGD;
import serpro.ppgd.infraestrutura.util.FichaColecaoIf;
import serpro.ppgd.infraestrutura.util.PPGDFormPanel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class BarraNavegacaoPPGD
extends PPGDFormPanel {
    private final Icon ICON_ADICIONAR = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_adicionar.gif"));
    private final Icon ICON_ADICIONAR_SEL = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_adicionarselecionado.gif"));
    private final Icon ICON_EXCLUIR = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_excluir.gif"));
    private final Icon ICON_EXCLUIR_SEL = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_excluirselecionado.gif"));
    private final Icon ICON_PRIMEIRO = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_primeiro.gif"));
    private final Icon ICON_PRIMEIRO_SEL = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_primeiroselecionado.gif"));
    private final Icon ICON_ANTERIOR = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_anterior.gif"));
    private final Icon ICON_ANTERIOR_SEL = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_anteriorselecionado.gif"));
    private final Icon ICON_PROXIMO = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_proximo.gif"));
    private final Icon ICON_PROXIMO_SEL = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_proximoselecionado.gif"));
    private final Icon ICON_ULTIMO = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_ultimo.gif"));
    private final Icon ICON_ULTIMO_SEL = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/nav_ultimoselecionado.gif"));
    private final String LABEL_ADICIONAR = "adicionar";
    private final String LABEL_EXCLUIR = "excluir";
    private final String LABEL_PRIMEIRO = "primeiro";
    private final String LABEL_ANTERIOR = "anterior";
    private final String LABEL_PROXIMO = "pr\u00f3ximo";
    private final String LABEL_ULTIMO = "\u00faltimo";
    private ButtonPPGD adicionar;
    private ButtonPPGD excluir;
    private ButtonPPGD primeiro;
    private ButtonPPGD anterior;
    private ButtonPPGD proximo;
    private ButtonPPGD ultimo;
    private List lista;
    private ObjetoNegocio obj;
    private FichaColecaoIf ficha;
    private int posAtual = 1;

    public BarraNavegacaoPPGD(Colecao colecao, FichaColecaoIf ficha) {
        this.lista = colecao.recuperarLista();
        this.obj = null;
        if (!this.lista.isEmpty()) {
            this.obj = (ObjetoNegocio)this.lista.get(0);
        }
        this.ficha = ficha;
        this.adicionar = new ButtonPPGD("adicionar", this.ICON_ADICIONAR, this.ICON_ADICIONAR, this.ICON_ADICIONAR);
        this.adicionar.setaDimensoes();
        this.excluir = new ButtonPPGD("excluir", this.ICON_EXCLUIR, this.ICON_EXCLUIR, this.ICON_EXCLUIR);
        this.excluir.setaDimensoes();
        this.primeiro = new ButtonPPGD("primeiro", this.ICON_PRIMEIRO, this.ICON_PRIMEIRO, this.ICON_PRIMEIRO);
        this.primeiro.setaDimensoes();
        this.anterior = new ButtonPPGD("anterior", this.ICON_ANTERIOR, this.ICON_ANTERIOR, this.ICON_ANTERIOR);
        this.anterior.setaDimensoes();
        this.proximo = new ButtonPPGD("pr\u00f3ximo", this.ICON_PROXIMO, this.ICON_PROXIMO, this.ICON_PROXIMO);
        this.proximo.setaDimensoes();
        this.ultimo = new ButtonPPGD("\u00faltimo", this.ICON_ULTIMO, this.ICON_ULTIMO, this.ICON_ULTIMO);
        this.ultimo.setaDimensoes();
        this.adicionar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarraNavegacaoPPGD.this.executaAdicionar();
            }
        });
        this.excluir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarraNavegacaoPPGD.this.executaExcluir();
            }
        });
        this.primeiro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarraNavegacaoPPGD.this.executaPrimeiro();
            }
        });
        this.anterior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarraNavegacaoPPGD.this.executaAnterior();
            }
        });
        this.proximo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarraNavegacaoPPGD.this.executaProximo();
            }
        });
        this.ultimo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarraNavegacaoPPGD.this.executaUltimo();
            }
        });
        FormLayout layout = new FormLayout("p:grow,p,5dlu,p,5dlu,p,5dlu,p,5dlu,p,5dlu,p,p:grow", "c:30dlu");
        layout.setColumnGroups((int[][])new int[][]{{2, 4, 6, 8, 10, 12}});
        this.setLayout((LayoutManager)layout);
        this.configuraLayout();
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.adicionar, (Object)cc.xy(2, 1));
        this.add((Component)this.excluir, (Object)cc.xy(4, 1));
        this.add((Component)this.primeiro, (Object)cc.xy(6, 1));
        this.add((Component)this.anterior, (Object)cc.xy(8, 1));
        this.add((Component)this.proximo, (Object)cc.xy(10, 1));
        this.add((Component)this.ultimo, (Object)cc.xy(12, 1));
    }

    protected void configuraLayout() {
    }

    protected boolean permiteCriacao() {
        return true;
    }

    public void executaAdicionar() {
        if (this.permiteCriacao()) {
            this.obj = this.ficha.criaObjetoNegocio();
            this.lista.add(this.obj);
            ++this.posAtual;
            this.ficha.mostraOutroObjetoNegocio(this.obj);
            this.excluir.setEnabled(true);
        }
    }

    public void executaExcluir() {
        boolean confirmacao = this.ficha.obtemConfirmacaoExclusao(this.obj);
        if (!confirmacao) {
            return;
        }
        int size = this.lista.size();
        int pos = this.lista.indexOf(this.obj);
        switch (size) {
            case 0: {
                this.excluir.setEnabled(false);
                this.obj = null;
                return;
            }
            case 1: {
                this.lista.remove(this.obj);
                --this.posAtual;
                this.executaAdicionar();
                this.excluir.setEnabled(false);
                break;
            }
            default: {
                if (pos == size - 1) {
                    this.obj = (ObjetoNegocio)this.lista.get(size - 2);
                    this.lista.remove(size - 1);
                    --this.posAtual;
                } else {
                    this.lista.remove(pos);
                    this.obj = (ObjetoNegocio)this.lista.get(pos);
                }
                this.ficha.mostraOutroObjetoNegocio(this.obj);
            }
        }
    }

    public void executaPrimeiro() {
        this.obj = (ObjetoNegocio)this.lista.get(0);
        this.posAtual = 1;
        this.ficha.mostraOutroObjetoNegocio(this.obj);
    }

    public void executaAnterior() {
        if (this.lista.indexOf(this.obj) == 0) {
            this.executaPrimeiro();
        } else {
            this.obj = (ObjetoNegocio)this.lista.get(this.lista.indexOf(this.obj) - 1);
            --this.posAtual;
            this.ficha.mostraOutroObjetoNegocio(this.obj);
        }
    }

    public void executaProximo() {
        if (this.lista.indexOf(this.obj) == this.lista.size() - 1) {
            this.executaUltimo();
        } else {
            this.obj = (ObjetoNegocio)this.lista.get(this.lista.indexOf(this.obj) + 1);
            ++this.posAtual;
            this.ficha.mostraOutroObjetoNegocio(this.obj);
        }
    }

    public void executaUltimo() {
        if (this.lista.size() > 0) {
            this.obj = (ObjetoNegocio)this.lista.get(this.lista.size() - 1);
            this.posAtual = this.lista.size();
            this.ficha.mostraOutroObjetoNegocio(this.obj);
        }
    }

    public void setColecao(Colecao Colecao2) {
        this.lista = Colecao2.recuperarLista();
        this.obj = null;
        if (!this.lista.isEmpty()) {
            this.obj = (ObjetoNegocio)this.lista.get(0);
        }
    }

    public int getPosicaoAtual() {
        return this.posAtual;
    }
}

