/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import java.awt.Component;
import java.awt.MenuItem;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import serpro.ppgd.infraestrutura.util.MyHelpBroker;
import serpro.ppgd.negocio.util.LogPPGD;

public class HelpUtil {
    private HelpSet hs;
    private HelpSet.Presentation pres;
    private MyHelpBroker hb;
    private JRootPane rootpane = null;
    private String defaultHelpID;
    private ActionListener contentListener;

    public HelpUtil() {
        this(null, null);
    }

    public HelpUtil(String defaultHelpID) {
        this(null, defaultHelpID);
    }

    public HelpUtil(JRootPane rootpane) {
        this(rootpane, null);
    }

    public HelpUtil(JRootPane rootpane, String defaultHelpID) {
        this.rootpane = rootpane;
        this.setDefaultID(defaultHelpID);
    }

    public void setDefaultID(String defaultHelpID) {
        this.defaultHelpID = defaultHelpID;
    }

    public String getDefaultID(String defaultHelpID) {
        return defaultHelpID;
    }

    public void setHelpSet(String helpSetName) {
        this.setHelpSet(helpSetName, null);
    }

    public void setHelpSet(String helpSetName, String path) {
        ClassLoader cl = null;
        this.hs = null;
        String name = helpSetName;
        cl = Thread.currentThread().getContextClassLoader();
        URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)name);
        if (url == null) {
            LogPPGD.erro((String)("HelpSet not found " + url));
            return;
        }
        try {
            this.hs = new HelpSet(cl, url);
        }
        catch (HelpSetException ex) {
            LogPPGD.erro((String)("Could not create HelpSet for " + url));
        }
        this.hb = new MyHelpBroker(this.hs);
        if (this.rootpane != null) {
            this.hb.enableHelpKey(this.rootpane, this.defaultHelpID, this.hs);
        }
    }

    public void setHelpID(Component c, String id) {
        if (c instanceof JButton || c instanceof JMenuItem) {
            this.hb.enableHelpOnButton(c, id, this.hs);
        } else {
            this.enableHelpKey(c, id);
        }
    }

    public void setHelpID(MenuItem j, String id) {
        this.hb.enableHelpOnButton(j, id, this.hs);
    }

    public void enableHelpKey(JRootPane root, String id) {
        this.hb.enableHelpKey(root, id, this.hs);
    }

    public void enableHelpKey(Component c, String id) {
        this.hb.enableHelpKey(c, id, this.hs);
    }

    public void exibeAjuda() {
        this.hb.setDisplayed(true);
    }

    public HelpSet getHelpSet() {
        return this.hs;
    }

    public HelpBroker getHelpBroker() {
        return this.hb;
    }

    public void setNavigatorVisible(boolean flag) {
        this.hb.setViewDisplayed(flag);
    }

    public void setIcon(ImageIcon icon) {
        this.hb.setHelpIcon(icon);
    }

    private URL[] parseURLs(String spec) {
        Vector<URL> v = new Vector<URL>();
        try {
            URL url = new URL(spec);
            v.addElement(url);
        }
        catch (Exception ex) {
            LogPPGD.erro((String)("cannot create URL for " + spec));
        }
        Object[] back = new URL[v.size()];
        v.copyInto(back);
        return back;
    }
}

