/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import serpro.ppgd.gui.ButtonPPGD;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.PPGDFormBuilder;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;

public class MensagemDialog {
    private final String LABEL_BOTAO_FECHAR = "Fechar";
    private final ImageIcon ICO_INDICADOR = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/ico_indicador.gif"));
    private JLabel lbMensagem;
    private JDialog dialog;

    public MensagemDialog() {
        this(null);
    }

    public MensagemDialog(JFrame owner) {
        this.dialog = owner != null ? new JDialog(owner, "", true) : new JDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "", true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().setBackground(ConstantesGlobaisGUI.COR_BRANCO);
        this.dialog.getContentPane().add(this.buildPanel());
    }

    private void fechar() {
        this.dialog.setVisible(false);
    }

    public void setMensagem(String mensagem) {
        this.lbMensagem.setText(mensagem);
    }

    public static void show(String mensagem) {
        MensagemDialog.show("", mensagem);
    }

    public static void show(String titulo, String mensagem) {
        MensagemDialog m = new MensagemDialog();
        m.showDialog(titulo, UtilitariosString.strToHtml((String)mensagem));
    }

    public void showDialog(String titulo, String mensagem) {
        this.dialog.setTitle(titulo);
        this.setMensagem(mensagem);
        this.dialog.setSize(this.dialog.getPreferredSize());
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    public JComponent buildPanel() {
        FormLayout layout = new FormLayout("5dlu,f:p:grow,5dlu", "8dlu,p,15dlu,p,3dlu");
        PPGDFormBuilder builder = new PPGDFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.getPanel().setBackground(ConstantesGlobaisGUI.COR_BRANCO);
        builder.nextLine();
        this.lbMensagem = new JLabel();
        UtilitariosGUI.setParametrosGUI((JComponent)this.lbMensagem, (Font)ConstantesGlobaisGUI.FONTE_10_NORMAL, (Color)ConstantesGlobaisGUI.COR_PRETO, (Color)ConstantesGlobaisGUI.COR_BRANCO);
        builder.setColumn(2);
        builder.append((Component)this.lbMensagem);
        builder.nextLine(2);
        ButtonPPGD btnFechar = new ButtonPPGD("Fechar", (Icon)ConstantesGlobaisGUI.ICO_STOP, (Icon)ConstantesGlobaisGUI.ICO_STOP_SEL, (Icon)ConstantesGlobaisGUI.ICO_STOP_PRES);
        UtilitariosGUI.setParametrosGUI((JComponent)btnFechar, (Font)ConstantesGlobaisGUI.FONTE_10_NORMAL, (Color)ConstantesGlobaisGUI.COR_PRETO, (Color)ConstantesGlobaisGUI.COR_BRANCO);
        btnFechar.setaDimensoes();
        btnFechar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MensagemDialog.this.fechar();
            }
        });
        builder.appendCenter((JComponent)btnFechar);
        return builder.getPanel();
    }
}

