/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.repositorioXML;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.IdUsuario;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.repositorio.RepositorioIdDeclaracaoIf;
import serpro.ppgd.repositorio.RepositorioIdIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioIdDeclaracaoXML
implements RepositorioIdDeclaracaoIf {
    private static final String NOME_RAIZ = "IdDeclaracoes";
    private static final String NOME_NODE = "IdDeclaracao";
    private List listIdDeclaracoes;
    private String nomeClasseIdDeclaracao = (class$serpro$ppgd$negocio$impl$IdDeclaracaoImpl == null ? (class$serpro$ppgd$negocio$impl$IdDeclaracaoImpl = RepositorioIdDeclaracaoXML.class$("serpro.ppgd.negocio.impl.IdDeclaracaoImpl")) : class$serpro$ppgd$negocio$impl$IdDeclaracaoImpl).getName();
    private RepositorioIdIf repositorioIdIf = null;
    static /* synthetic */ Class class$serpro$ppgd$negocio$impl$IdDeclaracaoImpl;
    static /* synthetic */ Class class$serpro$ppgd$negocio$IdUsuario;

    private RepositorioIdDeclaracaoXML() {
    }

    public RepositorioIdDeclaracaoXML(String pNomeClasseIdDeclaracao, RepositorioIdIf pRepositorioId) {
        if (pNomeClasseIdDeclaracao != null) {
            this.nomeClasseIdDeclaracao = pNomeClasseIdDeclaracao;
        }
        if (pRepositorioId == null) {
            throw new IllegalArgumentException("\u00c9 necess\u00e1rio passar uma refer\u00eancia n\u00e3o nula do reposit\u00f3rio de Ids");
        }
        this.repositorioIdIf = pRepositorioId;
    }

    public IdDeclaracao criaInstanciaIdDeclaracaoConcreto(IdUsuario pId) {
        try {
            Class[] argumentosFormais = new Class[]{class$serpro$ppgd$negocio$IdUsuario == null ? (class$serpro$ppgd$negocio$IdUsuario = RepositorioIdDeclaracaoXML.class$("serpro.ppgd.negocio.IdUsuario")) : class$serpro$ppgd$negocio$IdUsuario};
            Object[] argumentosReais = new Object[]{pId};
            Class<?> classe = Class.forName(this.nomeClasseIdDeclaracao);
            Constructor<?> construtor = classe.getConstructor(argumentosFormais);
            Object retorno = construtor.newInstance(argumentosReais);
            return (IdDeclaracao)retorno;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Erro na instancia\u00e7\u00e3o do IdDeclaracao Concreto :" + e.getMessage());
        }
    }

    public IdDeclaracao criarIdDeclaracao(IdUsuario id) {
        IdDeclaracao idDeclaracao = this.criarIdDeclaracaoNaoPersistido(id);
        this.listIdDeclaracoes.add(idDeclaracao);
        return idDeclaracao;
    }

    public IdDeclaracao criarIdDeclaracao(IdDeclaracao idDeclaracao) {
        this.listIdDeclaracoes.add(idDeclaracao);
        return idDeclaracao;
    }

    public IdDeclaracao criarIdDeclaracaoNaoPersistido(IdUsuario id) {
        IdDeclaracao idDeclaracao = this.criaInstanciaIdDeclaracaoConcreto(id);
        idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        idDeclaracao.getTipo().setConteudo("DECLARA\u00c7\u00c3O DE AJUSTE ANUAL");
        return idDeclaracao;
    }

    public boolean existeIdDeclaracao(IdDeclaracao idDeclaracao) {
        for (int i = 0; i < this.listIdDeclaracoes.size(); ++i) {
            if (!((IdDeclaracao)this.listIdDeclaracoes.get(i)).equals((Object)idDeclaracao)) continue;
            return true;
        }
        return false;
    }

    public IdDeclaracao retornaIdDeclaracaoPersistido(IdDeclaracao idDeclaracao) {
        for (int i = 0; i < this.listIdDeclaracoes.size(); ++i) {
            if (!((IdDeclaracao)this.listIdDeclaracoes.get(i)).equals((Object)idDeclaracao)) continue;
            return (IdDeclaracao)this.listIdDeclaracoes.get(i);
        }
        return null;
    }

    public void removerIdDeclaracao(IdDeclaracao idDeclaracao) throws RepositorioXMLException {
        for (int i = 0; i < this.listIdDeclaracoes.size(); ++i) {
            IdDeclaracao idDecl = (IdDeclaracao)this.listIdDeclaracoes.get(i);
            if (!idDeclaracao.equals((Object)idDecl)) continue;
            try {
                this.salvar((IdDeclaracao)this.listIdDeclaracoes.remove(i));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            return;
        }
        throw new RepositorioXMLException("IdDeclara\u00e7\u00e3o n\u00e3o localizado");
    }

    public List recuperarIdDeclaracoes(List listIds) {
        if (this.listIdDeclaracoes == null) {
            Element element;
            this.listIdDeclaracoes = new Vector();
            Document idDeclaracaoDOM = this.leArquivo(this.getPathArquivo());
            if (idDeclaracaoDOM != null && (element = idDeclaracaoDOM.getDocumentElement()).hasChildNodes()) {
                NodeList filhos = element.getChildNodes();
                for (int i = 0; i < filhos.getLength(); ++i) {
                    if (filhos.item(i).getNodeType() != 1) continue;
                    Element elementFilho = (Element)filhos.item(i);
                    IdUsuario id = this.repositorioIdIf.criaInstanciaIdConcreto();
                    FabricaUtilitarios.preencherObjetoComAtributosXml((Object)id, (Element)elementFilho);
                    id = this.repositorioIdIf.recuperarId(id);
                    IdDeclaracao idDeclaracao = this.criaInstanciaIdDeclaracaoConcreto(id);
                    this.preencherAtributosEspecificos(idDeclaracao, elementFilho);
                    if (!idDeclaracao.existeArquivoDeclaracao(FabricaUtilitarios.getPathCompletoDirDadosAplicacao())) continue;
                    this.listIdDeclaracoes.add(idDeclaracao);
                }
            }
        }
        return this.listIdDeclaracoes;
    }

    public void preencherAtributosEspecificos(IdDeclaracao idDecl, Element pElemento) {
        FabricaUtilitarios.preencherObjetoComAtributosXml((Object)idDecl, (Element)pElemento);
    }

    public void persisteAtributosEspecificos(IdDeclaracao idDecl, Element pElemento) {
        FabricaUtilitarios.preencherXMLComAtributosDoObjeto((Object)idDecl, (Element)pElemento);
    }

    public void salvar(IdDeclaracao idDeclaracao) throws RepositorioXMLException {
        Document idDeclaracaoDOM = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            idDeclaracaoDOM = builder.newDocument();
            Element root = idDeclaracaoDOM.createElement(NOME_RAIZ);
            idDeclaracaoDOM.appendChild(root);
            root.setAttribute("xmlns", ConstantesGlobais.XMLNS);
            for (int i = 0; i < this.listIdDeclaracoes.size(); ++i) {
                IdDeclaracao idDecl = (IdDeclaracao)this.listIdDeclaracoes.get(i);
                if (!idDecl.equals((Object)idDecl)) continue;
                Element node = idDeclaracaoDOM.createElement(NOME_NODE);
                root.appendChild(node);
                FabricaUtilitarios.preencherXMLComAtributosDoObjeto((Object)idDecl.getId(), (Element)node);
                this.persisteAtributosEspecificos(idDecl, node);
            }
        }
        catch (ParserConfigurationException e) {
            String msg = "Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage();
            LogPPGD.erro((String)msg);
            throw new RepositorioXMLException(msg);
        }
        idDeclaracaoDOM.normalize();
        File arquivoXML = new File(this.getPathArquivo());
        try {
            FileOutputStream os = new FileOutputStream(arquivoXML);
            StreamResult result = new StreamResult(os);
            DOMSource source = new DOMSource(idDeclaracaoDOM);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
            os.close();
        }
        catch (FileNotFoundException e) {
            String msg = "Arquivo nao localizado: " + arquivoXML.getPath() + " - " + e.getMessage();
            LogPPGD.erro((String)msg);
            throw new RepositorioXMLException(msg);
        }
        catch (TransformerConfigurationException e) {
            String msg = "Erro de configura\u00e7\u00e3o da f\u00e1brica de transforma\u00e7\u00e3o DOM: " + e.getMessage();
            LogPPGD.erro((String)msg);
            throw new RepositorioXMLException(msg);
        }
        catch (TransformerException e) {
            String msg = "Erro de transforma\u00e7\u00e3o DOM-XML: " + e.getMessage();
            LogPPGD.erro((String)msg);
            throw new RepositorioXMLException(msg);
        }
        catch (IOException e) {
            String msg = "Erro de IO: " + e.getMessage();
            LogPPGD.erro((String)msg);
            throw new RepositorioXMLException(msg);
        }
        if (!this.existeIdDeclaracao(idDeclaracao)) {
            String msg = "idDeclaracao nao localizado";
            LogPPGD.debug((String)msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private IdUsuario retornaId(List listIds, IdUsuario pId) {
        for (int i = 0; i < listIds.size(); ++i) {
            IdUsuario id = (IdUsuario)listIds.get(i);
            if (!pId.equals(id)) continue;
            return id;
        }
        return null;
    }

    private String getPathArquivo() {
        String path = FabricaUtilitarios.getPathCompletoDirDadosAplicacao();
        File file = new File(path);
        file.mkdirs();
        file = new File(path + "/idDeclaracoes.xml");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            return null;
        }
        return file.getPath();
    }

    private Document leArquivo(String pathArquivoDados) {
        Document idDeclaracaoDOM = null;
        if (pathArquivoDados != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                idDeclaracaoDOM = builder.parse(new File(pathArquivoDados));
                LogPPGD.debug((String)idDeclaracaoDOM.getImplementation().toString());
            }
            catch (SAXParseException e) {
                LogPPGD.erro((String)("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage()));
            }
            catch (SAXException e) {
                Exception x = e;
                if (e.getException() != null) {
                    x = e.getException();
                }
                LogPPGD.erro((String)("Erro de parsing: " + x.getMessage()));
            }
            catch (ParserConfigurationException e) {
                LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
            }
            catch (IOException e) {
                LogPPGD.erro((String)("Erro de I/O: " + e.getMessage()));
            }
        }
        return idDeclaracaoDOM;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

