/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ListaPPGD;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.LogPPGD;

public abstract class Colecao
extends ObjetoNegocio {
    private List lista;
    protected Class tipoItens = null;
    private int tamanho = 0;
    private PropertyChangeSupport observadoresLista = new PropertyChangeSupport(this);
    private boolean observadoresListaAtivos = true;
    public static final String OBJETO_INSERIDO = "ObjetoInserido";
    public static final String OBJETO_A_REMOVER = "ObjetoAremover";
    public static final String OBJETO_REMOVIDO = "ObjetoRemovido";

    public Colecao(IdDeclaracao idDeclaracao) {
        super(idDeclaracao);
        this.setTipoItens(null);
    }

    public Colecao() {
        this.setTipoItens(null);
    }

    public Colecao(IdDeclaracao idDeclaracao, String nomeClasse) {
        this(idDeclaracao);
        this.setTipoItens(nomeClasse);
    }

    public Colecao(String nomeClasse) {
        this.setTipoItens(nomeClasse);
    }

    public Colecao(IdDeclaracao idDeclaracao, String nomeClasse, int tamanho) {
        this(idDeclaracao, nomeClasse);
        this.tamanho = tamanho;
    }

    public Colecao(String nomeClasse, int tamanho) {
        this.tamanho = tamanho;
    }

    public void clear() {
        super.clear();
        this.recuperarLista().clear();
    }

    public void setValidadoresAtivos(boolean opcao) {
        super.setValidadoresAtivos(opcao);
        Iterator itItems = this.recuperarLista().iterator();
        while (itItems.hasNext()) {
            ObjetoNegocio obj = (ObjetoNegocio)itItems.next();
            obj.setValidadoresAtivos(opcao);
        }
    }

    public void setTipoItens(String tipoItens) {
        try {
            this.tipoItens = tipoItens != null ? Class.forName(tipoItens) : null;
        }
        catch (ClassNotFoundException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico("A classe " + tipoItens + " especificada com item da cole\u00e7\u00e3o " + this.getClass().getName() + " n\u00e3o foi encontrada.");
        }
    }

    public List recuperarLista() {
        if (this.lista == null) {
            this.lista = new ListaPPGD(this);
        }
        return this.lista;
    }

    public void objetoInserido(Object o) {
    }

    public void objetoARemover(Object o) {
    }

    public void objetoRemovido(Object o) {
    }

    public int novoObjeto() {
        this.recuperarLista().add(this.instanciaNovoObjeto());
        return this.recuperarLista().size() - 1;
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        Class classe = this.getTipoItens();
        try {
            Object o = classe.newInstance();
            return (ObjetoNegocio)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeObjeto(int i) {
        this.recuperarLista().remove(i);
    }

    public Class getTipoItens() {
        return this.tipoItens;
    }

    public List verificarPendencias(int numeroItem) {
        Vector listaPendenciasColecao = new Vector();
        listaPendenciasColecao.addAll(super.verificarPendencias(-1));
        int i = 0;
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            ++i;
            if (!(object instanceof ObjetoNegocio)) {
                String msg = "Par\u00e2metro " + object.getClass() + "da classe " + this.getClass() + " n\u00e3o \u00e9 ObjetoNegocio.";
                LogPPGD.erro(msg);
                throw new IllegalArgumentException(msg);
            }
            ObjetoNegocio objetoIrpf = (ObjetoNegocio)object;
            List listaPendenciasObjeto = objetoIrpf.verificarPendencias(i);
            listaPendenciasColecao.addAll(listaPendenciasObjeto);
        }
        return listaPendenciasColecao;
    }

    public void setFicha(String entidade) {
        this.ficha = entidade;
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof ObjetoNegocio)) {
                throw new IllegalArgumentException("Par\u00e2metro " + object.getClass() + " n\u00e3o \u00e9 Informacao.");
            }
            ObjetoNegocio objetoNegocio = (ObjetoNegocio)object;
            objetoNegocio.setFicha(entidade);
        }
        Iterator itAtributosColecao = this.recuperarListaCamposPendencia().iterator();
        while (itAtributosColecao.hasNext()) {
            Informacao info = (Informacao)itAtributosColecao.next();
            info.setFicha(entidade);
        }
    }

    public int getTamanho() {
        return this.tamanho;
    }

    public int recuperarNumeroObjetosNaoNulos() {
        Iterator iterator = this.recuperarLista().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ObjetoNegocio obj = (ObjetoNegocio)iterator.next();
            if (obj.isVazio()) continue;
            ++i;
        }
        return i;
    }

    public void excluirRegistrosEmBranco() {
        List list = this.recuperarLista();
        String a = "";
        for (int i = list.size() - 1; i >= 0; --i) {
            ObjetoNegocio objetoIrpf = (ObjetoNegocio)list.get(i);
            if (!objetoIrpf.isVazio()) continue;
            list.remove(i);
        }
    }

    public boolean isVazio() {
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            ObjetoNegocio obj = (ObjetoNegocio)iterator.next();
            if (obj.isVazio()) continue;
            return false;
        }
        boolean atributosDaColecaoVazios = super.isVazio();
        return atributosDaColecaoVazios;
    }

    public void removeObservadoresAnonimosDesnecessarios(Class pClasse) {
        super.removeObservadoresAnonimosDesnecessarios(pClasse);
        Iterator itItems = this.recuperarLista().iterator();
        while (itItems.hasNext()) {
            ObjetoNegocio proximo = (ObjetoNegocio)itItems.next();
            proximo.removeObservadoresAnonimosDesnecessarios(pClasse);
        }
    }

    public void removeObservadores(Class[] pClasse) {
        super.removeObservadores(pClasse);
        Iterator itItems = this.recuperarLista().iterator();
        while (itItems.hasNext()) {
            ObjetoNegocio proximo = (ObjetoNegocio)itItems.next();
            proximo.removeObservadores(pClasse);
        }
    }

    public PropertyChangeSupport getObservadoresLista() {
        return this.observadoresLista;
    }

    public void addObservador(Observador observador) {
        this.observadoresLista.addPropertyChangeListener(observador);
    }

    public void addObservador(String nomePropriedade, Observador observador) {
        this.observadoresLista.addPropertyChangeListener(nomePropriedade, observador);
    }

    public void removeObservador(Observador observador) {
        this.observadoresLista.removePropertyChangeListener(observador);
    }

    public void removeObservador(String nomePropriedade, Observador observador) {
        this.observadoresLista.removePropertyChangeListener(nomePropriedade, observador);
    }

    public boolean isObservadoresListaAtivos() {
        return this.observadoresListaAtivos;
    }

    public void setObservadoresAtivos(boolean observadoresAtivos) {
        this.observadoresListaAtivos = observadoresAtivos;
    }
}

