/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.List;
import java.util.ListIterator;
import serpro.ppgd.negocio.Colecao;

class ListIteratorColecaoPPGD
implements ListIterator {
    private ListIterator implementacao;
    private Colecao owner;
    private List lista;
    private Object objetoCorrente;

    private void verificaTipoInserido(Object o) {
        if (this.owner.getTipoItens() != null && !this.owner.getTipoItens().isInstance(o)) {
            throw new IllegalArgumentException("Tentativa inv\u00e1lida de inser\u00e7\u00e3o do elemento " + o + " na cole\u00e7\u00e3o " + this.owner);
        }
    }

    private void verificaTamanho(int index) {
        if (this.owner.getTamanho() != 0 && index == this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
    }

    public ListIteratorColecaoPPGD(ListIterator implementacao, Colecao owner, List lista) {
        this.implementacao = implementacao;
        this.owner = owner;
        this.lista = lista;
    }

    public void add(Object o) {
        this.verificaTipoInserido(o);
        this.verificaTamanho(this.lista.size());
        this.implementacao.add(o);
        this.owner.objetoInserido(o);
    }

    public boolean hasNext() {
        return this.implementacao.hasNext();
    }

    public boolean hasPrevious() {
        return this.implementacao.hasPrevious();
    }

    public Object next() {
        this.objetoCorrente = this.implementacao.next();
        return this.objetoCorrente;
    }

    public int nextIndex() {
        return this.implementacao.nextIndex();
    }

    public Object previous() {
        this.objetoCorrente = this.implementacao.previous();
        return this.objetoCorrente;
    }

    public int previousIndex() {
        return this.implementacao.previousIndex();
    }

    public void remove() {
        this.owner.objetoARemover(this.objetoCorrente);
        this.implementacao.remove();
        this.owner.objetoRemovido(this.objetoCorrente);
    }

    public void set(Object o) {
        this.verificaTipoInserido(o);
        this.owner.objetoARemover(this.objetoCorrente);
        this.implementacao.set(o);
        this.owner.objetoRemovido(this.objetoCorrente);
        this.owner.objetoInserido(o);
    }
}

