/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.TabelaMensagens;

public abstract class ObjetoNegocio
extends Observador {
    protected transient IdDeclaracao idDeclaracao;
    private boolean observadorAtivo = true;
    protected TabelaMensagens tab = TabelaMensagens.getTabelaMensagens();
    protected String ficha = "";
    protected boolean persistente = true;
    static /* synthetic */ Class class$serpro$ppgd$negocio$Informacao;
    static /* synthetic */ Class class$serpro$ppgd$negocio$ObjetoNegocio;
    static /* synthetic */ Class class$serpro$ppgd$negocio$IdDeclaracao;

    public ObjetoNegocio(IdDeclaracao idDeclaracao) {
        this.idDeclaracao = idDeclaracao;
    }

    public ObjetoNegocio() {
        this.idDeclaracao = null;
    }

    public IdDeclaracao getIdDeclaracao() {
        return this.idDeclaracao;
    }

    protected boolean testaVazio(Informacao pInfo) {
        return true;
    }

    public boolean isVazio() {
        try {
            Iterator itFields = FabricaUtilitarios.getAllFields(this.getClass()).iterator();
            while (itFields.hasNext()) {
                ObjetoNegocio obj;
                Informacao info;
                Field f = (Field)itFields.next();
                boolean acessible = f.isAccessible();
                f.setAccessible(true);
                if ((class$serpro$ppgd$negocio$Informacao == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.Informacao") : class$serpro$ppgd$negocio$Informacao).isAssignableFrom(f.getType()) ? this.testaVazio(info = (Informacao)f.get(this)) && !info.isVazio() : (class$serpro$ppgd$negocio$ObjetoNegocio == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.ObjetoNegocio") : class$serpro$ppgd$negocio$ObjetoNegocio).isAssignableFrom(f.getType()) && (obj = (ObjetoNegocio)f.get(this)) != null && !(obj instanceof IdDeclaracao) && !obj.isVazio()) {
                    return false;
                }
                f.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        return true;
    }

    public List recuperarCamposInformacao() {
        Vector<Informacao> retorno = new Vector<Informacao>();
        try {
            Iterator itFields = FabricaUtilitarios.getAllFields(this.getClass()).iterator();
            while (itFields.hasNext()) {
                Field f = (Field)itFields.next();
                boolean acessible = f.isAccessible();
                f.setAccessible(true);
                if ((class$serpro$ppgd$negocio$Informacao == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.Informacao") : class$serpro$ppgd$negocio$Informacao).isAssignableFrom(f.getType())) {
                    Informacao info = (Informacao)f.get(this);
                    retorno.add(info);
                }
                f.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        return retorno;
    }

    public void clear() {
        Iterator iterator = this.recuperarCamposInformacao().iterator();
        while (iterator.hasNext()) {
            Informacao informacao = (Informacao)iterator.next();
            informacao.clear();
        }
    }

    public final void propertyChange(PropertyChangeEvent evt) {
        if (this.isObservadorAtivo()) {
            LogPPGD.debug("Disparando observador " + this + ".");
            this.implementacaoPropertyChange(evt);
        }
        super.propertyChange(evt);
    }

    protected void implementacaoPropertyChange(PropertyChangeEvent evt) {
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
    }

    public boolean isObservadorAtivo() {
        return this.observadorAtivo;
    }

    public void setObservadorAtivo(boolean b) {
        this.observadorAtivo = b;
    }

    public void setValidadoresAtivos(boolean opcao) {
        try {
            Iterator itFields = FabricaUtilitarios.getAllFields(this.getClass()).iterator();
            while (itFields.hasNext()) {
                Object info;
                Field f = (Field)itFields.next();
                boolean acessible = f.isAccessible();
                f.setAccessible(true);
                if ((class$serpro$ppgd$negocio$Informacao == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.Informacao") : class$serpro$ppgd$negocio$Informacao).isAssignableFrom(f.getType())) {
                    info = (Informacao)f.get(this);
                    if (info != null) {
                        ((Informacao)info).setValidadoresAtivos(opcao);
                    }
                } else if (!(class$serpro$ppgd$negocio$IdDeclaracao == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.IdDeclaracao") : class$serpro$ppgd$negocio$IdDeclaracao).isAssignableFrom(f.getType()) && (class$serpro$ppgd$negocio$ObjetoNegocio == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.ObjetoNegocio") : class$serpro$ppgd$negocio$ObjetoNegocio).isAssignableFrom(f.getType()) && (info = (ObjetoNegocio)f.get(this)) != null) {
                    ((ObjetoNegocio)info).setValidadoresAtivos(opcao);
                }
                f.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
    }

    public List verificarPendencias(int numeroItem) {
        Vector<Pendencia> listaPendencias = new Vector<Pendencia>();
        Iterator iterator = this.recuperarListaCamposPendencia().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Informacao)) {
                throw new IllegalArgumentException("Par\u00e2metro " + object.getClass() + " n\u00e3o \u00e9 Informacao.");
            }
            Informacao informacao = (Informacao)object;
            Enumeration retornosValidacoes = informacao.validar().elements();
            while (retornosValidacoes.hasMoreElements()) {
                Object objectRetornoValidacao = retornosValidacoes.nextElement();
                if (!(objectRetornoValidacao instanceof RetornoValidacao)) {
                    String msg = "Elemento " + objectRetornoValidacao.getClass() + " da lista de RetornosValidacoes da classe " + this.getClass() + " n\u00e3o \u00e9 um RetornoValidacao";
                    LogPPGD.erro(msg);
                    throw new IllegalArgumentException(msg);
                }
                RetornoValidacao retornoValidacao = (RetornoValidacao)objectRetornoValidacao;
                if (retornoValidacao.getSeveridade() <= 0) continue;
                Pendencia pendencia = new Pendencia(retornoValidacao.getSeveridade(), informacao, informacao.getNomeCampo(), retornoValidacao.getMensagemValidacao(), numeroItem);
                listaPendencias.add(pendencia);
            }
        }
        return listaPendencias;
    }

    protected List recuperarListaCamposPendencia() {
        Vector listaCamposPendencia = new Vector();
        return listaCamposPendencia;
    }

    public void setFicha(String pFicha) {
        this.ficha = pFicha;
        Iterator iterator = this.recuperarListaCamposPendencia().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Informacao)) {
                throw new IllegalArgumentException("Par\u00e2metro " + object.getClass() + " n\u00e3o \u00e9 Informacao.");
            }
            Informacao informacao = (Informacao)object;
            informacao.setFicha(this.ficha);
        }
    }

    public String getFicha() {
        return this.ficha;
    }

    public void removeObservadoresAnonimosDesnecessarios(Class pClasse) {
        try {
            Iterator itFields = FabricaUtilitarios.getAllFields(this.getClass()).iterator();
            while (itFields.hasNext()) {
                ObjetoNegocio obj;
                boolean acessivel;
                Field f = (Field)itFields.next();
                if (Modifier.isTransient(f.getModifiers())) continue;
                if ((class$serpro$ppgd$negocio$Informacao == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.Informacao") : class$serpro$ppgd$negocio$Informacao).isAssignableFrom(f.getType())) {
                    Informacao info;
                    acessivel = f.isAccessible();
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if ((info = (Informacao)f.get(this)) != null) {
                        info.removeObservadoresAnonimosDesnecessarios(pClasse);
                    }
                    f.setAccessible(acessivel);
                    continue;
                }
                if ((class$serpro$ppgd$negocio$IdDeclaracao == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.IdDeclaracao") : class$serpro$ppgd$negocio$IdDeclaracao).isAssignableFrom(f.getType()) || !(class$serpro$ppgd$negocio$ObjetoNegocio == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.ObjetoNegocio") : class$serpro$ppgd$negocio$ObjetoNegocio).isAssignableFrom(f.getType())) continue;
                acessivel = f.isAccessible();
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((obj = (ObjetoNegocio)f.get(this)) != null) {
                    obj.removeObservadoresAnonimosDesnecessarios(pClasse);
                }
                f.setAccessible(acessivel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeObservadores(Class[] pClasse) {
        try {
            Iterator itFields = FabricaUtilitarios.getAllFields(this.getClass()).iterator();
            while (itFields.hasNext()) {
                ObjetoNegocio obj;
                boolean acessivel;
                Field f = (Field)itFields.next();
                if (Modifier.isTransient(f.getModifiers())) continue;
                if ((class$serpro$ppgd$negocio$Informacao == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.Informacao") : class$serpro$ppgd$negocio$Informacao).isAssignableFrom(f.getType())) {
                    Informacao info;
                    acessivel = f.isAccessible();
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if ((info = (Informacao)f.get(this)) != null) {
                        info.removeObservadores(pClasse);
                    }
                    f.setAccessible(acessivel);
                    continue;
                }
                if ((class$serpro$ppgd$negocio$IdDeclaracao == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.IdDeclaracao") : class$serpro$ppgd$negocio$IdDeclaracao).isAssignableFrom(f.getType()) || !(class$serpro$ppgd$negocio$ObjetoNegocio == null ? ObjetoNegocio.class$("serpro.ppgd.negocio.ObjetoNegocio") : class$serpro$ppgd$negocio$ObjetoNegocio).isAssignableFrom(f.getType())) continue;
                acessivel = f.isAccessible();
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((obj = (ObjetoNegocio)f.get(this)) != null) {
                    obj.removeObservadores(pClasse);
                }
                f.setAccessible(acessivel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isPersistente() {
        return this.persistente;
    }

    public void setPersistente(boolean persistente) {
        this.persistente = persistente;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

