/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.util.Iterator;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Bens
extends Colecao {
    private static final String VALOR_ALTO = "500.000,00";
    private Valor totalExercicioAnterior;
    private Valor totalExercicioAtual;
    private Alfa ultimoIndiceGerado;
    private static long geradorIndices;
    public static Class a;

    public Bens() {
        Class<?> clazz = a;
        if (clazz == null) {
            try {
                clazz = a = Class.forName("serpro.ppgd.irpf.bens.Bem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.totalExercicioAnterior = new Valor((ObjetoNegocio)this, "Total exercicio Anterior");
        this.totalExercicioAtual = new Valor((ObjetoNegocio)this, "Total exercicio Atual");
        this.ultimoIndiceGerado = new Alfa();
        this.setFicha("Bens e Direitos");
        this.totalExercicioAnterior.setReadOnly(true);
        this.totalExercicioAtual.setReadOnly(true);
    }

    public void inicializaGeradorIndices() {
        geradorIndices = this.ultimoIndiceGerado.asString().trim().equals("") ? 0L : Long.parseLong(this.ultimoIndiceGerado.asString());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.asString();
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        Bem bem = (Bem)super.instanciaNovoObjeto();
        bem.getIndice().setConteudo(this.proximoIndice());
        return bem;
    }

    public void objetoInserido(Object object) {
        this.setFicha(this.getFicha());
    }

    public Valor getTotalExercicioAnterior() {
        return this.totalExercicioAnterior;
    }

    public Valor getTotalExercicioAtual() {
        return this.totalExercicioAtual;
    }

    public boolean existeValorAlto() {
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Bem bem = (Bem)iterator.next();
            if (!bem.getValorExercicioAtual().comparacao(">", VALOR_ALTO)) continue;
            return true;
        }
        return false;
    }
}

