/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dividas;

import classes.jo;
import classes.mI;
import classes.s;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Divida
extends ObjetoNegocio
implements jo {
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", s.a());
    private Alfa discriminacao = new Alfa((ObjetoNegocio)this, "Discrimina\u00e7\u00e3o", 120);
    private mI valorExercicioAnterior = new mI(this, NOME_CAMPO_VALOR_ANTERIOR);
    private mI valorExercicioAtual = new mI(this, NOME_CAMPO_VALOR_ATUAL);
    private Alfa indice = new Alfa((ObjetoNegocio)this, "Indice");

    public Divida() {
        this.getCodigo().setColunaFiltro(1);
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNulo(3, this.tab.msg("divida_codigo")));
        this.getDiscriminacao().addValidador((ValidadorIf)new ValidadorNaoNulo(3, this.tab.msg("divida_discriminacao")));
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    public List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.discriminacao);
        list.add(this.valorExercicioAtual);
        list.add(this.valorExercicioAnterior);
        return list;
    }

    public boolean isVazio() {
        Iterator iterator = this.recuperarCamposInformacao().iterator();
        while (iterator.hasNext()) {
            Informacao informacao = (Informacao)iterator.next();
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Indice")) continue;
            return false;
        }
        return true;
    }

    public List verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia pendencia = new Pendencia(2, (Informacao)this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), this.tab.msg("divida_valor_nao_informado"), n2);
            list.add(pendencia);
        }
        return list;
    }

    public String getChave() {
        return this.getCodigo().asString();
    }

    public int compareTo(Object object) {
        Divida divida = (Divida)object;
        int n2 = divida.getCodigo().asInteger();
        return n2 - this.getCodigo().asInteger();
    }

    public Alfa getIndice() {
        return this.indice;
    }
}

