/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.ganhosdecapital;

import classes.mI;
import java.util.ArrayList;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ganhosdecapital.ColecaoIdentificacaoDeclaranteGCAP;
import serpro.ppgd.irpf.ganhosdecapital.IdentificacaoDeclaranteGCAP;
import serpro.ppgd.irpf.ganhosdecapital.bensimoveis.ColecaoBensImoveis;
import serpro.ppgd.irpf.ganhosdecapital.bensimoveis.ItemDadosBemImovel;
import serpro.ppgd.irpf.ganhosdecapital.bensmoveis.ColecaoBensMoveis;
import serpro.ppgd.irpf.ganhosdecapital.bensmoveis.ItemDadosBemMovel;
import serpro.ppgd.irpf.ganhosdecapital.psocietarias.ColecaoPSocietarias;
import serpro.ppgd.irpf.ganhosdecapital.psocietarias.ItemDadosPSocietarias;
import serpro.ppgd.negocio.ObjetoNegocio;

public class GanhosDeCapital
extends ObjetoNegocio {
    private ColecaoBensImoveis bensImoveis;
    private ColecaoBensMoveis bensMoveis;
    private ColecaoPSocietarias participacoesSocietarias;
    private ColecaoIdentificacaoDeclaranteGCAP declarantes;
    private mI totalImpostoPagoSobreGanhosCapital = new mI(this, "");
    private mI totalImpostoRetidoFonteSobreGanhosCapital = new mI(this, "");

    public GanhosDeCapital(DeclaracaoIRPF declaracaoIRPF) {
        this.setFicha("Ganho de Capital");
        this.bensImoveis = new ColecaoBensImoveis(declaracaoIRPF);
        this.bensMoveis = new ColecaoBensMoveis(declaracaoIRPF);
        this.participacoesSocietarias = new ColecaoPSocietarias(declaracaoIRPF);
        this.declarantes = new ColecaoIdentificacaoDeclaranteGCAP();
    }

    public ColecaoBensImoveis getBensImoveis() {
        return this.bensImoveis;
    }

    public ColecaoBensMoveis getBensMoveis() {
        return this.bensMoveis;
    }

    public ColecaoPSocietarias getParticipacoesSocietarias() {
        return this.participacoesSocietarias;
    }

    public mI getTotalImpostoPagoSobreGanhosCapital() {
        return this.totalImpostoPagoSobreGanhosCapital;
    }

    public void setBensImoveis(ColecaoBensImoveis colecaoBensImoveis) {
        this.bensImoveis = colecaoBensImoveis;
    }

    public void setBensMoveis(ColecaoBensMoveis colecaoBensMoveis) {
        this.bensMoveis = colecaoBensMoveis;
    }

    public void setParticipacoesSocietarias(ColecaoPSocietarias colecaoPSocietarias) {
        this.participacoesSocietarias = colecaoPSocietarias;
    }

    public ColecaoIdentificacaoDeclaranteGCAP getDeclarantes() {
        return this.declarantes;
    }

    public void setDeclarantes(ColecaoIdentificacaoDeclaranteGCAP colecaoIdentificacaoDeclaranteGCAP) {
        this.declarantes = colecaoIdentificacaoDeclaranteGCAP;
    }

    public void setTotalImpostoPagoSobreGanhosCapital(mI mI2) {
        this.totalImpostoPagoSobreGanhosCapital = mI2;
    }

    public mI getTotalImpostoRetidoFonteSobreGanhosCapital() {
        return this.totalImpostoRetidoFonteSobreGanhosCapital;
    }

    public void setTotalImpostoRetidoFonteSobreGanhosCapital(mI mI2) {
        this.totalImpostoRetidoFonteSobreGanhosCapital = mI2;
    }

    public void excluirItemPorCPF(String string) {
        ObjetoNegocio objetoNegocio;
        ArrayList<ItemDadosBemImovel> arrayList = new ArrayList<ItemDadosBemImovel>();
        ArrayList<ObjetoNegocio> arrayList2 = new ArrayList<ObjetoNegocio>();
        ArrayList<ObjetoNegocio> arrayList3 = new ArrayList<ObjetoNegocio>();
        ArrayList<ObjetoNegocio> arrayList4 = new ArrayList<ObjetoNegocio>();
        Iterator iterator = this.getBensImoveis().recuperarLista().iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (ItemDadosBemImovel)iterator.next();
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            arrayList.add((ItemDadosBemImovel)objetoNegocio);
        }
        iterator = this.getBensMoveis().recuperarLista().iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (ItemDadosBemMovel)iterator.next();
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            arrayList2.add(objetoNegocio);
        }
        iterator = this.getParticipacoesSocietarias().recuperarLista().iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (ItemDadosPSocietarias)iterator.next();
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            arrayList3.add(objetoNegocio);
        }
        iterator = this.getDeclarantes().recuperarLista().iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (IdentificacaoDeclaranteGCAP)((Object)iterator.next());
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            arrayList4.add(objetoNegocio);
            this.getDeclarantes().recuperarLista().remove(objetoNegocio);
            iterator = this.getDeclarantes().recuperarLista().iterator();
        }
        iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (ItemDadosPSocietarias)iterator.next();
            this.getParticipacoesSocietarias().recuperarLista().remove(objetoNegocio);
        }
        iterator = arrayList4.iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (IdentificacaoDeclaranteGCAP)((Object)iterator.next());
            this.getDeclarantes().recuperarLista().remove(objetoNegocio);
        }
        this.getBensMoveis().recuperarLista().removeAll(arrayList2);
        this.getBensImoveis().recuperarLista().removeAll(arrayList);
    }

    public boolean existeItemPorCPF(String string) {
        ObjetoNegocio objetoNegocio;
        if ("".equals(string.trim())) {
            return false;
        }
        Iterator iterator = this.getBensImoveis().recuperarLista().iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (ItemDadosBemImovel)iterator.next();
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            return true;
        }
        iterator = this.getBensMoveis().recuperarLista().iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (ItemDadosBemMovel)iterator.next();
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            return true;
        }
        iterator = this.getParticipacoesSocietarias().recuperarLista().iterator();
        while (iterator.hasNext()) {
            objetoNegocio = (ItemDadosPSocietarias)iterator.next();
            if (!string.equals(objetoNegocio.getCpf().asString())) continue;
            return true;
        }
        return false;
    }

    public ItemDadosBemImovel getBemImovelPorCodItem(String string) {
        Iterator iterator = this.getBensImoveis().recuperarLista().iterator();
        while (iterator.hasNext()) {
            ItemDadosBemImovel itemDadosBemImovel = (ItemDadosBemImovel)iterator.next();
            if (!itemDadosBemImovel.getNumeroItem().asString().equals(string)) continue;
            return itemDadosBemImovel;
        }
        return null;
    }

    public ItemDadosBemMovel getBemMovelPorCodItem(String string) {
        Iterator iterator = this.getBensMoveis().recuperarLista().iterator();
        while (iterator.hasNext()) {
            ItemDadosBemMovel itemDadosBemMovel = (ItemDadosBemMovel)iterator.next();
            if (!itemDadosBemMovel.getNumeroItem().asString().equals(string)) continue;
            return itemDadosBemMovel;
        }
        return null;
    }

    public ItemDadosPSocietarias getPartSocPorCodItem(String string) {
        Iterator iterator = this.getParticipacoesSocietarias().recuperarLista().iterator();
        while (iterator.hasNext()) {
            ItemDadosPSocietarias itemDadosPSocietarias = (ItemDadosPSocietarias)iterator.next();
            if (!itemDadosPSocietarias.getNumeroItem().asString().equals(string)) continue;
            return itemDadosPSocietarias;
        }
        return null;
    }

    public void clear() {
        this.getBensImoveis().recuperarLista().clear();
        this.getBensMoveis().recuperarLista().clear();
        this.getParticipacoesSocietarias().recuperarLista().clear();
        this.getDeclarantes().recuperarLista().clear();
        this.getTotalImpostoPagoSobreGanhosCapital().clear();
        this.getTotalImpostoRetidoFonteSobreGanhosCapital().clear();
    }
}

