/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import classes.bH;
import classes.cQ;
import classes.g;
import classes.mI;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendavariavel.ColecaoItemImpostoPagar;
import serpro.ppgd.irpf.rendavariavel.Operacoes;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class GanhosLiquidosOuPerdas
extends ObjetoNegocio {
    public static final String PROP_IR_FONTE_DAYTRADE = "IRFONTEDAYTRADE";
    public static final String PROP_IMP_RETIDO_LEI_11033 = "IR LEI 11033";
    public static final String PROP_IMP_PAGO = "IMP PAGO";
    public static final String MES = "M\u00eas";
    private Operacoes operacoesComuns = new Operacoes("15");
    private Operacoes operacoesDayTrade = new Operacoes("20");
    private Valor totalImpostoDevido = new Valor((ObjetoNegocio)this, "");
    private Valor irFonteDayTradeMesAtual = new Valor((ObjetoNegocio)this, "IRFONTEDAYTRADE");
    private Valor irFonteDayTradeMesesAnteriores = new Valor((ObjetoNegocio)this, "");
    private Valor irFonteDayTradeAcompensar = new Valor((ObjetoNegocio)this, "");
    private mI impostoApagar = new mI(this, "");
    private Valor impostoPago = new Valor((ObjetoNegocio)this, "IMP PAGO");
    private Valor impostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "IR LEI 11033");
    public static final String ALIQUOTA_DAYTRADE = "20";
    public static final String ALIQUOTA_COMUM = "15";
    public static final String TITULO_FICHA_SEM_MES = "Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade";
    private ColecaoItemImpostoPagar colecaoItemImpostoPagar;

    public GanhosLiquidosOuPerdas(DeclaracaoIRPF declaracaoIRPF, String string) {
        this.colecaoItemImpostoPagar = new ColecaoItemImpostoPagar(declaracaoIRPF, string);
        this.setFicha("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - " + string);
        this.getOperacoesComuns().setFicha(TITULO_FICHA_SEM_MES);
        this.getOperacoesDayTrade().setFicha(TITULO_FICHA_SEM_MES);
        this.getOperacoesComuns().getAliquotaDoImposto().setConteudo("15%");
        this.getOperacoesDayTrade().getAliquotaDoImposto().setConteudo("20%");
        this.getOperacoesComuns().getResultadoLiquidoMes().setReadOnly(true);
        this.getOperacoesDayTrade().getResultadoLiquidoMes().setReadOnly(true);
        this.getOperacoesComuns().getBaseCalculoImposto().setReadOnly(true);
        this.getOperacoesDayTrade().getBaseCalculoImposto().setReadOnly(true);
        this.getOperacoesComuns().getPrejuizoCompensar().setReadOnly(true);
        this.getOperacoesDayTrade().getPrejuizoCompensar().setReadOnly(true);
        this.getOperacoesComuns().getAliquotaDoImposto().setHabilitado(false);
        this.getOperacoesDayTrade().getAliquotaDoImposto().setHabilitado(false);
        this.getOperacoesComuns().getImpostoDevido().setReadOnly(true);
        this.getOperacoesDayTrade().getImpostoDevido().setReadOnly(true);
        this.getOperacoesComuns().getResultadoNegativoMesAnterior().setHabilitado(false);
        this.getOperacoesDayTrade().getResultadoNegativoMesAnterior().setHabilitado(false);
        this.getTotalImpostoDevido().setReadOnly(true);
        this.getIrFonteDayTradeMesesAnteriores().setReadOnly(true);
        this.getIrFonteDayTradeAcompensar().setReadOnly(true);
        this.getImpostoApagar().setReadOnly(true);
        this.getImpostoApagar().addValidador((ValidadorIf)new g(this, 3));
        this.getImpostoRetidoFonteLei11033().addValidador((ValidadorIf)new cQ(this, 3));
        bH bH2 = new bH(this);
        this.getTotalImpostoDevido().addObservador((Observador)bH2);
        this.getIrFonteDayTradeMesAtual().addObservador((Observador)bH2);
        this.getIrFonteDayTradeMesesAnteriores().addObservador((Observador)bH2);
        this.getOperacoesComuns().getImpostoDevido().addObservador((Observador)this);
        this.getOperacoesDayTrade().getImpostoDevido().addObservador((Observador)this);
        this.getIrFonteDayTradeMesAtual().addObservador((Observador)this);
        this.getIrFonteDayTradeMesesAnteriores().addObservador((Observador)this);
        this.getImpostoRetidoFonteLei11033().addObservador((Observador)this);
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.totalImpostoDevido.setConteudo(this.getOperacoesComuns().getImpostoDevido().operacao('+', this.getOperacoesDayTrade().getImpostoDevido()));
        Valor valor = new Valor();
        valor.append('+', this.getIrFonteDayTradeMesAtual());
        valor.append('+', this.getIrFonteDayTradeMesesAnteriores());
        if (valor.comparacao(">", this.getTotalImpostoDevido())) {
            Valor valor2 = new Valor();
            valor2.append('+', valor);
            valor2.append('-', this.getTotalImpostoDevido());
            this.getIrFonteDayTradeAcompensar().setConteudo(valor2);
            this.getImpostoApagar().clear();
        } else {
            this.getIrFonteDayTradeAcompensar().clear();
            Valor valor3 = new Valor();
            valor3.append('+', this.getTotalImpostoDevido());
            valor3.append('-', valor);
            valor3.append('-', this.getImpostoRetidoFonteLei11033());
            this.getImpostoApagar().setConteudo(valor3);
        }
    }

    public void adicionarObservadorCalculosRendaVariavel(Observador observador) {
        this.operacoesComuns.getBaseCalculoImposto().addObservador(observador);
        this.operacoesDayTrade.getBaseCalculoImposto().addObservador(observador);
        this.irFonteDayTradeMesAtual.addObservador(observador);
        this.impostoPago.addObservador(observador);
        this.impostoRetidoFonteLei11033.addObservador(observador);
        this.impostoApagar.addObservador(observador);
    }

    public Operacoes getOperacoesComuns() {
        return this.operacoesComuns;
    }

    public Operacoes getOperacoesDayTrade() {
        return this.operacoesDayTrade;
    }

    public mI getImpostoApagar() {
        return this.impostoApagar;
    }

    public Valor getImpostoPago() {
        return this.impostoPago;
    }

    public Valor getIrFonteDayTradeAcompensar() {
        return this.irFonteDayTradeAcompensar;
    }

    public Valor getIrFonteDayTradeMesAtual() {
        return this.irFonteDayTradeMesAtual;
    }

    public Valor getIrFonteDayTradeMesesAnteriores() {
        return this.irFonteDayTradeMesesAnteriores;
    }

    public Valor getTotalImpostoDevido() {
        return this.totalImpostoDevido;
    }

    public List recuperarListaCamposPendencia() {
        List list = super.recuperarCamposInformacao();
        list.add(this.getImpostoRetidoFonteLei11033());
        return list;
    }

    public boolean estaVazio() {
        boolean bl2 = this.operacoesComuns.isVazio();
        bl2 = bl2 && this.operacoesDayTrade.isVazio();
        bl2 = bl2 && this.irFonteDayTradeMesAtual.isVazio();
        bl2 = bl2 && this.impostoPago.isVazio();
        bl2 = bl2 && this.impostoRetidoFonteLei11033.isVazio();
        bl2 = bl2 && this.operacoesComuns.getResultadoLiquidoMes().isVazio();
        bl2 = bl2 && this.operacoesComuns.getResultadoNegativoMesAnterior().isVazio();
        bl2 = bl2 && this.operacoesDayTrade.getResultadoLiquidoMes().isVazio();
        bl2 = bl2 && this.operacoesDayTrade.getResultadoNegativoMesAnterior().isVazio();
        return bl2;
    }

    public Valor getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public void clear() {
        super.clear();
        this.operacoesComuns.clear();
        this.operacoesDayTrade.clear();
    }

    public ColecaoItemImpostoPagar getColecaoItemImpostoPagar() {
        return this.colecaoItemImpostoPagar;
    }

    public void setColecaoItemImpostoPagar(ColecaoItemImpostoPagar colecaoItemImpostoPagar) {
        this.colecaoItemImpostoPagar = colecaoItemImpostoPagar;
    }
}

