/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import classes.cy;
import classes.fD;
import classes.mI;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class RendPJTitular
extends ObjetoNegocio {
    public static final String NOME_NI_FONTE_PAGADORA = "CPF/CNPJ da Fonte Pagadora";
    public static final String NOME_REND_RECEB_PJ = "Rend. Recebid";
    public static final String NOME_CONTRIB_PREV = "Contr. Prev. Oficial";
    public static final String NOME_IMPOSTO_RETIDO = "IR Retido na Fonte";
    public static final String NOME_DECIMO_TERCEIRO = "13\u00ba Sal\u00e1rio";
    public transient IdentificadorDeclaracao identificadorDeclaracao = null;
    public Alfa nomeFontePagadora = new Alfa((ObjetoNegocio)this, "Nome da Fonte Pagadora");
    public NI NIFontePagadora = new NI((ObjetoNegocio)this, "CPF/CNPJ da Fonte Pagadora");
    public mI rendRecebidoPJ = new mI(this, "Rend. Recebid");
    public mI contribuicaoPrevOficial = new mI(this, "Contr. Prev. Oficial");
    public mI impostoRetidoFonte = new mI(this, "IR Retido na Fonte");
    public mI decimoTerceiro = new mI(this, "13\u00ba Sal\u00e1rio");

    public RendPJTitular(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.addValidadores();
    }

    public void addValidadores() {
        cy cy2 = new cy(this, 3);
        this.getNomeFontePagadora().addValidador((ValidadorIf)cy2);
        fD fD2 = new fD(this, 3);
        this.getNIFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3));
        this.getNIFontePagadora().addValidador((ValidadorIf)fD2);
    }

    public void addObservador(Observador observador) {
        this.rendRecebidoPJ.addObservador(observador);
        this.contribuicaoPrevOficial.addObservador(observador);
        this.impostoRetidoFonte.addObservador(observador);
        this.decimoTerceiro.addObservador(observador);
        this.NIFontePagadora.addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.rendRecebidoPJ.removeObservador(observador);
        this.contribuicaoPrevOficial.removeObservador(observador);
        this.impostoRetidoFonte.removeObservador(observador);
        this.decimoTerceiro.removeObservador(observador);
        this.NIFontePagadora.removeObservador(observador);
    }

    public Valor getContribuicaoPrevOficial() {
        return this.contribuicaoPrevOficial;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public Valor getImpostoRetidoFonte() {
        return this.impostoRetidoFonte;
    }

    public NI getNIFontePagadora() {
        return this.NIFontePagadora;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public Valor getRendRecebidoPJ() {
        return this.rendRecebidoPJ;
    }

    public Pendencia verificaValores(int n2) {
        Pendencia pendencia = null;
        if (this.getImpostoRetidoFonte().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getDecimoTerceiro().isVazio() && this.getRendRecebidoPJ().isVazio()) {
            pendencia = new Pendencia(3, (Informacao)this.getRendRecebidoPJ(), "Valores RendPJ", this.tab.msg("rendpj_faltam_valores"), n2);
        }
        return pendencia;
    }

    public List verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        Pendencia pendencia = this.verificaValores(n2);
        if (pendencia != null) {
            list.add(pendencia);
        }
        return list;
    }

    public List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public boolean isVazio() {
        Iterator iterator = this.recuperarCamposInformacao().iterator();
        while (iterator.hasNext()) {
            Informacao informacao = (Informacao)iterator.next();
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }
}

