/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import serpro.ppgd.gui.EditMascara;
import serpro.ppgd.gui.table.JTableEx;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JDialogEditCampoLeitor;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.PPGDFormPanel;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;

public class JEditColecao
extends JEditCampo
implements ActionListener,
KeyListener {
    protected JFormattedTextField txtCodigo;
    protected JLabel lblTexto;
    protected JButton btnPopup;
    private EditMascara edtMsk;
    protected int colunaExibidaLabel;
    protected int colunaExibidaCodigo;
    protected JDialog dlg;
    protected JTable tabelaPopup;
    protected JScrollPane scroll;
    protected String tituloDialogo = "";
    protected int delayMaxFiltroTeclado = 1000;
    protected int maxCaracteresNaColunaDaListaPopup = 40;
    protected String definicaoFormsColunas;
    protected String definicaoFormsLinha;
    private boolean debugging = false;
    private double pesoTxtCodigo;
    private double pesoLabel;
    private boolean quebraAutomaticaTexto = false;
    private boolean podeDigitarValoresForaDoDominio = false;
    static /* synthetic */ Class class$0;

    public JEditColecao() {
        super((Informacao)new Codigo(null, "Codigo", new Vector()));
        this.setMascaraTxtCodigo("**");
    }

    protected void instanciaComponentes() {
        ImageIcon icon = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/down_narrow.png"));
        this.btnPopup = new JButton(icon);
        this.btnPopup.setFocusable(true);
        this.btnPopup.setPreferredSize(new Dimension(26, this.btnPopup.getPreferredSize().height + 3));
        this.btnPopup.addActionListener(this);
        this.btnPopup.getAccessibleContext().setAccessibleName("Procura c\u00f3digo");
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.txtCodigo == null) {
            this.edtMsk = new EditMascara();
            this.edtMsk.removeTransfereFocoEnter();
            this.edtMsk.getComponenteFoco().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ((JTextField)JEditColecao.access$0(1.access$0(this.this$1)).getComponenteFoco()).selectAll();
                        }
                    });
                }

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    JEditColecao.this.setIdentificacaoFoco(false);
                    if (!JEditColecao.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !JEditColecao.this.verificaValidacoesImpeditivas(((JTextField)JEditColecao.this.edtMsk.getComponenteFoco()).getText())) {
                        return;
                    }
                    JEditColecao.this.setarCampo();
                    JEditColecao.this.implementacaoPropertyChange(null);
                    JEditColecao.this.chamaValidacao();
                }

                static /* synthetic */ JEditColecao access$0(1 var0) {
                    return var0.JEditColecao.this;
                }
            });
            this.edtMsk.getComponenteFoco().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 40) {
                        JEditColecao.this.btnPopup.doClick();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            });
            this.edtMsk.setSobrescreve(true);
            this.edtMsk.setMascara("*************");
            this.edtMsk.setTamanho(10);
            this.edtMsk.getInformacao().setObservadoresAtivos(false);
            this.definicaoFormsColunas = "1px,MIN(12dlu;P):grow(.1),2dlu,P,2dlu,MIN(1px;P):grow(.9)";
            this.definicaoFormsLinha = "1px,P,1px,MIN(P;10dlu):grow,1px";
            this.pesoTxtCodigo = 0.1;
            this.pesoLabel = 0.9;
            this.txtCodigo = (JFormattedTextField)this.edtMsk.getComponenteFoco();
            this.txtCodigo.setEditable(false);
            this.txtCodigo.setBorder(BorderFactory.createLoweredBevelBorder());
            this.lblTexto = new JLabel(" ");
            this.lblTexto.setBorder(BorderFactory.createLoweredBevelBorder());
            this.lblTexto.setVerticalTextPosition(1);
            this.lblTexto.setHorizontalTextPosition(2);
            this.colunaExibidaLabel = 1;
            this.colunaExibidaCodigo = 0;
        }
        this.add((Component)this.montaPainelCombo(), "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    public JButton getBtnPopup() {
        return this.btnPopup;
    }

    public boolean isTxtCodigoEditavel() {
        return this.txtCodigo.isEditable();
    }

    public void setTxtCodigoEditavel(boolean opt) {
        this.txtCodigo.setEditable(opt);
    }

    public boolean isTxtCodigoHabilitado() {
        return this.txtCodigo.isEnabled();
    }

    public void setTxtCodigoHabilitado(boolean opt) {
        this.txtCodigo.setEnabled(opt);
    }

    protected JPanel montaPainelCombo() {
        PPGDFormPanel retorno = new PPGDFormPanel();
        if (this.isDebugging()) {
            retorno.setDebugColor(true);
        }
        retorno.setLayout((LayoutManager)new FormLayout(this.definicaoFormsColunas, this.definicaoFormsLinha));
        retorno.getBuilder().setRow(2);
        retorno.getBuilder().setColumn(2);
        retorno.getBuilder().append((Component)this.txtCodigo);
        retorno.getBuilder().setColumn(4);
        retorno.getBuilder().append((Component)this.btnPopup);
        CellConstraints cc = new CellConstraints();
        retorno.add((Component)this.lblTexto, (Object)cc.xywh(6, 2, 1, 3));
        return retorno;
    }

    public int getColunaExibidaLabel() {
        return this.colunaExibidaLabel;
    }

    public void setColunaExibidaLabel(int pColunaExibidaLabel) {
        this.colunaExibidaLabel = pColunaExibidaLabel;
    }

    public int getColunaExibidaCodigo() {
        return this.colunaExibidaCodigo;
    }

    public void setColunaExibidaCodigo(int colunaExibidaCodigo) {
        this.colunaExibidaCodigo = colunaExibidaCodigo;
    }

    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JEditColecao.this.dlg == null) {
                    JEditColecao.this.instanciaPopUp();
                }
                JEditColecao.this.getInformacao().setConteudo(((JTextField)JEditColecao.this.edtMsk.getComponenteFoco()).getText());
                JEditColecao.this.exibePopUp();
            }
        });
    }

    private void instanciaPopUp() {
        this.dlg = new JDialog((Frame)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), false);
        this.dlg.setDefaultCloseOperation(2);
        this.tabelaPopup = this.getTabelaPopup();
        this.tabelaPopup.setModel(new ListPopupModel());
        this.tabelaPopup.setTableHeader(null);
        this.tabelaPopup.setSelectionMode(0);
        this.tabelaPopup.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                JEditColecao.this.dlg.setVisible(false);
                int indiceSelecionado = JEditColecao.this.tabelaPopup.getSelectedRow();
                if (indiceSelecionado != -1) {
                    String cod = (String)JEditColecao.this.tabelaPopup.getModel().getValueAt(indiceSelecionado, 0);
                    ((Codigo)JEditColecao.this.getInformacao()).setConteudo(cod);
                }
            }
        });
        this.tabelaPopup.addKeyListener(this);
        this.setListRenderer(new ListPopupRenderer(this.tabelaPopup));
        PPGDFormPanel pnl = new PPGDFormPanel();
        pnl.setLayout((LayoutManager)new FormLayout("P:grow", "P"));
        pnl.getBuilder().append((Component)this.tabelaPopup);
        this.scroll = new JScrollPane((Component)pnl);
        this.scroll.setAutoscrolls(true);
        this.scroll.setHorizontalScrollBarPolicy(32);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.tabelaPopup.addKeyListener(new KeyListenerPopup(((Codigo)this.getInformacao()).getColunaFiltro()));
        this.tabelaPopup.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    JEditColecao.this.dlg.setVisible(false);
                }
            }
        });
        this.dlg.getContentPane().add(this.scroll);
        this.dlg.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
            }

            public void windowLostFocus(WindowEvent e) {
                if (e.getOppositeWindow() != null && !e.getOppositeWindow().equals(JEditColecao.this.dlg)) {
                    JEditColecao.this.dlg.dispose();
                }
            }
        });
        this.dlg.setUndecorated(true);
        ((JPanel)this.dlg.getContentPane()).setBorder(BorderFactory.createRaisedBevelBorder());
        this.getTabelaPopup().setAutoResizeMode(0);
        this.ajustaLarguraColunas();
    }

    private void exibePopUp() {
        int linhaPreSelecionada = ((Codigo)this.getInformacao()).getIndiceElementoTabela();
        if (!this.getInformacao().isVazio()) {
            this.tabelaPopup.getSelectionModel().setSelectionInterval(linhaPreSelecionada, linhaPreSelecionada);
        } else {
            this.tabelaPopup.getSelectionModel().clearSelection();
            this.tabelaPopup.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.tabelaPopup.getPreferredSize().height < 160) {
            this.dlg.setSize(new Dimension(350, this.tabelaPopup.getPreferredSize().height + 5));
        } else {
            this.dlg.setSize(new Dimension(350, 160));
        }
        this.dlg.setTitle(this.tituloDialogo);
        this.dlg.setLocationRelativeTo(null);
        Point ponto = this.btnPopup.getLocationOnScreen();
        int larguraTela = Toolkit.getDefaultToolkit().getScreenSize().width;
        int larguraPopup = this.dlg.getSize().width;
        if (ponto.x + larguraPopup > larguraTela) {
            int excesso = ponto.x + larguraPopup - larguraTela;
            ponto.x -= excesso;
        }
        ponto.y += this.btnPopup.getSize().height;
        this.dlg.setLocation(ponto);
        this.dlg.setVisible(true);
        try {
            this.ajustaScroll();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
        this.scroll.getViewport().setViewPosition(new Point(0, 0));
    }

    private void ajustaScroll() {
        int totalLinhas = ((Codigo)this.getInformacao()).getColecaoElementoTabela().size();
        int indiceSelecionado = ((Codigo)this.getInformacao()).getIndiceElementoTabela();
        if (indiceSelecionado == -1) {
            this.scroll.getVerticalScrollBar().setValue(this.scroll.getVerticalScrollBar().getMinimum());
        }
        int valor = 0;
        int maximoScroll = this.scroll.getVerticalScrollBar().getMaximum();
        int larguraLinha = this.tabelaPopup.getRowHeight();
        this.scroll.getVerticalScrollBar().setBlockIncrement(40);
        this.scroll.getVerticalScrollBar().setUnitIncrement(20);
        valor = maximoScroll / totalLinhas * indiceSelecionado;
        this.scroll.getVerticalScrollBar().setValue(valor);
    }

    private void ajustaLarguraColunas() {
        List elementosTabela = ((Codigo)this.getInformacao()).getColecaoElementoTabela();
        int i = elementosTabela.size() - 1;
        while (i >= 0) {
            this.calculaLarguraColuna((ElementoTabela)elementosTabela.get(i));
            --i;
        }
    }

    private void calculaLarguraColuna(ElementoTabela elem) {
        JLabel lbl = new JLabel();
        int i = 0;
        while (i < elem.size()) {
            lbl.setText(elem.getConteudo(i));
            if (lbl.getPreferredSize().width > this.getLarguraColunaTabela(i)) {
                this.setLarguraColunaTabela(i, lbl.getPreferredSize().width);
            }
            ++i;
        }
    }

    public void setTxtCodigoVisivel(boolean pOpt) {
        this.txtCodigo.setVisible(pOpt);
        this.definicaoFormsColunas = !this.txtCodigo.isVisible() ? "1px,P,P,P,2dlu,MIN(1px;P):grow" : "1px,MIN(12dlu;P):grow(" + String.valueOf(this.pesoTxtCodigo) + "),2dlu,P,2dlu,MIN(1px;P):grow(" + String.valueOf(this.pesoLabel) + ")";
        this.buildComponente();
    }

    public void setLblTextoVisivel(boolean pOpt) {
        this.lblTexto.setVisible(pOpt);
    }

    public boolean isLblTextoVisivel() {
        return this.lblTexto.isVisible();
    }

    public boolean getTxtCodigoVisivel() {
        return this.txtCodigo.isVisible();
    }

    public void setLarguraColunaTabela(int col, int largura) {
        this.getTabelaPopup().getColumnModel().getColumn(col).setWidth(largura);
        this.getTabelaPopup().getColumnModel().getColumn(col).setPreferredWidth(largura);
    }

    public int getLarguraColunaTabela(int col) {
        return this.getTabelaPopup().getColumnModel().getColumn(col).getWidth();
    }

    public String getTituloDialogo() {
        return this.tituloDialogo;
    }

    public void setTituloDialogo(String tituloDialogo) {
        this.tituloDialogo = tituloDialogo;
    }

    public JLabel getLblTexto() {
        return this.lblTexto;
    }

    protected void informacaoModificada() {
        this.instanciaPopUp();
        this.implementacaoPropertyChange(null);
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        this.txtCodigo.setEditable(!readOnly);
        this.btnPopup.setEnabled(!readOnly);
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        this.txtCodigo.setEnabled(habilitado);
        if (habilitado) {
            this.txtCodigo.setBackground(Color.WHITE);
        } else {
            this.txtCodigo.setBackground(Color.getColor("TextField.disabledBackground"));
        }
        this.btnPopup.setEnabled(habilitado);
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        ElementoTabela elem;
        if (evt != null && evt.getPropertyName() != null && evt.getPropertyName().equals("ComboReiniciado")) {
            this.setInformacao(this.getInformacao());
        }
        String codigo = " ";
        String texto = " ";
        if (!this.getInformacao().isVazio() && (elem = ((Codigo)this.getInformacao()).getElementoTabela()) != null) {
            codigo = elem.getConteudo(this.colunaExibidaCodigo);
            texto = this.quebraAutomaticaTexto ? "<HTML>" + elem.getConteudo(this.colunaExibidaLabel) + "</HTML>" : elem.getConteudo(this.colunaExibidaLabel);
        }
        this.setaConteudoTxtCodigo(codigo);
        this.lblTexto.setText(texto);
        this.getAccessibleContext().setAccessibleName(String.valueOf(codigo) + " " + texto);
    }

    protected void setaConteudoTxtCodigo(String texto) {
        String valorSemMascara = UtilitariosString.retiraMascara((String)this.campo.getConteudoFormatado());
        String valorComMascara = UtilitariosString.retornaComMascara((String)valorSemMascara, (String)this.edtMsk.getFormatador().getMask());
        if (valorSemMascara.trim().equals("")) {
            this.txtCodigo.setText(valorComMascara);
            this.txtCodigo.setValue(null);
        } else {
            this.txtCodigo.setText(valorComMascara);
            this.txtCodigo.setValue(valorComMascara);
        }
        this.txtCodigo.setCaretPosition(0);
    }

    public JComponent getComponenteEditor() {
        return this.txtCodigo;
    }

    public JComponent getComponenteFoco() {
        return this.txtCodigo;
    }

    public void setEstiloFonte(int estilo) {
        Font f = this.txtCodigo.getFont();
        f = f.deriveFont(estilo);
        this.txtCodigo.setFont(f);
        f = this.lblTexto.getFont();
        f = f.deriveFont(estilo);
        this.lblTexto.setFont(f);
    }

    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = this.txtCodigo.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.txtCodigo.setFont(f);
        f = this.lblTexto.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.lblTexto.setFont(f);
    }

    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }

    public Color getBackGroundListaPopup() {
        return this.getTabelaPopup().getBackground();
    }

    public void setBackGroundListaPopup(Color cl) {
        this.getTabelaPopup().setBackground(cl);
    }

    public void setListRenderer(TableCellRenderer renderer) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tabelaPopup.setDefaultRenderer(clazz, renderer);
    }

    public JTable getTabelaPopup() {
        if (this.tabelaPopup == null) {
            this.tabelaPopup = new JTableEx(){

                public boolean getScrollableTracksViewportHeight() {
                    return true;
                }
            };
        }
        return this.tabelaPopup;
    }

    public int getDelayMaxFiltroTeclado() {
        return this.delayMaxFiltroTeclado;
    }

    public void setDelayMaxFiltroTeclado(int delayMaxFiltroTeclado) {
        this.delayMaxFiltroTeclado = delayMaxFiltroTeclado;
    }

    public int getMaxCaracteresNaColunaDaListaPopup() {
        return this.maxCaracteresNaColunaDaListaPopup;
    }

    public void setMaxCaracteresNaColunaDaListaPopup(int pMaxCaracteresNaColunaDaListaPopup) {
        this.maxCaracteresNaColunaDaListaPopup = pMaxCaracteresNaColunaDaListaPopup;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
        this.buildComponente();
    }

    public String getMascaraTxtCodigo() {
        return this.edtMsk.getMascara();
    }

    public void setMascaraTxtCodigo(String pMascaraTxtCodigo) {
        String textoAntigo = ((JTextField)this.edtMsk.getComponenteFoco()).getText();
        this.edtMsk.setMascara(pMascaraTxtCodigo);
        this.edtMsk.setTamanho(pMascaraTxtCodigo.length());
        this.setaConteudoTxtCodigo(textoAntigo);
        this.buildComponente();
    }

    public String getCaracteresInvalidosTxtCodigo() {
        return this.edtMsk.getFormatador().getInvalidCharacters();
    }

    public void setCaracteresInvalidosTxtCodigo(String pCaracteresInvalidosTxtCodigo) {
        this.edtMsk.setCaracteresInvalidos(pCaracteresInvalidosTxtCodigo);
    }

    public String getCaracteresValidosTxtCodigo() {
        return this.edtMsk.getFormatador().getValidCharacters();
    }

    public void setCaracteresValidosTxtCodigo(String pCaracteresValidosTxtCodigo) {
        this.edtMsk.setCaracteresValidos(pCaracteresValidosTxtCodigo);
    }

    public double getPesoLabel() {
        return this.pesoLabel;
    }

    public void setPesoLabel(double pPesoLabel) {
        if (pPesoLabel <= 0.0 || pPesoLabel >= 1.0 || !this.txtCodigo.isVisible()) {
            return;
        }
        this.pesoLabel = pPesoLabel;
        this.pesoTxtCodigo = 1.0 - this.pesoLabel;
        this.definicaoFormsColunas = "1px,MIN(12dlu;P):grow(" + String.valueOf(this.pesoTxtCodigo) + "),2dlu,P,2dlu,MIN(40dlu;P):grow(" + String.valueOf(this.pesoLabel) + ")";
        this.buildComponente();
    }

    public double getPesoTxtCodigo() {
        return this.pesoTxtCodigo;
    }

    public void setPesoTxtCodigo(double pPesoTxtCodigo) {
        if (pPesoTxtCodigo <= 0.0 || pPesoTxtCodigo >= 1.0 || !this.txtCodigo.isVisible()) {
            return;
        }
        this.pesoTxtCodigo = pPesoTxtCodigo;
        this.pesoLabel = 1.0 - this.pesoTxtCodigo;
        this.definicaoFormsColunas = "1px,MIN(12dlu;P):grow(" + String.valueOf(this.pesoTxtCodigo) + "),2dlu,P,2dlu,MIN(40dlu;P):grow(" + String.valueOf(this.pesoLabel) + ")";
        this.buildComponente();
    }

    public boolean isQuebraAutomaticaTexto() {
        return this.quebraAutomaticaTexto;
    }

    public void setQuebraAutomaticaTexto(boolean quebraAutomaticaTexto) {
        this.quebraAutomaticaTexto = quebraAutomaticaTexto;
    }

    public Icon getIconBtnPopup() {
        return this.btnPopup.getIcon();
    }

    public void setIconBtnPopup(Icon icon) {
        this.btnPopup.setIcon(icon);
    }

    public boolean isPodeDigitarValoresForaDoDominio() {
        return this.podeDigitarValoresForaDoDominio;
    }

    public void setPodeDigitarValoresForaDoDominio(boolean podeDigitarValoresForaDoDominio) {
        this.podeDigitarValoresForaDoDominio = podeDigitarValoresForaDoDominio;
    }

    public void setarCampo() {
        int total = ((Codigo)this.getInformacao()).getColecaoElementoTabela().size();
        int itemSelecionado = -1;
        String upperFiltro = ((JTextField)this.edtMsk.getComponenteFoco()).getText().trim().toUpperCase();
        boolean achouOpcaoValida = false;
        int i = 0;
        while (i < total) {
            ElementoTabela elem = (ElementoTabela)((Codigo)this.getInformacao()).getColecaoElementoTabela().get(i);
            String item = UtilitariosString.removeAcentos((String)elem.getConteudo(this.colunaExibidaCodigo)).trim();
            if (item.toUpperCase().equals(upperFiltro)) {
                itemSelecionado = i;
                achouOpcaoValida = true;
            }
            ++i;
        }
        if (!this.isPodeDigitarValoresForaDoDominio() && !achouOpcaoValida) {
            this.getInformacao().clear();
            ((JFormattedTextField)this.edtMsk.getComponenteFoco()).setValue(null);
        } else {
            this.getInformacao().setConteudo(((JTextField)this.edtMsk.getComponenteFoco()).getText());
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!e.isConsumed() && e.isControlDown() && e.getKeyCode() == 83) {
            String acessivel = FabricaUtilitarios.getProperties().getProperty("aplicacao.acessivel.habilitado");
            if (Boolean.valueOf(acessivel).booleanValue()) {
                JDialogEditCampoLeitor dialog = new JDialogEditCampoLeitor(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), this);
                dialog.setVisible(false);
            }
            e.consume();
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public static void main(String[] args) {
    }

    class ListPopupModel
    extends AbstractTableModel {
        ListPopupModel() {
        }

        public int getRowCount() {
            Codigo info = (Codigo)JEditColecao.this.getInformacao();
            return info.getColecaoElementoTabela().size();
        }

        public Object getValueAt(int row, int column) {
            boolean tem;
            ElementoTabela elemento = ((Codigo)JEditColecao.this.getInformacao()).getElementoTabela(row);
            String valor = elemento.getConteudo(column);
            boolean bl = tem = valor.indexOf("...") > 0;
            if (tem) {
                valor = valor.substring(0, valor.length() - 3);
            }
            return valor;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public int getColumnCount() {
            if (((Codigo)JEditColecao.this.getInformacao()).getColecaoElementoTabela().size() == 0) {
                return 0;
            }
            ElementoTabela elemento = ((Codigo)JEditColecao.this.getInformacao()).getElementoTabela(0);
            return elemento.size();
        }
    }

    class ListPopupRenderer
    extends DefaultTableCellRenderer {
        private JTable tbl;

        public ListPopupRenderer(JTable pTbl) {
            this.tbl = pTbl;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean ehPar = row % 2 == 0;
            String val = (String)value;
            super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
            if (!isSelected) {
                if (!ehPar) {
                    Color c = new Color(this.tbl.getBackground().getRed() - 35, this.tbl.getBackground().getGreen() - 35, this.tbl.getBackground().getBlue() - 35);
                    this.setBackground(c);
                } else {
                    this.setBackground(this.tbl.getBackground());
                }
                return this;
            }
            return super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
        }
    }

    class KeyListenerPopup
    extends KeyAdapter {
        long ultimaVez = 0L;
        String filtro = "";
        int colunaFiltro;

        public KeyListenerPopup(int aColunaFiltro) {
            this.colunaFiltro = aColunaFiltro;
        }

        public void keyPressed(KeyEvent e) {
            if (Character.isDigit(e.getKeyChar()) || Character.isLetter(e.getKeyChar())) {
                int selecao = this.selectionForKey(e.getKeyChar());
                JEditColecao.this.tabelaPopup.getSelectionModel().setSelectionInterval(selecao, selecao);
                if (selecao != -1) {
                    if (selecao == 0) {
                        JEditColecao.this.scroll.getVerticalScrollBar().setValue(JEditColecao.this.scroll.getVerticalScrollBar().getMinimum());
                    } else if (selecao == JEditColecao.this.tabelaPopup.getRowCount() - 1) {
                        JEditColecao.this.scroll.getVerticalScrollBar().setValue(JEditColecao.this.scroll.getVerticalScrollBar().getMaximum());
                    } else {
                        int max = JEditColecao.this.scroll.getVerticalScrollBar().getMaximum();
                        int pos = max / (JEditColecao.this.tabelaPopup.getRowCount() - 1) * selecao;
                        JEditColecao.this.scroll.getVerticalScrollBar().setValue(pos);
                    }
                }
            } else if (e.getKeyCode() == 10 && JEditColecao.this.tabelaPopup.getSelectedRow() != -1) {
                JEditColecao.this.dlg.setVisible(false);
                String cod = (String)JEditColecao.this.tabelaPopup.getModel().getValueAt(JEditColecao.this.tabelaPopup.getSelectedRow(), 0);
                ((Codigo)JEditColecao.this.getInformacao()).setConteudo(cod);
            }
        }

        public int selectionForKey(char aKey) {
            int itemSelecionado = -1;
            if (this.colunaFiltro >= 0) {
                long atual = System.currentTimeMillis();
                long diferenca = atual - this.ultimaVez;
                if (diferenca < (long)JEditColecao.this.getDelayMaxFiltroTeclado()) {
                    this.filtro = String.valueOf(this.filtro) + aKey;
                    itemSelecionado = this.tentaSelecionar();
                } else {
                    this.filtro = "";
                    this.filtro = String.valueOf(this.filtro) + aKey;
                    itemSelecionado = this.tentaSelecionar();
                }
                this.ultimaVez = atual;
                if (this.filtro.length() > 100) {
                    this.filtro = "";
                }
            }
            return itemSelecionado;
        }

        private synchronized int tentaSelecionar() {
            int total = ((Codigo)JEditColecao.this.getInformacao()).getColecaoElementoTabela().size();
            int itemSelecionado = -1;
            String upperFiltro = this.filtro.toUpperCase();
            int i = 0;
            while (i < total) {
                ElementoTabela elem = (ElementoTabela)((Codigo)JEditColecao.this.getInformacao()).getColecaoElementoTabela().get(i);
                String item = UtilitariosString.removeAcentos((String)elem.getConteudo(this.colunaFiltro));
                if (item.toUpperCase().startsWith(upperFiltro)) {
                    itemSelecionado = i;
                    break;
                }
                ++i;
            }
            return itemSelecionado;
        }
    }
}

