/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.editors.PPGDRadioButton;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.LogicoDefault;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.OpcaoLogico;

public class JEditLogico
extends JEditCampo {
    private Box box;
    private ButtonGroup group;
    private int orientacaoTexto;
    private static final Color DEFAULT_FOREGROUND = new JRadioButton().getForeground();
    private static final Color DISABLED_FOREGROUND = ConstantesGlobaisGUI.COR_CINZA_CLARO;
    private boolean bloqueiaItemListener = false;
    private Map radios;
    private LinkedList listaOrdenada = new LinkedList();

    public JEditLogico() {
        this((Informacao)new LogicoDefault());
    }

    public JEditLogico(Informacao campo) {
        super(campo);
        this.setOrientacaoTexto(1);
    }

    public void setFont(Font pFont) {
        Iterator itOpcoes = this.radios.values().iterator();
        while (itOpcoes.hasNext()) {
            JRadioButton radio = (JRadioButton)itOpcoes.next();
            radio.setFont(pFont);
        }
    }

    public void setForeground(Color pCor) {
        Iterator itOpcoes = this.radios.values().iterator();
        while (itOpcoes.hasNext()) {
            JRadioButton radio = (JRadioButton)itOpcoes.next();
            radio.setForeground(pCor);
        }
    }

    public void setFont(String pValOpcao, Color pCor) {
        String lblOpcao = ((Logico)this.getInformacao()).getLabelOpcao(pValOpcao);
        if (this.radios.containsKey(lblOpcao)) {
            JRadioButton radio = (JRadioButton)this.radios.get(lblOpcao);
            radio.setForeground(pCor);
        }
    }

    public void setFont(String pValOpcao, Font pFont) {
        String lblOpcao = ((Logico)this.getInformacao()).getLabelOpcao(pValOpcao);
        if (this.radios.containsKey(lblOpcao)) {
            JRadioButton radio = (JRadioButton)this.radios.get(lblOpcao);
            radio.setFont(pFont);
        }
    }

    public void addListener(String pValOpcao, EventListener listener) {
        String lblOpcao = ((Logico)this.getInformacao()).getLabelOpcao(pValOpcao);
        if (this.radios.containsKey(lblOpcao)) {
            JRadioButton radio = (JRadioButton)this.radios.get(lblOpcao);
            this.adicionaListener(radio, listener);
        }
    }

    private void adicionaListener(JRadioButton radio, EventListener listener) {
        if (listener instanceof ActionListener) {
            radio.addActionListener((ActionListener)listener);
        } else if (listener instanceof ItemListener) {
            radio.addItemListener((ItemListener)listener);
        } else if (listener instanceof KeyListener) {
            radio.addKeyListener((KeyListener)listener);
        } else if (listener instanceof FocusListener) {
            radio.addFocusListener((FocusListener)listener);
        } else if (listener instanceof MouseListener) {
            radio.addMouseListener((MouseListener)listener);
        } else if (listener instanceof MouseMotionListener) {
            radio.addMouseMotionListener((MouseMotionListener)listener);
        }
    }

    public void addListener(EventListener listener) {
        Iterator itOpcoes = this.radios.values().iterator();
        while (itOpcoes.hasNext()) {
            JRadioButton radio = (JRadioButton)itOpcoes.next();
            this.adicionaListener(radio, listener);
        }
    }

    public int getOrientacaoTexto() {
        return this.orientacaoTexto;
    }

    public void setOrientacaoTexto(int orientacaoTexto) {
        this.orientacaoTexto = orientacaoTexto;
        this.buildComponente();
    }

    public void setOpcaoHabilitada(String pValOpcao, boolean pOpt) {
        String lblOpcao = ((Logico)this.getInformacao()).getLabelOpcao(pValOpcao);
        if (this.radios.containsKey(lblOpcao)) {
            JRadioButton radio = (JRadioButton)this.radios.get(lblOpcao);
            radio.setEnabled(pOpt);
            if (!pOpt) {
                radio.setForeground(DISABLED_FOREGROUND);
            } else {
                radio.setForeground(DEFAULT_FOREGROUND);
            }
        }
    }

    public JComponent getComponenteEditor() {
        return this.box;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.setObservadorAtivo(false);
        if ((evt.getPropertyName() == null || !evt.getPropertyName().equals("ReadOnly")) && evt.getNewValue() instanceof String) {
            String novoValor = (String)evt.getNewValue();
            if (novoValor == null) {
                novoValor = "";
            }
            if (novoValor.equals("")) {
                this.group.setSelected(new JRadioButton().getModel(), true);
            } else {
                String labelNovoValor = ((Logico)this.getInformacao()).getLabelOpcao(novoValor);
                Iterator it = this.radios.values().iterator();
                while (it.hasNext()) {
                    JRadioButton rb = (JRadioButton)it.next();
                    if (rb.getText().equals(labelNovoValor)) {
                        this.setBloqueiaItemListener(true);
                        rb.setSelected(true);
                        this.setBloqueiaItemListener(false);
                        continue;
                    }
                    this.setBloqueiaItemListener(true);
                    rb.setSelected(false);
                    this.setBloqueiaItemListener(false);
                }
            }
        }
        this.setObservadorAtivo(true);
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        Iterator it = this.radios.values().iterator();
        while (it.hasNext()) {
            JRadioButton rb = (JRadioButton)it.next();
            rb.setEnabled(!readOnly);
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        Iterator it = this.radios.values().iterator();
        while (it.hasNext()) {
            JRadioButton rb = (JRadioButton)it.next();
            rb.setEnabled(habilitado);
        }
    }

    public JComponent getComponenteFoco() {
        if (this.radios.values().size() > 0) {
            return (JRadioButton)this.radios.values().toArray()[0];
        }
        return this.getComponenteEditor();
    }

    public Map getRadios() {
        return this.radios;
    }

    public void setRadios(Map radios) {
        this.radios = radios;
    }

    public LinkedList getListaRadiosOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isBloqueiaItemListener() {
        return this.bloqueiaItemListener;
    }

    public void setBloqueiaItemListener(boolean bloqueiaItemListener) {
        this.bloqueiaItemListener = bloqueiaItemListener;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.radios = new Hashtable();
        this.listaOrdenada = new LinkedList();
        this.box = new Box(this.getOrientacaoTexto());
        Logico logico = (Logico)this.getInformacao();
        this.group = new ButtonGroup();
        if (logico != null) {
            Iterator itOpcoes = logico.getListaOrdenada().iterator();
            while (itOpcoes.hasNext()) {
                OpcaoLogico opt = (OpcaoLogico)itOpcoes.next();
                PPGDRadioButton rb = new PPGDRadioButton(opt.labelOpcao, opt.selecionado);
                rb.setInformacao(this.campo);
                rb.setVisible(true);
                this.radios.put(rb.getText(), rb);
                this.listaOrdenada.addLast(rb);
                rb.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        if (e.getOppositeComponent() == null) {
                            return;
                        }
                        JEditLogico.this.setIdentificacaoFoco(false);
                        JEditLogico.this.chamaValidacao();
                    }
                });
                rb.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1 && !JEditLogico.this.isBloqueiaItemListener()) {
                            System.out.println("id evento->" + e.getID());
                            JRadioButton r = (JRadioButton)e.getSource();
                            String labelOpcao = r.getText().trim();
                            String valorOpcao = ((Logico)JEditLogico.this.getInformacao()).getValorOpcao(labelOpcao);
                            ((Logico)JEditLogico.this.getInformacao()).atualizaListaValidadoresImpeditivos(valorOpcao);
                            if (!JEditLogico.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !JEditLogico.this.verificaValidacoesImpeditivas(valorOpcao)) {
                                return;
                            }
                            ((Logico)JEditLogico.this.getInformacao()).setConteudo(valorOpcao);
                        }
                    }
                });
                if (this.getOrientacaoTexto() == 0) {
                    this.box.add(new JLabel(" "));
                }
                this.box.add((Component)rb);
                if (!((Logico)this.campo).isSelecaoMultipla()) {
                    this.group.add((AbstractButton)rb);
                }
                if (itOpcoes.hasNext() || this.getOrientacaoTexto() != 0) continue;
                this.box.add(new JLabel(" "));
            }
            this.setObservadorAtivo(false);
            PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, this.getInformacao().asString());
            this.implementacaoPropertyChange(evt);
            this.setObservadorAtivo(true);
        }
        this.add((Component)this.box, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    protected void informacaoModificada() {
        this.buildComponente();
    }

    public void setEstiloFonte(int estilo) {
        JRadioButton radio = null;
        radio = !this.radios.isEmpty() ? (JRadioButton)this.radios.values().toArray()[0] : new JRadioButton();
        Font f = radio.getFont();
        f = f.deriveFont(estilo);
        this.setFont(f);
    }

    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        JRadioButton radio = null;
        radio = !this.radios.isEmpty() ? (JRadioButton)this.radios.values().toArray()[0] : new JRadioButton();
        Font f = radio.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.setFont(f);
    }

    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }
}

