/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;

public class LineDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintLine line = (JRPrintLine)element;
        grx.setColor(line.getLinePen().getLineColor());
        Stroke stroke = LineDrawer.getBorderStroke(line.getLinePen());
        if (stroke != null) {
            grx.setStroke(stroke);
            if (line.getWidth() == 1) {
                if (line.getHeight() != 1) {
                    grx.translate(0.5, 0.0);
                    grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX, line.getY() + offsetY + line.getHeight());
                    grx.translate(-0.5, 0.0);
                }
            } else if (line.getHeight() == 1) {
                grx.translate(0.0, 0.5);
                grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX + line.getWidth(), line.getY() + offsetY);
                grx.translate(0.0, -0.5);
            } else if (line.getDirection() == 1) {
                grx.drawLine(line.getX() + offsetX, line.getY() + offsetY, line.getX() + offsetX + line.getWidth(), line.getY() + offsetY + line.getHeight());
            } else {
                grx.drawLine(line.getX() + offsetX, line.getY() + offsetY + line.getHeight(), line.getX() + offsetX + line.getWidth(), line.getY() + offsetY);
            }
        }
    }
}

