/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.data.JRJpaDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRJpaQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$query$JRJpaQueryExecuter == null ? (class$net$sf$jasperreports$engine$query$JRJpaQueryExecuter = JRJpaQueryExecuter.class$("net.sf.jasperreports.engine.query.JRJpaQueryExecuter")) : class$net$sf$jasperreports$engine$query$JRJpaQueryExecuter));
    private final Integer reportMaxCount;
    private EntityManager em = (EntityManager)this.getParameterValue("JPA_ENTITY_MANAGER");
    private Query query;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$query$JRJpaQueryExecuter;

    public JRJpaQueryExecuter(JRDataset dataset, Map parameters) {
        super(dataset, parameters);
        this.reportMaxCount = (Integer)this.getParameterValue("REPORT_MAX_COUNT");
        if (this.em == null) {
            log.warn((Object)"The supplied javax.persistence.EntityManager object is null.");
        }
        this.parseQuery();
    }

    public JRDataSource createDatasource() throws JRException {
        JRDataSource datasource = null;
        String queryString = this.getQueryString();
        if (this.em != null && queryString != null && queryString.trim().length() > 0) {
            this.createQuery(queryString);
            datasource = this.createResultDatasource();
        }
        return datasource;
    }

    protected synchronized void createQuery(String queryString) {
        Map queryHintsMap;
        if (log.isDebugEnabled()) {
            log.debug((Object)("EJBQL query: " + queryString));
        }
        this.query = this.em.createQuery(queryString);
        List parameterNames = this.getCollectedParameterNames();
        if (!parameterNames.isEmpty()) {
            HashSet<String> namesSet = new HashSet<String>();
            Iterator iter = parameterNames.iterator();
            while (iter.hasNext()) {
                String parameterName = (String)iter.next();
                if (!namesSet.add(parameterName)) continue;
                JRValueParameter parameter = this.getValueParameter(parameterName);
                String ejbParamName = this.getEjbqlParameterName(parameterName);
                Object paramValue = parameter.getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parameter " + ejbParamName + ": " + paramValue));
                }
                this.query.setParameter(ejbParamName, paramValue);
            }
        }
        if ((queryHintsMap = (Map)this.getParameterValue("JPA_QUERY_HINTS_MAP")) != null) {
            Iterator i = queryHintsMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry pairs = i.next();
                log.debug((Object)("EJBQL query hint [" + pairs.getKey() + "] set."));
                this.query.setHint((String)pairs.getKey(), pairs.getValue());
            }
        }
        List properties = JRProperties.getProperties(this.dataset, "net.sf.jasperreports.ejbql.query.hint.");
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            JRProperties.PropertySuffix property = (JRProperties.PropertySuffix)it.next();
            String queryHint = property.getSuffix();
            if (queryHint.length() <= 0) continue;
            String value = property.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("EJBQL query hint [" + queryHint + "] set to: " + value));
            }
            this.query.setHint(queryHint, (Object)property);
        }
    }

    protected JRDataSource createResultDatasource() {
        JRJpaDataSource resDatasource;
        try {
            int pageSize = JRProperties.getIntegerProperty(this.dataset, "net.sf.jasperreports.ejbql.query.page.size", 0);
            resDatasource = new JRJpaDataSource(this, pageSize);
        }
        catch (NumberFormatException e) {
            throw new JRRuntimeException("The net.sf.jasperreports.ejbql.query.page.size property must be numerical.");
        }
        return resDatasource;
    }

    public synchronized void close() {
        this.query = null;
    }

    public synchronized boolean cancelQuery() throws JRException {
        return false;
    }

    protected String getParameterReplacement(String parameterName) {
        return ':' + this.getEjbqlParameterName(parameterName);
    }

    protected String getEjbqlParameterName(String parameterName) {
        return JRStringUtil.getLiteral(parameterName);
    }

    public List getResultList() {
        if (this.reportMaxCount != null) {
            this.query.setMaxResults(this.reportMaxCount.intValue());
        }
        return this.query.getResultList();
    }

    public List getResultList(int firstIndex, int resultCount) {
        if (this.reportMaxCount != null && firstIndex + resultCount > this.reportMaxCount) {
            resultCount = this.reportMaxCount - firstIndex;
        }
        this.query.setFirstResult(firstIndex);
        this.query.setMaxResults(resultCount);
        return this.query.getResultList();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

