/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRPrintSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_JRPRINT = ".jrprint";
    public static final JRPrintSaveContributor INSTANCE = new JRPrintSaveContributor();

    public static JRPrintSaveContributor getInstance() {
        return INSTANCE;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_JRPRINT);
    }

    public String getDescription() {
        return "JasperReports (*.jrprint)";
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_JRPRINT)) {
            file = new File(file.getAbsolutePath() + EXTENSION_JRPRINT);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("file.exists"), file.getName()), ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save"), 2)) {
            JRSaver.saveObject((Object)jasperPrint, file);
        }
    }
}

