/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import serpro.ppgd.gui.CustomRenderer;

public class ComboFileRoots
extends JComboBox {
    private Color selectedForeGround = this.getForeground();
    public static ImageIcon iconeDisquete = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/disk.png"));
    private boolean bloqueiaActionListener = false;

    public ComboFileRoots() {
        this.adicionaFileRoots();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ComboFileRoots.this.bloqueiaActionListener) {
                    return;
                }
                File file = (File)ComboFileRoots.this.getSelectedItem();
                boolean acessivel = true;
                try {
                    acessivel = file.canRead();
                }
                catch (Exception ioe) {
                    acessivel = false;
                }
                if (acessivel) {
                    ComboFileRoots.this.selecionou(file);
                } else {
                    ComboFileRoots.this.selecionou(null);
                }
            }
        });
        this.setRenderer(new CustomRenderer(this));
    }

    public void atualizaRoots() {
        this.bloqueiaActionListener = true;
        this.removeAllItems();
        this.adicionaFileRoots();
        this.bloqueiaActionListener = false;
    }

    public boolean isBloqueiaActionListener() {
        return this.bloqueiaActionListener;
    }

    public void setBloqueiaActionListener(boolean bloqueiaActionListener) {
        this.bloqueiaActionListener = bloqueiaActionListener;
    }

    private void adicionaFileRoots() {
        boolean isWindows = System.getProperty("os.name").toUpperCase().indexOf("WIND") != -1;
        boolean isLinux = System.getProperty("os.name").toUpperCase().indexOf("LINUX") != -1;
        boolean isMac = System.getProperty("os.name").toUpperCase().indexOf("MAC") != -1;
        File[] fileRoots = File.listRoots();
        File fileHD = null;
        if (isWindows) {
            int i = 0;
            while (i < fileRoots.length) {
                boolean isHD;
                boolean bl = isHD = fileRoots[i].toString().toUpperCase().indexOf("C:") != -1;
                if (isWindows && isHD) {
                    fileHD = fileRoots[i];
                } else {
                    this.addItem(fileRoots[i]);
                }
                ++i;
            }
            if (fileHD != null) {
                ((DefaultComboBoxModel)this.getModel()).insertElementAt(fileHD, 0);
                this.getModel().setSelectedItem(fileHD);
            }
        } else {
            this.addItem(new File(System.getProperty("user.home")));
            this.addItem(new File("/"));
        }
    }

    public void atualizaCombo() {
        this.bloqueiaActionListener = true;
        this.removeAllItems();
        this.adicionaFileRoots();
        this.bloqueiaActionListener = false;
    }

    protected void selecionou(File pFile) {
    }

    public Color getSelectedForeGround() {
        return this.selectedForeGround;
    }

    public void setSelectedForeGround(Color selectedForeGround) {
        this.selectedForeGround = selectedForeGround;
    }
}

