/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileSystemView;
import serpro.ppgd.gui.ComboFileRoots;

class CustomRenderer
extends JPanel
implements ListCellRenderer {
    private JComboBox cmb = null;

    public CustomRenderer(JComboBox pCmb) {
        FlowLayout flow = new FlowLayout(3, 0, 0);
        super.setLayout(flow);
        this.cmb = pCmb;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean isFloppy;
        super.removeAll();
        list.setBackground(this.cmb.getBackground());
        list.setForeground(this.cmb.getForeground());
        File file = (File)value;
        JLabel label = new JLabel(" " + file.toString());
        boolean isWindows = System.getProperty("os.name").toUpperCase().indexOf("WIND") != -1;
        boolean bl = isFloppy = file.toString().toUpperCase().indexOf("A:") != -1;
        if (isWindows && isFloppy) {
            label.setIcon(ComboFileRoots.iconeDisquete);
            label.setText(file.toString());
        } else {
            try {
                label.setIcon(FileSystemView.getFileSystemView().getSystemIcon(file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        label.setFont(this.cmb.getFont());
        if (isSelected) {
            label.setBackground(list.getSelectionBackground());
            label.setForeground(list.getSelectionForeground());
        } else {
            label.setBackground(list.getBackground());
            label.setForeground(list.getForeground());
        }
        this.add(label);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }
}

