/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import serpro.ppgd.gui.DialogGenerico;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public abstract class PaginadorTabela
extends JPanel
implements ActionListener {
    protected JButton btnPrimeiro = new JButton(new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/imagens/pag-primeiro.png")));
    protected JButton btnAnterior = new JButton(new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/imagens/pag-anterior.png")));
    protected JButton btnProximo = new JButton(new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/imagens/pag-proximo.png")));
    protected JButton btnUltimo = new JButton(new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/imagens/pag-ultimo.png")));
    protected JToolBar toolbar = new JToolBar();
    protected JFormattedTextField txtPagina = new JFormattedTextField();
    protected int indice = 1;

    public PaginadorTabela() {
        this.setLayout((LayoutManager)new FormLayout("2dlu,P,2dlu,MIN(P;25dlu),2dlu", "P"));
        this.btnPrimeiro.setContentAreaFilled(false);
        this.btnAnterior.setContentAreaFilled(false);
        this.btnProximo.setContentAreaFilled(false);
        this.btnUltimo.setContentAreaFilled(false);
        this.btnPrimeiro.setBorderPainted(false);
        this.btnAnterior.setBorderPainted(false);
        this.btnProximo.setBorderPainted(false);
        this.btnUltimo.setBorderPainted(false);
        this.btnPrimeiro.setOpaque(false);
        this.btnAnterior.setOpaque(false);
        this.btnProximo.setOpaque(false);
        this.btnUltimo.setOpaque(false);
        this.toolbar.setOpaque(false);
        this.toolbar.add(this.btnPrimeiro);
        this.toolbar.add(this.btnAnterior);
        this.toolbar.add(this.btnProximo);
        this.toolbar.add(this.btnUltimo);
        this.toolbar.setFloatable(false);
        try {
            this.txtPagina.setColumns(4);
            MaskFormatter formatador = new MaskFormatter("****");
            formatador.setValidCharacters("0123456789 ");
            this.txtPagina.setFormatterFactory(new DefaultFormatterFactory(formatador));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.txtPagina.addActionListener(this);
        this.btnPrimeiro.addActionListener(this);
        this.btnAnterior.addActionListener(this);
        this.btnProximo.addActionListener(this);
        this.btnUltimo.addActionListener(this);
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.toolbar, cc.xy(2, 1));
        this.add((Component)this.txtPagina, cc.xy(4, 1));
        this.setOpaque(false);
        this.btnPrimeiro.doClick();
    }

    public JButton getBtnAnterior() {
        return this.btnAnterior;
    }

    public JButton getBtnPrimeiro() {
        return this.btnPrimeiro;
    }

    public JButton getBtnProximo() {
        return this.btnProximo;
    }

    public JButton getBtnUltimo() {
        return this.btnUltimo;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public static void main(String[] args) {
        new DialogGenerico(null, new PaginadorTabela(){

            public int getTotalPaginas() {
                return 6;
            }

            public void exibe(int pagina) {
            }
        }, "Teste");
    }

    public void actionPerformed(ActionEvent e) {
        int paginaDigitada;
        int totalPaginas = this.getTotalPaginas();
        if (e.getSource().equals(this.btnPrimeiro)) {
            this.indice = 1;
        } else if (e.getSource().equals(this.btnAnterior)) {
            --this.indice;
        } else if (e.getSource().equals(this.btnProximo)) {
            ++this.indice;
        } else if (e.getSource().equals(this.btnUltimo)) {
            this.indice = totalPaginas;
        } else if (e.getSource().equals(this.txtPagina) && !this.txtPagina.getText().trim().equals("") && (paginaDigitada = Integer.parseInt(this.txtPagina.getText().trim())) >= 1 && paginaDigitada <= totalPaginas) {
            this.indice = paginaDigitada;
        }
        this.txtPagina.setText(String.valueOf(this.indice));
        this.atualizaBotoes(totalPaginas);
        this.exibe(this.indice);
    }

    protected void atualizaBotoes(int totalPaginas) {
        this.btnPrimeiro.setEnabled(true);
        this.btnAnterior.setEnabled(true);
        this.btnProximo.setEnabled(true);
        this.btnUltimo.setEnabled(true);
        if (totalPaginas == 0 || totalPaginas == 1) {
            this.btnPrimeiro.setEnabled(false);
            this.btnAnterior.setEnabled(false);
            this.btnProximo.setEnabled(false);
            this.btnUltimo.setEnabled(false);
        } else if (this.indice == 1) {
            this.btnPrimeiro.setEnabled(false);
            this.btnAnterior.setEnabled(false);
            this.btnProximo.setEnabled(true);
            this.btnUltimo.setEnabled(true);
        } else if (this.indice == totalPaginas) {
            this.btnPrimeiro.setEnabled(true);
            this.btnAnterior.setEnabled(true);
            this.btnProximo.setEnabled(false);
            this.btnUltimo.setEnabled(false);
        } else {
            this.btnPrimeiro.setEnabled(true);
            this.btnAnterior.setEnabled(true);
            this.btnProximo.setEnabled(true);
            this.btnUltimo.setEnabled(true);
        }
    }

    public void setIndice(int pIndice) {
        int totalPaginas = this.getTotalPaginas();
        if (pIndice >= 1 && pIndice <= totalPaginas) {
            this.indice = pIndice;
            this.txtPagina.setText(String.valueOf(this.indice));
            this.atualizaBotoes(totalPaginas);
            this.exibe(this.indice);
        }
    }

    public abstract void exibe(int var1);

    public abstract int getTotalPaginas();
}

