/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class PainelSelecaoPasta
extends JPanel {
    public static final int TIPO_LOCALIZACAO_DIALOGO = 0;
    public static final int TIPO_LOCALIZACAO_EMBUTIDO = 1;
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "SelectedFileChangedProperty";
    private File pastaSelecionada = null;
    private JPanel pSelecao = null;
    private JPanel pTipoPasta = null;
    private JRadioButton rbPadrao = null;
    private JRadioButton rbOutraPasta = null;
    private JFileChooser fileChooser = null;
    private ButtonGroup bgTipo = new ButtonGroup();
    private File pastaPadrao = null;
    private JPanel pCentro = null;
    private JLabel lRotuloPastaSel = null;
    private JTextField edPastaSelecionada = null;
    private int tipoLocalizacaoPasta = 1;
    private boolean selecionandoPasta = false;

    public PainelSelecaoPasta() {
        this.initialize();
        this.bgTipo.add(this.rbPadrao);
        this.bgTipo.add(this.rbOutraPasta);
        this.setTipoLocalizacaoPasta(1);
        ActionListener clickTipo = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PainelSelecaoPasta.this.pSelecao.setVisible(e.getSource() == PainelSelecaoPasta.this.rbOutraPasta);
                if (e.getSource() == PainelSelecaoPasta.this.rbPadrao) {
                    PainelSelecaoPasta.this.setPastaSelecionada(PainelSelecaoPasta.this.pastaPadrao);
                } else if (e.getSource() == PainelSelecaoPasta.this.rbOutraPasta) {
                    File f = PainelSelecaoPasta.this.fileChooser.getSelectedFile();
                    if (f == null) {
                        f = PainelSelecaoPasta.this.fileChooser.getCurrentDirectory();
                    }
                    PainelSelecaoPasta.this.setPastaSelecionada(f);
                }
            }
        };
        this.rbPadrao.addActionListener(clickTipo);
        this.rbOutraPasta.addActionListener(clickTipo);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (PainelSelecaoPasta.this.selecionandoPasta) {
                    return;
                }
                if (PainelSelecaoPasta.SELECTED_FILE_CHANGED_PROPERTY.equals(evt.getPropertyName()) || "directoryChanged".equals(evt.getPropertyName())) {
                    File newFile = (File)evt.getNewValue();
                    PainelSelecaoPasta.this.setPastaSelecionada(newFile);
                }
            }
        });
    }

    public int getTipoLocalizacaoPasta() {
        return this.tipoLocalizacaoPasta;
    }

    public void setTipoLocalizacaoPasta(int tipoLocalizacaoPasta) {
        this.tipoLocalizacaoPasta = tipoLocalizacaoPasta;
        this.pCentro.setVisible(this.tipoLocalizacaoPasta == 1);
        if (this.tipoLocalizacaoPasta == 0) {
            this.fileChooser.setBorder(null);
            this.fileChooser.setControlButtonsAreShown(true);
        } else {
            this.fileChooser.setBorder(BorderFactory.createTitledBorder(null, "Indique a pasta:", 0, 0, new Font("Dialog", 1, 12), new Color(10, 36, 106)));
            this.fileChooser.setControlButtonsAreShown(false);
        }
        this.selecionandoPasta = false;
    }

    private void setPastaSelecionada(File pasta) {
        this.edPastaSelecionada.setText(pasta == null ? "nenhuma" : pasta.getPath());
        this.firePropertyChange(SELECTED_FILE_CHANGED_PROPERTY, this.pastaSelecionada, pasta);
        this.pastaSelecionada = pasta;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void rbOutraPastaClick() {
        if (this.tipoLocalizacaoPasta != 0) return;
        this.selecionandoPasta = true;
        try {
            if (this.fileChooser.showDialog(this, "Seleciona") != 0) {
                this.rbPadrao.setSelected(true);
                this.rbPadrao.doClick();
            } else {
                this.selecionandoPasta = false;
                this.setPastaSelecionada(this.fileChooser.getSelectedFile());
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.selecionandoPasta = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.selecionandoPasta = false;
            return;
        }
    }

    public void setPasta(File pasta) {
        if (pasta == null) {
            this.rbPadrao.setSelected(false);
            this.rbOutraPasta.setSelected(false);
        } else if (pasta.equals(this.getPastaPadrao())) {
            this.selecionaOpcaoPastaPadrao(true);
        } else {
            this.rbOutraPasta.setSelected(true);
            this.fileChooser.setSelectedFile(pasta);
            this.setPastaSelecionada(pasta);
        }
    }

    public void setPastaPadrao(File pastaPadrao, String descricaoItem) {
        this.pastaPadrao = pastaPadrao;
        this.rbPadrao.setText("<html>" + descricaoItem + "</html>");
        if (this.rbPadrao.isSelected()) {
            this.rbPadrao.doClick();
        }
    }

    public File getPastaPadrao() {
        return this.pastaPadrao;
    }

    public void selecionaOpcaoPastaPadrao(boolean selecionar) {
        JRadioButton r = selecionar ? this.rbPadrao : this.rbOutraPasta;
        r.setSelected(true);
        r.doClick();
    }

    public void selecionaNenhumaOpcao() {
        this.rbOutraPasta.setSelected(false);
        this.rbPadrao.setSelected(false);
        this.rbOutraPasta.doClick();
    }

    public File getPastaSelecionada() {
        return this.pastaSelecionada;
    }

    public boolean pastaSelecionadaExiste() {
        File pasta = this.getPastaSelecionada();
        return pasta != null && pasta.exists();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(542, 316);
        this.add((Component)this.getPTipoPasta(), "North");
        this.add((Component)this.getPCentro(), "Center");
    }

    private JPanel getPSelecao() {
        if (this.pSelecao == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(0);
            borderLayout.setVgap(0);
            this.pSelecao = new JPanel();
            this.pSelecao.setLayout(borderLayout);
            this.pSelecao.add((Component)this.getFileChooser(), "Center");
        }
        return this.pSelecao;
    }

    private JPanel getPTipoPasta() {
        if (this.pTipoPasta == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.insets = new Insets(5, 10, 0, 3);
            gridBagConstraints3.gridy = 1;
            this.lRotuloPastaSel = new JLabel();
            this.lRotuloPastaSel.setText("Pasta Selecionada:");
            this.lRotuloPastaSel.setForeground(Color.blue);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(2, 5, 0, 0);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(2, 0, 0, 10);
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 0.4;
            gridBagConstraints1.gridx = 0;
            this.pTipoPasta = new JPanel();
            this.pTipoPasta.setLayout(new GridBagLayout());
            this.pTipoPasta.add((Component)this.getRbPadrao(), gridBagConstraints1);
            this.pTipoPasta.add((Component)this.getRbOutraPasta(), gridBagConstraints2);
            this.pTipoPasta.add((Component)this.lRotuloPastaSel, gridBagConstraints3);
            this.pTipoPasta.add((Component)this.getEdPastaSelecionada(), gridBagConstraints4);
        }
        return this.pTipoPasta;
    }

    private JRadioButton getRbPadrao() {
        if (this.rbPadrao == null) {
            this.rbPadrao = new JRadioButton();
            this.rbPadrao.setText("Pasta Padr\u00e3o");
            this.rbPadrao.setHorizontalAlignment(4);
            this.rbPadrao.setForeground(Color.blue);
        }
        return this.rbPadrao;
    }

    private JRadioButton getRbOutraPasta() {
        if (this.rbOutraPasta == null) {
            this.rbOutraPasta = new JRadioButton();
            this.rbOutraPasta.setText("Outra pasta");
            this.rbOutraPasta.setForeground(Color.blue);
            this.rbOutraPasta.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PainelSelecaoPasta.this.rbOutraPastaClick();
                }
            });
        }
        return this.rbOutraPasta;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileHidingEnabled(false);
            this.fileChooser.setAutoscrolls(true);
            this.fileChooser.setCursor(new Cursor(0));
            this.fileChooser.setDialogTitle("Selecione uma pasta");
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return true;
                }

                public String getDescription() {
                    return "Todos Arquivos";
                }
            });
        }
        return this.fileChooser;
    }

    private JPanel getPCentro() {
        if (this.pCentro == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(3, 8, 4, 4);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weighty = 1.0;
            this.pCentro = new JPanel();
            this.pCentro.setLayout(new GridBagLayout());
            this.pCentro.add((Component)this.getPSelecao(), gridBagConstraints);
        }
        return this.pCentro;
    }

    private JTextField getEdPastaSelecionada() {
        if (this.edPastaSelecionada == null) {
            this.edPastaSelecionada = new JTextField();
            this.edPastaSelecionada.setEditable(false);
            this.edPastaSelecionada.setBorder(null);
        }
        return this.edPastaSelecionada;
    }
}

