/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.table;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import serpro.ppgd.gui.table.ColumnGroup;
import serpro.ppgd.gui.table.GroupableTableHeaderUI;

public class GroupableTableHeader
extends JTableHeader {
    private static final String uiClassID = "GroupableTableHeaderUI";
    protected Vector columnGroups = null;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
    }

    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public Enumeration getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration en = this.columnGroups.elements();
        while (en.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)en.nextElement();
            Vector v_ret = cGroup.getColumnGroups(col, new Vector());
            if (v_ret == null) continue;
            return v_ret.elements();
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration en = this.columnGroups.elements();
        while (en.hasMoreElements()) {
            ColumnGroup cGroup = (ColumnGroup)en.nextElement();
            cGroup.setColumnMargin(columnMargin);
        }
    }
}

