/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.j2d;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.packrect.BackingStoreManager;
import com.sun.opengl.impl.packrect.Rect;
import com.sun.opengl.impl.packrect.RectVisitor;
import com.sun.opengl.impl.packrect.RectanglePacker;
import com.sun.opengl.util.FPSAnimator;
import com.sun.opengl.util.j2d.TextureRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class TextRenderer {
    private static final boolean DEBUG = Debug.debug("TextRenderer");
    private Font font;
    private boolean antialiased;
    private boolean useFractionalMetrics;
    private boolean mipmap;
    private RectanglePacker packer;
    private boolean haveMaxSize;
    private RenderDelegate renderDelegate;
    private TextureRenderer cachedBackingStore;
    private Graphics2D cachedGraphics;
    private FontRenderContext cachedFontRenderContext;
    private Map stringLocations = new HashMap();
    private boolean splitAtSpaces = false;
    private int spaceWidth = -1;
    private List tokenizationResults = new ArrayList();
    private static final int CYCLES_PER_FLUSH = 100;
    private int numRenderCycles;
    private static final float MAX_VERTICAL_FRAGMENTATION = 0.7f;
    private boolean inBeginEndPair;
    private boolean isOrthoMode;
    private int beginRenderingWidth;
    private int beginRenderingHeight;
    private boolean beginRenderingDepthTestDisabled;
    private boolean haveCachedColor;
    private float cachedR;
    private float cachedG;
    private float cachedB;
    private float cachedA;
    private Color cachedColor;
    private boolean needToResetColor;
    private Frame dbgFrame;
    private boolean debugged;

    public TextRenderer(Font font) {
        this(font, false, false, null, false);
    }

    public TextRenderer(Font font, boolean bl) {
        this(font, false, false, null, bl);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2) {
        this(font, bl, bl2, null, false);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2, RenderDelegate renderDelegate) {
        this(font, bl, bl2, renderDelegate, false);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2, RenderDelegate renderDelegate, boolean bl3) {
        this.font = font;
        this.antialiased = bl;
        this.useFractionalMetrics = bl2;
        this.mipmap = bl3;
        this.packer = new RectanglePacker(new Manager(), 256, 256);
        if (renderDelegate == null) {
            renderDelegate = new DefaultRenderDelegate();
        }
        this.renderDelegate = renderDelegate;
    }

    public Rectangle2D getBounds(String string) {
        Rect rect = null;
        rect = (Rect)this.stringLocations.get(string);
        if (rect != null) {
            TextData textData = (TextData)rect.getUserData();
            return new Rectangle2D.Double(-textData.origin().x, -textData.origin().y, rect.w(), rect.h());
        }
        return TextRenderer.normalize(this.renderDelegate.getBounds(string, this.font, this.getFontRenderContext()));
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        if (this.cachedFontRenderContext == null) {
            this.cachedFontRenderContext = this.getGraphics2D().getFontRenderContext();
        }
        return this.cachedFontRenderContext;
    }

    public void beginRendering(int n, int n2) throws GLException {
        this.beginRendering(n, n2, true);
    }

    public void beginRendering(int n, int n2, boolean bl) throws GLException {
        this.beginRendering(true, n, n2, bl);
    }

    public void begin3DRendering() throws GLException {
        this.beginRendering(false, 0, 0, false);
    }

    public void setColor(Color color) throws GLException {
        this.getBackingStore().setColor(color);
        this.haveCachedColor = true;
        this.cachedColor = color;
    }

    public void setColor(float f, float f2, float f3, float f4) throws GLException {
        this.getBackingStore().setColor(f, f2, f3, f4);
        this.haveCachedColor = true;
        this.cachedR = f;
        this.cachedG = f2;
        this.cachedB = f3;
        this.cachedA = f4;
        this.cachedColor = null;
    }

    public void draw(String string, int n, int n2) throws GLException {
        this.draw3D(string, n, n2, 0.0f, 1.0f);
    }

    public void draw3D(String string, float f, float f2, float f3, float f4) {
        this.tokenize(string);
        int n = 0;
        Iterator iterator = this.tokenizationResults.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 != null) {
                Object object;
                Object object2;
                Rect rect = (Rect)this.stringLocations.get(string2);
                if (rect == null) {
                    object2 = this.getGraphics2D();
                    object = TextRenderer.normalize(this.renderDelegate.getBounds(string2, this.font, this.getFontRenderContext()));
                    Point point = new Point((int)(-((RectangularShape)object).getMinX()), (int)(-((RectangularShape)object).getMinY()));
                    rect = new Rect(0, 0, (int)((RectangularShape)object).getWidth(), (int)((RectangularShape)object).getHeight(), new TextData(string2, point));
                    this.packer.add(rect);
                    this.stringLocations.put(string2, rect);
                    object2 = this.getGraphics2D();
                    int n2 = rect.x() + point.x;
                    int n3 = rect.y() + point.y;
                    Composite composite = ((Graphics2D)object2).getComposite();
                    ((Graphics2D)object2).setComposite(AlphaComposite.Clear);
                    ((Graphics)object2).fillRect(rect.x(), rect.y(), rect.w(), rect.h());
                    ((Graphics2D)object2).setComposite(composite);
                    this.renderDelegate.draw((Graphics2D)object2, string2, n2, n3);
                    this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
                }
                object2 = this.getBackingStore();
                object = (TextData)rect.getUserData();
                ((TextData)object).markUsed();
                ((TextureRenderer)object2).draw3DRect(f + (float)n - f4 * (float)((TextData)object).origin().x, f2 - f4 * (float)(rect.h() - ((TextData)object).origin().y), f3, rect.x(), ((TextureRenderer)object2).getHeight() - rect.y() - rect.h(), rect.w(), rect.h(), f4);
                n = (int)((float)n + (float)rect.w() * f4);
            }
            n = (int)((float)n + (float)this.getSpaceWidth() * f4);
        }
    }

    public void endRendering() throws GLException {
        this.endRendering(true);
    }

    private int getSpaceWidth() {
        if (this.spaceWidth < 0) {
            Graphics2D graphics2D = this.getGraphics2D();
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, " ");
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
            this.spaceWidth = (int)glyphMetrics.getAdvanceX();
        }
        return this.spaceWidth;
    }

    public void end3DRendering() throws GLException {
        this.endRendering(false);
    }

    public void dispose() throws GLException {
        this.packer.dispose();
        this.packer = null;
        this.cachedBackingStore = null;
        this.cachedGraphics = null;
        this.cachedFontRenderContext = null;
        if (this.dbgFrame != null) {
            this.dbgFrame.dispose();
        }
    }

    private static Rectangle2D normalize(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double((int)Math.floor(rectangle2D.getMinX() - 1.0), (int)Math.floor(rectangle2D.getMinY() - 1.0), (int)Math.ceil(rectangle2D.getWidth() + 2.0), (int)Math.ceil(rectangle2D.getHeight()) + 2);
    }

    private TextureRenderer getBackingStore() {
        TextureRenderer textureRenderer = (TextureRenderer)this.packer.getBackingStore();
        if (textureRenderer != this.cachedBackingStore) {
            if (this.cachedGraphics != null) {
                this.cachedGraphics.dispose();
                this.cachedGraphics = null;
                this.cachedFontRenderContext = null;
            }
            this.cachedBackingStore = textureRenderer;
        }
        return this.cachedBackingStore;
    }

    private Graphics2D getGraphics2D() {
        TextureRenderer textureRenderer = this.getBackingStore();
        if (this.cachedGraphics == null) {
            this.cachedGraphics = textureRenderer.createGraphics();
            this.cachedGraphics.setComposite(AlphaComposite.SrcOver);
            this.cachedGraphics.setColor(Color.WHITE);
            this.cachedGraphics.setFont(this.font);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialiased ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.useFractionalMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        return this.cachedGraphics;
    }

    private void beginRendering(boolean bl, int n, int n2, boolean bl2) {
        if (DEBUG && !this.debugged) {
            this.debug();
        }
        this.inBeginEndPair = true;
        this.isOrthoMode = bl;
        this.beginRenderingWidth = n;
        this.beginRenderingHeight = n2;
        this.beginRenderingDepthTestDisabled = bl2;
        if (bl) {
            this.getBackingStore().beginOrthoRendering(n, n2, bl2);
        } else {
            this.getBackingStore().begin3DRendering();
        }
        GL gL = GLU.getCurrentGL();
        if (!this.haveMaxSize) {
            int[] nArray = new int[1];
            gL.glGetIntegerv(3379, nArray, 0);
            this.packer.setMaxSize(nArray[0], nArray[0]);
            this.haveMaxSize = true;
        }
        if (this.needToResetColor && this.haveCachedColor) {
            if (this.cachedColor == null) {
                this.getBackingStore().setColor(this.cachedR, this.cachedG, this.cachedB, this.cachedA);
            } else {
                this.getBackingStore().setColor(this.cachedColor);
            }
            this.needToResetColor = false;
        }
        if (this.mipmap && !this.getBackingStore().isUsingAutoMipmapGeneration()) {
            if (DEBUG) {
                System.err.println("Disabled mipmapping in TextRenderer");
            }
            this.mipmap = false;
        }
    }

    private void endRendering(boolean bl) throws GLException {
        this.inBeginEndPair = false;
        if (bl) {
            this.getBackingStore().endOrthoRendering();
        } else {
            this.getBackingStore().end3DRendering();
        }
        if (++this.numRenderCycles >= 100) {
            this.numRenderCycles = 0;
            if (DEBUG) {
                System.err.println("Clearing unused entries in endRendering()");
            }
            this.clearUnusedEntries();
        }
    }

    private void tokenize(String string) {
        this.tokenizationResults.clear();
        if (!this.splitAtSpaces) {
            this.tokenizationResults.add(string);
        } else {
            int n = 0;
            boolean bl = false;
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(i) != ' ') continue;
                if (n < i) {
                    this.tokenizationResults.add(string.substring(n, i));
                } else {
                    this.tokenizationResults.add(null);
                }
                n = i + 1;
            }
            if (n == 0) {
                this.tokenizationResults.add(string);
            } else if (n < n2) {
                this.tokenizationResults.add(string.substring(n, n2));
            }
        }
    }

    private void clearUnusedEntries() {
        final ArrayList arrayList = new ArrayList();
        this.packer.visit(new RectVisitor(){

            public void visit(Rect rect) {
                TextData textData = (TextData)rect.getUserData();
                if (textData.used()) {
                    textData.clearUsed();
                } else {
                    arrayList.add(rect);
                }
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Rect rect = (Rect)iterator.next();
            this.packer.remove(rect);
            this.stringLocations.remove(((TextData)rect.getUserData()).string());
            if (!DEBUG) continue;
            Graphics2D graphics2D = this.getGraphics2D();
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
            graphics2D.setComposite(composite);
        }
        float f = this.packer.verticalFragmentationRatio();
        if (!arrayList.isEmpty() && f > 0.7f) {
            if (DEBUG) {
                System.err.println("Compacting TextRenderer backing store due to vertical fragmentation " + f);
            }
            this.packer.compact();
        }
        if (DEBUG) {
            this.getBackingStore().markDirty(0, 0, this.getBackingStore().getWidth(), this.getBackingStore().getHeight());
        }
    }

    private void debug() {
        this.dbgFrame = new Frame("TextRenderer Debug Output");
        GLCanvas gLCanvas = new GLCanvas(new GLCapabilities(), null, GLContext.getCurrent(), null);
        gLCanvas.addGLEventListener(new DebugListener(this.dbgFrame));
        this.dbgFrame.add(gLCanvas);
        final FPSAnimator fPSAnimator = new FPSAnimator(gLCanvas, 10);
        this.dbgFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        2.access$1800(this.this$1).stop();
                    }
                }).start();
            }

            static /* synthetic */ FPSAnimator access$1800(2 var0) {
                return var0.fPSAnimator;
            }
        });
        this.dbgFrame.setSize(256, 256);
        this.dbgFrame.setVisible(true);
        fPSAnimator.start();
        this.debugged = true;
    }

    class DebugListener
    implements GLEventListener {
        private GLU glu = new GLU();
        private Frame frame;

        DebugListener(Frame frame) {
            this.frame = frame;
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClear(16640);
            if (TextRenderer.this.packer == null) {
                return;
            }
            TextureRenderer textureRenderer = TextRenderer.this.getBackingStore();
            int n = textureRenderer.getWidth();
            int n2 = textureRenderer.getHeight();
            textureRenderer.beginOrthoRendering(n, n2);
            textureRenderer.drawOrthoRect(0, 0);
            textureRenderer.endOrthoRendering();
            if (this.frame.getWidth() != n || this.frame.getHeight() != n2) {
                EventQueue.invokeLater(new Runnable(this, n, n2){
                    private final /* synthetic */ int val$w;
                    private final /* synthetic */ int val$h;
                    private final /* synthetic */ DebugListener this$1;
                    {
                        this.this$1 = debugListener;
                        this.val$w = n;
                        this.val$h = n2;
                    }

                    public void run() {
                        DebugListener.access$2000(this.this$1).setSize(this.val$w, this.val$h);
                    }
                });
            }
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        static /* synthetic */ Frame access$2000(DebugListener debugListener) {
            return debugListener.frame;
        }
    }

    class DefaultRenderDelegate
    implements RenderDelegate {
        DefaultRenderDelegate() {
        }

        public boolean intensityOnly() {
            return true;
        }

        public Rectangle2D getBounds(String string, Font font, FontRenderContext fontRenderContext) {
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
            return glyphVector.getPixelBounds(fontRenderContext, 0.0f, 0.0f);
        }

        public void draw(Graphics2D graphics2D, String string, int n, int n2) {
            graphics2D.drawString(string, n, n2);
        }
    }

    class Manager
    implements BackingStoreManager {
        private Graphics2D g;

        Manager() {
        }

        public Object allocateBackingStore(int n, int n2) {
            TextureRenderer textureRenderer = TextRenderer.this.renderDelegate.intensityOnly() ? TextureRenderer.createAlphaOnlyRenderer(n, n2, TextRenderer.this.mipmap) : new TextureRenderer(n, n2, true, TextRenderer.this.mipmap);
            if (DEBUG) {
                System.err.println(" TextRenderer allocating backing store " + n + " x " + n2);
            }
            return textureRenderer;
        }

        public void deleteBackingStore(Object object) {
            ((TextureRenderer)object).dispose();
        }

        public boolean preExpand(Rect rect, int n) {
            if (n == 0) {
                if (DEBUG) {
                    System.err.println("Clearing unused entries in preExpand(): attempt number " + n);
                }
                TextRenderer.this.clearUnusedEntries();
                return true;
            }
            return false;
        }

        public void additionFailed(Rect rect, int n) {
            TextRenderer.this.packer.clear();
            TextRenderer.this.stringLocations.clear();
            if (DEBUG) {
                System.err.println(" *** Cleared all text because addition failed ***");
            }
        }

        public void beginMovement(Object object, Object object2) {
            if (TextRenderer.this.inBeginEndPair) {
                if (TextRenderer.this.isOrthoMode) {
                    ((TextureRenderer)object).endOrthoRendering();
                } else {
                    ((TextureRenderer)object).end3DRendering();
                }
            }
            TextureRenderer textureRenderer = (TextureRenderer)object2;
            this.g = textureRenderer.createGraphics();
            this.g.setComposite(AlphaComposite.Src);
        }

        public void move(Object object, Rect rect, Object object2, Rect rect2) {
            TextureRenderer textureRenderer = (TextureRenderer)object;
            TextureRenderer textureRenderer2 = (TextureRenderer)object2;
            if (textureRenderer == textureRenderer2) {
                this.g.copyArea(rect.x(), rect.y(), rect.w(), rect.h(), rect2.x() - rect.x(), rect2.y() - rect.y());
            } else {
                Image image = textureRenderer.getImage();
                this.g.drawImage(image, rect2.x(), rect2.y(), rect2.x() + rect2.w(), rect2.y() + rect2.h(), rect.x(), rect.y(), rect.x() + rect.w(), rect.y() + rect.h(), null);
            }
        }

        public void endMovement(Object object, Object object2) {
            this.g.dispose();
            TextureRenderer textureRenderer = (TextureRenderer)object2;
            textureRenderer.markDirty(0, 0, textureRenderer.getWidth(), textureRenderer.getHeight());
            if (TextRenderer.this.inBeginEndPair) {
                if (TextRenderer.this.isOrthoMode) {
                    ((TextureRenderer)object2).beginOrthoRendering(TextRenderer.this.beginRenderingWidth, TextRenderer.this.beginRenderingHeight, TextRenderer.this.beginRenderingDepthTestDisabled);
                } else {
                    ((TextureRenderer)object2).begin3DRendering();
                }
                if (TextRenderer.this.haveCachedColor) {
                    if (TextRenderer.this.cachedColor == null) {
                        ((TextureRenderer)object2).setColor(TextRenderer.this.cachedR, TextRenderer.this.cachedG, TextRenderer.this.cachedB, TextRenderer.this.cachedA);
                    } else {
                        ((TextureRenderer)object2).setColor(TextRenderer.this.cachedColor);
                    }
                }
            } else {
                TextRenderer.this.needToResetColor = true;
            }
        }
    }

    public static interface RenderDelegate {
        public boolean intensityOnly();

        public Rectangle2D getBounds(String var1, Font var2, FontRenderContext var3);

        public void draw(Graphics2D var1, String var2, int var3, int var4);
    }

    static class TextData {
        private String str;
        private Point origin;
        private boolean used;

        TextData(String string, Point point) {
            this.str = string;
            this.origin = point;
        }

        String string() {
            return this.str;
        }

        Point origin() {
            return this.origin;
        }

        boolean used() {
            return this.used;
        }

        void markUsed() {
            this.used = true;
        }

        void clearUsed() {
            this.used = false;
        }
    }
}

