/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOUSE. See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public License
 * along with this program; if not write to the Free Software
 * Foundation, inc., 59 Temple Place, Suite 330, Boston MA 02111-1307
 * USA
 */

package gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
/**
 * Insert the type's description here.
 *
 * @author: Yuriy Mikhaylovskiy
 */

public class Processor_Find extends JPanel {
  JTextArea text;
  GridLayout gridLayout1 = new GridLayout();
  JLabel jLabel1 = new JLabel();
  JTextField tFind = new JTextField();
  JButton jButton1 = new JButton();
  JLabel jLabel2 = new JLabel();
  JTextField tReplace = new JTextField();
  JButton jButton2 = new JButton();
  private JLabel lb_cmd = new JLabel();
  private JCheckBox cb_all = new JCheckBox();

  public Processor_Find(JTextArea t) {
    try {
      text=t;
      jbInit();
    } catch(Exception e) {  e.printStackTrace();  }
  }
  
  private void jbInit() throws Exception {
    jLabel1.setText("Text to find");
    gridLayout1.setRows(3);
    gridLayout1.setColumns(3);
    this.setLayout(gridLayout1);
    jButton1.setText("Find");
    jButton1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton1_actionPerformed(e);
      }
    });
    jLabel2.setText("Replace with");
    jButton2.setText("Replace");
    jButton2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton2_actionPerformed(e);
      }
    });
    cb_all.setText("Replace All");
    this.add(jLabel1, null);
    this.add(tFind, null);
    this.add(jButton1, null);
    this.add(jLabel2, null);
    this.add(tReplace, null);
    this.add(jButton2, null);
    this.add(lb_cmd, null);
    this.add(cb_all, null);

  }

  void jButton1_actionPerformed(ActionEvent e) {
    String f_st = tFind.getText();
    if(f_st.length()==0)return;
    boolean stop = false;
    int pos = text.getCaretPosition();
    text.grabFocus();
    try{
      while(pos!=text.getText().length() && !stop){
        text.setSelectionStart(pos);
        text.setSelectionEnd(pos+f_st.length());
        if(text.getSelectedText().equals(f_st)) stop=true;
        pos++;
      }
    }catch(Exception e1){}
  }

  void jButton2_actionPerformed(ActionEvent e) {
    String r_st = tReplace.getText();
    String f_st = tFind.getText();
    if(f_st.length()==0)return;
    text.grabFocus();
    try{
      if(cb_all.isSelected()){
        text.setSelectionStart(text.getCaretPosition());
        text.setSelectionEnd(text.getText().length());
        if(text.getSelectedText()!=null && text.getSelectedText().trim().length()!=0) text.replaceSelection(text.getSelectedText().replaceAll(f_st,r_st));
      }else{
        if(text.getSelectedText()!=null && text.getSelectedText().trim().length()!=0){
          if(!text.getSelectedText().equals(f_st))text.setCaretPosition(text.getSelectionStart());
          else  text.replaceSelection(tReplace.getText());
        }
        jButton1_actionPerformed(e);
      }
    }catch(Exception e1){}
  }
}