#####################################################################################
#
#  Copyright (c) Microsoft Corporation. All rights reserved.
#
#  This source code is subject to terms and conditions of the Shared Source License
#  for IronPython. A copy of the license can be found in the License.html file
#  at the root of this distribution. If you can not locate the Shared Source License
#  for IronPython, please send an email to ironpy@microsoft.com.
#  By using this source code in any fashion, you are agreeing to be bound by
#  the terms of the Shared Source License for IronPython.
#
#  You must not remove this notice, or any other, from this software.
#
######################################################################################

from lib.assert_util import *

x="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"

def test_string():
    Assert( x[10] == 'k')
    Assert( x[20] == 'u')
    Assert( x[30] == 'E')
    Assert( x[-10] == 'Q')
    Assert(x[-3] == 'X')
    Assert(x[14:20] == 'opqrst')
    Assert(x[20:14] == '')
    Assert(x[-30:-5] == 'wxyzABCDEFGHIJKLMNOPQRSTU')
    Assert(x[-5:-30] == '')
    Assert(x[3:40:2] == 'dfhjlnprtvxzBDFHJLN')
    Assert(x[40:3:2] == '')
    Assert(x[3:40:-2] == '')
    Assert(x[40:3:-2] == 'OMKIGECAywusqomkige')
    Assert(x[-40:-4:-2] == '')
    Assert(x[-4:-40:-2] == 'WUSQOMKIGECAywusqo')
    Assert(x[-40:-4:2] == 'moqsuwyACEGIKMOQSU')
    Assert(x[-4:-40:2] == '')
    Assert(x[-40:-5:-2] == '')
    Assert(x[-5:-40:-2] == 'VTRPNLJHFDBzxvtrpn')
    Assert(x[-40:-5:2] == 'moqsuwyACEGIKMOQSU')
    Assert(x[-5:-40:2] == '')
    Assert(x[-40:-6:-2] == '')
    Assert(x[-6:-40:-2] == 'USQOMKIGECAywusqo')
    Assert(x[-40:-6:2] == 'moqsuwyACEGIKMOQS')
    Assert(x[-6:-40:2] == '')
    Assert(x[-49:-5:-3] == '')
    Assert(x[-5:-49:-3] == 'VSPMJGDAxurolif')
    Assert(x[-49:-5:3] == 'dgjmpsvyBEHKNQT')
    Assert(x[-5:-49:3] == '')
    Assert(x[-50:-5:-3] == '')
    Assert(x[-5:-50:-3] == 'VSPMJGDAxurolif')
    Assert(x[-50:-5:3] == 'cfiloruxADGJMPS')
    Assert(x[-5:-50:3] == '')
    Assert(x[-51:-5:-3] == '')
    Assert(x[-5:-51:-3] == 'VSPMJGDAxurolifc')
    Assert(x[-51:-5:3] == 'behknqtwzCFILORU')
    Assert(x[-5:-51:3] == '')

def test_list_tuple():
    # check for good behaviour of slices on lists in general
    l=list(x)
    Assert( l[10] == 'k')
    Assert( l[20] == 'u')
    Assert( l[30] == 'E')
    Assert( l[-10] == 'Q')
    Assert(l[-3] == 'X')
    Assert(l[14:20] == list('opqrst'))
    Assert(l[20:14] == [])
    Assert(l[-51:-5:-3] == [])
    Assert(l[-5:-51:3] == [])

    Assert((1, 2, 3, 4, 5)[1:-1][::-1] == (4, 3, 2))
    Assert([1, 2, 3, 4, 5][1:-1][::-1] == [4, 3, 2])
    Assert((9, 7, 5, 3) == (1, 2, 3, 4, 5, 6, 7, 8, 9, 0)[1:-1][::-2])
    Assert([9, 7, 5, 3] == [1, 2, 3, 4, 5, 6, 7, 8, 9, 0][1:-1][::-2])
    Assert((2, 4, 6, 8) == (1, 2, 3, 4, 5, 6, 7, 8, 9, 0)[1:-1][::2])
    Assert([2, 4, 6, 8] == [1, 2, 3, 4, 5, 6, 7, 8, 9, 0][1:-1][::2])
    Assert((2, 5, 8) == (1, 2, 3, 4, 5, 6, 7, 8, 9, 0)[1:-1][::3])
    Assert([2, 5, 8] == [1, 2, 3, 4, 5, 6, 7, 8, 9, 0][1:-1][::3])
    
def test_assign():
    l = list(x)
    l[2:50] = "10"
    Assert(l == list("ab10YZ"))
    l = list(x)
    l[2:50:2] = "~!@#$%^&*()-=_+[]{}|;:/?"
    Assert(l == list("ab~d!f@h#j$l%n^p&r*t(v)x-z=B_D+F[H]J{L}N|P;R:T/V?XYZ"))

def test_negative():
    l = range(10)
    def f1(): l[::3] = [1]
    def f2(): l[::3] = range(5)
    def f3(): l[::3] = (1,)
    def f4(): l[::3] = (1, 2, 3, 4, 5, 6)
    
    for f in (f1, f2, f3, f4):
        AssertError(ValueError, f)

def test__new__():
    AreEqual(slice(3) == slice(0, 3, 1), False)
    AreEqual(slice(3) == slice(None, 3, None), True)
    AreEqual(slice(3) == 3, False)

    AreEqual(range(10)[slice(None,None,2)], [0,2,4,6,8])

def test_coverage():
    # ToString    
    AreEqual(str(slice(1,2,3)), 'slice(1, 2, 3)')
    
    # ...


#***** Copying from 'IndiceTest' *****
def t(i,j,k,l,r) :
	rr = slice(i,j,k).indices(l)
	Assert(rr == r, "slice(" + str(i) + "," + str(j) + "," + str(k) + ").indices(" + str(l) + ") != " + str(r) + ": " + str(rr))

def a():
	t(None,None,-5,-100,(-101, -1, -5))
	t(None,None,-5,-15,(-16, -1, -5))
	t(None,None,-5,-3,(-4, -1, -5))
	t(None,None,-5,0,(-1, -1, -5))
	t(None,None,-5,1,(0, -1, -5))
	t(None,None,-5,5,(4, -1, -5))
	t(None,None,-5,10,(9, -1, -5))
	t(None,None,-5,100,(99, -1, -5))
	t(None,None,-3,-100,(-101, -1, -3))
	t(None,None,-3,-15,(-16, -1, -3))
	t(None,None,-3,-3,(-4, -1, -3))
	t(None,None,-3,0,(-1, -1, -3))
	t(None,None,-3,1,(0, -1, -3))
	t(None,None,-3,5,(4, -1, -3))
	t(None,None,-3,10,(9, -1, -3))
	t(None,None,-3,100,(99, -1, -3))
	t(None,None,-1,-100,(-101, -1, -1))
	t(None,None,-1,-15,(-16, -1, -1))
	t(None,None,-1,-3,(-4, -1, -1))
	t(None,None,-1,0,(-1, -1, -1))
	t(None,None,-1,1,(0, -1, -1))
	t(None,None,-1,5,(4, -1, -1))
	t(None,None,-1,10,(9, -1, -1))
	t(None,None,-1,100,(99, -1, -1))
	t(None,None,1,-100,(0, -100, 1))
	t(None,None,1,-15,(0, -15, 1))
	t(None,None,1,-3,(0, -3, 1))
	t(None,None,1,0,(0, 0, 1))
	t(None,None,1,1,(0, 1, 1))
	t(None,None,1,5,(0, 5, 1))
	t(None,None,1,10,(0, 10, 1))
	t(None,None,1,100,(0, 100, 1))
	t(None,None,5,-100,(0, -100, 5))
	t(None,None,5,-15,(0, -15, 5))
	t(None,None,5,-3,(0, -3, 5))
	t(None,None,5,0,(0, 0, 5))
	t(None,None,5,1,(0, 1, 5))
	t(None,None,5,5,(0, 5, 5))
	t(None,None,5,10,(0, 10, 5))
	t(None,None,5,100,(0, 100, 5))
	t(None,None,20,-100,(0, -100, 20))
	t(None,None,20,-15,(0, -15, 20))
	t(None,None,20,-3,(0, -3, 20))
	t(None,None,20,0,(0, 0, 20))
	t(None,None,20,1,(0, 1, 20))
	t(None,None,20,5,(0, 5, 20))
	t(None,None,20,10,(0, 10, 20))
	t(None,None,20,100,(0, 100, 20))
	t(None,-7,-5,-100,(-101, -100, -5))
	t(None,-7,-5,-15,(-16, -15, -5))
	t(None,-7,-5,-3,(-4, -3, -5))
	t(None,-7,-5,0,(-1, -1, -5))
	t(None,-7,-5,1,(0, -1, -5))
	t(None,-7,-5,5,(4, -1, -5))
	t(None,-7,-5,10,(9, 3, -5))
	t(None,-7,-5,100,(99, 93, -5))
	t(None,-7,-3,-100,(-101, -100, -3))
	t(None,-7,-3,-15,(-16, -15, -3))
	t(None,-7,-3,-3,(-4, -3, -3))
	t(None,-7,-3,0,(-1, -1, -3))
	t(None,-7,-3,1,(0, -1, -3))
	t(None,-7,-3,5,(4, -1, -3))
	t(None,-7,-3,10,(9, 3, -3))
	t(None,-7,-3,100,(99, 93, -3))
	t(None,-7,-1,-100,(-101, -100, -1))
	t(None,-7,-1,-15,(-16, -15, -1))
	t(None,-7,-1,-3,(-4, -3, -1))
	t(None,-7,-1,0,(-1, -1, -1))
	t(None,-7,-1,1,(0, -1, -1))
	t(None,-7,-1,5,(4, -1, -1))
	t(None,-7,-1,10,(9, 3, -1))
	t(None,-7,-1,100,(99, 93, -1))
	t(None,-7,1,-100,(0, -100, 1))
	t(None,-7,1,-15,(0, -15, 1))
	t(None,-7,1,-3,(0, -3, 1))
	t(None,-7,1,0,(0, -1, 1))
	t(None,-7,1,1,(0, -1, 1))
	t(None,-7,1,5,(0, -1, 1))
	t(None,-7,1,10,(0, 3, 1))
	t(None,-7,1,100,(0, 93, 1))
	t(None,-7,5,-100,(0, -100, 5))
	t(None,-7,5,-15,(0, -15, 5))
	t(None,-7,5,-3,(0, -3, 5))
	t(None,-7,5,0,(0, -1, 5))
	t(None,-7,5,1,(0, -1, 5))
	t(None,-7,5,5,(0, -1, 5))
	t(None,-7,5,10,(0, 3, 5))
	t(None,-7,5,100,(0, 93, 5))
	t(None,-7,20,-100,(0, -100, 20))
	t(None,-7,20,-15,(0, -15, 20))
	t(None,-7,20,-3,(0, -3, 20))
	t(None,-7,20,0,(0, -1, 20))
	t(None,-7,20,1,(0, -1, 20))
	t(None,-7,20,5,(0, -1, 20))
	t(None,-7,20,10,(0, 3, 20))
	t(None,-7,20,100,(0, 93, 20))
	t(None,-2,-5,-100,(-101, -100, -5))
	t(None,-2,-5,-15,(-16, -15, -5))
	t(None,-2,-5,-3,(-4, -3, -5))
	t(None,-2,-5,0,(-1, -1, -5))
	t(None,-2,-5,1,(0, -1, -5))
	t(None,-2,-5,5,(4, 3, -5))
	t(None,-2,-5,10,(9, 8, -5))
	t(None,-2,-5,100,(99, 98, -5))
	t(None,-2,-3,-100,(-101, -100, -3))
	t(None,-2,-3,-15,(-16, -15, -3))
	t(None,-2,-3,-3,(-4, -3, -3))
	t(None,-2,-3,0,(-1, -1, -3))
	t(None,-2,-3,1,(0, -1, -3))
	t(None,-2,-3,5,(4, 3, -3))
	t(None,-2,-3,10,(9, 8, -3))
	t(None,-2,-3,100,(99, 98, -3))
	t(None,-2,-1,-100,(-101, -100, -1))
	t(None,-2,-1,-15,(-16, -15, -1))
	t(None,-2,-1,-3,(-4, -3, -1))
	t(None,-2,-1,0,(-1, -1, -1))
	t(None,-2,-1,1,(0, -1, -1))
	t(None,-2,-1,5,(4, 3, -1))
	t(None,-2,-1,10,(9, 8, -1))
	t(None,-2,-1,100,(99, 98, -1))
	t(None,-2,1,-100,(0, -100, 1))
	t(None,-2,1,-15,(0, -15, 1))
	t(None,-2,1,-3,(0, -3, 1))
	t(None,-2,1,0,(0, -1, 1))
	t(None,-2,1,1,(0, -1, 1))
	t(None,-2,1,5,(0, 3, 1))
	t(None,-2,1,10,(0, 8, 1))
	t(None,-2,1,100,(0, 98, 1))
	t(None,-2,5,-100,(0, -100, 5))
	t(None,-2,5,-15,(0, -15, 5))
	t(None,-2,5,-3,(0, -3, 5))
	t(None,-2,5,0,(0, -1, 5))
	t(None,-2,5,1,(0, -1, 5))
	t(None,-2,5,5,(0, 3, 5))
	t(None,-2,5,10,(0, 8, 5))
	t(None,-2,5,100,(0, 98, 5))
	t(None,-2,20,-100,(0, -100, 20))
	t(None,-2,20,-15,(0, -15, 20))
	t(None,-2,20,-3,(0, -3, 20))
	t(None,-2,20,0,(0, -1, 20))
	t(None,-2,20,1,(0, -1, 20))
	t(None,-2,20,5,(0, 3, 20))
	t(None,-2,20,10,(0, 8, 20))
	t(None,-2,20,100,(0, 98, 20))
	t(None,0,-5,-100,(-101, -100, -5))
	t(None,0,-5,-15,(-16, -15, -5))
	t(None,0,-5,-3,(-4, -3, -5))
	t(None,0,-5,0,(-1, 0, -5))
	t(None,0,-5,1,(0, 0, -5))
	t(None,0,-5,5,(4, 0, -5))
	t(None,0,-5,10,(9, 0, -5))
	t(None,0,-5,100,(99, 0, -5))
	t(None,0,-3,-100,(-101, -100, -3))
	t(None,0,-3,-15,(-16, -15, -3))
	t(None,0,-3,-3,(-4, -3, -3))
	t(None,0,-3,0,(-1, 0, -3))
	t(None,0,-3,1,(0, 0, -3))
	t(None,0,-3,5,(4, 0, -3))
	t(None,0,-3,10,(9, 0, -3))
	t(None,0,-3,100,(99, 0, -3))
	t(None,0,-1,-100,(-101, -100, -1))
	t(None,0,-1,-15,(-16, -15, -1))
	t(None,0,-1,-3,(-4, -3, -1))
	t(None,0,-1,0,(-1, 0, -1))
	t(None,0,-1,1,(0, 0, -1))
	t(None,0,-1,5,(4, 0, -1))
	t(None,0,-1,10,(9, 0, -1))
	t(None,0,-1,100,(99, 0, -1))
	t(None,0,1,-100,(0, -100, 1))
	t(None,0,1,-15,(0, -15, 1))
	t(None,0,1,-3,(0, -3, 1))
	t(None,0,1,0,(0, 0, 1))
	t(None,0,1,1,(0, 0, 1))
	t(None,0,1,5,(0, 0, 1))
	t(None,0,1,10,(0, 0, 1))
	t(None,0,1,100,(0, 0, 1))
	t(None,0,5,-100,(0, -100, 5))
	t(None,0,5,-15,(0, -15, 5))
	t(None,0,5,-3,(0, -3, 5))
	t(None,0,5,0,(0, 0, 5))
	t(None,0,5,1,(0, 0, 5))
	t(None,0,5,5,(0, 0, 5))
	t(None,0,5,10,(0, 0, 5))
	t(None,0,5,100,(0, 0, 5))
	t(None,0,20,-100,(0, -100, 20))
	t(None,0,20,-15,(0, -15, 20))
	t(None,0,20,-3,(0, -3, 20))
	t(None,0,20,0,(0, 0, 20))
	t(None,0,20,1,(0, 0, 20))
	t(None,0,20,5,(0, 0, 20))
	t(None,0,20,10,(0, 0, 20))
	t(None,0,20,100,(0, 0, 20))
	t(None,1,-5,-100,(-101, -100, -5))
	t(None,1,-5,-15,(-16, -15, -5))
	t(None,1,-5,-3,(-4, -3, -5))
	t(None,1,-5,0,(-1, 0, -5))
	t(None,1,-5,1,(0, 1, -5))
	t(None,1,-5,5,(4, 1, -5))
	t(None,1,-5,10,(9, 1, -5))
	t(None,1,-5,100,(99, 1, -5))
	t(None,1,-3,-100,(-101, -100, -3))
	t(None,1,-3,-15,(-16, -15, -3))
	t(None,1,-3,-3,(-4, -3, -3))
	t(None,1,-3,0,(-1, 0, -3))
	t(None,1,-3,1,(0, 1, -3))
	t(None,1,-3,5,(4, 1, -3))
	t(None,1,-3,10,(9, 1, -3))
	t(None,1,-3,100,(99, 1, -3))
	t(None,1,-1,-100,(-101, -100, -1))
	t(None,1,-1,-15,(-16, -15, -1))
	t(None,1,-1,-3,(-4, -3, -1))
	t(None,1,-1,0,(-1, 0, -1))
	t(None,1,-1,1,(0, 1, -1))
	t(None,1,-1,5,(4, 1, -1))
	t(None,1,-1,10,(9, 1, -1))
	t(None,1,-1,100,(99, 1, -1))
	t(None,1,1,-100,(0, -100, 1))
	t(None,1,1,-15,(0, -15, 1))
	t(None,1,1,-3,(0, -3, 1))
	t(None,1,1,0,(0, 0, 1))
	t(None,1,1,1,(0, 1, 1))
	t(None,1,1,5,(0, 1, 1))
	t(None,1,1,10,(0, 1, 1))
	t(None,1,1,100,(0, 1, 1))
	t(None,1,5,-100,(0, -100, 5))
	t(None,1,5,-15,(0, -15, 5))
	t(None,1,5,-3,(0, -3, 5))
	t(None,1,5,0,(0, 0, 5))
	t(None,1,5,1,(0, 1, 5))
	t(None,1,5,5,(0, 1, 5))
	t(None,1,5,10,(0, 1, 5))
	t(None,1,5,100,(0, 1, 5))
	t(None,1,20,-100,(0, -100, 20))
	t(None,1,20,-15,(0, -15, 20))
	t(None,1,20,-3,(0, -3, 20))
	t(None,1,20,0,(0, 0, 20))
	t(None,1,20,1,(0, 1, 20))
	t(None,1,20,5,(0, 1, 20))
	t(None,1,20,10,(0, 1, 20))
	t(None,1,20,100,(0, 1, 20))
	t(None,6,-5,-100,(-101, -100, -5))
	t(None,6,-5,-15,(-16, -15, -5))
	t(None,6,-5,-3,(-4, -3, -5))
	t(None,6,-5,0,(-1, 0, -5))
	t(None,6,-5,1,(0, 1, -5))
	t(None,6,-5,5,(4, 5, -5))
	t(None,6,-5,10,(9, 6, -5))
	t(None,6,-5,100,(99, 6, -5))
	t(None,6,-3,-100,(-101, -100, -3))
	t(None,6,-3,-15,(-16, -15, -3))
	t(None,6,-3,-3,(-4, -3, -3))
	t(None,6,-3,0,(-1, 0, -3))
	t(None,6,-3,1,(0, 1, -3))
	t(None,6,-3,5,(4, 5, -3))
	t(None,6,-3,10,(9, 6, -3))
	t(None,6,-3,100,(99, 6, -3))
	t(None,6,-1,-100,(-101, -100, -1))
	t(None,6,-1,-15,(-16, -15, -1))
	t(None,6,-1,-3,(-4, -3, -1))
	t(None,6,-1,0,(-1, 0, -1))
	t(None,6,-1,1,(0, 1, -1))
	t(None,6,-1,5,(4, 5, -1))
	t(None,6,-1,10,(9, 6, -1))
	t(None,6,-1,100,(99, 6, -1))
	t(None,6,1,-100,(0, -100, 1))
	t(None,6,1,-15,(0, -15, 1))
	t(None,6,1,-3,(0, -3, 1))
	t(None,6,1,0,(0, 0, 1))
	t(None,6,1,1,(0, 1, 1))
	t(None,6,1,5,(0, 5, 1))
	t(None,6,1,10,(0, 6, 1))
	t(None,6,1,100,(0, 6, 1))
	t(None,6,5,-100,(0, -100, 5))
	t(None,6,5,-15,(0, -15, 5))
	t(None,6,5,-3,(0, -3, 5))
	t(None,6,5,0,(0, 0, 5))
	t(None,6,5,1,(0, 1, 5))
	t(None,6,5,5,(0, 5, 5))
	t(None,6,5,10,(0, 6, 5))
	t(None,6,5,100,(0, 6, 5))
	t(None,6,20,-100,(0, -100, 20))
	t(None,6,20,-15,(0, -15, 20))
	t(None,6,20,-3,(0, -3, 20))
	t(None,6,20,0,(0, 0, 20))
	t(None,6,20,1,(0, 1, 20))
	t(None,6,20,5,(0, 5, 20))
	t(None,6,20,10,(0, 6, 20))
	t(None,6,20,100,(0, 6, 20))
	t(None,10,-5,-100,(-101, -100, -5))
	t(None,10,-5,-15,(-16, -15, -5))
	t(None,10,-5,-3,(-4, -3, -5))
	t(None,10,-5,0,(-1, 0, -5))
	t(None,10,-5,1,(0, 1, -5))
	t(None,10,-5,5,(4, 5, -5))
	t(None,10,-5,10,(9, 10, -5))
	t(None,10,-5,100,(99, 10, -5))
	t(None,10,-3,-100,(-101, -100, -3))
	t(None,10,-3,-15,(-16, -15, -3))
	t(None,10,-3,-3,(-4, -3, -3))
	t(None,10,-3,0,(-1, 0, -3))
	t(None,10,-3,1,(0, 1, -3))
	t(None,10,-3,5,(4, 5, -3))
	t(None,10,-3,10,(9, 10, -3))
	t(None,10,-3,100,(99, 10, -3))
	t(None,10,-1,-100,(-101, -100, -1))
	t(None,10,-1,-15,(-16, -15, -1))
	t(None,10,-1,-3,(-4, -3, -1))
	t(None,10,-1,0,(-1, 0, -1))
	t(None,10,-1,1,(0, 1, -1))
	t(None,10,-1,5,(4, 5, -1))
	t(None,10,-1,10,(9, 10, -1))
	t(None,10,-1,100,(99, 10, -1))
	t(None,10,1,-100,(0, -100, 1))
	t(None,10,1,-15,(0, -15, 1))
	t(None,10,1,-3,(0, -3, 1))
	t(None,10,1,0,(0, 0, 1))
	t(None,10,1,1,(0, 1, 1))
	t(None,10,1,5,(0, 5, 1))
	t(None,10,1,10,(0, 10, 1))
	t(None,10,1,100,(0, 10, 1))
	t(None,10,5,-100,(0, -100, 5))
	t(None,10,5,-15,(0, -15, 5))
	t(None,10,5,-3,(0, -3, 5))
	t(None,10,5,0,(0, 0, 5))
	t(None,10,5,1,(0, 1, 5))
	t(None,10,5,5,(0, 5, 5))
	t(None,10,5,10,(0, 10, 5))
	t(None,10,5,100,(0, 10, 5))
	t(None,10,20,-100,(0, -100, 20))
	t(None,10,20,-15,(0, -15, 20))
	t(None,10,20,-3,(0, -3, 20))
	t(None,10,20,0,(0, 0, 20))
	t(None,10,20,1,(0, 1, 20))
	t(None,10,20,5,(0, 5, 20))
	t(None,10,20,10,(0, 10, 20))
	t(None,10,20,100,(0, 10, 20))
	t(-7,None,-5,-100,(-101, -1, -5))
	t(-7,None,-5,-15,(-16, -1, -5))
	t(-7,None,-5,-3,(-4, -1, -5))
	t(-7,None,-5,0,(-1, -1, -5))
	t(-7,None,-5,1,(-1, -1, -5))
	t(-7,None,-5,5,(-1, -1, -5))
	t(-7,None,-5,10,(3, -1, -5))
	t(-7,None,-5,100,(93, -1, -5))
	t(-7,None,-3,-100,(-101, -1, -3))
	t(-7,None,-3,-15,(-16, -1, -3))
	t(-7,None,-3,-3,(-4, -1, -3))
	t(-7,None,-3,0,(-1, -1, -3))
	t(-7,None,-3,1,(-1, -1, -3))
	t(-7,None,-3,5,(-1, -1, -3))
	t(-7,None,-3,10,(3, -1, -3))
	t(-7,None,-3,100,(93, -1, -3))
	t(-7,None,-1,-100,(-101, -1, -1))
	t(-7,None,-1,-15,(-16, -1, -1))
	t(-7,None,-1,-3,(-4, -1, -1))
	t(-7,None,-1,0,(-1, -1, -1))
	t(-7,None,-1,1,(-1, -1, -1))
	t(-7,None,-1,5,(-1, -1, -1))
	t(-7,None,-1,10,(3, -1, -1))
	t(-7,None,-1,100,(93, -1, -1))
	t(-7,None,1,-100,(-100, -100, 1))
	t(-7,None,1,-15,(-15, -15, 1))
	t(-7,None,1,-3,(-3, -3, 1))
	t(-7,None,1,0,(0, 0, 1))
	t(-7,None,1,1,(0, 1, 1))
	t(-7,None,1,5,(0, 5, 1))
	t(-7,None,1,10,(3, 10, 1))
	t(-7,None,1,100,(93, 100, 1))
	t(-7,None,5,-100,(-100, -100, 5))
	t(-7,None,5,-15,(-15, -15, 5))
	t(-7,None,5,-3,(-3, -3, 5))
	t(-7,None,5,0,(0, 0, 5))
	t(-7,None,5,1,(0, 1, 5))
	t(-7,None,5,5,(0, 5, 5))
	t(-7,None,5,10,(3, 10, 5))
	t(-7,None,5,100,(93, 100, 5))
	t(-7,None,20,-100,(-100, -100, 20))
	t(-7,None,20,-15,(-15, -15, 20))
	t(-7,None,20,-3,(-3, -3, 20))
	t(-7,None,20,0,(0, 0, 20))
	t(-7,None,20,1,(0, 1, 20))
	t(-7,None,20,5,(0, 5, 20))
	t(-7,None,20,10,(3, 10, 20))
	t(-7,None,20,100,(93, 100, 20))
	t(-7,-7,-5,-100,(-101, -100, -5))
	t(-7,-7,-5,-15,(-16, -15, -5))
	t(-7,-7,-5,-3,(-4, -3, -5))
	t(-7,-7,-5,0,(-1, -1, -5))
	t(-7,-7,-5,1,(-1, -1, -5))
	t(-7,-7,-5,5,(-1, -1, -5))
	t(-7,-7,-5,10,(3, 3, -5))
	t(-7,-7,-5,100,(93, 93, -5))
	t(-7,-7,-3,-100,(-101, -100, -3))
	t(-7,-7,-3,-15,(-16, -15, -3))
	t(-7,-7,-3,-3,(-4, -3, -3))
	t(-7,-7,-3,0,(-1, -1, -3))
	t(-7,-7,-3,1,(-1, -1, -3))
	t(-7,-7,-3,5,(-1, -1, -3))
	t(-7,-7,-3,10,(3, 3, -3))
	t(-7,-7,-3,100,(93, 93, -3))
	t(-7,-7,-1,-100,(-101, -100, -1))
	t(-7,-7,-1,-15,(-16, -15, -1))
	t(-7,-7,-1,-3,(-4, -3, -1))
	t(-7,-7,-1,0,(-1, -1, -1))
	t(-7,-7,-1,1,(-1, -1, -1))
	t(-7,-7,-1,5,(-1, -1, -1))
	t(-7,-7,-1,10,(3, 3, -1))
	t(-7,-7,-1,100,(93, 93, -1))
	t(-7,-7,1,-100,(-100, -100, 1))
	t(-7,-7,1,-15,(-15, -15, 1))
	t(-7,-7,1,-3,(-3, -3, 1))
	t(-7,-7,1,0,(0, -1, 1))
	t(-7,-7,1,1,(0, -1, 1))
	t(-7,-7,1,5,(0, -1, 1))
	t(-7,-7,1,10,(3, 3, 1))
	t(-7,-7,1,100,(93, 93, 1))
	t(-7,-7,5,-100,(-100, -100, 5))
	t(-7,-7,5,-15,(-15, -15, 5))
	t(-7,-7,5,-3,(-3, -3, 5))
	t(-7,-7,5,0,(0, -1, 5))
	t(-7,-7,5,1,(0, -1, 5))
	t(-7,-7,5,5,(0, -1, 5))
	t(-7,-7,5,10,(3, 3, 5))
	t(-7,-7,5,100,(93, 93, 5))
	t(-7,-7,20,-100,(-100, -100, 20))
	t(-7,-7,20,-15,(-15, -15, 20))
	t(-7,-7,20,-3,(-3, -3, 20))
	t(-7,-7,20,0,(0, -1, 20))
	t(-7,-7,20,1,(0, -1, 20))
	t(-7,-7,20,5,(0, -1, 20))
	t(-7,-7,20,10,(3, 3, 20))
	t(-7,-7,20,100,(93, 93, 20))
	t(-7,-2,-5,-100,(-101, -100, -5))
	t(-7,-2,-5,-15,(-16, -15, -5))
	t(-7,-2,-5,-3,(-4, -3, -5))
	t(-7,-2,-5,0,(-1, -1, -5))
	t(-7,-2,-5,1,(-1, -1, -5))
	t(-7,-2,-5,5,(-1, 3, -5))
	t(-7,-2,-5,10,(3, 8, -5))
	t(-7,-2,-5,100,(93, 98, -5))
	t(-7,-2,-3,-100,(-101, -100, -3))
	t(-7,-2,-3,-15,(-16, -15, -3))
	t(-7,-2,-3,-3,(-4, -3, -3))
	t(-7,-2,-3,0,(-1, -1, -3))
	t(-7,-2,-3,1,(-1, -1, -3))
	t(-7,-2,-3,5,(-1, 3, -3))
	t(-7,-2,-3,10,(3, 8, -3))
	t(-7,-2,-3,100,(93, 98, -3))
	t(-7,-2,-1,-100,(-101, -100, -1))
	t(-7,-2,-1,-15,(-16, -15, -1))
	t(-7,-2,-1,-3,(-4, -3, -1))
	t(-7,-2,-1,0,(-1, -1, -1))
	t(-7,-2,-1,1,(-1, -1, -1))
	t(-7,-2,-1,5,(-1, 3, -1))
	t(-7,-2,-1,10,(3, 8, -1))
	t(-7,-2,-1,100,(93, 98, -1))
	t(-7,-2,1,-100,(-100, -100, 1))
	t(-7,-2,1,-15,(-15, -15, 1))
	t(-7,-2,1,-3,(-3, -3, 1))
	t(-7,-2,1,0,(0, -1, 1))
	t(-7,-2,1,1,(0, -1, 1))
	t(-7,-2,1,5,(0, 3, 1))
	t(-7,-2,1,10,(3, 8, 1))
	t(-7,-2,1,100,(93, 98, 1))
	t(-7,-2,5,-100,(-100, -100, 5))
	t(-7,-2,5,-15,(-15, -15, 5))
	t(-7,-2,5,-3,(-3, -3, 5))
	t(-7,-2,5,0,(0, -1, 5))
	t(-7,-2,5,1,(0, -1, 5))
	t(-7,-2,5,5,(0, 3, 5))
	t(-7,-2,5,10,(3, 8, 5))
	t(-7,-2,5,100,(93, 98, 5))
	t(-7,-2,20,-100,(-100, -100, 20))
	t(-7,-2,20,-15,(-15, -15, 20))
	t(-7,-2,20,-3,(-3, -3, 20))
	t(-7,-2,20,0,(0, -1, 20))
	t(-7,-2,20,1,(0, -1, 20))
	t(-7,-2,20,5,(0, 3, 20))
	t(-7,-2,20,10,(3, 8, 20))
	t(-7,-2,20,100,(93, 98, 20))
	t(-7,0,-5,-100,(-101, -100, -5))
	t(-7,0,-5,-15,(-16, -15, -5))
	t(-7,0,-5,-3,(-4, -3, -5))
	t(-7,0,-5,0,(-1, 0, -5))
	t(-7,0,-5,1,(-1, 0, -5))
	t(-7,0,-5,5,(-1, 0, -5))
	t(-7,0,-5,10,(3, 0, -5))
	t(-7,0,-5,100,(93, 0, -5))
	t(-7,0,-3,-100,(-101, -100, -3))
	t(-7,0,-3,-15,(-16, -15, -3))
	t(-7,0,-3,-3,(-4, -3, -3))
	t(-7,0,-3,0,(-1, 0, -3))
	t(-7,0,-3,1,(-1, 0, -3))
	t(-7,0,-3,5,(-1, 0, -3))
	t(-7,0,-3,10,(3, 0, -3))
	t(-7,0,-3,100,(93, 0, -3))
	t(-7,0,-1,-100,(-101, -100, -1))
	t(-7,0,-1,-15,(-16, -15, -1))
	t(-7,0,-1,-3,(-4, -3, -1))
	t(-7,0,-1,0,(-1, 0, -1))
	t(-7,0,-1,1,(-1, 0, -1))
	t(-7,0,-1,5,(-1, 0, -1))
	t(-7,0,-1,10,(3, 0, -1))
	t(-7,0,-1,100,(93, 0, -1))
	t(-7,0,1,-100,(-100, -100, 1))
	t(-7,0,1,-15,(-15, -15, 1))
	t(-7,0,1,-3,(-3, -3, 1))
	t(-7,0,1,0,(0, 0, 1))
	t(-7,0,1,1,(0, 0, 1))
	t(-7,0,1,5,(0, 0, 1))
	t(-7,0,1,10,(3, 0, 1))
	t(-7,0,1,100,(93, 0, 1))
	t(-7,0,5,-100,(-100, -100, 5))
	t(-7,0,5,-15,(-15, -15, 5))
	t(-7,0,5,-3,(-3, -3, 5))
	t(-7,0,5,0,(0, 0, 5))
	t(-7,0,5,1,(0, 0, 5))
	t(-7,0,5,5,(0, 0, 5))
	t(-7,0,5,10,(3, 0, 5))
	t(-7,0,5,100,(93, 0, 5))
	t(-7,0,20,-100,(-100, -100, 20))
	t(-7,0,20,-15,(-15, -15, 20))
	t(-7,0,20,-3,(-3, -3, 20))
	t(-7,0,20,0,(0, 0, 20))
	t(-7,0,20,1,(0, 0, 20))
	t(-7,0,20,5,(0, 0, 20))
	t(-7,0,20,10,(3, 0, 20))
	t(-7,0,20,100,(93, 0, 20))
	t(-7,1,-5,-100,(-101, -100, -5))
	t(-7,1,-5,-15,(-16, -15, -5))
	t(-7,1,-5,-3,(-4, -3, -5))
	t(-7,1,-5,0,(-1, 0, -5))
	t(-7,1,-5,1,(-1, 1, -5))
	t(-7,1,-5,5,(-1, 1, -5))
	t(-7,1,-5,10,(3, 1, -5))
	t(-7,1,-5,100,(93, 1, -5))
	t(-7,1,-3,-100,(-101, -100, -3))
	t(-7,1,-3,-15,(-16, -15, -3))
	t(-7,1,-3,-3,(-4, -3, -3))
	t(-7,1,-3,0,(-1, 0, -3))
	t(-7,1,-3,1,(-1, 1, -3))
	t(-7,1,-3,5,(-1, 1, -3))
	t(-7,1,-3,10,(3, 1, -3))
	t(-7,1,-3,100,(93, 1, -3))
	t(-7,1,-1,-100,(-101, -100, -1))
	t(-7,1,-1,-15,(-16, -15, -1))
	t(-7,1,-1,-3,(-4, -3, -1))
	t(-7,1,-1,0,(-1, 0, -1))
	t(-7,1,-1,1,(-1, 1, -1))
	t(-7,1,-1,5,(-1, 1, -1))
	t(-7,1,-1,10,(3, 1, -1))
	t(-7,1,-1,100,(93, 1, -1))
	t(-7,1,1,-100,(-100, -100, 1))
	t(-7,1,1,-15,(-15, -15, 1))
	t(-7,1,1,-3,(-3, -3, 1))
	t(-7,1,1,0,(0, 0, 1))
	t(-7,1,1,1,(0, 1, 1))
	t(-7,1,1,5,(0, 1, 1))
	t(-7,1,1,10,(3, 1, 1))
	t(-7,1,1,100,(93, 1, 1))
	t(-7,1,5,-100,(-100, -100, 5))
	t(-7,1,5,-15,(-15, -15, 5))
	t(-7,1,5,-3,(-3, -3, 5))
	t(-7,1,5,0,(0, 0, 5))
	t(-7,1,5,1,(0, 1, 5))
	t(-7,1,5,5,(0, 1, 5))
	t(-7,1,5,10,(3, 1, 5))
	t(-7,1,5,100,(93, 1, 5))
	t(-7,1,20,-100,(-100, -100, 20))
	t(-7,1,20,-15,(-15, -15, 20))
	t(-7,1,20,-3,(-3, -3, 20))
	t(-7,1,20,0,(0, 0, 20))
	t(-7,1,20,1,(0, 1, 20))
	t(-7,1,20,5,(0, 1, 20))
	t(-7,1,20,10,(3, 1, 20))
	t(-7,1,20,100,(93, 1, 20))
	t(-7,6,-5,-100,(-101, -100, -5))
	t(-7,6,-5,-15,(-16, -15, -5))
	t(-7,6,-5,-3,(-4, -3, -5))
	t(-7,6,-5,0,(-1, 0, -5))
	t(-7,6,-5,1,(-1, 1, -5))
	t(-7,6,-5,5,(-1, 5, -5))
	t(-7,6,-5,10,(3, 6, -5))
	t(-7,6,-5,100,(93, 6, -5))
	t(-7,6,-3,-100,(-101, -100, -3))
	t(-7,6,-3,-15,(-16, -15, -3))
	t(-7,6,-3,-3,(-4, -3, -3))
	t(-7,6,-3,0,(-1, 0, -3))
	t(-7,6,-3,1,(-1, 1, -3))
	t(-7,6,-3,5,(-1, 5, -3))
	t(-7,6,-3,10,(3, 6, -3))
	t(-7,6,-3,100,(93, 6, -3))
	t(-7,6,-1,-100,(-101, -100, -1))
	t(-7,6,-1,-15,(-16, -15, -1))
	t(-7,6,-1,-3,(-4, -3, -1))
	t(-7,6,-1,0,(-1, 0, -1))
	t(-7,6,-1,1,(-1, 1, -1))
	t(-7,6,-1,5,(-1, 5, -1))
	t(-7,6,-1,10,(3, 6, -1))
	t(-7,6,-1,100,(93, 6, -1))
	t(-7,6,1,-100,(-100, -100, 1))
	t(-7,6,1,-15,(-15, -15, 1))
	t(-7,6,1,-3,(-3, -3, 1))
	t(-7,6,1,0,(0, 0, 1))
	t(-7,6,1,1,(0, 1, 1))
	t(-7,6,1,5,(0, 5, 1))
	t(-7,6,1,10,(3, 6, 1))
	t(-7,6,1,100,(93, 6, 1))
	t(-7,6,5,-100,(-100, -100, 5))
	t(-7,6,5,-15,(-15, -15, 5))
	t(-7,6,5,-3,(-3, -3, 5))
	t(-7,6,5,0,(0, 0, 5))
	t(-7,6,5,1,(0, 1, 5))
	t(-7,6,5,5,(0, 5, 5))
	t(-7,6,5,10,(3, 6, 5))
	t(-7,6,5,100,(93, 6, 5))
	t(-7,6,20,-100,(-100, -100, 20))
	t(-7,6,20,-15,(-15, -15, 20))
	t(-7,6,20,-3,(-3, -3, 20))
	t(-7,6,20,0,(0, 0, 20))
	t(-7,6,20,1,(0, 1, 20))
	t(-7,6,20,5,(0, 5, 20))
	t(-7,6,20,10,(3, 6, 20))
	t(-7,6,20,100,(93, 6, 20))
	t(-7,10,-5,-100,(-101, -100, -5))
	t(-7,10,-5,-15,(-16, -15, -5))
	t(-7,10,-5,-3,(-4, -3, -5))
	t(-7,10,-5,0,(-1, 0, -5))
	t(-7,10,-5,1,(-1, 1, -5))
	t(-7,10,-5,5,(-1, 5, -5))
	t(-7,10,-5,10,(3, 10, -5))
	t(-7,10,-5,100,(93, 10, -5))
	t(-7,10,-3,-100,(-101, -100, -3))
	t(-7,10,-3,-15,(-16, -15, -3))
	t(-7,10,-3,-3,(-4, -3, -3))
	t(-7,10,-3,0,(-1, 0, -3))
	t(-7,10,-3,1,(-1, 1, -3))
	t(-7,10,-3,5,(-1, 5, -3))
	t(-7,10,-3,10,(3, 10, -3))
	t(-7,10,-3,100,(93, 10, -3))
	t(-7,10,-1,-100,(-101, -100, -1))
	t(-7,10,-1,-15,(-16, -15, -1))
	t(-7,10,-1,-3,(-4, -3, -1))
	t(-7,10,-1,0,(-1, 0, -1))
	t(-7,10,-1,1,(-1, 1, -1))
	t(-7,10,-1,5,(-1, 5, -1))
	t(-7,10,-1,10,(3, 10, -1))
	t(-7,10,-1,100,(93, 10, -1))
	t(-7,10,1,-100,(-100, -100, 1))
	t(-7,10,1,-15,(-15, -15, 1))
	t(-7,10,1,-3,(-3, -3, 1))
	t(-7,10,1,0,(0, 0, 1))
	t(-7,10,1,1,(0, 1, 1))
	t(-7,10,1,5,(0, 5, 1))
	t(-7,10,1,10,(3, 10, 1))
	t(-7,10,1,100,(93, 10, 1))
	t(-7,10,5,-100,(-100, -100, 5))
	t(-7,10,5,-15,(-15, -15, 5))
	t(-7,10,5,-3,(-3, -3, 5))
	t(-7,10,5,0,(0, 0, 5))
	t(-7,10,5,1,(0, 1, 5))
	t(-7,10,5,5,(0, 5, 5))
	t(-7,10,5,10,(3, 10, 5))
	t(-7,10,5,100,(93, 10, 5))
	t(-7,10,20,-100,(-100, -100, 20))
	t(-7,10,20,-15,(-15, -15, 20))
	t(-7,10,20,-3,(-3, -3, 20))
	t(-7,10,20,0,(0, 0, 20))
	t(-7,10,20,1,(0, 1, 20))
	t(-7,10,20,5,(0, 5, 20))
	t(-7,10,20,10,(3, 10, 20))
	t(-7,10,20,100,(93, 10, 20))
	t(-2,None,-5,-100,(-101, -1, -5))
	t(-2,None,-5,-15,(-16, -1, -5))
	t(-2,None,-5,-3,(-4, -1, -5))
	t(-2,None,-5,0,(-1, -1, -5))
	t(-2,None,-5,1,(-1, -1, -5))
	t(-2,None,-5,5,(3, -1, -5))
	t(-2,None,-5,10,(8, -1, -5))
	t(-2,None,-5,100,(98, -1, -5))
	t(-2,None,-3,-100,(-101, -1, -3))
	t(-2,None,-3,-15,(-16, -1, -3))
	t(-2,None,-3,-3,(-4, -1, -3))
	t(-2,None,-3,0,(-1, -1, -3))
	t(-2,None,-3,1,(-1, -1, -3))
	t(-2,None,-3,5,(3, -1, -3))
	t(-2,None,-3,10,(8, -1, -3))
	t(-2,None,-3,100,(98, -1, -3))
	t(-2,None,-1,-100,(-101, -1, -1))
	t(-2,None,-1,-15,(-16, -1, -1))
	t(-2,None,-1,-3,(-4, -1, -1))
	t(-2,None,-1,0,(-1, -1, -1))
	t(-2,None,-1,1,(-1, -1, -1))
	t(-2,None,-1,5,(3, -1, -1))
	t(-2,None,-1,10,(8, -1, -1))
	t(-2,None,-1,100,(98, -1, -1))
	t(-2,None,1,-100,(-100, -100, 1))
	t(-2,None,1,-15,(-15, -15, 1))
	t(-2,None,1,-3,(-3, -3, 1))
	t(-2,None,1,0,(0, 0, 1))
	t(-2,None,1,1,(0, 1, 1))
	t(-2,None,1,5,(3, 5, 1))
	t(-2,None,1,10,(8, 10, 1))
	t(-2,None,1,100,(98, 100, 1))
	t(-2,None,5,-100,(-100, -100, 5))
	t(-2,None,5,-15,(-15, -15, 5))
	t(-2,None,5,-3,(-3, -3, 5))
	t(-2,None,5,0,(0, 0, 5))
	t(-2,None,5,1,(0, 1, 5))
	t(-2,None,5,5,(3, 5, 5))
	t(-2,None,5,10,(8, 10, 5))
	t(-2,None,5,100,(98, 100, 5))
	t(-2,None,20,-100,(-100, -100, 20))
	t(-2,None,20,-15,(-15, -15, 20))
	t(-2,None,20,-3,(-3, -3, 20))
	t(-2,None,20,0,(0, 0, 20))
	t(-2,None,20,1,(0, 1, 20))
	t(-2,None,20,5,(3, 5, 20))
	t(-2,None,20,10,(8, 10, 20))
	t(-2,None,20,100,(98, 100, 20))
	t(-2,-7,-5,-100,(-101, -100, -5))
	t(-2,-7,-5,-15,(-16, -15, -5))
	t(-2,-7,-5,-3,(-4, -3, -5))
	t(-2,-7,-5,0,(-1, -1, -5))
	t(-2,-7,-5,1,(-1, -1, -5))
	t(-2,-7,-5,5,(3, -1, -5))
	t(-2,-7,-5,10,(8, 3, -5))
	t(-2,-7,-5,100,(98, 93, -5))
	t(-2,-7,-3,-100,(-101, -100, -3))
	t(-2,-7,-3,-15,(-16, -15, -3))
	t(-2,-7,-3,-3,(-4, -3, -3))
	t(-2,-7,-3,0,(-1, -1, -3))
	t(-2,-7,-3,1,(-1, -1, -3))
	t(-2,-7,-3,5,(3, -1, -3))
	t(-2,-7,-3,10,(8, 3, -3))
	t(-2,-7,-3,100,(98, 93, -3))
	t(-2,-7,-1,-100,(-101, -100, -1))
	t(-2,-7,-1,-15,(-16, -15, -1))
	t(-2,-7,-1,-3,(-4, -3, -1))
	t(-2,-7,-1,0,(-1, -1, -1))
	t(-2,-7,-1,1,(-1, -1, -1))
	t(-2,-7,-1,5,(3, -1, -1))
	t(-2,-7,-1,10,(8, 3, -1))
	t(-2,-7,-1,100,(98, 93, -1))
	t(-2,-7,1,-100,(-100, -100, 1))
	t(-2,-7,1,-15,(-15, -15, 1))
	t(-2,-7,1,-3,(-3, -3, 1))
	t(-2,-7,1,0,(0, -1, 1))
	t(-2,-7,1,1,(0, -1, 1))
	t(-2,-7,1,5,(3, -1, 1))
	t(-2,-7,1,10,(8, 3, 1))
	t(-2,-7,1,100,(98, 93, 1))
	t(-2,-7,5,-100,(-100, -100, 5))
	t(-2,-7,5,-15,(-15, -15, 5))
	t(-2,-7,5,-3,(-3, -3, 5))
	t(-2,-7,5,0,(0, -1, 5))
	t(-2,-7,5,1,(0, -1, 5))
	t(-2,-7,5,5,(3, -1, 5))
	t(-2,-7,5,10,(8, 3, 5))
	t(-2,-7,5,100,(98, 93, 5))
	t(-2,-7,20,-100,(-100, -100, 20))
	t(-2,-7,20,-15,(-15, -15, 20))
	t(-2,-7,20,-3,(-3, -3, 20))
	t(-2,-7,20,0,(0, -1, 20))
	t(-2,-7,20,1,(0, -1, 20))
	t(-2,-7,20,5,(3, -1, 20))
	t(-2,-7,20,10,(8, 3, 20))
	t(-2,-7,20,100,(98, 93, 20))
	t(-2,-2,-5,-100,(-101, -100, -5))
	t(-2,-2,-5,-15,(-16, -15, -5))
	t(-2,-2,-5,-3,(-4, -3, -5))
	t(-2,-2,-5,0,(-1, -1, -5))
	t(-2,-2,-5,1,(-1, -1, -5))
	t(-2,-2,-5,5,(3, 3, -5))
	t(-2,-2,-5,10,(8, 8, -5))
	t(-2,-2,-5,100,(98, 98, -5))
	t(-2,-2,-3,-100,(-101, -100, -3))
	t(-2,-2,-3,-15,(-16, -15, -3))
	t(-2,-2,-3,-3,(-4, -3, -3))
	t(-2,-2,-3,0,(-1, -1, -3))
	t(-2,-2,-3,1,(-1, -1, -3))

def b():
	t(-2,-2,-3,5,(3, 3, -3))
	t(-2,-2,-3,10,(8, 8, -3))
	t(-2,-2,-3,100,(98, 98, -3))
	t(-2,-2,-1,-100,(-101, -100, -1))
	t(-2,-2,-1,-15,(-16, -15, -1))
	t(-2,-2,-1,-3,(-4, -3, -1))
	t(-2,-2,-1,0,(-1, -1, -1))
	t(-2,-2,-1,1,(-1, -1, -1))
	t(-2,-2,-1,5,(3, 3, -1))
	t(-2,-2,-1,10,(8, 8, -1))
	t(-2,-2,-1,100,(98, 98, -1))
	t(-2,-2,1,-100,(-100, -100, 1))
	t(-2,-2,1,-15,(-15, -15, 1))
	t(-2,-2,1,-3,(-3, -3, 1))
	t(-2,-2,1,0,(0, -1, 1))
	t(-2,-2,1,1,(0, -1, 1))
	t(-2,-2,1,5,(3, 3, 1))
	t(-2,-2,1,10,(8, 8, 1))
	t(-2,-2,1,100,(98, 98, 1))
	t(-2,-2,5,-100,(-100, -100, 5))
	t(-2,-2,5,-15,(-15, -15, 5))
	t(-2,-2,5,-3,(-3, -3, 5))
	t(-2,-2,5,0,(0, -1, 5))
	t(-2,-2,5,1,(0, -1, 5))
	t(-2,-2,5,5,(3, 3, 5))
	t(-2,-2,5,10,(8, 8, 5))
	t(-2,-2,5,100,(98, 98, 5))
	t(-2,-2,20,-100,(-100, -100, 20))
	t(-2,-2,20,-15,(-15, -15, 20))
	t(-2,-2,20,-3,(-3, -3, 20))
	t(-2,-2,20,0,(0, -1, 20))
	t(-2,-2,20,1,(0, -1, 20))
	t(-2,-2,20,5,(3, 3, 20))
	t(-2,-2,20,10,(8, 8, 20))
	t(-2,-2,20,100,(98, 98, 20))
	t(-2,0,-5,-100,(-101, -100, -5))
	t(-2,0,-5,-15,(-16, -15, -5))
	t(-2,0,-5,-3,(-4, -3, -5))
	t(-2,0,-5,0,(-1, 0, -5))
	t(-2,0,-5,1,(-1, 0, -5))
	t(-2,0,-5,5,(3, 0, -5))
	t(-2,0,-5,10,(8, 0, -5))
	t(-2,0,-5,100,(98, 0, -5))
	t(-2,0,-3,-100,(-101, -100, -3))
	t(-2,0,-3,-15,(-16, -15, -3))
	t(-2,0,-3,-3,(-4, -3, -3))
	t(-2,0,-3,0,(-1, 0, -3))
	t(-2,0,-3,1,(-1, 0, -3))
	t(-2,0,-3,5,(3, 0, -3))
	t(-2,0,-3,10,(8, 0, -3))
	t(-2,0,-3,100,(98, 0, -3))
	t(-2,0,-1,-100,(-101, -100, -1))
	t(-2,0,-1,-15,(-16, -15, -1))
	t(-2,0,-1,-3,(-4, -3, -1))
	t(-2,0,-1,0,(-1, 0, -1))
	t(-2,0,-1,1,(-1, 0, -1))
	t(-2,0,-1,5,(3, 0, -1))
	t(-2,0,-1,10,(8, 0, -1))
	t(-2,0,-1,100,(98, 0, -1))
	t(-2,0,1,-100,(-100, -100, 1))
	t(-2,0,1,-15,(-15, -15, 1))
	t(-2,0,1,-3,(-3, -3, 1))
	t(-2,0,1,0,(0, 0, 1))
	t(-2,0,1,1,(0, 0, 1))
	t(-2,0,1,5,(3, 0, 1))
	t(-2,0,1,10,(8, 0, 1))
	t(-2,0,1,100,(98, 0, 1))
	t(-2,0,5,-100,(-100, -100, 5))
	t(-2,0,5,-15,(-15, -15, 5))
	t(-2,0,5,-3,(-3, -3, 5))
	t(-2,0,5,0,(0, 0, 5))
	t(-2,0,5,1,(0, 0, 5))
	t(-2,0,5,5,(3, 0, 5))
	t(-2,0,5,10,(8, 0, 5))
	t(-2,0,5,100,(98, 0, 5))
	t(-2,0,20,-100,(-100, -100, 20))
	t(-2,0,20,-15,(-15, -15, 20))
	t(-2,0,20,-3,(-3, -3, 20))
	t(-2,0,20,0,(0, 0, 20))
	t(-2,0,20,1,(0, 0, 20))
	t(-2,0,20,5,(3, 0, 20))
	t(-2,0,20,10,(8, 0, 20))
	t(-2,0,20,100,(98, 0, 20))
	t(-2,1,-5,-100,(-101, -100, -5))
	t(-2,1,-5,-15,(-16, -15, -5))
	t(-2,1,-5,-3,(-4, -3, -5))
	t(-2,1,-5,0,(-1, 0, -5))
	t(-2,1,-5,1,(-1, 1, -5))
	t(-2,1,-5,5,(3, 1, -5))
	t(-2,1,-5,10,(8, 1, -5))
	t(-2,1,-5,100,(98, 1, -5))
	t(-2,1,-3,-100,(-101, -100, -3))
	t(-2,1,-3,-15,(-16, -15, -3))
	t(-2,1,-3,-3,(-4, -3, -3))
	t(-2,1,-3,0,(-1, 0, -3))
	t(-2,1,-3,1,(-1, 1, -3))
	t(-2,1,-3,5,(3, 1, -3))
	t(-2,1,-3,10,(8, 1, -3))
	t(-2,1,-3,100,(98, 1, -3))
	t(-2,1,-1,-100,(-101, -100, -1))
	t(-2,1,-1,-15,(-16, -15, -1))
	t(-2,1,-1,-3,(-4, -3, -1))
	t(-2,1,-1,0,(-1, 0, -1))
	t(-2,1,-1,1,(-1, 1, -1))
	t(-2,1,-1,5,(3, 1, -1))
	t(-2,1,-1,10,(8, 1, -1))
	t(-2,1,-1,100,(98, 1, -1))
	t(-2,1,1,-100,(-100, -100, 1))
	t(-2,1,1,-15,(-15, -15, 1))
	t(-2,1,1,-3,(-3, -3, 1))
	t(-2,1,1,0,(0, 0, 1))
	t(-2,1,1,1,(0, 1, 1))
	t(-2,1,1,5,(3, 1, 1))
	t(-2,1,1,10,(8, 1, 1))
	t(-2,1,1,100,(98, 1, 1))
	t(-2,1,5,-100,(-100, -100, 5))
	t(-2,1,5,-15,(-15, -15, 5))
	t(-2,1,5,-3,(-3, -3, 5))
	t(-2,1,5,0,(0, 0, 5))
	t(-2,1,5,1,(0, 1, 5))
	t(-2,1,5,5,(3, 1, 5))
	t(-2,1,5,10,(8, 1, 5))
	t(-2,1,5,100,(98, 1, 5))
	t(-2,1,20,-100,(-100, -100, 20))
	t(-2,1,20,-15,(-15, -15, 20))
	t(-2,1,20,-3,(-3, -3, 20))
	t(-2,1,20,0,(0, 0, 20))
	t(-2,1,20,1,(0, 1, 20))
	t(-2,1,20,5,(3, 1, 20))
	t(-2,1,20,10,(8, 1, 20))
	t(-2,1,20,100,(98, 1, 20))
	t(-2,6,-5,-100,(-101, -100, -5))
	t(-2,6,-5,-15,(-16, -15, -5))
	t(-2,6,-5,-3,(-4, -3, -5))
	t(-2,6,-5,0,(-1, 0, -5))
	t(-2,6,-5,1,(-1, 1, -5))
	t(-2,6,-5,5,(3, 5, -5))
	t(-2,6,-5,10,(8, 6, -5))
	t(-2,6,-5,100,(98, 6, -5))
	t(-2,6,-3,-100,(-101, -100, -3))
	t(-2,6,-3,-15,(-16, -15, -3))
	t(-2,6,-3,-3,(-4, -3, -3))
	t(-2,6,-3,0,(-1, 0, -3))
	t(-2,6,-3,1,(-1, 1, -3))
	t(-2,6,-3,5,(3, 5, -3))
	t(-2,6,-3,10,(8, 6, -3))
	t(-2,6,-3,100,(98, 6, -3))
	t(-2,6,-1,-100,(-101, -100, -1))
	t(-2,6,-1,-15,(-16, -15, -1))
	t(-2,6,-1,-3,(-4, -3, -1))
	t(-2,6,-1,0,(-1, 0, -1))
	t(-2,6,-1,1,(-1, 1, -1))
	t(-2,6,-1,5,(3, 5, -1))
	t(-2,6,-1,10,(8, 6, -1))
	t(-2,6,-1,100,(98, 6, -1))
	t(-2,6,1,-100,(-100, -100, 1))
	t(-2,6,1,-15,(-15, -15, 1))
	t(-2,6,1,-3,(-3, -3, 1))
	t(-2,6,1,0,(0, 0, 1))
	t(-2,6,1,1,(0, 1, 1))
	t(-2,6,1,5,(3, 5, 1))
	t(-2,6,1,10,(8, 6, 1))
	t(-2,6,1,100,(98, 6, 1))
	t(-2,6,5,-100,(-100, -100, 5))
	t(-2,6,5,-15,(-15, -15, 5))
	t(-2,6,5,-3,(-3, -3, 5))
	t(-2,6,5,0,(0, 0, 5))
	t(-2,6,5,1,(0, 1, 5))
	t(-2,6,5,5,(3, 5, 5))
	t(-2,6,5,10,(8, 6, 5))
	t(-2,6,5,100,(98, 6, 5))
	t(-2,6,20,-100,(-100, -100, 20))
	t(-2,6,20,-15,(-15, -15, 20))
	t(-2,6,20,-3,(-3, -3, 20))
	t(-2,6,20,0,(0, 0, 20))
	t(-2,6,20,1,(0, 1, 20))
	t(-2,6,20,5,(3, 5, 20))
	t(-2,6,20,10,(8, 6, 20))
	t(-2,6,20,100,(98, 6, 20))
	t(-2,10,-5,-100,(-101, -100, -5))
	t(-2,10,-5,-15,(-16, -15, -5))
	t(-2,10,-5,-3,(-4, -3, -5))
	t(-2,10,-5,0,(-1, 0, -5))
	t(-2,10,-5,1,(-1, 1, -5))
	t(-2,10,-5,5,(3, 5, -5))
	t(-2,10,-5,10,(8, 10, -5))
	t(-2,10,-5,100,(98, 10, -5))
	t(-2,10,-3,-100,(-101, -100, -3))
	t(-2,10,-3,-15,(-16, -15, -3))
	t(-2,10,-3,-3,(-4, -3, -3))
	t(-2,10,-3,0,(-1, 0, -3))
	t(-2,10,-3,1,(-1, 1, -3))
	t(-2,10,-3,5,(3, 5, -3))
	t(-2,10,-3,10,(8, 10, -3))
	t(-2,10,-3,100,(98, 10, -3))
	t(-2,10,-1,-100,(-101, -100, -1))
	t(-2,10,-1,-15,(-16, -15, -1))
	t(-2,10,-1,-3,(-4, -3, -1))
	t(-2,10,-1,0,(-1, 0, -1))
	t(-2,10,-1,1,(-1, 1, -1))
	t(-2,10,-1,5,(3, 5, -1))
	t(-2,10,-1,10,(8, 10, -1))
	t(-2,10,-1,100,(98, 10, -1))
	t(-2,10,1,-100,(-100, -100, 1))
	t(-2,10,1,-15,(-15, -15, 1))
	t(-2,10,1,-3,(-3, -3, 1))
	t(-2,10,1,0,(0, 0, 1))
	t(-2,10,1,1,(0, 1, 1))
	t(-2,10,1,5,(3, 5, 1))
	t(-2,10,1,10,(8, 10, 1))
	t(-2,10,1,100,(98, 10, 1))
	t(-2,10,5,-100,(-100, -100, 5))
	t(-2,10,5,-15,(-15, -15, 5))
	t(-2,10,5,-3,(-3, -3, 5))
	t(-2,10,5,0,(0, 0, 5))
	t(-2,10,5,1,(0, 1, 5))
	t(-2,10,5,5,(3, 5, 5))
	t(-2,10,5,10,(8, 10, 5))
	t(-2,10,5,100,(98, 10, 5))
	t(-2,10,20,-100,(-100, -100, 20))
	t(-2,10,20,-15,(-15, -15, 20))
	t(-2,10,20,-3,(-3, -3, 20))
	t(-2,10,20,0,(0, 0, 20))
	t(-2,10,20,1,(0, 1, 20))
	t(-2,10,20,5,(3, 5, 20))
	t(-2,10,20,10,(8, 10, 20))
	t(-2,10,20,100,(98, 10, 20))
	t(0,None,-5,-100,(-101, -1, -5))
	t(0,None,-5,-15,(-16, -1, -5))
	t(0,None,-5,-3,(-4, -1, -5))
	t(0,None,-5,0,(-1, -1, -5))
	t(0,None,-5,1,(0, -1, -5))
	t(0,None,-5,5,(0, -1, -5))
	t(0,None,-5,10,(0, -1, -5))
	t(0,None,-5,100,(0, -1, -5))
	t(0,None,-3,-100,(-101, -1, -3))
	t(0,None,-3,-15,(-16, -1, -3))
	t(0,None,-3,-3,(-4, -1, -3))
	t(0,None,-3,0,(-1, -1, -3))
	t(0,None,-3,1,(0, -1, -3))
	t(0,None,-3,5,(0, -1, -3))
	t(0,None,-3,10,(0, -1, -3))
	t(0,None,-3,100,(0, -1, -3))
	t(0,None,-1,-100,(-101, -1, -1))
	t(0,None,-1,-15,(-16, -1, -1))
	t(0,None,-1,-3,(-4, -1, -1))
	t(0,None,-1,0,(-1, -1, -1))
	t(0,None,-1,1,(0, -1, -1))
	t(0,None,-1,5,(0, -1, -1))
	t(0,None,-1,10,(0, -1, -1))
	t(0,None,-1,100,(0, -1, -1))
	t(0,None,1,-100,(-100, -100, 1))
	t(0,None,1,-15,(-15, -15, 1))
	t(0,None,1,-3,(-3, -3, 1))
	t(0,None,1,0,(0, 0, 1))
	t(0,None,1,1,(0, 1, 1))
	t(0,None,1,5,(0, 5, 1))
	t(0,None,1,10,(0, 10, 1))
	t(0,None,1,100,(0, 100, 1))
	t(0,None,5,-100,(-100, -100, 5))
	t(0,None,5,-15,(-15, -15, 5))
	t(0,None,5,-3,(-3, -3, 5))
	t(0,None,5,0,(0, 0, 5))
	t(0,None,5,1,(0, 1, 5))
	t(0,None,5,5,(0, 5, 5))
	t(0,None,5,10,(0, 10, 5))
	t(0,None,5,100,(0, 100, 5))
	t(0,None,20,-100,(-100, -100, 20))
	t(0,None,20,-15,(-15, -15, 20))
	t(0,None,20,-3,(-3, -3, 20))
	t(0,None,20,0,(0, 0, 20))
	t(0,None,20,1,(0, 1, 20))
	t(0,None,20,5,(0, 5, 20))
	t(0,None,20,10,(0, 10, 20))
	t(0,None,20,100,(0, 100, 20))
	t(0,-7,-5,-100,(-101, -100, -5))
	t(0,-7,-5,-15,(-16, -15, -5))
	t(0,-7,-5,-3,(-4, -3, -5))
	t(0,-7,-5,0,(-1, -1, -5))
	t(0,-7,-5,1,(0, -1, -5))
	t(0,-7,-5,5,(0, -1, -5))
	t(0,-7,-5,10,(0, 3, -5))
	t(0,-7,-5,100,(0, 93, -5))
	t(0,-7,-3,-100,(-101, -100, -3))
	t(0,-7,-3,-15,(-16, -15, -3))
	t(0,-7,-3,-3,(-4, -3, -3))
	t(0,-7,-3,0,(-1, -1, -3))
	t(0,-7,-3,1,(0, -1, -3))
	t(0,-7,-3,5,(0, -1, -3))
	t(0,-7,-3,10,(0, 3, -3))
	t(0,-7,-3,100,(0, 93, -3))
	t(0,-7,-1,-100,(-101, -100, -1))
	t(0,-7,-1,-15,(-16, -15, -1))
	t(0,-7,-1,-3,(-4, -3, -1))
	t(0,-7,-1,0,(-1, -1, -1))
	t(0,-7,-1,1,(0, -1, -1))
	t(0,-7,-1,5,(0, -1, -1))
	t(0,-7,-1,10,(0, 3, -1))
	t(0,-7,-1,100,(0, 93, -1))
	t(0,-7,1,-100,(-100, -100, 1))
	t(0,-7,1,-15,(-15, -15, 1))
	t(0,-7,1,-3,(-3, -3, 1))
	t(0,-7,1,0,(0, -1, 1))
	t(0,-7,1,1,(0, -1, 1))
	t(0,-7,1,5,(0, -1, 1))
	t(0,-7,1,10,(0, 3, 1))
	t(0,-7,1,100,(0, 93, 1))
	t(0,-7,5,-100,(-100, -100, 5))
	t(0,-7,5,-15,(-15, -15, 5))
	t(0,-7,5,-3,(-3, -3, 5))
	t(0,-7,5,0,(0, -1, 5))
	t(0,-7,5,1,(0, -1, 5))
	t(0,-7,5,5,(0, -1, 5))
	t(0,-7,5,10,(0, 3, 5))
	t(0,-7,5,100,(0, 93, 5))
	t(0,-7,20,-100,(-100, -100, 20))
	t(0,-7,20,-15,(-15, -15, 20))
	t(0,-7,20,-3,(-3, -3, 20))
	t(0,-7,20,0,(0, -1, 20))
	t(0,-7,20,1,(0, -1, 20))
	t(0,-7,20,5,(0, -1, 20))
	t(0,-7,20,10,(0, 3, 20))
	t(0,-7,20,100,(0, 93, 20))
	t(0,-2,-5,-100,(-101, -100, -5))
	t(0,-2,-5,-15,(-16, -15, -5))
	t(0,-2,-5,-3,(-4, -3, -5))
	t(0,-2,-5,0,(-1, -1, -5))
	t(0,-2,-5,1,(0, -1, -5))
	t(0,-2,-5,5,(0, 3, -5))
	t(0,-2,-5,10,(0, 8, -5))
	t(0,-2,-5,100,(0, 98, -5))
	t(0,-2,-3,-100,(-101, -100, -3))
	t(0,-2,-3,-15,(-16, -15, -3))
	t(0,-2,-3,-3,(-4, -3, -3))
	t(0,-2,-3,0,(-1, -1, -3))
	t(0,-2,-3,1,(0, -1, -3))
	t(0,-2,-3,5,(0, 3, -3))
	t(0,-2,-3,10,(0, 8, -3))
	t(0,-2,-3,100,(0, 98, -3))
	t(0,-2,-1,-100,(-101, -100, -1))
	t(0,-2,-1,-15,(-16, -15, -1))
	t(0,-2,-1,-3,(-4, -3, -1))
	t(0,-2,-1,0,(-1, -1, -1))
	t(0,-2,-1,1,(0, -1, -1))
	t(0,-2,-1,5,(0, 3, -1))
	t(0,-2,-1,10,(0, 8, -1))
	t(0,-2,-1,100,(0, 98, -1))
	t(0,-2,1,-100,(-100, -100, 1))
	t(0,-2,1,-15,(-15, -15, 1))
	t(0,-2,1,-3,(-3, -3, 1))
	t(0,-2,1,0,(0, -1, 1))
	t(0,-2,1,1,(0, -1, 1))
	t(0,-2,1,5,(0, 3, 1))
	t(0,-2,1,10,(0, 8, 1))
	t(0,-2,1,100,(0, 98, 1))
	t(0,-2,5,-100,(-100, -100, 5))
	t(0,-2,5,-15,(-15, -15, 5))
	t(0,-2,5,-3,(-3, -3, 5))
	t(0,-2,5,0,(0, -1, 5))
	t(0,-2,5,1,(0, -1, 5))
	t(0,-2,5,5,(0, 3, 5))
	t(0,-2,5,10,(0, 8, 5))
	t(0,-2,5,100,(0, 98, 5))
	t(0,-2,20,-100,(-100, -100, 20))
	t(0,-2,20,-15,(-15, -15, 20))
	t(0,-2,20,-3,(-3, -3, 20))
	t(0,-2,20,0,(0, -1, 20))
	t(0,-2,20,1,(0, -1, 20))
	t(0,-2,20,5,(0, 3, 20))
	t(0,-2,20,10,(0, 8, 20))
	t(0,-2,20,100,(0, 98, 20))
	t(0,0,-5,-100,(-101, -100, -5))
	t(0,0,-5,-15,(-16, -15, -5))
	t(0,0,-5,-3,(-4, -3, -5))
	t(0,0,-5,0,(-1, 0, -5))
	t(0,0,-5,1,(0, 0, -5))
	t(0,0,-5,5,(0, 0, -5))
	t(0,0,-5,10,(0, 0, -5))
	t(0,0,-5,100,(0, 0, -5))
	t(0,0,-3,-100,(-101, -100, -3))
	t(0,0,-3,-15,(-16, -15, -3))
	t(0,0,-3,-3,(-4, -3, -3))
	t(0,0,-3,0,(-1, 0, -3))
	t(0,0,-3,1,(0, 0, -3))
	t(0,0,-3,5,(0, 0, -3))
	t(0,0,-3,10,(0, 0, -3))
	t(0,0,-3,100,(0, 0, -3))
	t(0,0,-1,-100,(-101, -100, -1))
	t(0,0,-1,-15,(-16, -15, -1))
	t(0,0,-1,-3,(-4, -3, -1))
	t(0,0,-1,0,(-1, 0, -1))
	t(0,0,-1,1,(0, 0, -1))
	t(0,0,-1,5,(0, 0, -1))
	t(0,0,-1,10,(0, 0, -1))
	t(0,0,-1,100,(0, 0, -1))
	t(0,0,1,-100,(-100, -100, 1))
	t(0,0,1,-15,(-15, -15, 1))
	t(0,0,1,-3,(-3, -3, 1))
	t(0,0,1,0,(0, 0, 1))
	t(0,0,1,1,(0, 0, 1))
	t(0,0,1,5,(0, 0, 1))
	t(0,0,1,10,(0, 0, 1))
	t(0,0,1,100,(0, 0, 1))
	t(0,0,5,-100,(-100, -100, 5))
	t(0,0,5,-15,(-15, -15, 5))
	t(0,0,5,-3,(-3, -3, 5))
	t(0,0,5,0,(0, 0, 5))
	t(0,0,5,1,(0, 0, 5))
	t(0,0,5,5,(0, 0, 5))
	t(0,0,5,10,(0, 0, 5))
	t(0,0,5,100,(0, 0, 5))
	t(0,0,20,-100,(-100, -100, 20))
	t(0,0,20,-15,(-15, -15, 20))
	t(0,0,20,-3,(-3, -3, 20))
	t(0,0,20,0,(0, 0, 20))
	t(0,0,20,1,(0, 0, 20))
	t(0,0,20,5,(0, 0, 20))
	t(0,0,20,10,(0, 0, 20))
	t(0,0,20,100,(0, 0, 20))
	t(0,1,-5,-100,(-101, -100, -5))
	t(0,1,-5,-15,(-16, -15, -5))
	t(0,1,-5,-3,(-4, -3, -5))
	t(0,1,-5,0,(-1, 0, -5))
	t(0,1,-5,1,(0, 1, -5))
	t(0,1,-5,5,(0, 1, -5))
	t(0,1,-5,10,(0, 1, -5))
	t(0,1,-5,100,(0, 1, -5))
	t(0,1,-3,-100,(-101, -100, -3))
	t(0,1,-3,-15,(-16, -15, -3))
	t(0,1,-3,-3,(-4, -3, -3))
	t(0,1,-3,0,(-1, 0, -3))
	t(0,1,-3,1,(0, 1, -3))
	t(0,1,-3,5,(0, 1, -3))
	t(0,1,-3,10,(0, 1, -3))
	t(0,1,-3,100,(0, 1, -3))
	t(0,1,-1,-100,(-101, -100, -1))
	t(0,1,-1,-15,(-16, -15, -1))
	t(0,1,-1,-3,(-4, -3, -1))
	t(0,1,-1,0,(-1, 0, -1))
	t(0,1,-1,1,(0, 1, -1))
	t(0,1,-1,5,(0, 1, -1))
	t(0,1,-1,10,(0, 1, -1))
	t(0,1,-1,100,(0, 1, -1))
	t(0,1,1,-100,(-100, -100, 1))
	t(0,1,1,-15,(-15, -15, 1))
	t(0,1,1,-3,(-3, -3, 1))
	t(0,1,1,0,(0, 0, 1))
	t(0,1,1,1,(0, 1, 1))
	t(0,1,1,5,(0, 1, 1))
	t(0,1,1,10,(0, 1, 1))
	t(0,1,1,100,(0, 1, 1))
	t(0,1,5,-100,(-100, -100, 5))
	t(0,1,5,-15,(-15, -15, 5))
	t(0,1,5,-3,(-3, -3, 5))
	t(0,1,5,0,(0, 0, 5))
	t(0,1,5,1,(0, 1, 5))
	t(0,1,5,5,(0, 1, 5))
	t(0,1,5,10,(0, 1, 5))
	t(0,1,5,100,(0, 1, 5))
	t(0,1,20,-100,(-100, -100, 20))
	t(0,1,20,-15,(-15, -15, 20))
	t(0,1,20,-3,(-3, -3, 20))
	t(0,1,20,0,(0, 0, 20))
	t(0,1,20,1,(0, 1, 20))
	t(0,1,20,5,(0, 1, 20))
	t(0,1,20,10,(0, 1, 20))
	t(0,1,20,100,(0, 1, 20))
	t(0,6,-5,-100,(-101, -100, -5))
	t(0,6,-5,-15,(-16, -15, -5))
	t(0,6,-5,-3,(-4, -3, -5))
	t(0,6,-5,0,(-1, 0, -5))
	t(0,6,-5,1,(0, 1, -5))
	t(0,6,-5,5,(0, 5, -5))
	t(0,6,-5,10,(0, 6, -5))
	t(0,6,-5,100,(0, 6, -5))
	t(0,6,-3,-100,(-101, -100, -3))
	t(0,6,-3,-15,(-16, -15, -3))
	t(0,6,-3,-3,(-4, -3, -3))
	t(0,6,-3,0,(-1, 0, -3))
	t(0,6,-3,1,(0, 1, -3))
	t(0,6,-3,5,(0, 5, -3))
	t(0,6,-3,10,(0, 6, -3))
	t(0,6,-3,100,(0, 6, -3))
	t(0,6,-1,-100,(-101, -100, -1))
	t(0,6,-1,-15,(-16, -15, -1))
	t(0,6,-1,-3,(-4, -3, -1))
	t(0,6,-1,0,(-1, 0, -1))
	t(0,6,-1,1,(0, 1, -1))
	t(0,6,-1,5,(0, 5, -1))
	t(0,6,-1,10,(0, 6, -1))
	t(0,6,-1,100,(0, 6, -1))
	t(0,6,1,-100,(-100, -100, 1))
	t(0,6,1,-15,(-15, -15, 1))
	t(0,6,1,-3,(-3, -3, 1))
	t(0,6,1,0,(0, 0, 1))
	t(0,6,1,1,(0, 1, 1))
	t(0,6,1,5,(0, 5, 1))
	t(0,6,1,10,(0, 6, 1))
	t(0,6,1,100,(0, 6, 1))
	t(0,6,5,-100,(-100, -100, 5))
	t(0,6,5,-15,(-15, -15, 5))
	t(0,6,5,-3,(-3, -3, 5))
	t(0,6,5,0,(0, 0, 5))
	t(0,6,5,1,(0, 1, 5))
	t(0,6,5,5,(0, 5, 5))
	t(0,6,5,10,(0, 6, 5))
	t(0,6,5,100,(0, 6, 5))
	t(0,6,20,-100,(-100, -100, 20))
	t(0,6,20,-15,(-15, -15, 20))
	t(0,6,20,-3,(-3, -3, 20))
	t(0,6,20,0,(0, 0, 20))
	t(0,6,20,1,(0, 1, 20))
	t(0,6,20,5,(0, 5, 20))
	t(0,6,20,10,(0, 6, 20))
	t(0,6,20,100,(0, 6, 20))
	t(0,10,-5,-100,(-101, -100, -5))
	t(0,10,-5,-15,(-16, -15, -5))
	t(0,10,-5,-3,(-4, -3, -5))
	t(0,10,-5,0,(-1, 0, -5))
	t(0,10,-5,1,(0, 1, -5))
	t(0,10,-5,5,(0, 5, -5))
	t(0,10,-5,10,(0, 10, -5))
	t(0,10,-5,100,(0, 10, -5))
	t(0,10,-3,-100,(-101, -100, -3))
	t(0,10,-3,-15,(-16, -15, -3))
	t(0,10,-3,-3,(-4, -3, -3))
	t(0,10,-3,0,(-1, 0, -3))
	t(0,10,-3,1,(0, 1, -3))
	t(0,10,-3,5,(0, 5, -3))
	t(0,10,-3,10,(0, 10, -3))
	t(0,10,-3,100,(0, 10, -3))
	t(0,10,-1,-100,(-101, -100, -1))
	t(0,10,-1,-15,(-16, -15, -1))
	t(0,10,-1,-3,(-4, -3, -1))
	t(0,10,-1,0,(-1, 0, -1))
	t(0,10,-1,1,(0, 1, -1))
	t(0,10,-1,5,(0, 5, -1))
	t(0,10,-1,10,(0, 10, -1))
	t(0,10,-1,100,(0, 10, -1))
	t(0,10,1,-100,(-100, -100, 1))
	t(0,10,1,-15,(-15, -15, 1))
	t(0,10,1,-3,(-3, -3, 1))
	t(0,10,1,0,(0, 0, 1))
	t(0,10,1,1,(0, 1, 1))
	t(0,10,1,5,(0, 5, 1))
	t(0,10,1,10,(0, 10, 1))
	t(0,10,1,100,(0, 10, 1))
	t(0,10,5,-100,(-100, -100, 5))
	t(0,10,5,-15,(-15, -15, 5))
	t(0,10,5,-3,(-3, -3, 5))
	t(0,10,5,0,(0, 0, 5))
	t(0,10,5,1,(0, 1, 5))
	t(0,10,5,5,(0, 5, 5))
	t(0,10,5,10,(0, 10, 5))
	t(0,10,5,100,(0, 10, 5))
	t(0,10,20,-100,(-100, -100, 20))
	t(0,10,20,-15,(-15, -15, 20))
	t(0,10,20,-3,(-3, -3, 20))
	t(0,10,20,0,(0, 0, 20))
	t(0,10,20,1,(0, 1, 20))
	t(0,10,20,5,(0, 5, 20))
	t(0,10,20,10,(0, 10, 20))
	t(0,10,20,100,(0, 10, 20))
	t(1,None,-5,-100,(-101, -1, -5))
	t(1,None,-5,-15,(-16, -1, -5))
	t(1,None,-5,-3,(-4, -1, -5))
	t(1,None,-5,0,(-1, -1, -5))
	t(1,None,-5,1,(0, -1, -5))
	t(1,None,-5,5,(1, -1, -5))
	t(1,None,-5,10,(1, -1, -5))
	t(1,None,-5,100,(1, -1, -5))
	t(1,None,-3,-100,(-101, -1, -3))
	t(1,None,-3,-15,(-16, -1, -3))
	t(1,None,-3,-3,(-4, -1, -3))
	t(1,None,-3,0,(-1, -1, -3))
	t(1,None,-3,1,(0, -1, -3))
	t(1,None,-3,5,(1, -1, -3))
	t(1,None,-3,10,(1, -1, -3))
	t(1,None,-3,100,(1, -1, -3))
	t(1,None,-1,-100,(-101, -1, -1))
	t(1,None,-1,-15,(-16, -1, -1))
	t(1,None,-1,-3,(-4, -1, -1))
	t(1,None,-1,0,(-1, -1, -1))
	t(1,None,-1,1,(0, -1, -1))
	t(1,None,-1,5,(1, -1, -1))
	t(1,None,-1,10,(1, -1, -1))
	t(1,None,-1,100,(1, -1, -1))
	t(1,None,1,-100,(-100, -100, 1))
	t(1,None,1,-15,(-15, -15, 1))
	t(1,None,1,-3,(-3, -3, 1))
	t(1,None,1,0,(0, 0, 1))
	t(1,None,1,1,(1, 1, 1))
	t(1,None,1,5,(1, 5, 1))
	t(1,None,1,10,(1, 10, 1))
	t(1,None,1,100,(1, 100, 1))
	t(1,None,5,-100,(-100, -100, 5))
	t(1,None,5,-15,(-15, -15, 5))
	t(1,None,5,-3,(-3, -3, 5))
	t(1,None,5,0,(0, 0, 5))
	t(1,None,5,1,(1, 1, 5))
	t(1,None,5,5,(1, 5, 5))
	t(1,None,5,10,(1, 10, 5))
	t(1,None,5,100,(1, 100, 5))
	t(1,None,20,-100,(-100, -100, 20))
	t(1,None,20,-15,(-15, -15, 20))
	t(1,None,20,-3,(-3, -3, 20))
	t(1,None,20,0,(0, 0, 20))
	t(1,None,20,1,(1, 1, 20))
	t(1,None,20,5,(1, 5, 20))
	t(1,None,20,10,(1, 10, 20))
	t(1,None,20,100,(1, 100, 20))
	t(1,-7,-5,-100,(-101, -100, -5))
	t(1,-7,-5,-15,(-16, -15, -5))
	t(1,-7,-5,-3,(-4, -3, -5))
	t(1,-7,-5,0,(-1, -1, -5))
	t(1,-7,-5,1,(0, -1, -5))
	t(1,-7,-5,5,(1, -1, -5))
	t(1,-7,-5,10,(1, 3, -5))
	t(1,-7,-5,100,(1, 93, -5))
	t(1,-7,-3,-100,(-101, -100, -3))
	t(1,-7,-3,-15,(-16, -15, -3))
	t(1,-7,-3,-3,(-4, -3, -3))
	t(1,-7,-3,0,(-1, -1, -3))
	t(1,-7,-3,1,(0, -1, -3))
	t(1,-7,-3,5,(1, -1, -3))
	t(1,-7,-3,10,(1, 3, -3))
	t(1,-7,-3,100,(1, 93, -3))
	t(1,-7,-1,-100,(-101, -100, -1))
	t(1,-7,-1,-15,(-16, -15, -1))
	t(1,-7,-1,-3,(-4, -3, -1))
	t(1,-7,-1,0,(-1, -1, -1))
	t(1,-7,-1,1,(0, -1, -1))
	t(1,-7,-1,5,(1, -1, -1))
	t(1,-7,-1,10,(1, 3, -1))
	t(1,-7,-1,100,(1, 93, -1))
	t(1,-7,1,-100,(-100, -100, 1))
	t(1,-7,1,-15,(-15, -15, 1))
	t(1,-7,1,-3,(-3, -3, 1))
	t(1,-7,1,0,(0, -1, 1))
	t(1,-7,1,1,(1, -1, 1))
	t(1,-7,1,5,(1, -1, 1))
	t(1,-7,1,10,(1, 3, 1))
	t(1,-7,1,100,(1, 93, 1))
	t(1,-7,5,-100,(-100, -100, 5))
	t(1,-7,5,-15,(-15, -15, 5))
	t(1,-7,5,-3,(-3, -3, 5))
	t(1,-7,5,0,(0, -1, 5))
	t(1,-7,5,1,(1, -1, 5))
	t(1,-7,5,5,(1, -1, 5))
	t(1,-7,5,10,(1, 3, 5))
	t(1,-7,5,100,(1, 93, 5))
	t(1,-7,20,-100,(-100, -100, 20))
	t(1,-7,20,-15,(-15, -15, 20))
	t(1,-7,20,-3,(-3, -3, 20))
	t(1,-7,20,0,(0, -1, 20))
	t(1,-7,20,1,(1, -1, 20))
	t(1,-7,20,5,(1, -1, 20))
	t(1,-7,20,10,(1, 3, 20))
	t(1,-7,20,100,(1, 93, 20))
	t(1,-2,-5,-100,(-101, -100, -5))
	t(1,-2,-5,-15,(-16, -15, -5))
	t(1,-2,-5,-3,(-4, -3, -5))
	t(1,-2,-5,0,(-1, -1, -5))
	t(1,-2,-5,1,(0, -1, -5))
	t(1,-2,-5,5,(1, 3, -5))
	t(1,-2,-5,10,(1, 8, -5))
	t(1,-2,-5,100,(1, 98, -5))
	t(1,-2,-3,-100,(-101, -100, -3))
	t(1,-2,-3,-15,(-16, -15, -3))
	t(1,-2,-3,-3,(-4, -3, -3))
	t(1,-2,-3,0,(-1, -1, -3))
	t(1,-2,-3,1,(0, -1, -3))
	t(1,-2,-3,5,(1, 3, -3))
	t(1,-2,-3,10,(1, 8, -3))
	t(1,-2,-3,100,(1, 98, -3))
	t(1,-2,-1,-100,(-101, -100, -1))
	t(1,-2,-1,-15,(-16, -15, -1))
	t(1,-2,-1,-3,(-4, -3, -1))
	t(1,-2,-1,0,(-1, -1, -1))
	t(1,-2,-1,1,(0, -1, -1))
	t(1,-2,-1,5,(1, 3, -1))
	t(1,-2,-1,10,(1, 8, -1))
	t(1,-2,-1,100,(1, 98, -1))
	t(1,-2,1,-100,(-100, -100, 1))
	t(1,-2,1,-15,(-15, -15, 1))
	t(1,-2,1,-3,(-3, -3, 1))
	t(1,-2,1,0,(0, -1, 1))
	t(1,-2,1,1,(1, -1, 1))
	t(1,-2,1,5,(1, 3, 1))
	t(1,-2,1,10,(1, 8, 1))
	t(1,-2,1,100,(1, 98, 1))
	t(1,-2,5,-100,(-100, -100, 5))
	t(1,-2,5,-15,(-15, -15, 5))
	t(1,-2,5,-3,(-3, -3, 5))
	t(1,-2,5,0,(0, -1, 5))
	t(1,-2,5,1,(1, -1, 5))
	t(1,-2,5,5,(1, 3, 5))
	t(1,-2,5,10,(1, 8, 5))
	t(1,-2,5,100,(1, 98, 5))
	t(1,-2,20,-100,(-100, -100, 20))
	t(1,-2,20,-15,(-15, -15, 20))
	t(1,-2,20,-3,(-3, -3, 20))
	t(1,-2,20,0,(0, -1, 20))
	t(1,-2,20,1,(1, -1, 20))
	t(1,-2,20,5,(1, 3, 20))
	t(1,-2,20,10,(1, 8, 20))
	t(1,-2,20,100,(1, 98, 20))
	t(1,0,-5,-100,(-101, -100, -5))
	t(1,0,-5,-15,(-16, -15, -5))
	t(1,0,-5,-3,(-4, -3, -5))
	t(1,0,-5,0,(-1, 0, -5))
	t(1,0,-5,1,(0, 0, -5))
	t(1,0,-5,5,(1, 0, -5))
	t(1,0,-5,10,(1, 0, -5))
	t(1,0,-5,100,(1, 0, -5))
	t(1,0,-3,-100,(-101, -100, -3))
	t(1,0,-3,-15,(-16, -15, -3))
	t(1,0,-3,-3,(-4, -3, -3))
	t(1,0,-3,0,(-1, 0, -3))
	t(1,0,-3,1,(0, 0, -3))
	t(1,0,-3,5,(1, 0, -3))
	t(1,0,-3,10,(1, 0, -3))
	t(1,0,-3,100,(1, 0, -3))
	t(1,0,-1,-100,(-101, -100, -1))
	t(1,0,-1,-15,(-16, -15, -1))
	t(1,0,-1,-3,(-4, -3, -1))
	t(1,0,-1,0,(-1, 0, -1))
	t(1,0,-1,1,(0, 0, -1))
	t(1,0,-1,5,(1, 0, -1))
	t(1,0,-1,10,(1, 0, -1))
	t(1,0,-1,100,(1, 0, -1))
	t(1,0,1,-100,(-100, -100, 1))
	t(1,0,1,-15,(-15, -15, 1))
	t(1,0,1,-3,(-3, -3, 1))
	t(1,0,1,0,(0, 0, 1))
	t(1,0,1,1,(1, 0, 1))
	t(1,0,1,5,(1, 0, 1))
	t(1,0,1,10,(1, 0, 1))
	t(1,0,1,100,(1, 0, 1))
	t(1,0,5,-100,(-100, -100, 5))
	t(1,0,5,-15,(-15, -15, 5))
	t(1,0,5,-3,(-3, -3, 5))
	t(1,0,5,0,(0, 0, 5))
	t(1,0,5,1,(1, 0, 5))
	t(1,0,5,5,(1, 0, 5))
	t(1,0,5,10,(1, 0, 5))
	t(1,0,5,100,(1, 0, 5))
	t(1,0,20,-100,(-100, -100, 20))
	t(1,0,20,-15,(-15, -15, 20))
	t(1,0,20,-3,(-3, -3, 20))
	t(1,0,20,0,(0, 0, 20))
	t(1,0,20,1,(1, 0, 20))
	t(1,0,20,5,(1, 0, 20))
	t(1,0,20,10,(1, 0, 20))
	t(1,0,20,100,(1, 0, 20))
	t(1,1,-5,-100,(-101, -100, -5))
	t(1,1,-5,-15,(-16, -15, -5))
	t(1,1,-5,-3,(-4, -3, -5))
	t(1,1,-5,0,(-1, 0, -5))
	t(1,1,-5,1,(0, 1, -5))
	t(1,1,-5,5,(1, 1, -5))
	t(1,1,-5,10,(1, 1, -5))
	t(1,1,-5,100,(1, 1, -5))
	t(1,1,-3,-100,(-101, -100, -3))
	t(1,1,-3,-15,(-16, -15, -3))
	t(1,1,-3,-3,(-4, -3, -3))
	t(1,1,-3,0,(-1, 0, -3))
	t(1,1,-3,1,(0, 1, -3))
	t(1,1,-3,5,(1, 1, -3))
	t(1,1,-3,10,(1, 1, -3))
	t(1,1,-3,100,(1, 1, -3))
	t(1,1,-1,-100,(-101, -100, -1))
	t(1,1,-1,-15,(-16, -15, -1))
	t(1,1,-1,-3,(-4, -3, -1))
	t(1,1,-1,0,(-1, 0, -1))
	t(1,1,-1,1,(0, 1, -1))
	t(1,1,-1,5,(1, 1, -1))
	t(1,1,-1,10,(1, 1, -1))
	t(1,1,-1,100,(1, 1, -1))
	t(1,1,1,-100,(-100, -100, 1))
	t(1,1,1,-15,(-15, -15, 1))
	t(1,1,1,-3,(-3, -3, 1))
	t(1,1,1,0,(0, 0, 1))
	t(1,1,1,1,(1, 1, 1))
	t(1,1,1,5,(1, 1, 1))
	t(1,1,1,10,(1, 1, 1))
	t(1,1,1,100,(1, 1, 1))
	t(1,1,5,-100,(-100, -100, 5))
	t(1,1,5,-15,(-15, -15, 5))
	t(1,1,5,-3,(-3, -3, 5))
	t(1,1,5,0,(0, 0, 5))
	t(1,1,5,1,(1, 1, 5))
	t(1,1,5,5,(1, 1, 5))
	t(1,1,5,10,(1, 1, 5))
	t(1,1,5,100,(1, 1, 5))
	t(1,1,20,-100,(-100, -100, 20))
	t(1,1,20,-15,(-15, -15, 20))
	t(1,1,20,-3,(-3, -3, 20))
	t(1,1,20,0,(0, 0, 20))
	t(1,1,20,1,(1, 1, 20))
	t(1,1,20,5,(1, 1, 20))
	t(1,1,20,10,(1, 1, 20))
	t(1,1,20,100,(1, 1, 20))
	t(1,6,-5,-100,(-101, -100, -5))
	t(1,6,-5,-15,(-16, -15, -5))
	t(1,6,-5,-3,(-4, -3, -5))
	t(1,6,-5,0,(-1, 0, -5))
	t(1,6,-5,1,(0, 1, -5))
	t(1,6,-5,5,(1, 5, -5))
	t(1,6,-5,10,(1, 6, -5))
	t(1,6,-5,100,(1, 6, -5))
	t(1,6,-3,-100,(-101, -100, -3))
	t(1,6,-3,-15,(-16, -15, -3))
	t(1,6,-3,-3,(-4, -3, -3))
	t(1,6,-3,0,(-1, 0, -3))
	t(1,6,-3,1,(0, 1, -3))
	t(1,6,-3,5,(1, 5, -3))
	t(1,6,-3,10,(1, 6, -3))
	t(1,6,-3,100,(1, 6, -3))
	t(1,6,-1,-100,(-101, -100, -1))
	t(1,6,-1,-15,(-16, -15, -1))
	t(1,6,-1,-3,(-4, -3, -1))
	t(1,6,-1,0,(-1, 0, -1))
	t(1,6,-1,1,(0, 1, -1))
	t(1,6,-1,5,(1, 5, -1))
	t(1,6,-1,10,(1, 6, -1))
	t(1,6,-1,100,(1, 6, -1))
	t(1,6,1,-100,(-100, -100, 1))
	t(1,6,1,-15,(-15, -15, 1))
	t(1,6,1,-3,(-3, -3, 1))
	t(1,6,1,0,(0, 0, 1))
	t(1,6,1,1,(1, 1, 1))
	t(1,6,1,5,(1, 5, 1))
	t(1,6,1,10,(1, 6, 1))
	t(1,6,1,100,(1, 6, 1))
	t(1,6,5,-100,(-100, -100, 5))
	t(1,6,5,-15,(-15, -15, 5))
	t(1,6,5,-3,(-3, -3, 5))
	t(1,6,5,0,(0, 0, 5))
	t(1,6,5,1,(1, 1, 5))
	t(1,6,5,5,(1, 5, 5))
	t(1,6,5,10,(1, 6, 5))
	t(1,6,5,100,(1, 6, 5))
	t(1,6,20,-100,(-100, -100, 20))
	t(1,6,20,-15,(-15, -15, 20))
	t(1,6,20,-3,(-3, -3, 20))
	t(1,6,20,0,(0, 0, 20))
	t(1,6,20,1,(1, 1, 20))
	t(1,6,20,5,(1, 5, 20))
	t(1,6,20,10,(1, 6, 20))
	t(1,6,20,100,(1, 6, 20))
	t(1,10,-5,-100,(-101, -100, -5))
	t(1,10,-5,-15,(-16, -15, -5))
	t(1,10,-5,-3,(-4, -3, -5))
	t(1,10,-5,0,(-1, 0, -5))
	t(1,10,-5,1,(0, 1, -5))
	t(1,10,-5,5,(1, 5, -5))
	t(1,10,-5,10,(1, 10, -5))
	t(1,10,-5,100,(1, 10, -5))
	t(1,10,-3,-100,(-101, -100, -3))
	t(1,10,-3,-15,(-16, -15, -3))
	t(1,10,-3,-3,(-4, -3, -3))
	t(1,10,-3,0,(-1, 0, -3))
	t(1,10,-3,1,(0, 1, -3))
	t(1,10,-3,5,(1, 5, -3))
	t(1,10,-3,10,(1, 10, -3))
	t(1,10,-3,100,(1, 10, -3))
	t(1,10,-1,-100,(-101, -100, -1))
	t(1,10,-1,-15,(-16, -15, -1))
	t(1,10,-1,-3,(-4, -3, -1))
	t(1,10,-1,0,(-1, 0, -1))
	t(1,10,-1,1,(0, 1, -1))
	t(1,10,-1,5,(1, 5, -1))
	t(1,10,-1,10,(1, 10, -1))
	t(1,10,-1,100,(1, 10, -1))
	t(1,10,1,-100,(-100, -100, 1))
	t(1,10,1,-15,(-15, -15, 1))
	t(1,10,1,-3,(-3, -3, 1))
	t(1,10,1,0,(0, 0, 1))
	t(1,10,1,1,(1, 1, 1))
	t(1,10,1,5,(1, 5, 1))
	t(1,10,1,10,(1, 10, 1))
	t(1,10,1,100,(1, 10, 1))
	t(1,10,5,-100,(-100, -100, 5))
	t(1,10,5,-15,(-15, -15, 5))
	t(1,10,5,-3,(-3, -3, 5))
	t(1,10,5,0,(0, 0, 5))
	t(1,10,5,1,(1, 1, 5))
	t(1,10,5,5,(1, 5, 5))
	t(1,10,5,10,(1, 10, 5))
	t(1,10,5,100,(1, 10, 5))
	t(1,10,20,-100,(-100, -100, 20))
	t(1,10,20,-15,(-15, -15, 20))
	t(1,10,20,-3,(-3, -3, 20))
	t(1,10,20,0,(0, 0, 20))
	t(1,10,20,1,(1, 1, 20))
	t(1,10,20,5,(1, 5, 20))
	t(1,10,20,10,(1, 10, 20))
	t(1,10,20,100,(1, 10, 20))
	t(6,None,-5,-100,(-101, -1, -5))
	t(6,None,-5,-15,(-16, -1, -5))
	t(6,None,-5,-3,(-4, -1, -5))
	t(6,None,-5,0,(-1, -1, -5))
	t(6,None,-5,1,(0, -1, -5))
	t(6,None,-5,5,(4, -1, -5))
	t(6,None,-5,10,(6, -1, -5))
	t(6,None,-5,100,(6, -1, -5))
	t(6,None,-3,-100,(-101, -1, -3))
	t(6,None,-3,-15,(-16, -1, -3))
	t(6,None,-3,-3,(-4, -1, -3))
	t(6,None,-3,0,(-1, -1, -3))
	t(6,None,-3,1,(0, -1, -3))
	t(6,None,-3,5,(4, -1, -3))
	t(6,None,-3,10,(6, -1, -3))
	t(6,None,-3,100,(6, -1, -3))
	t(6,None,-1,-100,(-101, -1, -1))
	t(6,None,-1,-15,(-16, -1, -1))
	t(6,None,-1,-3,(-4, -1, -1))
	t(6,None,-1,0,(-1, -1, -1))
	t(6,None,-1,1,(0, -1, -1))
	t(6,None,-1,5,(4, -1, -1))
	t(6,None,-1,10,(6, -1, -1))
	t(6,None,-1,100,(6, -1, -1))
	t(6,None,1,-100,(-100, -100, 1))
	t(6,None,1,-15,(-15, -15, 1))
	t(6,None,1,-3,(-3, -3, 1))
	t(6,None,1,0,(0, 0, 1))
	t(6,None,1,1,(1, 1, 1))
	t(6,None,1,5,(5, 5, 1))
	t(6,None,1,10,(6, 10, 1))
	t(6,None,1,100,(6, 100, 1))
	t(6,None,5,-100,(-100, -100, 5))
	t(6,None,5,-15,(-15, -15, 5))
	t(6,None,5,-3,(-3, -3, 5))
	t(6,None,5,0,(0, 0, 5))
	t(6,None,5,1,(1, 1, 5))
	t(6,None,5,5,(5, 5, 5))
	t(6,None,5,10,(6, 10, 5))
	t(6,None,5,100,(6, 100, 5))
	t(6,None,20,-100,(-100, -100, 20))
	t(6,None,20,-15,(-15, -15, 20))
	t(6,None,20,-3,(-3, -3, 20))
	t(6,None,20,0,(0, 0, 20))
	t(6,None,20,1,(1, 1, 20))
	t(6,None,20,5,(5, 5, 20))
	t(6,None,20,10,(6, 10, 20))
	t(6,None,20,100,(6, 100, 20))
	t(6,-7,-5,-100,(-101, -100, -5))
	t(6,-7,-5,-15,(-16, -15, -5))
	t(6,-7,-5,-3,(-4, -3, -5))
	t(6,-7,-5,0,(-1, -1, -5))
	t(6,-7,-5,1,(0, -1, -5))
	t(6,-7,-5,5,(4, -1, -5))
	t(6,-7,-5,10,(6, 3, -5))
	t(6,-7,-5,100,(6, 93, -5))
	t(6,-7,-3,-100,(-101, -100, -3))
	t(6,-7,-3,-15,(-16, -15, -3))
	t(6,-7,-3,-3,(-4, -3, -3))
	t(6,-7,-3,0,(-1, -1, -3))
	t(6,-7,-3,1,(0, -1, -3))
	t(6,-7,-3,5,(4, -1, -3))
	t(6,-7,-3,10,(6, 3, -3))
	t(6,-7,-3,100,(6, 93, -3))
	t(6,-7,-1,-100,(-101, -100, -1))
	t(6,-7,-1,-15,(-16, -15, -1))
	t(6,-7,-1,-3,(-4, -3, -1))
	t(6,-7,-1,0,(-1, -1, -1))
	t(6,-7,-1,1,(0, -1, -1))
	t(6,-7,-1,5,(4, -1, -1))
	t(6,-7,-1,10,(6, 3, -1))
	t(6,-7,-1,100,(6, 93, -1))
	t(6,-7,1,-100,(-100, -100, 1))
	t(6,-7,1,-15,(-15, -15, 1))
	t(6,-7,1,-3,(-3, -3, 1))
	t(6,-7,1,0,(0, -1, 1))
	t(6,-7,1,1,(1, -1, 1))
	t(6,-7,1,5,(5, -1, 1))
	t(6,-7,1,10,(6, 3, 1))
	t(6,-7,1,100,(6, 93, 1))
	t(6,-7,5,-100,(-100, -100, 5))
	t(6,-7,5,-15,(-15, -15, 5))
	t(6,-7,5,-3,(-3, -3, 5))
	t(6,-7,5,0,(0, -1, 5))
	t(6,-7,5,1,(1, -1, 5))
	t(6,-7,5,5,(5, -1, 5))
	t(6,-7,5,10,(6, 3, 5))
	t(6,-7,5,100,(6, 93, 5))
	t(6,-7,20,-100,(-100, -100, 20))
	t(6,-7,20,-15,(-15, -15, 20))
	t(6,-7,20,-3,(-3, -3, 20))
	t(6,-7,20,0,(0, -1, 20))
	t(6,-7,20,1,(1, -1, 20))
	t(6,-7,20,5,(5, -1, 20))
	t(6,-7,20,10,(6, 3, 20))
	t(6,-7,20,100,(6, 93, 20))
	t(6,-2,-5,-100,(-101, -100, -5))
	t(6,-2,-5,-15,(-16, -15, -5))
	t(6,-2,-5,-3,(-4, -3, -5))
	t(6,-2,-5,0,(-1, -1, -5))
	t(6,-2,-5,1,(0, -1, -5))
	t(6,-2,-5,5,(4, 3, -5))
	t(6,-2,-5,10,(6, 8, -5))
	t(6,-2,-5,100,(6, 98, -5))
	t(6,-2,-3,-100,(-101, -100, -3))
	t(6,-2,-3,-15,(-16, -15, -3))
	t(6,-2,-3,-3,(-4, -3, -3))
	t(6,-2,-3,0,(-1, -1, -3))
	t(6,-2,-3,1,(0, -1, -3))
	t(6,-2,-3,5,(4, 3, -3))
	t(6,-2,-3,10,(6, 8, -3))
	t(6,-2,-3,100,(6, 98, -3))
	t(6,-2,-1,-100,(-101, -100, -1))
	t(6,-2,-1,-15,(-16, -15, -1))
	t(6,-2,-1,-3,(-4, -3, -1))
	t(6,-2,-1,0,(-1, -1, -1))
	t(6,-2,-1,1,(0, -1, -1))
	t(6,-2,-1,5,(4, 3, -1))
	t(6,-2,-1,10,(6, 8, -1))
	t(6,-2,-1,100,(6, 98, -1))
	t(6,-2,1,-100,(-100, -100, 1))
	t(6,-2,1,-15,(-15, -15, 1))
	t(6,-2,1,-3,(-3, -3, 1))
	t(6,-2,1,0,(0, -1, 1))
	t(6,-2,1,1,(1, -1, 1))
	t(6,-2,1,5,(5, 3, 1))
	t(6,-2,1,10,(6, 8, 1))
	t(6,-2,1,100,(6, 98, 1))
	t(6,-2,5,-100,(-100, -100, 5))
	t(6,-2,5,-15,(-15, -15, 5))
	t(6,-2,5,-3,(-3, -3, 5))
	t(6,-2,5,0,(0, -1, 5))
	t(6,-2,5,1,(1, -1, 5))
	t(6,-2,5,5,(5, 3, 5))
	t(6,-2,5,10,(6, 8, 5))
	t(6,-2,5,100,(6, 98, 5))
	t(6,-2,20,-100,(-100, -100, 20))
	t(6,-2,20,-15,(-15, -15, 20))
	t(6,-2,20,-3,(-3, -3, 20))
	t(6,-2,20,0,(0, -1, 20))
	t(6,-2,20,1,(1, -1, 20))
	t(6,-2,20,5,(5, 3, 20))
	t(6,-2,20,10,(6, 8, 20))
	t(6,-2,20,100,(6, 98, 20))
	t(6,0,-5,-100,(-101, -100, -5))
	t(6,0,-5,-15,(-16, -15, -5))
	t(6,0,-5,-3,(-4, -3, -5))
	t(6,0,-5,0,(-1, 0, -5))
	t(6,0,-5,1,(0, 0, -5))
	t(6,0,-5,5,(4, 0, -5))
	t(6,0,-5,10,(6, 0, -5))
	t(6,0,-5,100,(6, 0, -5))
	t(6,0,-3,-100,(-101, -100, -3))
	t(6,0,-3,-15,(-16, -15, -3))
	t(6,0,-3,-3,(-4, -3, -3))
	t(6,0,-3,0,(-1, 0, -3))
	t(6,0,-3,1,(0, 0, -3))
	t(6,0,-3,5,(4, 0, -3))
	t(6,0,-3,10,(6, 0, -3))
	t(6,0,-3,100,(6, 0, -3))
	t(6,0,-1,-100,(-101, -100, -1))
	t(6,0,-1,-15,(-16, -15, -1))
	t(6,0,-1,-3,(-4, -3, -1))
	t(6,0,-1,0,(-1, 0, -1))
	t(6,0,-1,1,(0, 0, -1))
	t(6,0,-1,5,(4, 0, -1))
	t(6,0,-1,10,(6, 0, -1))
	t(6,0,-1,100,(6, 0, -1))
	t(6,0,1,-100,(-100, -100, 1))
	t(6,0,1,-15,(-15, -15, 1))
	t(6,0,1,-3,(-3, -3, 1))
	t(6,0,1,0,(0, 0, 1))
	t(6,0,1,1,(1, 0, 1))
	t(6,0,1,5,(5, 0, 1))
	t(6,0,1,10,(6, 0, 1))
	t(6,0,1,100,(6, 0, 1))
	t(6,0,5,-100,(-100, -100, 5))
	t(6,0,5,-15,(-15, -15, 5))
	t(6,0,5,-3,(-3, -3, 5))
	t(6,0,5,0,(0, 0, 5))
	t(6,0,5,1,(1, 0, 5))
	t(6,0,5,5,(5, 0, 5))
	t(6,0,5,10,(6, 0, 5))
	t(6,0,5,100,(6, 0, 5))
	t(6,0,20,-100,(-100, -100, 20))
	t(6,0,20,-15,(-15, -15, 20))
	t(6,0,20,-3,(-3, -3, 20))
	t(6,0,20,0,(0, 0, 20))
	t(6,0,20,1,(1, 0, 20))
	t(6,0,20,5,(5, 0, 20))
	t(6,0,20,10,(6, 0, 20))
	t(6,0,20,100,(6, 0, 20))
	t(6,1,-5,-100,(-101, -100, -5))
	t(6,1,-5,-15,(-16, -15, -5))
	t(6,1,-5,-3,(-4, -3, -5))
	t(6,1,-5,0,(-1, 0, -5))
	t(6,1,-5,1,(0, 1, -5))
	t(6,1,-5,5,(4, 1, -5))
	t(6,1,-5,10,(6, 1, -5))
	t(6,1,-5,100,(6, 1, -5))
	t(6,1,-3,-100,(-101, -100, -3))
	t(6,1,-3,-15,(-16, -15, -3))
	t(6,1,-3,-3,(-4, -3, -3))
	t(6,1,-3,0,(-1, 0, -3))
	t(6,1,-3,1,(0, 1, -3))
	t(6,1,-3,5,(4, 1, -3))
	t(6,1,-3,10,(6, 1, -3))
	t(6,1,-3,100,(6, 1, -3))
	t(6,1,-1,-100,(-101, -100, -1))
	t(6,1,-1,-15,(-16, -15, -1))
	t(6,1,-1,-3,(-4, -3, -1))
	t(6,1,-1,0,(-1, 0, -1))
	t(6,1,-1,1,(0, 1, -1))
	t(6,1,-1,5,(4, 1, -1))
	t(6,1,-1,10,(6, 1, -1))
	t(6,1,-1,100,(6, 1, -1))
	t(6,1,1,-100,(-100, -100, 1))
	t(6,1,1,-15,(-15, -15, 1))
	t(6,1,1,-3,(-3, -3, 1))
	t(6,1,1,0,(0, 0, 1))
	t(6,1,1,1,(1, 1, 1))
	t(6,1,1,5,(5, 1, 1))
	t(6,1,1,10,(6, 1, 1))
	t(6,1,1,100,(6, 1, 1))
	t(6,1,5,-100,(-100, -100, 5))
	t(6,1,5,-15,(-15, -15, 5))
	t(6,1,5,-3,(-3, -3, 5))
	t(6,1,5,0,(0, 0, 5))
	t(6,1,5,1,(1, 1, 5))
	t(6,1,5,5,(5, 1, 5))
	t(6,1,5,10,(6, 1, 5))
	t(6,1,5,100,(6, 1, 5))
	t(6,1,20,-100,(-100, -100, 20))
	t(6,1,20,-15,(-15, -15, 20))
	t(6,1,20,-3,(-3, -3, 20))
	t(6,1,20,0,(0, 0, 20))
	t(6,1,20,1,(1, 1, 20))
	t(6,1,20,5,(5, 1, 20))
	t(6,1,20,10,(6, 1, 20))
	t(6,1,20,100,(6, 1, 20))
	t(6,6,-5,-100,(-101, -100, -5))
	t(6,6,-5,-15,(-16, -15, -5))
	t(6,6,-5,-3,(-4, -3, -5))
	t(6,6,-5,0,(-1, 0, -5))
	t(6,6,-5,1,(0, 1, -5))
	t(6,6,-5,5,(4, 5, -5))
	t(6,6,-5,10,(6, 6, -5))
	t(6,6,-5,100,(6, 6, -5))
	t(6,6,-3,-100,(-101, -100, -3))
	t(6,6,-3,-15,(-16, -15, -3))
	t(6,6,-3,-3,(-4, -3, -3))
	t(6,6,-3,0,(-1, 0, -3))
	t(6,6,-3,1,(0, 1, -3))
	t(6,6,-3,5,(4, 5, -3))
	t(6,6,-3,10,(6, 6, -3))
	t(6,6,-3,100,(6, 6, -3))
	t(6,6,-1,-100,(-101, -100, -1))
	t(6,6,-1,-15,(-16, -15, -1))
	t(6,6,-1,-3,(-4, -3, -1))
	t(6,6,-1,0,(-1, 0, -1))
	t(6,6,-1,1,(0, 1, -1))
	t(6,6,-1,5,(4, 5, -1))
	t(6,6,-1,10,(6, 6, -1))
	t(6,6,-1,100,(6, 6, -1))
	t(6,6,1,-100,(-100, -100, 1))
	t(6,6,1,-15,(-15, -15, 1))
	t(6,6,1,-3,(-3, -3, 1))
	t(6,6,1,0,(0, 0, 1))
	t(6,6,1,1,(1, 1, 1))
	t(6,6,1,5,(5, 5, 1))
	t(6,6,1,10,(6, 6, 1))
	t(6,6,1,100,(6, 6, 1))
	t(6,6,5,-100,(-100, -100, 5))
	t(6,6,5,-15,(-15, -15, 5))
	t(6,6,5,-3,(-3, -3, 5))
	t(6,6,5,0,(0, 0, 5))
	t(6,6,5,1,(1, 1, 5))
	t(6,6,5,5,(5, 5, 5))
	t(6,6,5,10,(6, 6, 5))
	t(6,6,5,100,(6, 6, 5))
	t(6,6,20,-100,(-100, -100, 20))
	t(6,6,20,-15,(-15, -15, 20))
	t(6,6,20,-3,(-3, -3, 20))
	t(6,6,20,0,(0, 0, 20))
	t(6,6,20,1,(1, 1, 20))
	t(6,6,20,5,(5, 5, 20))
	t(6,6,20,10,(6, 6, 20))
	t(6,6,20,100,(6, 6, 20))
	t(6,10,-5,-100,(-101, -100, -5))
	t(6,10,-5,-15,(-16, -15, -5))
	t(6,10,-5,-3,(-4, -3, -5))
	t(6,10,-5,0,(-1, 0, -5))
	t(6,10,-5,1,(0, 1, -5))
	t(6,10,-5,5,(4, 5, -5))
	t(6,10,-5,10,(6, 10, -5))
	t(6,10,-5,100,(6, 10, -5))
	t(6,10,-3,-100,(-101, -100, -3))
	t(6,10,-3,-15,(-16, -15, -3))
	t(6,10,-3,-3,(-4, -3, -3))
	t(6,10,-3,0,(-1, 0, -3))
	t(6,10,-3,1,(0, 1, -3))
	t(6,10,-3,5,(4, 5, -3))
	t(6,10,-3,10,(6, 10, -3))
	t(6,10,-3,100,(6, 10, -3))
	t(6,10,-1,-100,(-101, -100, -1))
	t(6,10,-1,-15,(-16, -15, -1))
	t(6,10,-1,-3,(-4, -3, -1))
	t(6,10,-1,0,(-1, 0, -1))
	t(6,10,-1,1,(0, 1, -1))
	t(6,10,-1,5,(4, 5, -1))
	t(6,10,-1,10,(6, 10, -1))
	t(6,10,-1,100,(6, 10, -1))
	t(6,10,1,-100,(-100, -100, 1))
	t(6,10,1,-15,(-15, -15, 1))
	t(6,10,1,-3,(-3, -3, 1))
	t(6,10,1,0,(0, 0, 1))
	t(6,10,1,1,(1, 1, 1))
	t(6,10,1,5,(5, 5, 1))
	t(6,10,1,10,(6, 10, 1))
	t(6,10,1,100,(6, 10, 1))

def c():
	t(6,10,5,-100,(-100, -100, 5))
	t(6,10,5,-15,(-15, -15, 5))
	t(6,10,5,-3,(-3, -3, 5))
	t(6,10,5,0,(0, 0, 5))
	t(6,10,5,1,(1, 1, 5))
	t(6,10,5,5,(5, 5, 5))
	t(6,10,5,10,(6, 10, 5))
	t(6,10,5,100,(6, 10, 5))
	t(6,10,20,-100,(-100, -100, 20))
	t(6,10,20,-15,(-15, -15, 20))
	t(6,10,20,-3,(-3, -3, 20))
	t(6,10,20,0,(0, 0, 20))
	t(6,10,20,1,(1, 1, 20))
	t(6,10,20,5,(5, 5, 20))
	t(6,10,20,10,(6, 10, 20))
	t(6,10,20,100,(6, 10, 20))
	t(10,None,-5,-100,(-101, -1, -5))
	t(10,None,-5,-15,(-16, -1, -5))
	t(10,None,-5,-3,(-4, -1, -5))
	t(10,None,-5,0,(-1, -1, -5))
	t(10,None,-5,1,(0, -1, -5))
	t(10,None,-5,5,(4, -1, -5))
	t(10,None,-5,10,(9, -1, -5))
	t(10,None,-5,100,(10, -1, -5))
	t(10,None,-3,-100,(-101, -1, -3))
	t(10,None,-3,-15,(-16, -1, -3))
	t(10,None,-3,-3,(-4, -1, -3))
	t(10,None,-3,0,(-1, -1, -3))
	t(10,None,-3,1,(0, -1, -3))
	t(10,None,-3,5,(4, -1, -3))
	t(10,None,-3,10,(9, -1, -3))
	t(10,None,-3,100,(10, -1, -3))
	t(10,None,-1,-100,(-101, -1, -1))
	t(10,None,-1,-15,(-16, -1, -1))
	t(10,None,-1,-3,(-4, -1, -1))
	t(10,None,-1,0,(-1, -1, -1))
	t(10,None,-1,1,(0, -1, -1))
	t(10,None,-1,5,(4, -1, -1))
	t(10,None,-1,10,(9, -1, -1))
	t(10,None,-1,100,(10, -1, -1))
	t(10,None,1,-100,(-100, -100, 1))
	t(10,None,1,-15,(-15, -15, 1))
	t(10,None,1,-3,(-3, -3, 1))
	t(10,None,1,0,(0, 0, 1))
	t(10,None,1,1,(1, 1, 1))
	t(10,None,1,5,(5, 5, 1))
	t(10,None,1,10,(10, 10, 1))
	t(10,None,1,100,(10, 100, 1))
	t(10,None,5,-100,(-100, -100, 5))
	t(10,None,5,-15,(-15, -15, 5))
	t(10,None,5,-3,(-3, -3, 5))
	t(10,None,5,0,(0, 0, 5))
	t(10,None,5,1,(1, 1, 5))
	t(10,None,5,5,(5, 5, 5))
	t(10,None,5,10,(10, 10, 5))
	t(10,None,5,100,(10, 100, 5))
	t(10,None,20,-100,(-100, -100, 20))
	t(10,None,20,-15,(-15, -15, 20))
	t(10,None,20,-3,(-3, -3, 20))
	t(10,None,20,0,(0, 0, 20))
	t(10,None,20,1,(1, 1, 20))
	t(10,None,20,5,(5, 5, 20))
	t(10,None,20,10,(10, 10, 20))
	t(10,None,20,100,(10, 100, 20))
	t(10,-7,-5,-100,(-101, -100, -5))
	t(10,-7,-5,-15,(-16, -15, -5))
	t(10,-7,-5,-3,(-4, -3, -5))
	t(10,-7,-5,0,(-1, -1, -5))
	t(10,-7,-5,1,(0, -1, -5))
	t(10,-7,-5,5,(4, -1, -5))
	t(10,-7,-5,10,(9, 3, -5))
	t(10,-7,-5,100,(10, 93, -5))
	t(10,-7,-3,-100,(-101, -100, -3))
	t(10,-7,-3,-15,(-16, -15, -3))
	t(10,-7,-3,-3,(-4, -3, -3))
	t(10,-7,-3,0,(-1, -1, -3))
	t(10,-7,-3,1,(0, -1, -3))
	t(10,-7,-3,5,(4, -1, -3))
	t(10,-7,-3,10,(9, 3, -3))
	t(10,-7,-3,100,(10, 93, -3))
	t(10,-7,-1,-100,(-101, -100, -1))
	t(10,-7,-1,-15,(-16, -15, -1))
	t(10,-7,-1,-3,(-4, -3, -1))
	t(10,-7,-1,0,(-1, -1, -1))
	t(10,-7,-1,1,(0, -1, -1))
	t(10,-7,-1,5,(4, -1, -1))
	t(10,-7,-1,10,(9, 3, -1))
	t(10,-7,-1,100,(10, 93, -1))
	t(10,-7,1,-100,(-100, -100, 1))
	t(10,-7,1,-15,(-15, -15, 1))
	t(10,-7,1,-3,(-3, -3, 1))
	t(10,-7,1,0,(0, -1, 1))
	t(10,-7,1,1,(1, -1, 1))
	t(10,-7,1,5,(5, -1, 1))
	t(10,-7,1,10,(10, 3, 1))
	t(10,-7,1,100,(10, 93, 1))
	t(10,-7,5,-100,(-100, -100, 5))
	t(10,-7,5,-15,(-15, -15, 5))
	t(10,-7,5,-3,(-3, -3, 5))
	t(10,-7,5,0,(0, -1, 5))
	t(10,-7,5,1,(1, -1, 5))
	t(10,-7,5,5,(5, -1, 5))
	t(10,-7,5,10,(10, 3, 5))
	t(10,-7,5,100,(10, 93, 5))
	t(10,-7,20,-100,(-100, -100, 20))
	t(10,-7,20,-15,(-15, -15, 20))
	t(10,-7,20,-3,(-3, -3, 20))
	t(10,-7,20,0,(0, -1, 20))
	t(10,-7,20,1,(1, -1, 20))
	t(10,-7,20,5,(5, -1, 20))
	t(10,-7,20,10,(10, 3, 20))
	t(10,-7,20,100,(10, 93, 20))
	t(10,-2,-5,-100,(-101, -100, -5))
	t(10,-2,-5,-15,(-16, -15, -5))
	t(10,-2,-5,-3,(-4, -3, -5))
	t(10,-2,-5,0,(-1, -1, -5))
	t(10,-2,-5,1,(0, -1, -5))
	t(10,-2,-5,5,(4, 3, -5))
	t(10,-2,-5,10,(9, 8, -5))
	t(10,-2,-5,100,(10, 98, -5))
	t(10,-2,-3,-100,(-101, -100, -3))
	t(10,-2,-3,-15,(-16, -15, -3))
	t(10,-2,-3,-3,(-4, -3, -3))
	t(10,-2,-3,0,(-1, -1, -3))
	t(10,-2,-3,1,(0, -1, -3))
	t(10,-2,-3,5,(4, 3, -3))
	t(10,-2,-3,10,(9, 8, -3))
	t(10,-2,-3,100,(10, 98, -3))
	t(10,-2,-1,-100,(-101, -100, -1))
	t(10,-2,-1,-15,(-16, -15, -1))
	t(10,-2,-1,-3,(-4, -3, -1))
	t(10,-2,-1,0,(-1, -1, -1))
	t(10,-2,-1,1,(0, -1, -1))
	t(10,-2,-1,5,(4, 3, -1))
	t(10,-2,-1,10,(9, 8, -1))
	t(10,-2,-1,100,(10, 98, -1))
	t(10,-2,1,-100,(-100, -100, 1))
	t(10,-2,1,-15,(-15, -15, 1))
	t(10,-2,1,-3,(-3, -3, 1))
	t(10,-2,1,0,(0, -1, 1))
	t(10,-2,1,1,(1, -1, 1))
	t(10,-2,1,5,(5, 3, 1))
	t(10,-2,1,10,(10, 8, 1))
	t(10,-2,1,100,(10, 98, 1))
	t(10,-2,5,-100,(-100, -100, 5))
	t(10,-2,5,-15,(-15, -15, 5))
	t(10,-2,5,-3,(-3, -3, 5))
	t(10,-2,5,0,(0, -1, 5))
	t(10,-2,5,1,(1, -1, 5))
	t(10,-2,5,5,(5, 3, 5))
	t(10,-2,5,10,(10, 8, 5))
	t(10,-2,5,100,(10, 98, 5))
	t(10,-2,20,-100,(-100, -100, 20))
	t(10,-2,20,-15,(-15, -15, 20))
	t(10,-2,20,-3,(-3, -3, 20))
	t(10,-2,20,0,(0, -1, 20))
	t(10,-2,20,1,(1, -1, 20))
	t(10,-2,20,5,(5, 3, 20))
	t(10,-2,20,10,(10, 8, 20))
	t(10,-2,20,100,(10, 98, 20))
	t(10,0,-5,-100,(-101, -100, -5))
	t(10,0,-5,-15,(-16, -15, -5))
	t(10,0,-5,-3,(-4, -3, -5))
	t(10,0,-5,0,(-1, 0, -5))
	t(10,0,-5,1,(0, 0, -5))
	t(10,0,-5,5,(4, 0, -5))
	t(10,0,-5,10,(9, 0, -5))
	t(10,0,-5,100,(10, 0, -5))
	t(10,0,-3,-100,(-101, -100, -3))
	t(10,0,-3,-15,(-16, -15, -3))
	t(10,0,-3,-3,(-4, -3, -3))
	t(10,0,-3,0,(-1, 0, -3))
	t(10,0,-3,1,(0, 0, -3))
	t(10,0,-3,5,(4, 0, -3))
	t(10,0,-3,10,(9, 0, -3))
	t(10,0,-3,100,(10, 0, -3))
	t(10,0,-1,-100,(-101, -100, -1))
	t(10,0,-1,-15,(-16, -15, -1))
	t(10,0,-1,-3,(-4, -3, -1))
	t(10,0,-1,0,(-1, 0, -1))
	t(10,0,-1,1,(0, 0, -1))
	t(10,0,-1,5,(4, 0, -1))
	t(10,0,-1,10,(9, 0, -1))
	t(10,0,-1,100,(10, 0, -1))
	t(10,0,1,-100,(-100, -100, 1))
	t(10,0,1,-15,(-15, -15, 1))
	t(10,0,1,-3,(-3, -3, 1))
	t(10,0,1,0,(0, 0, 1))
	t(10,0,1,1,(1, 0, 1))
	t(10,0,1,5,(5, 0, 1))
	t(10,0,1,10,(10, 0, 1))
	t(10,0,1,100,(10, 0, 1))
	t(10,0,5,-100,(-100, -100, 5))
	t(10,0,5,-15,(-15, -15, 5))
	t(10,0,5,-3,(-3, -3, 5))
	t(10,0,5,0,(0, 0, 5))
	t(10,0,5,1,(1, 0, 5))
	t(10,0,5,5,(5, 0, 5))
	t(10,0,5,10,(10, 0, 5))
	t(10,0,5,100,(10, 0, 5))
	t(10,0,20,-100,(-100, -100, 20))
	t(10,0,20,-15,(-15, -15, 20))
	t(10,0,20,-3,(-3, -3, 20))
	t(10,0,20,0,(0, 0, 20))
	t(10,0,20,1,(1, 0, 20))
	t(10,0,20,5,(5, 0, 20))
	t(10,0,20,10,(10, 0, 20))
	t(10,0,20,100,(10, 0, 20))
	t(10,1,-5,-100,(-101, -100, -5))
	t(10,1,-5,-15,(-16, -15, -5))
	t(10,1,-5,-3,(-4, -3, -5))
	t(10,1,-5,0,(-1, 0, -5))
	t(10,1,-5,1,(0, 1, -5))
	t(10,1,-5,5,(4, 1, -5))
	t(10,1,-5,10,(9, 1, -5))
	t(10,1,-5,100,(10, 1, -5))
	t(10,1,-3,-100,(-101, -100, -3))
	t(10,1,-3,-15,(-16, -15, -3))
	t(10,1,-3,-3,(-4, -3, -3))
	t(10,1,-3,0,(-1, 0, -3))
	t(10,1,-3,1,(0, 1, -3))
	t(10,1,-3,5,(4, 1, -3))
	t(10,1,-3,10,(9, 1, -3))
	t(10,1,-3,100,(10, 1, -3))
	t(10,1,-1,-100,(-101, -100, -1))
	t(10,1,-1,-15,(-16, -15, -1))
	t(10,1,-1,-3,(-4, -3, -1))
	t(10,1,-1,0,(-1, 0, -1))
	t(10,1,-1,1,(0, 1, -1))
	t(10,1,-1,5,(4, 1, -1))
	t(10,1,-1,10,(9, 1, -1))
	t(10,1,-1,100,(10, 1, -1))
	t(10,1,1,-100,(-100, -100, 1))
	t(10,1,1,-15,(-15, -15, 1))
	t(10,1,1,-3,(-3, -3, 1))
	t(10,1,1,0,(0, 0, 1))
	t(10,1,1,1,(1, 1, 1))
	t(10,1,1,5,(5, 1, 1))
	t(10,1,1,10,(10, 1, 1))
	t(10,1,1,100,(10, 1, 1))
	t(10,1,5,-100,(-100, -100, 5))
	t(10,1,5,-15,(-15, -15, 5))
	t(10,1,5,-3,(-3, -3, 5))
	t(10,1,5,0,(0, 0, 5))
	t(10,1,5,1,(1, 1, 5))
	t(10,1,5,5,(5, 1, 5))
	t(10,1,5,10,(10, 1, 5))
	t(10,1,5,100,(10, 1, 5))
	t(10,1,20,-100,(-100, -100, 20))
	t(10,1,20,-15,(-15, -15, 20))
	t(10,1,20,-3,(-3, -3, 20))
	t(10,1,20,0,(0, 0, 20))
	t(10,1,20,1,(1, 1, 20))
	t(10,1,20,5,(5, 1, 20))
	t(10,1,20,10,(10, 1, 20))
	t(10,1,20,100,(10, 1, 20))
	t(10,6,-5,-100,(-101, -100, -5))
	t(10,6,-5,-15,(-16, -15, -5))
	t(10,6,-5,-3,(-4, -3, -5))
	t(10,6,-5,0,(-1, 0, -5))
	t(10,6,-5,1,(0, 1, -5))
	t(10,6,-5,5,(4, 5, -5))
	t(10,6,-5,10,(9, 6, -5))
	t(10,6,-5,100,(10, 6, -5))
	t(10,6,-3,-100,(-101, -100, -3))
	t(10,6,-3,-15,(-16, -15, -3))
	t(10,6,-3,-3,(-4, -3, -3))
	t(10,6,-3,0,(-1, 0, -3))
	t(10,6,-3,1,(0, 1, -3))
	t(10,6,-3,5,(4, 5, -3))
	t(10,6,-3,10,(9, 6, -3))
	t(10,6,-3,100,(10, 6, -3))
	t(10,6,-1,-100,(-101, -100, -1))
	t(10,6,-1,-15,(-16, -15, -1))
	t(10,6,-1,-3,(-4, -3, -1))
	t(10,6,-1,0,(-1, 0, -1))
	t(10,6,-1,1,(0, 1, -1))
	t(10,6,-1,5,(4, 5, -1))
	t(10,6,-1,10,(9, 6, -1))
	t(10,6,-1,100,(10, 6, -1))
	t(10,6,1,-100,(-100, -100, 1))
	t(10,6,1,-15,(-15, -15, 1))
	t(10,6,1,-3,(-3, -3, 1))
	t(10,6,1,0,(0, 0, 1))
	t(10,6,1,1,(1, 1, 1))
	t(10,6,1,5,(5, 5, 1))
	t(10,6,1,10,(10, 6, 1))
	t(10,6,1,100,(10, 6, 1))
	t(10,6,5,-100,(-100, -100, 5))
	t(10,6,5,-15,(-15, -15, 5))
	t(10,6,5,-3,(-3, -3, 5))
	t(10,6,5,0,(0, 0, 5))
	t(10,6,5,1,(1, 1, 5))
	t(10,6,5,5,(5, 5, 5))
	t(10,6,5,10,(10, 6, 5))
	t(10,6,5,100,(10, 6, 5))
	t(10,6,20,-100,(-100, -100, 20))
	t(10,6,20,-15,(-15, -15, 20))
	t(10,6,20,-3,(-3, -3, 20))
	t(10,6,20,0,(0, 0, 20))
	t(10,6,20,1,(1, 1, 20))
	t(10,6,20,5,(5, 5, 20))
	t(10,6,20,10,(10, 6, 20))
	t(10,6,20,100,(10, 6, 20))
	t(10,10,-5,-100,(-101, -100, -5))
	t(10,10,-5,-15,(-16, -15, -5))
	t(10,10,-5,-3,(-4, -3, -5))
	t(10,10,-5,0,(-1, 0, -5))
	t(10,10,-5,1,(0, 1, -5))
	t(10,10,-5,5,(4, 5, -5))
	t(10,10,-5,10,(9, 10, -5))
	t(10,10,-5,100,(10, 10, -5))
	t(10,10,-3,-100,(-101, -100, -3))
	t(10,10,-3,-15,(-16, -15, -3))
	t(10,10,-3,-3,(-4, -3, -3))
	t(10,10,-3,0,(-1, 0, -3))
	t(10,10,-3,1,(0, 1, -3))
	t(10,10,-3,5,(4, 5, -3))
	t(10,10,-3,10,(9, 10, -3))
	t(10,10,-3,100,(10, 10, -3))
	t(10,10,-1,-100,(-101, -100, -1))
	t(10,10,-1,-15,(-16, -15, -1))
	t(10,10,-1,-3,(-4, -3, -1))
	t(10,10,-1,0,(-1, 0, -1))
	t(10,10,-1,1,(0, 1, -1))
	t(10,10,-1,5,(4, 5, -1))
	t(10,10,-1,10,(9, 10, -1))
	t(10,10,-1,100,(10, 10, -1))
	t(10,10,1,-100,(-100, -100, 1))
	t(10,10,1,-15,(-15, -15, 1))
	t(10,10,1,-3,(-3, -3, 1))
	t(10,10,1,0,(0, 0, 1))
	t(10,10,1,1,(1, 1, 1))
	t(10,10,1,5,(5, 5, 1))
	t(10,10,1,10,(10, 10, 1))
	t(10,10,1,100,(10, 10, 1))
	t(10,10,5,-100,(-100, -100, 5))
	t(10,10,5,-15,(-15, -15, 5))
	t(10,10,5,-3,(-3, -3, 5))
	t(10,10,5,0,(0, 0, 5))
	t(10,10,5,1,(1, 1, 5))
	t(10,10,5,5,(5, 5, 5))
	t(10,10,5,10,(10, 10, 5))
	t(10,10,5,100,(10, 10, 5))
	t(10,10,20,-100,(-100, -100, 20))
	t(10,10,20,-15,(-15, -15, 20))
	t(10,10,20,-3,(-3, -3, 20))
	t(10,10,20,0,(0, 0, 20))
	t(10,10,20,1,(1, 1, 20))
	t(10,10,20,5,(5, 5, 20))
	t(10,10,20,10,(10, 10, 20))
	t(10,10,20,100,(10, 10, 20))

def main():
	a()
	b()
	c()

main()


def test_getslice1():
    # verify __getslice__ is used for sequence types
    class C(list):
        def __getslice__(self, i, j):
            return (i,j)

    a = C()
    AreEqual(a[32:197], (32,197))

def test_getslice_setslice2():     
    # positive values work w/o len defined
    class C(object):
        def __getslice__(self, i, j):
            return 'Ok'
        def __setslice__(self, i, j, value):
            self.lastCall = 'set'
        def __delslice__(self, i,j):
            self.lastCall = 'delete'
   
    a = C()
    AreEqual(a[5:10], 'Ok')

    a.lastCall = ''
    a[5:10] = 'abc'
    AreEqual(a.lastCall, 'set')

    a.lastCall = ''
    del(a[5:10])
    AreEqual(a.lastCall, 'delete')

# all values work w/ length defined,but don't call len if it's positive
def test_getslice_setslice3():        
    class C(object):
        def __init__(self):
            self.calls = []
        def __getslice__(self, i, j):
            self.calls.append('get')
            return 'Ok'
        def __setslice__(self, i, j, value):
            self.calls.append('set')
        def __delslice__(self, i, j):
            self.calls.append('delete')
        def __len__(self):
            self.calls.append('len')
            return 5

    a = C()
    AreEqual(a[3:5], 'Ok')
    AreEqual(a.calls, ['get'])

    a = C()
    a[3:5] = 'abc'
    AreEqual(a.calls, ['set'])

    a = C()
    del(a[3:5])
    AreEqual(a.calls, ['delete'])

    # but call length if it's negative (and we should only call length once)
    a = C()
    AreEqual(a[-1:5], 'Ok')
    AreEqual(a.calls, ['len', 'get'])

    a = C()
    AreEqual(a[1:-5], 'Ok')
    AreEqual(a.calls, ['len', 'get'])

    a = C()
    AreEqual(a[-1:-5], 'Ok')
    AreEqual(a.calls, ['len', 'get'])

    a = C()
    a[-1:5] = 'abc'
    AreEqual(a.calls, ['len', 'set'])

    a = C()
    a[1:-5] = 'abc'
    AreEqual(a.calls, ['len', 'set'])

    a = C()
    a[-1:-5] = 'abc'
    AreEqual(a.calls, ['len', 'set'])

    a = C()
    del(a[-1:5])
    AreEqual(a.calls, ['len', 'delete'])

    a = C()
    del(a[1:-5])
    AreEqual(a.calls, ['len', 'delete'])

    a = C()
    del(a[-1:-5])
    AreEqual(a.calls, ['len', 'delete'])

run_test(__name__)