/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.client;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.jmx.interfaces.JMXAdaptor;

public class Deployer {
    protected ObjectName createFactoryName() throws MalformedObjectNameException {
        return new ObjectName("J2EE:service=J2eeDeployer");
    }

    protected URL createUrl(String url) throws MalformedURLException {
        if (new File(url).exists()) {
            return new File(url).toURL();
        }
        return new URL(url);
    }

    public void deploy(String url) throws Exception {
        ObjectName containerFactory = this.createFactoryName();
        URL deploymentUrl = this.createUrl(url);
        JMXAdaptor server = this.lookupAdaptor();
        server.invoke(containerFactory, "deploy", new Object[]{deploymentUrl.toString()}, new String[]{"java.lang.String"});
    }

    protected JMXAdaptor lookupAdaptor() throws NamingException {
        return (JMXAdaptor)new InitialContext().lookup("jmx");
    }

    public static void main(String[] args) throws Exception {
        int count = 0;
        while (count < args.length) {
            if (!args[count].equalsIgnoreCase("-undeploy")) {
                System.out.println("Deploying " + args[count]);
                new Deployer().deploy(args[count]);
                System.out.println(String.valueOf(args[count]) + " has been deployed successfully");
            } else {
                System.out.println("Undeploying " + args[++count]);
                new Deployer().undeploy(args[count]);
                System.out.println(String.valueOf(args[count]) + " has been successfully undeployed");
            }
            ++count;
        }
    }

    public void undeploy(String url) throws Exception {
        ObjectName containerFactory = this.createFactoryName();
        URL deploymentUrl = this.createUrl(url);
        JMXAdaptor server = this.lookupAdaptor();
        server.invoke(containerFactory, "undeploy", new Object[]{deploymentUrl.toString()}, new String[]{"java.lang.String"});
    }
}

