/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.logging.log4j.CategoryWriter;
import org.jboss.resource.ConnectionFactoryLoaderMBean;
import org.jboss.resource.ConnectionManagerFactory;
import org.jboss.resource.ConnectorConfig;
import org.jboss.resource.JBossConnectionListenerImpl;
import org.jboss.resource.JBossConnectionManager;
import org.jboss.resource.JBossResourceSubjectFactory;
import org.jboss.resource.RARMetaData;
import org.jboss.resource.security.PrincipalMapping;
import org.jboss.util.ServiceMBeanSupport;

public class ConnectionFactoryLoader
extends ServiceMBeanSupport
implements ConnectionFactoryLoaderMBean,
NotificationListener,
ObjectFactory {
    private static Map cfs = new HashMap();
    private MBeanServer server;
    private String resourceAdapterName;
    private String factoryName;
    private String properties = "";
    private String rarDeployerName;
    private String tmName = "java:/TransactionManager";
    private String cmfName;
    private String cmProps;
    private String princMapClass;
    private String princMapProps = "";
    private ObjectName rarDeployerObjectName;
    private String bindName;
    private JBossConnectionManager cm;

    public void setResourceAdapterName(String resourceAdapterName) {
        this.resourceAdapterName = resourceAdapterName.trim();
    }

    public void setFactoryName(String name) {
        this.factoryName = name.trim();
    }

    public void setProperties(String p) {
        this.properties = p;
    }

    public void setRARDeployerName(String rarDeployerName) {
        this.rarDeployerName = rarDeployerName.trim();
    }

    public void setTransactionManagerName(String n) {
        this.tmName = n.trim();
    }

    public void setConnectionManagerFactoryName(String c) {
        this.cmfName = c.trim();
    }

    public void setConnectionManagerProperties(String p) {
        this.cmProps = p;
    }

    public void setPrincipalMappingClass(String c) {
        this.princMapClass = c.trim();
    }

    public void setPrincipalMappingProperties(String p) {
        this.princMapProps = p;
    }

    public String getResourceAdapterName() {
        return this.resourceAdapterName;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getRARDeployerName() {
        return this.rarDeployerName;
    }

    public String getTransactionManagerName() {
        return this.tmName;
    }

    public String getConnectionManagerFactoryName() {
        return this.cmfName;
    }

    public String getConnectionManagerProperties() {
        return this.cmProps;
    }

    public String getPrincipalMappingClass() {
        return this.princMapClass;
    }

    public String getPrincipalMappingProperties() {
        return this.princMapProps;
    }

    public String getName() {
        return "ConnectionFactoryLoader";
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        this.log.debug((Object)("ConnectionFactoryLoader.getObjectInstance, name = '" + name + "'"));
        Map map = cfs;
        synchronized (map) {
            Object v = cfs.get(name.toString());
            return v;
        }
    }

    public void handleNotification(Notification n, Object handback) {
        this.log.debug((Object)("Received notification '" + n + "'"));
        String type = n.getType();
        try {
            if (type.endsWith(".deploy")) {
                this.loadConnectionFactory((RARMetaData)n.getUserData());
            } else if (type.endsWith(".undeploy")) {
                this.unloadConnectionFactory((RARMetaData)n.getUserData());
            } else {
                this.log.error((Object)("Unknown notification type: " + type));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Problem loading or unloading connection factory", (Throwable)e);
        }
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) {
        this.server = server;
        if (name == null) {
            String nameStr = ":service=ConnectionFactoryLoader,name=" + this.factoryName;
            try {
                name = new ObjectName(nameStr);
            }
            catch (MalformedObjectNameException mone) {
                this.log.error((Object)("The name '" + nameStr + "' is malformed"), (Throwable)mone);
            }
        }
        return name;
    }

    protected void initService() throws Exception {
        String logName = this.getClass().getName() + "." + this.factoryName;
        this.log = Logger.getLogger((String)logName);
        this.rarDeployerObjectName = new ObjectName(this.rarDeployerName);
        this.server.addNotificationListener(this.rarDeployerObjectName, this, (NotificationFilter)new RAFilter(this.log), null);
    }

    protected void startService() throws Exception {
        String[] sig;
        Object[] args;
        RARMetaData rmd;
        if (!cfs.containsKey(this.factoryName) && this.server.isRegistered(this.rarDeployerObjectName) && (rmd = (RARMetaData)this.server.invoke(this.rarDeployerObjectName, "getMetaData", args = new Object[]{this.resourceAdapterName}, sig = new String[]{"java.lang.String"})) != null) {
            this.loadConnectionFactory(rmd);
        }
    }

    protected void stopService() {
        if (cfs.containsKey(this.factoryName)) {
            try {
                if (this.server.isRegistered(this.rarDeployerObjectName)) {
                    Object[] args = new Object[]{this.resourceAdapterName};
                    String[] sig = new String[]{"java.lang.String"};
                    RARMetaData rmd = (RARMetaData)this.server.invoke(this.rarDeployerObjectName, "getMetaData", args, sig);
                    if (rmd != null) {
                        this.unloadConnectionFactory(rmd);
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Problem stopping ConnectionFactoryLoader service:", (Throwable)e);
            }
        }
    }

    private void loadConnectionFactory(RARMetaData metaData) {
        Object cf;
        ConnectionManagerFactory cmf;
        PrincipalMapping principalMapping;
        ManagedConnectionFactory mcf;
        Class<?> mcfClass;
        InitialContext ctx;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException ne) {
            this.log.error((Object)"Unable to obtain initial context", (Throwable)ne);
            return;
        }
        ClassLoader cl = metaData.getClassLoader();
        String mcfClassName = metaData.getManagedConnectionFactoryClass();
        try {
            mcfClass = cl.loadClass(mcfClassName);
        }
        catch (ClassNotFoundException cnfe) {
            this.log.error((Object)("Unable to load managed connection factory class '" + mcfClassName + "'"), (Throwable)cnfe);
            return;
        }
        try {
            mcf = (ManagedConnectionFactory)mcfClass.newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to instantiate manageed connection factory class '" + mcfClass + "'"), (Throwable)e);
            return;
        }
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(this.properties.getBytes("ISO-8859-1")));
        }
        catch (IOException ioe) {
            this.log.error((Object)("Problem converting properties string '" + this.properties + "' to Properties"), (Throwable)ioe);
        }
        Map ddProps = metaData.getProperties();
        Iterator i = ddProps.values().iterator();
        while (i.hasNext()) {
            Method setter;
            Class<?> clazz;
            RARMetaData.Property ddProp = (RARMetaData.Property)i.next();
            String value = (String)((Hashtable)props).get(ddProp.name);
            if (value == null) {
                if (ddProp.value == null) {
                    this.log.warn((Object)("Not setting config property '" + ddProp.name + "'"));
                    continue;
                }
                this.log.warn((Object)("Using default value '" + ddProp.value + "' for " + "config property '" + ddProp.name + "'"));
                value = ddProp.value;
            }
            try {
                clazz = cl.loadClass(ddProp.type);
            }
            catch (ClassNotFoundException cnfe) {
                this.log.warn((Object)("Unable to find class '" + ddProp.type + "' for " + "property '" + ddProp.name + "' - skipping property."));
                continue;
            }
            PropertyEditor pe = PropertyEditorManager.findEditor(clazz);
            if (pe == null) {
                this.log.warn((Object)("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + ddProp.name + "' - " + "skipping property"));
                continue;
            }
            try {
                pe.setAsText(value);
            }
            catch (IllegalArgumentException iae) {
                this.log.warn((Object)("Value '" + value + "' is not valid for property '" + ddProp.name + "' of class '" + clazz + "' - skipping " + "property"));
                continue;
            }
            Object v = pe.getValue();
            try {
                setter = mcfClass.getMethod("set" + ddProp.name, clazz);
            }
            catch (NoSuchMethodException nsme) {
                this.log.warn((Object)("The class '" + mcfClass.toString() + "' has no " + "setter for config property '" + ddProp.name + "'"));
                continue;
            }
            try {
                setter.invoke((Object)mcf, v);
            }
            catch (Exception e) {
                this.log.warn((Object)("Unable to invoke setter method '" + setter + "' " + "on object '" + mcf + "'"), (Throwable)e);
            }
        }
        CategoryWriter logWriter = new CategoryWriter(this.log.getCategory());
        try {
            mcf.setLogWriter((PrintWriter)logWriter);
        }
        catch (ResourceException re) {
            this.log.warn((Object)("Unable to set log writer '" + logWriter + "' on " + "managed connection factory"), (Throwable)re);
            this.log.warn((Object)"Linked exception:", (Throwable)re.getLinkedException());
        }
        TransactionManager tm = null;
        try {
            tm = (TransactionManager)ctx.lookup(this.tmName);
        }
        catch (NamingException ne) {
            this.log.error((Object)("Unable to locate the transaction manager at '" + this.tmName + "'"), (Throwable)ne);
        }
        try {
            principalMapping = (PrincipalMapping)Class.forName(this.princMapClass).newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to instantiate principal mapping class '" + this.princMapClass + "'"), (Throwable)e);
            return;
        }
        principalMapping.setName(this.factoryName);
        principalMapping.setManagedConnectionFactory(mcf);
        principalMapping.setRARMetaData(metaData);
        principalMapping.setProperties(this.princMapProps);
        try {
            cmf = (ConnectionManagerFactory)ctx.lookup("java:/" + this.cmfName);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to find connection manager factory at 'java:/" + this.cmfName + "'"), (Throwable)e);
            return;
        }
        ConnectorConfig cmConfig = new ConnectorConfig();
        cmConfig.logWriter = logWriter;
        cmConfig.rsf = new JBossResourceSubjectFactory(principalMapping);
        cmConfig.isReauthenticationSupported = metaData.getReauthenticationSupport();
        JBossConnectionListenerImpl listener = new JBossConnectionListenerImpl(mcf, this.factoryName);
        cmConfig.listener = listener;
        Properties cmProperties = new Properties();
        try {
            if (this.cmProps != null) {
                byte[] bytes = this.cmProps.getBytes("ISO-8859-1");
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                cmProperties.load(bais);
            }
            cmConfig.properties = cmProperties;
        }
        catch (IOException ioe) {
            this.log.error((Object)("Couldn't convert properties string '" + this.cmProps + "' to " + "Properties"), (Throwable)ioe);
        }
        try {
            this.cm = cmf.addManagedConnectionFactory(mcf, cmConfig, this.factoryName);
        }
        catch (ResourceException re) {
            this.log.error((Object)"Error initialising connection manager", (Throwable)re);
            return;
        }
        listener.setConnectionManager(this.cm);
        try {
            cf = mcf.createConnectionFactory((ConnectionManager)this.cm);
        }
        catch (ResourceException re) {
            this.log.error((Object)"Unable to create connection factory", (Throwable)re);
            return;
        }
        this.bindName = "java:/" + this.factoryName;
        this.log.debug((Object)("Binding object '" + cf + "' into JNDI at '" + this.bindName + "'"));
        Map map = cfs;
        synchronized (map) {
            cfs.put(this.factoryName, cf);
        }
        ((Referenceable)cf).setReference(new Reference(cf.getClass().getName(), this.getClass().getName(), null));
        try {
            ctx.bind(this.bindName, cf);
            this.log.info((Object)("Bound connection factory for resource adapter '" + this.resourceAdapterName + "' to JNDI name '" + this.bindName + "'"));
        }
        catch (NamingException ne) {
            this.log.error((Object)("Unable to bind connection factory to JNDI name '" + this.bindName + "'"), (Throwable)ne);
        }
    }

    private void unloadConnectionFactory(RARMetaData metaData) {
        this.cm.shutDown();
        cfs.remove(this.factoryName);
        this.log.info((Object)("Connection factory '" + this.factoryName + "' shut down."));
        try {
            new InitialContext().unbind(this.bindName);
        }
        catch (NamingException ne) {
            this.log.error((Object)("Unable to unbind connection factory at JNDI location '" + this.bindName + "'"), (Throwable)ne);
        }
    }

    private class RAFilter
    implements NotificationFilter {
        private Logger log;

        private RAFilter(Logger log) {
            this.log = log;
        }

        public boolean isNotificationEnabled(Notification n) {
            this.log.debug((Object)("Evaluating notification type='" + n.getType() + "', " + "message='" + n.getMessage() + "'"));
            return n.getType().startsWith("org.jboss.resource.deployment") && n.getMessage().equals(ConnectionFactoryLoader.this.resourceAdapterName);
        }
    }
}

