/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.resource.ConnectionManagerFactory;
import org.jboss.resource.ConnectionManagerFactoryLoaderMBean;
import org.jboss.util.ServiceMBeanSupport;

public class ConnectionManagerFactoryLoader
extends ServiceMBeanSupport
implements ConnectionManagerFactoryLoaderMBean,
ObjectFactory {
    private static Map cmfs = new HashMap();
    private String factoryName;
    private String factoryClass;
    private String properties;
    private String tmName = "java:/TransactionManager";
    private String bindName;
    private ConnectionManagerFactory cmf;

    public void setFactoryName(String name) {
        this.factoryName = name.trim();
    }

    public void setProperties(String p) {
        this.properties = p;
    }

    public void setTransactionManagerName(String n) {
        this.tmName = n.trim();
    }

    public void setFactoryClass(String c) {
        this.factoryClass = c.trim();
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getTransactionManagerName() {
        return this.tmName;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public String getName() {
        return "ConnectionManagerFactoryLoader";
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        this.log.debug((Object)("ConnectionManagerLoader.getObjectInstance, name = '" + name + "'"));
        Map map = cmfs;
        synchronized (map) {
            Object v = cmfs.get(name.toString());
            return v;
        }
    }

    public void startService() throws Exception {
        InitialContext ctx = new InitialContext();
        Class<?> cls = Class.forName(this.factoryClass);
        this.cmf = (ConnectionManagerFactory)cls.newInstance();
        TransactionManager tm = (TransactionManager)ctx.lookup(this.tmName);
        this.cmf.setTransactionManager(tm);
        if (this.properties != null) {
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(this.properties.getBytes("ISO-8859-1")));
            this.cmf.setProperties(props);
        }
        Map map = cmfs;
        synchronized (map) {
            cmfs.put(this.factoryName, this.cmf);
        }
        this.bind(ctx, "java:/" + this.factoryName, new Reference(this.cmf.getClass().getName(), this.getClass().getName(), null));
        this.log.info((Object)("Connection manager factory '" + this.factoryName + " bound to " + "'java:/" + this.factoryName + "'"));
    }

    public void stopService() {
        try {
            new InitialContext().unbind("java:/" + this.factoryName);
            this.log.info((Object)("Connection manager factory '" + this.factoryName + "' removed from JNDI"));
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) {
        if (name == null) {
            String nameStr = "JCA:service=ConnectionManagerFactoryLoader,name=" + this.factoryName;
            try {
                name = new ObjectName(nameStr);
            }
            catch (MalformedObjectNameException mone) {
                this.log.error((Object)("The name '" + nameStr + "' is malformed"), (Throwable)mone);
            }
        }
        return name;
    }

    protected void initService() throws Exception {
        String logName = this.getClass().getName() + "." + this.factoryName;
        this.log = Logger.getLogger((String)logName);
    }

    private void bind(Context ctx, String name, Object val) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        ctx.bind(n.get(0), val);
    }
}

