/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource;

import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.logging.Logger;
import org.jboss.resource.JBossConnectionListener;
import org.jboss.resource.JBossConnectionManager;

public class JBossConnectionListenerImpl
implements JBossConnectionListener {
    private ManagedConnectionFactory mcf;
    private JBossConnectionManager cm;
    private Logger log;

    JBossConnectionListenerImpl(ManagedConnectionFactory mcf, String factoryName) {
        this.mcf = mcf;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + factoryName));
    }

    public void connectionHandleIssued(Object connection) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Connection handle '" + connection + "' issued by connection manager '" + this.cm + "' from mcf '" + this.mcf + "'"));
        }
    }

    public void connectionHandleClosed(Object connection) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Connection handle '" + connection + "' closed from connection manager '" + this.cm + "' from mcf '" + this.mcf + "'"));
        }
    }

    void setConnectionManager(JBossConnectionManager cm) {
        this.cm = cm;
    }
}

