/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Logger {
    private static final String CATEGORY_CLASS = "org.apache.log4j.Category";
    private static final String PRIORITY_CLASS = "org.apache.log4j.Priority";
    private static final String TRACE_PRIORITY_CLASS = "org.jboss.logging.TracePriority";
    private static final int GET_INSTANCE = 0;
    private static final int IS_ENABLED_FOR_PRIORITY = 1;
    private static final int LOG_PRIORITY_MSG = 2;
    private static final int LOG_PRIORITY_MSG_EX = 3;
    private static final int N_METHODS = 4;
    private static Method[] log4jMethods = null;
    private static String[] priorityNames = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private static Object[] log4jPriorities = new Object[priorityNames.length];
    private static final int TRACE = 0;
    private static final int DEBUG = 1;
    private static final int INFO = 2;
    private static final int WARN = 3;
    private static final int ERROR = 4;
    private static final int FATAL = 5;
    private static boolean logInitFailures = false;
    private static int maxInitAttempts = 100;
    private static int initAttempts;
    private Object category;
    private String categoryType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static Logger getLogger(Class categoryType) {
        return Logger.getLogger(categoryType.getName());
    }

    public static Logger getLogger(String categoryType) {
        try {
            Logger.initLog4j();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Logger(categoryType);
    }

    public void trace(Object msg) {
        this.log(0, msg);
    }

    public void trace(Object msg, Throwable ex) {
        this.log(0, msg, ex);
    }

    public void debug(Object msg) {
        this.log(1, msg);
    }

    public void debug(Object msg, Throwable ex) {
        this.log(1, msg, ex);
    }

    public void info(Object msg) {
        this.log(2, msg);
    }

    public void info(Object msg, Throwable ex) {
        this.log(2, msg, ex);
    }

    public void warn(Object msg) {
        this.log(3, msg);
    }

    public void warn(Object msg, Throwable ex) {
        this.log(3, msg, ex);
    }

    public void error(Object msg) {
        this.log(4, msg);
    }

    public void error(Object msg, Throwable ex) {
        this.log(4, msg, ex);
    }

    public void fatal(Object msg) {
        this.log(5, msg);
    }

    public void fatal(Object msg, Throwable ex) {
        this.log(5, msg, ex);
    }

    public boolean isTraceEnabled() {
        return this.isEnabledFor(0);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(1);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(2);
    }

    private boolean isEnabledFor(int priorityIdx) {
        boolean isEnabled = false;
        try {
            if (this.category == null) {
                this.init();
                if (this.category == null) {
                    return false;
                }
            }
            Object priority = log4jPriorities[priorityIdx];
            Object[] args = new Object[]{priority};
            Boolean bool = (Boolean)log4jMethods[1].invoke(this.category, args);
            isEnabled = bool;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isEnabled;
    }

    private void log(int priorityIdx, Object msg) {
        if (this.category == null) {
            this.init();
            if (this.category == null) {
                String name = priorityNames[priorityIdx];
                System.out.println(name + ", " + msg);
                return;
            }
        }
        try {
            Object priority = log4jPriorities[priorityIdx];
            Object[] args = new Object[]{priority, msg};
            log4jMethods[2].invoke(this.category, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void log(int priorityIdx, Object msg, Throwable ex) {
        if (this.category == null) {
            this.init();
            if (this.category == null) {
                String name = priorityNames[priorityIdx];
                System.out.println(name + ", " + msg);
                ex.printStackTrace();
                return;
            }
        }
        try {
            Object priority = log4jPriorities[priorityIdx];
            Object[] args = new Object[]{priority, msg, ex};
            log4jMethods[3].invoke(this.category, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Logger(String categoryType) {
        this.categoryType = categoryType;
        this.init();
    }

    private void init() {
        block4: {
            try {
                if (log4jMethods == null) {
                    Logger.initLog4j();
                }
                if (log4jMethods != null) {
                    Object[] args = new Object[]{this.categoryType};
                    this.category = log4jMethods[0].invoke(null, args);
                }
            }
            catch (Exception e) {
                if (!logInitFailures) break block4;
                e.printStackTrace();
            }
        }
    }

    private static synchronized void initLog4j() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (log4jMethods != null || initAttempts > 100) {
            return;
        }
        ++initAttempts;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> trace = loader.loadClass(TRACE_PRIORITY_CLASS);
        Class<?> priorityClass = loader.loadClass(PRIORITY_CLASS);
        Class[] toPriorityTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Logger.class$("java.lang.String")) : class$java$lang$String};
        Method toPriority = priorityClass.getDeclaredMethod("toPriority", toPriorityTypes);
        int n = 1;
        while (n < priorityNames.length) {
            Object[] args = new Object[]{priorityNames[n]};
            Logger.log4jPriorities[n] = toPriority.invoke(null, args);
            ++n;
        }
        toPriorityTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Logger.class$("java.lang.String")) : class$java$lang$String, priorityClass};
        toPriority = trace.getDeclaredMethod("toPriority", toPriorityTypes);
        Logger.log4jPriorities[0] = toPriority.invoke(null, "TRACE", log4jPriorities[1]);
        Method[] tmp = new Method[4];
        Class<?> categoryClass = loader.loadClass(CATEGORY_CLASS);
        Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Logger.class$("java.lang.String")) : class$java$lang$String};
        tmp[0] = categoryClass.getDeclaredMethod("getInstance", paramTypes);
        paramTypes = new Class[]{priorityClass};
        tmp[1] = categoryClass.getDeclaredMethod("isEnabledFor", paramTypes);
        paramTypes = new Class[]{priorityClass, class$java$lang$Object == null ? (class$java$lang$Object = Logger.class$("java.lang.Object")) : class$java$lang$Object};
        tmp[2] = categoryClass.getDeclaredMethod("log", paramTypes);
        paramTypes = new Class[]{priorityClass, class$java$lang$Object == null ? (class$java$lang$Object = Logger.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Logger.class$("java.lang.Throwable")) : class$java$lang$Throwable};
        tmp[3] = categoryClass.getDeclaredMethod("log", paramTypes);
        log4jMethods = tmp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            logInitFailures = Boolean.getBoolean("org.jboss.system.BootstrapLogger.logInitFailures");
            Integer i = Integer.getInteger("org.jboss.system.BootstrapLogger.maxInitAttempts", maxInitAttempts);
            maxInitAttempts = i;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

