/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class IdentityLoginModule
extends AbstractServerLoginModule {
    private String principalName;
    private String roleNames;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.principalName = (String)options.get("principal");
        if (this.principalName == null) {
            this.principalName = "guest";
        }
        this.roleNames = (String)options.get("roles");
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            return true;
        }
        SimplePrincipal principal = new SimplePrincipal(this.principalName);
        this.subject.getPrincipals().add(principal);
        this.sharedState.put("javax.security.auth.login.name", this.principalName);
        return true;
    }

    protected Principal getIdentity() {
        SimplePrincipal principal = new SimplePrincipal(this.principalName);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        if (this.roleNames != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.roleNames, ",");
            while (tokenizer.hasMoreTokens()) {
                String roleName = tokenizer.nextToken();
                roles.addMember(new SimplePrincipal(roleName));
            }
        }
        return roleSets;
    }
}

