/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.Util;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public abstract class UsernamePasswordLoginModule
extends AbstractServerLoginModule {
    private Principal identity;
    private char[] credential;
    private Principal unauthenticatedIdentity;
    private String hashAlgorithm = null;
    private String hashCharset = null;
    private String hashEncoding = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String name = (String)options.get("unauthenticatedIdentity");
        if (name != null) {
            this.unauthenticatedIdentity = new SimplePrincipal(name);
            this.log.trace("Saw unauthenticatedIdentity=" + name);
        }
        this.hashAlgorithm = (String)options.get("hashAlgorithm");
        if (this.hashAlgorithm != null) {
            this.hashEncoding = (String)options.get("hashEncoding");
            if (this.hashEncoding == null) {
                this.hashEncoding = "BASE64";
            }
            this.hashCharset = (String)options.get("hashCharset");
            if (this.log.isTraceEnabled()) {
                this.log.trace("Passworg hashing activated: algorithm = " + this.hashAlgorithm + ", encoding = " + this.hashEncoding + (this.hashCharset == null ? "" : "charset = " + this.hashCharset));
            }
        }
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                this.identity = new SimplePrincipal(name);
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof char[]) {
                this.credential = (char[])password;
            } else if (password != null) {
                String tmp = password.toString();
                this.credential = tmp.toCharArray();
            }
            return true;
        }
        String[] info = this.getUsernameAndPassword();
        String username = info[0];
        String password = info[1];
        if (username == null && password == null) {
            this.identity = this.unauthenticatedIdentity;
            this.log.trace("Authenticating as unauthenticatedIdentity=" + this.identity);
        }
        if (this.identity == null) {
            String expectedPassword;
            this.identity = new SimplePrincipal(username);
            if (this.hashAlgorithm != null) {
                password = this.createPasswordHash(username, password);
            }
            if (!this.validatePassword(password, expectedPassword = this.getUsersPassword())) {
                this.log.debug("Bad password for username=" + username);
                throw new FailedLoginException("Password Incorrect/Password Required");
            }
        }
        this.log.trace("User '" + this.identity + "' authenticated.");
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", username);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        return true;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected String getUsername() {
        return this.getIdentity().getName();
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[]{null, null};
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = new String(this.credential);
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        info[0] = username;
        info[1] = password;
        return info;
    }

    protected String createPasswordHash(String username, String password) {
        String passwordHash = Util.createPasswordHash(this.hashAlgorithm, this.hashEncoding, this.hashCharset, username, password);
        return passwordHash;
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (inputPassword == null || expectedPassword == null) {
            return false;
        }
        return inputPassword.equals(expectedPassword);
    }

    protected abstract String getUsersPassword() throws LoginException;
}

